FUNCTION MPP_Value,mpp,index,Title=title,Flag=flag, Pointer=pointer

;+
; 
; NAME: 
;	MPP_Value
;
; PURPOSE:
;	This function returns the value of array(s) stored in the
;	MPP handler
;
; CATEGORY:
;	MPP utilities to handle multiple array data
;
; CALLING SEQUENCE:
;	out = MPP_Value,mpp ,index
;
; INPUTS:
;     mpp: the MPP handle as created by MPP_New(). It can be a structure
;		or a pointer to a structure.
;     INDEX: a string with the description of the array with the MPP 
;       indices to free. Examples: '[*]', '[1:2]'
;
; OPTIONAL INPUTS:
;
; KEYWORD PARAMETERS:
;	*** With no keywords, the function returns the array
;	    with data corresponding to a single index. When
;	    using one of the keywords, it can also return a
;	    multiple data arrays ***
;	Title: if set, the function returns the title
;	Flag: Pointer=pointer
;	Pointer: Returns a pointer with the data
;
;
; EXAMPLES:
;	mpp = mpp_new(4,/Pointer)
;	print,'Setting elements [1:3]...'
;	mpp_set,mpp,'[1:3]',Title=Replicate('Example',3),Flag=[100,200,300],$
;	Value=fltarr(2,100)
;	Print,' Title for element 2...'
;	print,mpp_value(mpp,2,/Title)
;	 
;
; MODIFICATION HISTORY:
;	Initial version by M. Sanchez del Rio, February 2000.
;
;-

mppType = Type(mpp)
IF mppType EQ 10 THEN BEGIN
  IF Ptr_Valid(mpp) EQ 0 THEN Message,'MPP_Value: input not valid.'
  mppstr=*mpp 
ENDIF ELSE mppstr=mpp

IF N_Elements(index) EQ 0 THEN ind='[*]' ELSE ind=index
IF Type(ind) NE 7 THEN ind='['+Vect2String(ind)+']'

n = MPP_Info(mppstr,/N_Elements)
indices = LIndGen(n)
cmd = 'indices = indices'+ind
itmp = Execute(cmd)

out=0
IF Keyword_Set(Title) THEN BEGIN
  out = mppstr[indices].title
  GoTo,out
ENDIF
IF Keyword_Set(Flag) THEN BEGIN
  out = mppstr[indices].Flag
  GoTo,out
ENDIF

IF Keyword_Set(pointer) THEN BEGIN
  out = mppstr[indices].ptrData
  GoTo,out
ENDIF

ptrs = 0
ptrs = mppstr[indices].ptrData
IF N_Elements(ptrs) NE 1 THEN $
  Message,'Cannot return multiple data blocks'
out = *ptrs


out:
RETURN,out
END
