PRO MPP_Sort,mpp,indices

;+
; 
; NAME: 
;	MPP_Sort
;
; PURPOSE:
;	This procedure sorts the MPP handle
;
; CATEGORY:
;	MPP utilities to handle multiple array data
;
; CALLING SEQUENCE:
;	MPP_Sort,mpp ,indices
;
; INPUTS:
;     mpp: the MPP handle as created by MPP_New(). It can be a structure
;		or a pointer to a structure.
;     indices: the new order of the indices
;
; EXAMPLES:
;	mpp = MPP_New()
;	mpp_set,mpp,Value=fltarr(3,3),/Add
;	mpp_set,mpp,Value=fltarr(4,4),/Add
;	tmp = mpp_info(mpp,/Verbose)
;	print,'Reversing the element...'
;	mpp_sort,mpp,[1,0]
;	tmp = mpp_info(mpp,/Verbose)
;	mpp_free,mpp  
;
; MODIFICATION HISTORY:
;	Initial version by M. Sanchez del Rio, February 2000.
;
;-
IF N_Elements(indices) NE MPP_Info(mpp,/N_Elements) THEN $
  Message,'Number of elements in sorting info different from mpp data'

IF Type(mpp) EQ 10 THEN mppstr=*mpp ELSE mppstr=mpp
mppstr = mppstr(indices)
IF Type(mpp) EQ 10 THEN *mpp=mppstr ELSE mpp=mppstr

END

