PRO MPP_Set,mpp,index,Title=title,Flag=flag,Pointer=pointer,Value=value,$
 Clean=Clean,Add=add


;+
; 
; NAME: 
;	MPP_Set
;
; PURPOSE:
;	This procedure stores some data on the MPP handle
;
;
; CATEGORY:
;	MPP utilities to handle multiple array data
;
; CALLING SEQUENCE:
;	MPP_Set,mpp [,index]
;
; INPUTS:
;     mpp: the MPP handle as created by MPP_New(). It can be a structure
;		or a pointer to a structure.
;     index: the index where to store the data
;
; OPTIONAL INPUTS:
;     INDEX: a string with the description of the array with the MPP 
;       indices to free. Examples: '[*]', '[1:2]'
;
; KEYWORD PARAMETERS:
;	Title: a string with the title
;	Flag: a flag value
;       Pointer: a pointer to the data to be stored
;	Value: the array with the data to be stored
;	Clean: when set, cleans the corresponding data
;	Add: if set, the data is added to the bottom of the list
;
;
; EXAMPLES:
;	mpp = MPP_New()
;	mpp_set,mpp,Value=fltarr(3,3),/Add
;	tmp = mpp_info(mpp,/Verbose)
;	mpp_free,mpp  
;
; MODIFICATION HISTORY:
;	Initial version by M. Sanchez del Rio, February 2000.
;
;-

IF Type(mpp) EQ 10 THEN BEGIN ; input type is a pointer
  IF Ptr_Valid(mpp) EQ 0 THEN BEGIN ; null pointer entered
    mpp = MPP_New(1,/Pointer)
    mppstr = *mpp
    index = 0
    add = 0
  ENDIF ELSE BEGIN
    mppstr=*mpp 
  ENDELSE
ENDIF ELSE BEGIN  ; input type is an array of structures
  mppstr=mpp
ENDELSE

IF Keyword_Set(add) THEN BEGIN
   mppstr = [Temporary(mppstr),{mpp}]
   index = N_Elements(mppstr)-1
ENDIF


IF N_Elements(index) EQ 0 THEN ind='[*]' ELSE ind=index
IF Type(ind) NE 7 THEN ind='['+Vect2String(ind)+']'

n = MPP_Info(mppstr,/N_Elements)
indices = LIndGen(n)
cmd = 'indices = indices'+ind
itmp = Execute(cmd)


IF  Keyword_Set(title) OR  Keyword_Set(flag) OR  Keyword_Set(pointer) THEN BEGIN
  FOR i=0,N_Elements(indices)-1 DO BEGIN
    tmp=mppstr[indices[i]]
    IF Keyword_Set(title) THEN tmp.title = title[i]
    IF Keyword_Set(flag) THEN tmp.flag = flag[i]
    IF Keyword_Set(pointer) THEN tmp.pointer = pointer[i]
    mppstr[indices[i]]=tmp
  ENDFOR
ENDIF

IF Keyword_Set(Value) THEN BEGIN
  ptrs = mppstr[indices].ptrData

  IF Keyword_Set(Clean) THEN BEGIN
    FOR i=0,N_elements(ptrs)-1 DO BEGIN
       IF Ptr_Valid(ptrs[i]) THEN Ptr_Free,ptrs[i]
    ENDFOR
  ENDIF

  FOR i=0,N_elements(ptrs)-1 DO BEGIN
     ptrs[i] = Ptr_New(value)
  ENDFOR

  mppstr[indices].ptrData = ptrs
ENDIF

IF Type(mpp) EQ 10 THEN *mpp=mppstr ELSE mpp=mppstr

END

