PRO MPP_Free,mpp,index

;+
; 
; NAME: 
;	MPP_FREE
;
; PURPOSE:
;	Frees the data stores in the mpp handle
;
;
; CATEGORY:
;	MPP utilities to handle multiple array data
;
; CALLING SEQUENCE:
;	MPP_Free,mpp [,index]
;
; INPUTS:
;     mpp: the MPP handle as created by MPP_New(). It can be a structure
;		or a pointer to a structure.
;
; OPTIONAL INPUTS:
;     INDEX: a string with the description of the array with the MPP 
;       indices to free. Examples: '[*]', '[1:2]'
;
; KEYWORD PARAMETERS:
;
;
; SIDE EFFECTS:
;	Frees also the corresponding pointers stored in the MPP
;	structure.
;
; EXAMPLES:
;	mpp = MPP_New()
;	mpp_set,mpp,Value=fltarr(3,3),/Add
;	tmp = mpp_info(mpp,/Verbose)
;	mpp_free,mpp  
;
; MODIFICATION HISTORY:
;	Initial version by M. Sanchez del Rio, February 2000.
;
;-

mppType = Type(mpp)
IF mppType EQ 10 THEN BEGIN
  IF Ptr_Valid(mpp) EQ 0 THEN RETURN ; if null ptr entered, return
  mppstr=*mpp 
ENDIF ELSE mppstr=mpp

IF N_Elements(index) EQ 0 THEN ind='[*]' ELSE ind=index
IF Type(ind) NE 7 THEN ind='['+Vect2String(ind)+']'

n = MPP_Info(mppstr,/N_Elements)
indices = LIndGen(n)
indices_todelete = 0
cmd = 'indices_todelete = indices'+ind
itmp = Execute(cmd)

IF N_Elements(index) EQ 0 THEN BEGIN    ; free everything
  FOR i=0,N_elements(mppstr)-1 DO BEGIN
    pi = mppstr[i].ptrData
    IF Ptr_Valid(pi) THEN Ptr_Free,pi
  ENDFOR
  IF mppType EQ 10 THEN BEGIN
    IF Ptr_Valid(mpp) THEN Ptr_Free,mpp
  ENDIF
  mpp = Ptr_New()
ENDIF ELSE BEGIN                        ; free only indices_todelete
  ptrs = 0
  IF Type(ind) NE 7 THEN ind = Vect2String(ind) ELSE ind=ind
  ptrs = (mppstr[indices_todelete]).ptrData
  FOR i=0,N_elements(ptrs)-1 DO $
    IF Ptr_Valid(ptrs[i]) THEN Ptr_Free,ptrs[i]
  indices_tmp = indices
  indices_tmp[indices_todelete]=-1
  tmp = Where(indices_tmp NE -1)
  IF tmp[0] EQ -1 THEN BEGIN ; nothing good
    IF Ptr_Valid(mpp) THEN Ptr_Free,mpp
    mpp = Ptr_New()
  ENDIF ELSE BEGIN
    indices_good=indices_tmp(tmp)
    mppstr = mppstr[indices_good]
    IF mppType EQ 10 THEN *mpp=mppstr ELSE mpp=mppstr
  ENDELSE

ENDELSE


END

