;;-TOPOSITECONFIG.PRO----------------------------------------------------
;;
;; SITE/PLATFORM-DEPENDENT SETTINGS 
;;
;; The most important thing to set here is the installation directory.
;; If you don't set this correctly, TOPO will not work at all.
;;
;; If you will use TOPO with a licensed copy of IDL, then the default
;; TOPO installation directory is inside of the user_contrib directory
;; in the main IDL directory (i.e., inside the directory specified by
;; the !DIR system variable.)  If you did not install TOPO in this
;; location, then you MUST set the value of the 'topohome' variable
;; below to reflect the actual installation directory.
;;
;; If you will use TOPO as a XOP extension, then TOPO must be
;; installed in the extensions subdirectory of the xop directory.
;; 
;; 
;; The only other things you should need to set to get TOPO to run on
;; your system are (a) the desired widget font for your platform, and
;; (b) the special characters necessary for widgets to display the
;; angstrom symbol and the greek mu character.  If you're not sure
;; about these special characters, just use an 'A' for the angstrom
;; symbol and a 'u' for the mu symbol.
;;
;; 
;; NOTE: Each line of this file must use valid IDL syntax. Lines
;; cannot be continued using the $ symbol.  Be careful making changes:
;; If you mess it up, TOPO won't run.
;;
;;------------------------------------------------------------------------
;;
;; UNIX PLATFORMS:
;;
;; TOPO Installation directory:
;;
if (!version.os_family eq 'unix') then topohome=!dir+'/user_contrib/topo/' 
;;
;; installation directory for topo4xop
if (!version.os_family eq 'unix') and (getenv('XOP_HOME') ne '') then topohome=getenv('XOP_HOME')+'/extensions/topo/'
;; 
;; default widget fonts and special characters:
;;
;; these work for me on HP-UX:
if (!version.os eq "hp-ux") then font_w='' 
if (!version.os eq "hp-ux") then angstrom_w=string(208B) 
if (!version.os eq "hp-ux") then mu_w=string(243B) 

;; these work for me on Sun OS
if (!version.os eq "sunos") then font_w='helvR12' 
if (!version.os eq "sunos") then angstrom_w=string(197B) 
if (!version.os eq "sunos") then mu_w=string(181B) 

;; these are untested:
if (!version.os eq "A/UX") then font_w='' 
if (!version.os eq "A/UX") then angstrom_w='A'
if (!version.os eq "A/UX") then mu_w='u'

;; these are untested:
if (!version.os eq "AIX") then font_w='' 
if (!version.os eq "AIX") then angstrom_w='A'
if (!version.os eq "AIX") then mu_w='u'

;; these are untested:
if (!version.os eq "DG/UX") then font_w='' 
if (!version.os eq "DG/UX") then angstrom_w='A'
if (!version.os eq "DG/UX") then mu_w='u'

;; these are untested:
if (!version.os eq "IRIX") then font_w='' 
if (!version.os eq "IRIX") then angstrom_w='A'
if (!version.os eq "IRIX") then mu_w='u'

;; these are untested:
if (!version.os eq "linux") then font_w='' 
if (!version.os eq "linux") then angstrom_w='A'
if (!version.os eq "linux") then mu_w='u'

;; these are untested:
if (!version.os eq "OSF") then font_w='' 
if (!version.os eq "OSF") then angstrom_w='A'
if (!version.os eq "OSF") then mu_w='u'

;; these are untested:
if (!version.os eq "RISC/os") then font_w='' 
if (!version.os eq "RISC/os") then angstrom_w='A'
if (!version.os eq "RISC/os") then mu_w='u'

;; add your unix platform here:
;; 
if (!version.os eq "YOUR UNIX OS") then font_w='' 
if (!version.os eq "YOUR UNIX OS") then angstrom_w='A'
if (!version.os eq "YOUR UNIX OS") then mu_w='u'

;;------------------------------------------------------------------------
;;
;; WINDOWS:
;;
;; 
;; TOPO Installation directory:
;;
if (!version.os eq 'Win32') then topohome=!dir+'\user_contrib\topo\' 
;; 
;;
;; installation directory for topo4xop
if (!version.os eq 'Win32') and (getenv('XOP_HOME') ne '') then topohome=getenv('XOP_HOME')+'\extensions\topo\'
;; 
;; default widget fonts and special characters:
;;
if (!version.os eq 'Win32') then font_w='' 
if (!version.os eq 'Win32') then angstrom_w=string(197B)
if (!version.os eq 'Win32') then mu_w=string(181B) 

;;------------------------------------------------------------------------
;;
;; MACINTOSH:
;;
;; TOPO Installation directory:
;;
if (!version.os eq 'MacOS') then topohome=!dir+'user_contrib:topo:' 
;; 
;; installation directory for topo4xop
if (!version.os eq 'MacOS') and (getenv('XOP_HOME') ne '') then topohome=getenv('XOP_HOME')+'extensions:topo:'
;;
;; default widget fonts and special characters:
;;
if (!version.os eq 'MacOS') then font_w='' 
if (!version.os eq 'MacOS') then angstrom_w=string(129B) 
if (!version.os eq 'MacOS') then mu_w='u' 

;;------------------------------------------------------------------------
;;
;; VMS:
;;
;; I have no clue about the VMS file system:
;;
if (!version.os eq 'vms') then topohome=!dir+':[user_contrib.topo]' 
;; 
;; installation directory for topo4xop
if (!version.os eq 'vms') and (getenv('XOP_HOME') ne '') then topohome=getenv('XOP_HOME')+':[extensions.topo]'
;;
;; default widget fonts and special characters:
;;
if (!version.os eq 'vms') then font_w='' 
if (!version.os eq 'vms') then angstrom_w='A' 
if (!version.os eq 'vms') then mu_w='u' 
