;
;   ===========================  Xshtroe   =========================
;
;   Xshtroe is an widget based graphical interface to generate
;   a SHADOW optical element.
;
; ----------------------------------------------------------------------
;       Author: Christoph Michetschlaeger (michet@esrf.fr) , ESRF, Nov 1997
;       Modification history:
;	98/03/15 srio@esrf.fr rewrites most of the code.
;
;
;========================================================================
;

Pro xshoe_updateoestr,wids,oestr

catch, error_status
 if error_status ne 0 then begin
   catch, /cancel
   message,/info,'Error caught: '+!err_string
   if sdep(/w) then itmp = dialog_message('XSHOE_UPDATEOESTR: Error caught: '+$
	!err_string,/error)
   return
endif

Widget_Control,wids.fwrite,Get_Value=tmp
oestr.fwrite = fix(tmp(0))

Widget_Control,wids.t_source,Get_Value=tmp
oestr.t_source = float(tmp(0))

Widget_Control,wids.t_image,Get_Value=tmp
oestr.t_image = float(tmp(0))

Widget_Control,wids.t_incidence,Get_Value=tmp
oestr.t_incidence = float(tmp(0))

Widget_Control,wids.t_reflection,Get_Value=tmp
oestr.t_reflection = float(tmp(0))

Widget_Control,wids.f_angle,Get_Value=tmp
oestr.f_angle = fix(tmp(0))

Widget_Control,wids.alpha,Get_Value=tmp
oestr.alpha = float(tmp(0))

Widget_Control,wids.f_refrac,Get_Value=tmp
oestr.f_refrac = fix(tmp(0))

Widget_Control,wids.fmirr,Get_Value=tmp
oestr.fmirr = fix(tmp(0))+1

Widget_Control,wids.f_grating,Get_Value=tmp
oestr.f_grating = fix(tmp(0))

Widget_Control,wids.f_crystal,Get_Value=tmp
oestr.f_crystal = fix(tmp(0))

Widget_Control,wids.f_move,Get_Value=tmp
oestr.f_move = fix(tmp(0))

Widget_Control,wids.fslit,Get_Value=tmp
oestr.fslit = fix(tmp(0))

Widget_Control,wids.fdummy,Get_Value=tmp
oestr.f_ripple = 0
oestr.f_facet = 0
oestr.f_roughness = 0
oestr.f_koma = 0
oestr.f_segment = 0
case fix(tmp(0)) of
  0:
  1:oestr.f_ripple = 1
  2:oestr.f_facet = 1
  3:oestr.f_roughness = 1
  4:oestr.f_koma = 1
  5:oestr.f_segment = 1
  else:
endcase

Widget_Control,wids.fstat,Get_Value=tmp
oestr.fstat = fix(tmp(0))

end
;
;========================================================================
;
Pro xshoe_updatemain,wids,oestr

catch, error_status
 if error_status ne 0 then begin
   catch, /cancel
   message,/info,'Error caught: '+!err_string
   if sdep(/w) then itmp = dialog_message('XSHOE_UPDATEMAIN: Error caught: '+$
	!err_string,/error)
   return
endif


if oestr.f_screen EQ 0 then oestr.n_screen = 0
nscr = oestr.n_screen
Widget_Control,wids.scrlabel,Set_Value=$
	'# of defined screens: '+strcompress(nscr,/rem)

Widget_Control,wids.fwrite,Set_Value=strcompress(oestr.fwrite,/rem)

Widget_Control,wids.t_source,Set_Value= strcompress(oestr.t_source)

Widget_Control,wids.t_image,Set_Value= strcompress(oestr.t_image)

Widget_Control,wids.t_incidence,Set_Value= strcompress(oestr.t_incidence)

Widget_Control,wids.t_reflection,Set_Value= strcompress(oestr.t_reflection)

Widget_Control,wids.f_angle,Set_Value=strcompress(oestr.f_angle,/rem)

Widget_Control,wids.alpha,Set_Value=strcompress(oestr.alpha)

Widget_Control,wids.f_refrac,Set_Value=strcompress(oestr.f_refrac,/rem)

Widget_Control,wids.fmirr,Set_Value=strcompress(oestr.fmirr-1,/rem)

Widget_Control,wids.f_grating,Set_Value=strcompress(oestr.f_grating,/rem)

Widget_Control,wids.f_crystal,Set_Value= strcompress(oestr.f_crystal,/rem)

Widget_Control,wids.f_move,Set_Value=strcompress(oestr.f_move,/rem)

Widget_Control,wids.fslit,Set_Value=strcompress( oestr.fslit ,/rem)

fdummy = 0
if oestr.f_ripple EQ 1 then fdummy=1
if oestr.f_facet EQ 1 then fdummy=2
if oestr.f_roughness EQ 1 then fdummy=3
if oestr.f_koma EQ 1 then fdummy=4
if oestr.f_segment EQ 1 then fdummy=5
Widget_Control,wids.fdummy,Set_Value=strcompress(fdummy,/rem)

Widget_Control,wids.fstat,Set_Value=strcompress( oestr.fstat,/rem)

end
;		
;========================================================================
;

PRO xshoe_event,event

catch, error_status
 if error_status ne 0 then begin
   catch, /cancel
   message,/info,'Error caught: '+!err_string
   if sdep(/w) then itmp = dialog_message('XSHOE_EVENT: Error caught: '+$
	!err_string,/error)
   goto,out
endif

stateid = widget_info(event.handler,/Child)
Widget_Control,stateid,Get_UValue=state,/No_Copy
Widget_Control,event.id,Get_UValue=uval
; help,uval

CASE uval OF
  'DONE': BEGIN
	if Ptr_Valid(state.input_pointer) then begin
	  tmp = state.oestr
	  xshoe_updateoestr,state.wids,tmp
	  *(state.input_pointer) = tmp
	endif
	Widget_Control,event.top,/Destroy
	Return
	END
  'CANCEL': BEGIN
	Widget_Control,event.top,/Destroy
	Return
	END
  'F_REFRAC': BEGIN
	Widget_Control,state.wids.f_refrac,Get_Value=tmp
	if strcompress(tmp(0),/rem) NE '1' then goto,out
	tmpstr = state.oestr
	xshoe_f_refrac,tmpstr,Group=event.top,ACTION=action
	if action EQ 'DONT' then goto,out
	state.oestr = tmpstr
	; if FZP selected, set grating flag ON
	Widget_Control,state.wids.f_grating,Get_Value=tmp
	if strcompress(tmp,/rem) NE '1' and state.oestr.FZP EQ 1 then begin
	  Widget_Control,state.wids.f_grating,Set_Value='1'
	  itmp = Dialog_Message(/Info,'Diffraction set to GRATING, as a '+$
	  'consequence of Fresnel Zone Plane setting',Dialog_Parent=$
	  event.top)
	endif
	END
  'FMIRR': BEGIN
	Widget_Control,state.wids.fmirr,Get_Value=tmp
	fmirr = 1+fix(tmp)
	tmpstr = state.oestr
	xshoe_fmirr,tmpstr,fmirr=fmirr,Group=event.top,ACTION=action
	if action EQ 'DONT' then goto,out
	state.oestr = tmpstr
	END
  'F_GRATING': BEGIN
	Widget_Control,state.wids.f_grating,Get_Value=tmp
	if strcompress(tmp(0),/rem) NE '1' then goto,out
	tmpstr = state.oestr
	xshoe_f_grating,tmpstr,Group=event.top,ACTION=action
	if action EQ 'DONT' then goto,out
	state.oestr = tmpstr
	END
  'F_CRYSTAL': BEGIN
	Widget_Control,state.wids.f_crystal,Get_Value=tmp
	if strcompress(tmp(0),/rem) NE '1' then goto,out
	tmpstr = state.oestr
	xshoe_f_crystal,tmpstr,Group=event.top,ACTION=action
	if action EQ 'DONT' then goto,out
	state.oestr = tmpstr
	END
  'F_MOVE': BEGIN
	Widget_Control,state.wids.f_move,Get_Value=tmp
	if strcompress(tmp(0),/rem) NE '1' then goto,out
	tmpstr = state.oestr
	xshoe_f_move,tmpstr,Group=event.top,ACTION=action
	if action EQ 'DONT' then goto,out
	state.oestr = tmpstr
	END
  'FSLIT': BEGIN
	Widget_Control,state.wids.fslit,Get_Value=tmp
	if strcompress(tmp(0),/rem) NE '1' then goto,out
	tmpstr = state.oestr
	xshoe_fslit,tmpstr,Group=event.top,ACTION=action
	if action EQ 'DONT' then goto,out
	state.oestr = tmpstr
	END
  'FDUMMY': BEGIN
	Widget_Control,state.wids.fdummy,Get_Value=tmp
	index = strcompress(tmp(0),/rem)

	tmpstr = state.oestr
	case index of
	  '0': BEGIN
	  	state.oestr.f_ripple = 0
		state.oestr.f_facet = 0
		state.oestr.f_roughness = 0
		state.oestr.f_koma = 0
		state.oestr.f_segment = 0
		END
	  '1': BEGIN
		f_ripple_old = tmpstr.f_ripple
		xshoe_f_ripple,tmpstr,Group=event.top,ACTION=action
		if action EQ 'DONT' then begin
		  state.oestr.f_ripple = f_ripple_old
		  goto,out
		endif else begin
		  tmpstr.f_ripple = 1
		  state.oestr = tmpstr
		endelse
		END
	  '2': BEGIN
		f_facet_old = tmpstr.f_facet
		xshoe_f_facet,tmpstr,Group=event.top,ACTION=action
		if action EQ 'DONT' then begin
		  state.oestr.f_facet = f_facet_old
		  goto,out
		endif else begin
		  tmpstr.f_facet = 1
		  state.oestr = tmpstr
		endelse
		END
	  '3': BEGIN
		f_roughness_old = tmpstr.f_roughness
		xshoe_f_roughness,tmpstr,Group=event.top,ACTION=action
		if action EQ 'DONT' then begin
		  state.oestr.f_roughness = f_roughness_old
		  goto,out
		endif else begin
		  tmpstr.f_roughness = 1
		  state.oestr = tmpstr
		endelse
		END
	  '4': BEGIN
		f_koma_old = tmpstr.f_koma
		xshoe_f_koma,tmpstr,Group=event.top,ACTION=action
		if action EQ 'DONT' then begin
		  state.oestr.f_koma = f_koma_old
		  goto,out
		endif else begin
		  tmpstr.f_koma = 1
		  state.oestr = tmpstr
		endelse
		END
	  '5': BEGIN

		f_segment_old = tmpstr.f_segment
		xshoe_f_segment,tmpstr,Group=event.top,ACTION=action
		if action EQ 'DONT' then begin
		  state.oestr.f_segment = f_segment_old
		  goto,out
		endif else begin
		  tmpstr.f_segment = 1
		  state.oestr = tmpstr
		endelse
		END
	  else:
	endcase
	state.oestr = tmpstr
	END
  'FSTAT': BEGIN
	Widget_Control,state.wids.fstat,Get_Value=tmp
	if strcompress(tmp(0),/rem) NE '1' then goto,out
	tmpstr = state.oestr
	xshoe_fstat,tmpstr,Group=event.top,ACTION=action
	if action EQ 'DONT' then goto,out
	state.oestr = tmpstr
	END

  'SCRMGR': BEGIN
	tmpstr = state.oestr
	xshscr,tmpstr,Group=event.top,ACTION=action
	if action EQ 'DONT' then goto,out
	state.oestr = tmpstr
	xshoe_updatemain,state.wids,tmpstr
	END
  ELSE: BEGIN
	END
ENDCASE


out:
IF widget_info(stateid,/Valid_Id) THEN $
  Widget_Control,stateid,Set_UValue=state,/No_Copy
END


;		
;========================================================================
;
Pro xshoe,input_pointer,ACTION=action,Group=group,FILE=file, Wtitle=wtitle

input_type = type(input_pointer)

case input_type of
 0: BEGIN 	; undefined
  	oestr = xsh_defaults('XSHOE')
  	input_pointer = 0
	END
 10: BEGIN 	; pointer
	oestr = *input_pointer
	END
  else: message,'Wrong input'
endcase

IF NOT(KEYWORD_SET(wtitle)) THEN wtitle='Set o.e. parameters'

IF KEYWORD_SET(file) THEN BEGIN
  oestr=read_gfile(file)
  input_pointer = 0
ENDIF 


;
; start creating widgets
;

base1=Widget_Base(Column=1,Title=wtitle)

butbase=Widget_Base(base1,Row=1)
  doner=Widget_Button(butbase,Value='Accept',UValue='DONE')
  canceler=Widget_Button(butbase,Value='Cancel',UValue='CANCEL')

wscreens=Widget_Base(base1,Row=1,Frame=1) 
  wscrlabel=Widget_Label(wscreens,value='# of defined screens: ???',/align_left)
  wtmp=Widget_Button(wscreens,value='Screen Manager...',UVAL='SCRMGR',$
	/align_right)


para=Widget_Base(base1,Column=1,Frame=1) 

;
; fwrite (files to save)
;
value=['0','All','Mirror','Image','None']
title='Files to write out'
w_fwrite=CW_Droplist(para,Value=value,Title=title,UValue='FWRITE')

;
; t_source (source plane distance)
;
wtmp0=Widget_Base(para,Row=1)
title='Source plane distance [cm]'
wtmp=Widget_Label(wtmp0,value=title,/align_left)
w_t_source=Widget_Text(wtmp0,XSize=12,Value='0.0',UValue='T_SOURCE',/Edit)
;
; t_image (image plane distance)
;
wtmp0=Widget_Base(para,Row=1)
title='Image plane distance [cm]'
wtmp=Widget_Label(wtmp0,value=title,/align_left)
w_t_image=Widget_Text(wtmp0,XSize=12,Value='0.0',UValue='T_IMAGE',/Edit)
;
; t_incidence
;
wtmp0=Widget_Base(para,Row=1)
title='Incidence angle respect to the normal [deg]'
wtmp=Widget_Label(wtmp0,value=title,/align_left)
w_t_incidence=Widget_Text(wtmp0,XSize=12,Value='0.0',UValue='T_INCIDENCE',/Edit)
;
; t_reflection
;
wtmp0=Widget_Base(para,Row=1)
title='Reflection angle respect to the normal [deg]'
wtmp=Widget_Label(wtmp0,value=title,/align_left)
w_t_reflection=Widget_Text(wtmp0,XSize=12,Value='0.0',UValue='T_REFLECTION',$
	/Edit)

;
; f_angle 
;
value=['0','No','Yes']
title='Write out Incident/Reflected angles'
w_f_angle=CW_Droplist(para,Value=value,Title=title,UValue='F_ANGLE')

;
; alpha
;
wtmp0=Widget_Base(para,Row=1)
title='Mirror orientation angle [deg]'
wtmp=Widget_Label(wtmp0,value=title,/align_left)
w_alpha=Widget_Text(wtmp0,XSize=12,Value='0.0',UValue='ALPHA',/Edit)
; 
; f_refrac
;
value=['0','Reflector','Refractor...','Empty']
title='Type of element'
w_f_refrac=CW_Droplist(para,Value=value,Title=title,UValue='F_REFRAC')

;
; fmirr 
;
value=['4','Spherical...','Elliptical...','Toroidal...','Parabolical...',$
  'Plane...','Codling Slit...','Hyperbolical...','Conical...','Polynomial...']
title='Figure'
w_fmirr=CW_Droplist(para,Value=value,Title=title,UValue='FMIRR')
; 
; f_grating
;
value=['0','Mirror','Grating...']
title='Diffraction'
w_f_grating=CW_Droplist(para,Value=value,Title=title,UValue='F_GRATING')

;
; f_crystal
;
value=['0','No','Yes...']
title='Crystal'
w_f_crystal=CW_Droplist(para,Value=value,Title=title,UValue='F_CRYSTAL')

;
; f_move
;
value=['0','No','Yes...']
title='Mirror movement'
w_f_move=CW_Droplist(para,Value=value,Title=title,UValue='F_MOVE')

;
; fslit
;
value=['0','No','Yes...']
title='Exit slit'
w_fslit=CW_Droplist(para,Value=value,Title=title,UValue='FSLIT')
;
; fdummy (mod sur ??? )
;
value=['0','None','Surface error...','Faceted Surface...',$
  'Surface Roughness...','Kumakhov lens...','Segmented Mirror...']
title='Modified surface'
w_fdummy=CW_Droplist(para,Value=value,Title=title,UValue='FDUMMY')

;
; fstat (source mov)
;
value=['0','No','Yes...']
title='Source Movement'
w_fstat=CW_Droplist(para,Value=value,Title=title,UValue='FSTAT')

;
; end of widget definition 
;



Widget_Control,base1,/Realize

wids =	{ scrlabel:wscrlabel,$
	fwrite:w_fwrite, $
	t_source:w_t_source, $
	t_image:w_t_image, $
	t_incidence:w_t_incidence, $
	t_reflection:w_t_reflection, $
	f_angle:w_f_angle, $
	alpha:w_alpha, $
	f_refrac:w_f_refrac, $
	fmirr:w_fmirr, $
	f_grating:w_f_grating, $
	f_crystal:w_f_crystal, $
	f_move:w_f_move, $
	fslit:w_fslit, $
	fdummy:w_fdummy, $
	fstat:w_fstat }
   
xshoe_updatemain,wids,oestr

                
state = {wids:wids, oestr:oestr, input_pointer:input_pointer }

Widget_Control,Widget_Info(base1,/Child),Set_UValue=state,/No_copy
XManager,'XSHOE',base1,MODAL=modal,No_Block=1

END
