
;
;+
;
;==============================  XSh_Ray_Prop   ==================================
;
; XSh_Ray_Prop is a widget based graphical interface for calculating and
; diaplaying the propagation of a beam in vacuum
;
;
;  Menu bar
;  ========
;  File:
;  Quit: to exit from the program
;
;  Help:   Shows the XSh_Ray_Prop help (this text).
;
;  Other controls
;  ==============
;  
;  "Quit" button: quite sthe program
;  "Show contols": starts an application allowing to change interactively 
;	the parameters. 
;  "Go animation" starts the calculation.
;
; COPYRIGHT:
;	XSH_Ray_Prop  belongs to SHADOWVUI package and it is distributed 
;	as an XOP extension.
;	PLEASE REFER TO THE XOP COPYRIGHT NOTICE BEFORE USING IT.
;	http://www.esrf.fr/computing/scientific/xop/
;
; CREDITS:
;	Published calculations made with SHADOW and SHADOWVUI should refer:
;
;	C. Welnak, G.J. Chen and F. Cerrina "SHADOW: a synchrotron
;	radiation X-ray optics simulation tool", Nucl. Instr. and Meth. A347
;	(1994) 344-347 
;	
;	M. Sanchez del Rio and R. J. Dejus "XOP: Recent Developments"
;	SPIE proceedings vol. 3448, pp.340-345, 1998.
;
; LAST MODIFICATION: msr/msr/00-07-10
;
;-
;
; -----------------------------------------------------------------------
;	Author: M. Sanchez del Rio (srio@esrf.fr) , ESRF
;	00/07/10 srio@esrf.fr version 1.1 for xop 2.0. Documented.
;
;
;========================================================================
;
;
;===============================================================================
;
PRO xsh_ray_prop_event,event


!p.position=0 

Widget_Control, event.id, get_UValue=eventUValue
;Widget_Control, event.id, get_Value=Value

if n_elements(eventuvalue) EQ 0 then eventuvalue = ''
if not(keyword_set(eventuvalue)) then eventuvalue = ''

stateid = Widget_Info(event.handler,/Child)
Widget_Control, stateid, get_UValue=state, /No_Copy

widget_control,state.wids.draw,get_value=windownum
wset,windownum

;
; Action
;
Case eventUValue OF
     'RESIZE': BEGIN
	widget_control,state.wids.draw,$
		scr_xsize=event.x-5,scr_ysize=event.y-105
        Widget_Control,state.wids.command,xsize=(event.x-5)/8
        Widget_Control,state.wids.base,xsize=event.x-5
        Widget_Control,state.wids.command,Get_Value=Command
	Widget_Control,/HourGlass
        tmp = execute(command(0)+',group=event.top')
     END
    'QUIT': Begin
	; Free pointer if input type is not a pointer
	IF state.type_input NE 10 THEN Ptr_Free,state.StrPtr
	;
	Widget_Control, event.top, /destroy
	Return
	End
    'APPLY': Begin
	;update command
	tmp=state.StrPtr
	Command = XSh_Ray_Prop_Command(tmp)
	Widget_Control,state.wids.command,Set_Value=Command
	Widget_Control,/HourGlass
	tmp = execute(command(0)+',group=event.top')
	End
    'PRINT': Begin
	Widget_Control,state.wids.command,Get_Value=Command
	XPrint,Buffer=command(0)+',/print', Group=event.top
	End
    'REFRESH': Begin
	Widget_Control,state.wids.command,Get_Value=Command
	if strcompress(Command(0),/Rem) NE '' then begin
	  Widget_Control,/HourGlass
	  tmp = execute(command(0)+',group=event.top')
	endif
	End
    'SHOWHIDE': Begin
	Case state.controls_status of
	'hiden': Begin
		Widget_Control,state.wids.showhide,set_value='Hide controls'
		state.controls_status='shown'
		p=0
		Widget_Control,/HourGlass
		Widget_control,state.wids.refresh,sensitive=0
		xsh_Ray_Prop_controls,state.strptr,TLB_ID=p,Group=event.top, $
			Caller_ID=event.handler
		state.wids.controls=p
		End
	'shown': Begin
		Widget_Control,state.wids.showhide,set_value='Show controls'
		state.controls_status='hiden'
		Widget_control,state.wids.refresh,sensitive=1
		IF state.wids.controls NE 0L THEN $
			Widget_Control,state.wids.controls,/destroy
		state.wids.controls=0L
		End
	EndCase
	End
    'Help.XSh_Ray_Prop': xhelp,'xsh_ray_prop',GRO=event.top
    'Help.Ray_Prop': xhelp,'ray_prop',GRO=event.top
    else: print,'else : ',eventUValue
ENDCASE


Widget_Control, stateid, Set_UValue=state, /No_Copy

END
;
;===============================================================================
;
PRO xsh_ray_prop,input, Col1=col1, Col2=col2, Iters=iters, Group = group , $
 File=file, Wtitle=wtitle, NOEXECUTE=noexecute

on_error,2
;
; analyse input
;
CASE type(input) OF
  0: BEGIN ; undefined
	str = XSh_Defaults('XSH_RAY_PROP')
	ptr = Ptr_New(str)
     END
  8: BEGIN ; structure
	ptr = Ptr_New(input)
     END
  10: BEGIN ; pointer
	ptr = input
     END
ENDCASE

if keyword_set(file) then (*ptr).shadow_in=file
if keyword_set(col1) then (*ptr).col1=col1
if keyword_set(col2) then (*ptr).col2=col2
if keyword_set(iters) then (*ptr).iters=iters


; check if file exists
if checkfile((*ptr).shadow_in) NE 1 then begin
  itmp = Dialog_Message(/Question,Dialog_Parent=group,$
  ['XSH_RAY_PROP: Input file does not exist: '+(*ptr).shadow_in,'Abort?'])
  if itmp EQ 'Yes' then return
endif

if not(keyword_set(wtitle)) then wtitle='Ray_Prop window'
; 
; Create widgets
;
wbase=widget_base(/col,MBAR=wMenuBar,Title=wtitle,$
 /TLB_Size_Events,UVALUE='RESIZE')
wstate=widget_base(wbase) ; to store state

;Menu bar
wFileMenu =  WIDGET_BUTTON(wMenuBar, VALUE='File', /MENU)
  wtmp=WIDGET_BUTTON(wFileMenu, VALUE='Print...', Uvalue= 'PRINT')
  wtmp=WIDGET_BUTTON(wFileMenu, VALUE='Quit', Uvalue= 'QUIT')

wHelpMenu = WIDGET_BUTTON(wMenuBar, VALUE='Help', /HELP)
  wHelptmp = WIDGET_BUTTON(wHelpMenu, VALUE='XSh_Ray_Prop', $
	UVALUE='Help.XSh_Ray_Prop')
  wHelptmp = WIDGET_BUTTON(wHelpMenu, VALUE='Ray_Prop', UVALUE='Help.Ray_Prop')


wblk =widget_base(wbase,/col)

wtmp0 = Widget_Base(wbase,/Row)
wtmp = Widget_Button(wtmp0,Value='Quit',UValue='QUIT')
wshowhide = Widget_Button(wtmp0,Value='Show controls',UValue='SHOWHIDE')
wrefresh = Widget_Button(wtmp0,Value='Go Animation',UValue='REFRESH')

WDraw = widget_draw(wbase,xsize=500,ysize=350,RETAIN=2)

wCommand = Widget_Text(wbase,Value='',/Align_Left,XSize=70,/Edit,$
	UValue='REFRESH')

wids = {showhide:wshowhide,command:wcommand, controls:0L, draw:wdraw,$
	base:wbase,refresh:wrefresh}
state = {wids:wids, controls_status:'hiden', strptr:ptr, $
	type_input:type(input)}

stateid = Widget_Info(wbase,/Child)
Widget_Control, stateid, Set_UValue=state, /No_Copy

widget_control,wbase,/realize

Command = XSh_Ray_Prop_Command(ptr)
if not(keyword_set(noexecute)) then begin
  itmp = execute(command(0)+',group=group')
  Widget_Control,wcommand,Set_Value=command(0)
endif 

xmanager, 'xsh_ray_prop', wbase, GROUP=group, /No_Block

end

