PRO showsh3,file,columns=columns,vel=vel,npoints=npoints,color=color, $
  ax=ax,az=az,xrange=xrange,yrange=yrange,zrange=zrange, nolost=nolost
;

;+
; NAME:
;	SHOWSH3
; PURPOSE:
;	Plot a 3-dimensional scattered plot of 3 SHADOW columns.
; CATEGORY:
;	SHADOW's utilities.
; CALLING SEQUENCE:
;	showsh3,shadow_in,keyword_parameters
; INPUTS:
;	shadow_in     an IDL structure with SHADOW data
; OPTIONAL INPUTS:
; KEYWORD PARAMETERS:
;	COLUMNS = [col1,col2,col3] column to be plotted (default=[1,2,3])
;	VEL = when set to 1, plots a starigt line with velocity direction.
;	[XYZ]XRANGE = [ min,max ], plot limits
;	A[XZ] = rotation of graph axis (as in SURFACE)
;	NOLOST = consider losses
;		0 all rays (default option)
;		1 exclude losses;
; OUTPUTS:
;	a graphic
; COMMON BLOCKS:
;	None.
; SIDE EFFECTS:
;	None.
; RESTRICTIONS:
;	None.
; PROCEDURE:
;       Easy
; MODIFICATION HISTORY:
;	M. Sanchez del Rio. ESRF. Grenoble, April 1996
;-
on_error,2
if not(keyword_set(ax)) then ax = 30
if not(keyword_set(az)) then az = 30
if not(keyword_set(columns)) then columns = [1,2,3]
if n_elements(columns) NE 3 then begin
  print,'SHOWSH3: Error, Number of columns must be 3.'
  return
endif
a = getshcol(file,columns,nolost=nolost)
if keyword_set(npoints) then a=a(*,0:npoints-1)

x=reform( a(0,*) )
y=reform( a(1,*) )
z=reform( a(2,*) )
xlim=[min(x),max(x)]
ylim=[min(y),max(y)]
zlim=[min(z),max(z)]
if not(keyword_set(xrange)) then xrange=xlim
if not(keyword_set(yrange)) then yrange=ylim
if not(keyword_set(zrange)) then zrange=zlim

surface,[[0,0],[0,0]],xra=xrange,yran=yrange,zran=zrange,/nodata,/save, $
  ax=ax,az=az, $
  xtitle='column '+strcompress(columns(0),/rem), $
  ytitle='column '+strcompress(columns(1),/rem), $
  ztitle='column '+strcompress(columns(2),/rem)
if not(keyword_set(color)) then cc1=x*0+125 else begin
  cc = reform( getshcol(file,color,nolost=nolost) )
  if keyword_set(npoints) then cc=cc(0:npoints-1)
  cclim = [min(cc),max(cc)]
  cc1 = fix( (cc - cclim(0))/(cclim(1)-cclim(0)) * 255 )
endelse
for i=0,n_elements(z)-1 do plots, [x(i),x(i)], [y(i),y(i)], [z(i),z(i)],/t3d, color=cc1(i),psym=4


if keyword_set(vel) then begin
  avel = getshcol(file,[4,5,6],nolost=nolost)
  if keyword_set(npoints) then avel=avel(*,0:npoints-1)
  vx = avel(0,*)
  vy = avel(1,*)
  vz = avel(2,*)
  vlen = abs(ylim(1) - ylim(0))/ 10.
  for i=0,n_elements(z)-1 do plots, [x(i),x(i)+vlen*vx(i)], [y(i),y(i)+vlen*vy(i)], [z(i),z(i)+vlen*vz(i)],/t3d, color=25
endif
end
