pro PRESURFACE, file, surf, XRANGE=xrange,YRANGE=yrange,TITLE=title,  $
XTITLE=xtitle,YTITLE=ytitle,XYRANGE=xyrange,ZTITLE=ztitle,         $
ZRANGE=zrange,NOPLOT=noplot
;+
; NAME:
;	PRESURFACE
; PURPOSE:
;	to visualize a surface in the SHADOW's format
; CATEGORY:
;       SHADOW's utilities
; CALLING SEQUENCE:
;	presurface,'myfile',idl_var,Keyboard_parameters
; INPUTS:
;	myfile  name of the file with data (between quotes) 
; OPTIONAL INPUT PARAMETERS:
;	idl_var name of an idl variable to store the data
; KEYWORD PARAMETERS:
;		XRANGE=[xmin,xmax] range of the x variable for the plot
;		YRANGE=[ymin,ymax]              y
;		ZRANGE=[zmin,zmax]              y
;		XYRANGE=[xymin,xymax] sets XRANGE and YRANGE simultaneously.
;		TITLE='top_title' title to be written at the top
;		XTITLE='x_title'  title of x axis
;		YTITLE='y_title'           y
;		ZTITLE='z_title'           z
;		NCOL = number of columns in input file (def=2)
;		XCOL = column for x (default=1)
;		YCOL = column for y (default=2)
;		NOPLOT = When set, inhibits the graph.
; OUTPUTS:
;	a plot
; OPTIONAL OUTPUT PARAMETERS:
;	the data of the file  in the structure variable selected (idl_var)
;       surf = {x:x , y:y , z:z}
; COMMON BLOCKS:
;	None.
; SIDE EFFECTS:
;	None.
; RESTRICTIONS:
;	None.
; PROCEDURE:
;	Straightforward.
; MODIFICATION HISTORY:
;	by M. Sanchez del Rio. ESRF. Grenoble, Sep 1992
;	95/09/26 MSR adds /NOPLOT keyword.
;-	
on_error,2
charsize_old = !p.charsize
!p.charsize=2
if not(keyword_set(title)) then title = file
if not(keyword_set(xtitle)) then xtitle = ' x '
if not(keyword_set(ytitle)) then ytitle = ' y '
if not(keyword_set(ztitle)) then ztitle = ' z '
input_type = (size(file)) ((size(file)) (0)+1)
;
;
if (input_type eq 7) then begin
  openr,Unit,file,/get_lun
    readf,Unit,npointx,npointy
    yy = fltarr(npointy)
    xx = fltarr(npointx)
    zz = fltarr(npointx,npointy)
    readf,Unit,yy
    zzz = fltarr(npointy)
    for i=0,npointx-1 do begin
      readf,Unit,a,zzz
      xx(i) = a
      zz(i,*) = zzz
    endfor
  free_lun,Unit
endif
;
;  search for extrema
;
if not(keyword_set(xrange)) then begin
  xrange = fltarr(2)
  off1 = 0.1*abs( max(xx)-min(xx) )
  xrange =[min(xx)-off1,max(xx)+off1]
endif
if not(keyword_set(yrange)) then begin
  yrange = fltarr(2)
  off2 = 0.1*abs( max(yy)-min(yy) )
  if off2 lt 1e-10 then off2 = 0.1*max(yy)
  yrange =[min(yy)-off2,max(yy)+off2]
endif
if keyword_set(xyrange) then begin
   yrange = xyrange
   xrange = xyrange
endif
if not(keyword_set(zrange)) then begin
  zrange = fltarr(2)
  maxzz=max(zz)
  minzz=min(zz)
  off3 = 0.10*abs( maxzz-minzz )
  off4 = 10*abs( maxzz-minzz )
  zrange =[minzz-off3,maxzz+off4]
endif
;
if not(keyword_set(noplot)) then $
  surface,zz,xx,yy,xtitle=xtitle,ytitle=ytitle,ztitle=ztitle,   $
  xrange=xrange,yrange=yrange,zrange=zrange,az=45,ax=60,        $
  title=title
;
!p.charsize = charsize_old
surf = {   x: xx, y: yy, z:zz   }
return
end
