;+
; 
;      ============================= NOP  ======================
;
;  NOP is a collection of programs for neutron optics
;
;   The documentation for NOP (an XOP extension) will be found at:
;   http://www.esrf.fr/computing/scientific/xop/
;
;		
; The NOP main window allows you to start the different applications :
;
;       nsources: for maxwellian source spectra
;	nmirror: for mirror reflectivity and related parameters 
;		(refractive index, ...)
;	ncrystal: for perfect and mosaic crystal diffraction profiles.
;	mamon: for perfect crystals, multiple beam diffraction.
;	imd: for multilayers.
;
;    DABAX tools:
;	Main interface to view and plot data from the database.
;
;
; LAST MODIFICATION: msr/msr/03-02-12
;
;-
;
;=====================================================================
;
FUNCTION nop_version,group=group
RETURN,'1.0Beta1'
END
;
;=====================================================================
;
PRO nop_about,group=group
;
; launches about window
;
catch, error_status
if error_status ne 0 then begin
   message,/info,'error caught: '+!err_string
   itmp = Dialog_Message(Dialog_Parent=group, $
   /Error,'NOP_ABOUT: error caught: '+!err_string)
   catch, /cancel
   on_error,2
   Return
endif
text = [$
' ', $
'                            NOP '+Nop_Version()+'        ',$
' ',$
'                         Neutron OPtics                       ',$
' ',$
'           (Graphical user interfaces for  thermal neutron ',$
'           spectral, optics, and data analysis calculations)   ',$
' ',$
'                             by                                          ',$
' ',$
'           Lucia Alianelli     (alianell@ill.fr)                        ',$
' ', $
'                             and                                         ',$
' ', $
'           Manuel Sanchez del Rio  (srio@esrf.fr)                        ',$
' ',$
' ']
tmp = Dialog_Message(dialog_parent=group,text,/info,title='About Nop')
end  ; Nop_about
;
;============================================================================
;
PRO Nop_Event, event

Catch, error_status
IF error_status NE 0 THEN BEGIN
  Message,/Info,'error caught: '+!err_string
  itmp = Dialog_Message(/Error,Dialog_Parent=event.top,$
    'XOP_EVENT: '+'error caught: '+!error_state.msg)
  Catch, /Cancel
  GoTo,out
ENDIF

;
; register the events
;
stateid = Widget_Info(event.handler,/Child)
Widget_control, stateid,  Get_uValue=state,/No_copy

Widget_Control,event.id,GET_UValue=uval


CASE uval OF
  'Quit': BEGIN
	Widget_Control,event.top,/Destroy
	END
  'ABOUT': NOP_About,Group=event.top
  'HELP': BEGIN
	tmp=''
	Widget_Control,event.id,Get_Value=tmp
	Xhelp,StrLowCase(tmp[0]),group=event.top
	END
  'Start...': BEGIN
	CASE event.value OF
	  'Quit':Widget_Control,event.top,/Destroy
	  'Neutron reactor spectra (NSOURCES)': XOP_IFC,'nsources'
	  'Mirrors (NMIRROR)': nmirror
	  'Mirrors and attenuators on source (NFLUX)': nflux
	  'Multilayers (IMD)': imd4nop
	  'Crystals-Diffraction profiles (NCRYSTAL)': ncrystal
	  'Crystals-Multiple Beam Diffraction (MAMON)': Xop_IFC,'mamon'
	  'Database (DABAX)': dabax,/no_xray
	  else:
	ENDCASE
	END
  'XPLOT': BEGIN
	Widget_Control,/HourGlass
	set = state.set
	IF N_Elements(set) GT 1 THEN $
	  Xplot,set,Group=event.top, No_Block=state.no_block ELSE $
	  Xplot, No_Block=state.no_block  ; ,Group=event.top 
	END
  else: BEGIN
	Widget_Control,/HourGlass
	command = uval+',Group=event.top'
	itmp = Execute(command)
	END
ENDCASE

out:
If Type(stateid) EQ 3 THEN $
  IF Widget_Info(stateid,/Valid_Id) EQ 1 THEN $
  Widget_Control, stateid, Set_UValue=state,/No_Copy

END ; XPeakFit_event
;
;============================================================================
;


PRO Nop, set, Group = group, No_Block = no_Block

Catch, error_status
IF error_status NE 0 THEN BEGIN
  Message,/Info,'error caught: '+!err_string
  itmp = Dialog_Message(/Error,Dialog_Parent=group,$
    'NOP: '+'error caught: '+!error_state.msg)
  Catch, /Cancel
  RETURN
ENDIF

IF N_Elements(no_block) EQ 0 THEN no_block=1
IF N_Elements(set) EQ 0 THEN set=0


wTop = Widget_Base(Title='NOP '+nop_version(),MBAR=wMenu)
wtmp = Widget_Base(wTop) ; to store state

;
; define menu bar
;
wtmp0 = Widget_Button(wMenu, Value='File', /MENU)
 wtmp1 = Widget_Button(wtmp0, Value='Quit', UValue='Quit',/Separator)

wToolsMenu = Widget_Button(wMenu,Value='Tools',/Menu)
  wtmp = Widget_Button(wToolsMenu,Value='Plotting tool...',$
	UValue='XPLOT')
  wtmp = Widget_Button(wToolsMenu,Value='Display file...',$
	UValue='XOP_FILE_DISPLAY')
  wtmp = Widget_Button(wToolsMenu,Value='XOP Main window...',$
	UValue='XOP')

wHelpMenu = Widget_Button(wMenu,Value='Help',/Help)
  wtmp = Widget_Button(wHelpMenu, Value='About NOP',UValue='ABOUT')
  wtmp = Widget_Button(wHelpMenu, Value='NOP',UValue='HELP')
;

desc = [ '0\Quit', $
	 '1\Start...' , $
         '1\Sources' , $
           '2\Neutron reactor spectra (NSOURCES)' , $
         '1\Optics' , $
           '0\Mirrors (NMIRROR)' , $
;           '0\Mirrors and attenuators on source (NFLUX)' , $
           '0\Multilayers (IMD)' , $
           '0\Crystals-Multiple Beam Diffraction (MAMON)' , $
           '2\Crystals-Diffraction profiles (NCRYSTAL)' , $
         '1\DABAX' , $
           '2\Database (DABAX)']

wBase = Widget_Base(wTop,/Column)
wtmp = CW_PDMenu(wBase,desc,/Return_Name,UValue='Start...')


if sdep() EQ 'WINDOWS' then $
font = 'VERDANA*BOLD*ITALIC*24' else $
font = '-adobe-helvetica-bold-o-normal--18-180-75-75-p-104-iso8859-1'

;junk = WIDGET_LABEL( wBase, FONT=font, VALUE=' NOP ')
junk = WIDGET_LABEL( wBase, FONT=font, $
  VALUE="NOP: Neutron optics")


Widget_Control,wTop,/Realize 

wids = { junk:0}
state= { wids:wids, set:set, no_block:no_block}

Widget_control,Widget_Info(wTop,/CHILD),set_uValue=state,/No_copy

XManager, 'NOP', wTop, GROUP_LEADER=group,No_Block=no_block

END ; XpeakFit
