;
; oct/nov 2001 - VFN : - added Graphical interface while keeping the
;	 	   		 	   	 possibility to use INES without GUI.
;	 	   		 	   	 Removed all auto generation of postscript files
;

PRO INES_COMMON_DEF
;
; added by srio to define common blocks
;

COMMON INES_GRAPHICAL_WINDOWS,xplot_p, xwindow_p
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;Define some constants;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
COMMON CONSTANTS, avog, hbar, elch, speed_of_light, k_boltz, pi, n_multiph

avog = 6.0222d23                ; [nuclei/mole]
hbar = 1.0551d-34               ; [Js]
elch = 1.6022d-19               ; [C]
speed_of_light = 2.9979d8       ; [m/s]
k_boltz = 1.3806d-23            ; [JK^-1]
pi = acos(-1.0)                 ; pi
n_multiph = 30.                 ; number of multiphonon terms
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;Parameters read from input file;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
COMMON INPUT_PARAM, inst_f_switch, nhr, en_col, data_col, inst_nhr, inst_en_col, inst_data_col, $
                   arr_size, inst_arr_size, resonant_energy, atomic_mass, max_en, back_min, back_max, $
                   en_1, en_2, sub_flag, pif

; inst_f_switch defines wether the instrumental function data are absent (0), contained in the same
; data file as the inelastic data (1) or in another file(2)
; nhr and inst_nhr are the number of header lines in the inelastic and instrumental scans
; en_col, data_col, inst_en_col, inst_data_col define which columns are to be read in the file(s)
; arr-size and inst_arr_size define the size of temporary array(s) used to read the file(s) row by row
; resonant_energy and atomic_mass have a clear meaning
; max_en is the maximum energy considered
; back_min and back_max define the points where background has to be calculated
; The elastic peak is removed in the range en_1 < energy < en_2, using a simple linear interpolation
; (sub_flag=0) or subtracting the instrumental function after proper normalization (sub_flag<>0)
; pif is similar to the parameter of Kohn's DOS program: if pif << 1 then the instrumental
; function is deconvoluted completely, if pif >> 1 no deconvolution is performed.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;Arrays read from data file (and from instrumental function file);;;;;;;;;;;;;;;;;
COMMON FILE_DATA, energy, inst_energy, cts_inc_r, err_inc_r, cts_for_r, err_for_r
; energy and inst_energy: energy columns; cts_inc_r: counts in the incoherent channel
;(err_inc_r is the error), cts_for_r: counts in the incoherent channel (err_for_r is the error)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;Names of the file containing incoherent spectrum (and instrumental function spectrum);;;;;;
COMMON FILE_NAMES, data_file, inst_file, output_files
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;Energy moments of incoherent and forward spectra;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
COMMON MOMENTS, mass, rec_en, res_en_J, integral_inc, integral_inc_err, $
                fm_inc, fm_inc_err, fm_inc_exp, fm_inc_exp_err, $
                fm_inc_real, fm_inc_real_err, sm_inc_exp, sm_inc_exp_err, sm_inc_real, sm_inc_real_err, $
                tm_inc_exp, tm_inc_exp_err, tm_inc_real, tm_inc_real_err, integral_for, integral_for_err,$
                fm_for, fm_for_err, sm_for, sm_for_err, tm_for, tm_for_err, norm1, norm2, diff12, norm
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;Normalized arrays;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
COMMON CHECK_PARAM, flm, flm_err, flm_dos, flm_dos_err, mean_ke, mean_ke_err, mean_ke_dos, $
                    mean_ke_dos_err, mean_Vzz, mean_Vzz_err, mean_Vzz_dos, mean_Vzz_dos_err, $
                    int_g, int_g_err
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;Normalized arrays;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
COMMON NORM_DATA, se_inc, se_err, cts_for_n, err_for_n, se_inc_sub, se_err_sub

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; USING GRAPHICAL INTERFACE ?;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
COMMON INES_GUI,useGui,wInes,wInesLog,LogFileUnit,wStepIndex, ai
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


END ; INES_COMMON_DEF




PRO Ines_ErrorMessage
;
COMMON INES_GUI,useGui,wInes,wInesLog,LogFileUnit,wStepIndex, ai
Ines_Print, ''
Ines_Print, ''
Ines_Print, '*******************************************************'
Ines_Print, '*                                                     *'
Ines_Print, '*                INES RUN ABORTED                     *'
Ines_Print, '*                                                     *'
Ines_Print, '*******************************************************'
Ines_Print, ''
Ines_Print, ''

IF Widget_Info(wStepIndex,/Valid_ID) THEN Widget_Control,wStepIndex,Set_Value='..'

END ; Ines_ErrorMessage`



PRO INES_THERMODYNAMIC, energy, dos_p, dos_p_err, kappa_T_meV, risultati, $
                   flm_dos, flm_dos_err, mean_ke_dos, mean_ke_dos_err,$
						 mean_Vzz_dos, mean_Vzz_dos_err,gui=gui

; calculation of Lamb-Moessbauer factor using integral of dos
; according to theory from Singwi-Sjoelander

COMMON FILE_NAMES
COMMON CONSTANTS
COMMON MOMENTS
COMMON INES_GRAPHICAL_WINDOWS,xplot_p, xwindow_p

num=250

Ines_Print, ''
Ines_Print, ''
Ines_Print, '*******************************************************'
Ines_Print, '*                                                     *'
Ines_Print, '*          CALCULATION OF SOME THERMODYNAMIC          *'
Ines_Print, '*                  PARAMETERS FROM DOS                *'
Ines_Print, '*                                                     *'
Ines_Print, '*******************************************************'
Ines_Print, ''
Ines_Print, ''

energy_p=energy(where(energy gt 0))
integrand = (dos_p/energy_p)* $
  ((1.+exp(-energy_p/kappa_T_meV))/(1.-exp(-energy_p/kappa_T_meV)))
two_w = rec_en*int_tabulated(energy_p, integrand)
flm_dos = exp(-two_w)
flm_dos_err = rec_en*flm_dos*$
    sqrt(int_tabulated(energy_p, ((1./energy_p)*$
    (1.+exp(-energy_p/kappa_T_meV))/$
    (1.-exp(-energy_p/kappa_T_meV)))^2*dos_p_err^2))
mean_sq_displ = (two_w*(hbar*speed_of_light)^2/res_en_J^2)*1.d20
mean_sq_displ_err = (hbar*speed_of_light)^2/res_en_J^2*1.d20*$
     rec_en*sqrt(int_tabulated(energy_p, ((1./energy_p)*$/
     (1.+exp(-energy_p/kappa_T_meV))/$
     (1.-exp(-energy_p/kappa_T_meV)))^2*dos_p_err^2))

Ines_Print, ''
Ines_Print, ''
Ines_Print, 'Lamb-Moessbauer factor from DOS = '+string(flm_dos)+ ' +/- '+ string(flm_dos_err)
Ines_Print, 'Mean square displacement from DOS = '+string( mean_sq_displ)+ $
       ' +/- '+string(mean_sq_displ_err)+ ' A^2'
Ines_Print, 'Mean square displacement from DOS = '+string(mean_sq_displ*$
       1.d4)+ ' +/- '+string( mean_sq_displ_err*1.d4)+ ' pm^2'

printf, risultati, ''
printf, risultati, ''
printf, risultati,$
'-----------------------------------------------------------------'
printf, risultati,$
'|                                                               |'
printf, risultati,$
'|                       LAMB-MOESSBAUER                         |'
printf, risultati,$
'|                   FACTOR AND MEAN SQUARE                      |'
printf, risultati,$
'|                    DISPLACEMENT FROM DOS                      |'
printf, risultati,$
'|                                                               |'
printf, risultati,$
'-----------------------------------------------------------------'
printf, risultati, ''
printf, risultati, format='("Lamb-Moessbauer factor from DOS = ", f10.5, " +/- ", f10.5)', flm_dos, flm_dos_err
printf, risultati, format='("Mean square displacement from DOS = ", f10.5, " +/- ", f10.5, " A^2")', $
                             mean_sq_displ, mean_sq_displ_err
printf, risultati, 'Mean square displacement from DOS = ', $
	mean_sq_displ*1.d4, ' +/- ', $
	mean_sq_displ_err*1.d4, ' pm^2'

temper_array = lindgen(num)*2. + 2.
kT_j_array = k_boltz*temper_array
kT_meV_array = kT_j_array/(elch*1.e-3)
integr_array = dblarr(num, n_elements(dos_p))
two_w_arr = dblarr(num)
for i = 0, num-1 do begin
    integr_array(i,*) = (dos_p(*)/energy_p(*))* $
     ((1.+exp(-energy_p(*)/kT_meV_array(i)))/$
     (1.-exp(-energy_p(*)/kT_meV_array(i))))
    two_w_arr(i) = rec_en*int_tabulated(energy_p, integr_array(i,*))
endfor
flm_array = exp(-two_w_arr)
mean_sq_displ_array = (two_w_arr*(hbar*speed_of_light)^2$
		    /res_en_J^2)*1.d20
if not(keyword_set(gui)) then begin
  !p.multi = [0,2,2]
  plot, temper_array, flm_array, title='Lamb-Moessbauer factor', $
       xtitle='Temperature [K]', ytitle='fLM'
  plot, temper_array, mean_sq_displ_array, $
      title='Mean square displacement', $
      xtitle='Temperature [K]', ytitle='<u^2> [A^2]'
endif

openw, lun, output_files + '.flm', /get_lun
for i=0,num-1 do printf, lun, temper_array(i), flm_array(i)
free_lun, lun

openw, lun, output_files + '.msd', /get_lun
for i=0,num-1 do printf, lun, temper_array(i), mean_sq_displ_array(i)
free_lun, lun


; calculation of Debye temperature

integrand = dos_p*energy_p
theta_debye = 4./3.*int_tabulated(energy_p, integrand)/$
	(k_boltz/(1.d-3*elch))
theta_debye_err = 4./3./(k_boltz/(1.d-3*elch))*$
      sqrt(int_tabulated(energy_p, energy_p^2*dos_p_err^2))

Ines_Print, ''
Ines_Print, 'Debye temperature = '+string(theta_debye)+ ' +/- '+ $
        string(theta_debye_err)+ '   K'

printf, risultati, ''
printf, risultati, ''
printf, risultati,$
'-----------------------------------------------------------------'
printf, risultati,$
'|                                                               |'
printf, risultati,$
'|                      DEBYE TEMPERATURE                        |'
printf, risultati,$
'|                                                               |'
printf, risultati,$
'-----------------------------------------------------------------'
printf, risultati, ''
printf, risultati, 'Debye temperature = ', $
	theta_debye, ' +/- ', theta_debye_err, '   K'

; calculation of vibrational part of Helmholtz free energy

integrand = dos_p*alog(exp(energy_p/(2.*kappa_T_meV))-$
     exp(-energy_p/(2.*kappa_T_meV)))
f_v = 3.*kappa_T_meV*elch*1.e-3*int_tabulated(energy_p, integrand)
f_v_err = 3.*kappa_T_meV*elch*1.e-3*$
    sqrt(int_tabulated(energy_p, alog(exp(energy_p/(2.*kappa_T_meV))-$
     exp(-energy_p/(2.*kappa_T_meV)))^2*dos_p_err^2))

Ines_Print, ''
Ines_Print, 'Vibrational part of Helmholtz free energy = '+string(f_v)+ ' +/- '+ $
        string(f_v_err)+ '   J'
Ines_Print, 'Vibrational part of Helmholtz free energy = '+string(f_v*avog)+ $
       ' +/- '+string(f_v_err*avog)+'   Jmol^-1'

printf, risultati, ''
printf, risultati, ''
printf, risultati,$
'-----------------------------------------------------------------'
printf, risultati,$
'|                                                               |'
printf, risultati,$
'|                      VIBRATIONAL PART OF                      |'
printf, risultati,$
'|                 HELMHOLTZ FREE ENERGY FROM DOS                |'
printf, risultati,$
'|                                                               |'
printf, risultati,$
'-----------------------------------------------------------------'
printf, risultati, ''
printf, risultati, 'Vibrational part of Helmholtz free energy = ', $
	f_v, ' +/- ', f_v_err, '   J'
printf, risultati, 'Vibrational part of Helmholtz free energy = ', $
	f_v*avog, ' +/- ', f_v_err*avog, '   Jmol^-1'

f_v_array = dblarr(num)
for i = 0, num-1 do begin
    integr_array(i,*) = dos_p(*)*alog(exp(energy_p(*)/(2.*kT_meV_array(i)))-$
     exp(-energy_p(*)/(2.*kT_meV_array(i))))
     f_v_array(i) = 3.*kT_j_array(i)*$
		  int_tabulated(energy_p,integr_array(i,*))
endfor
if not(keyword_set(gui)) then begin
  plot, temper_array, f_v_array*avog, $
      title='Vibrational part of Helmholtz free energy', $
      xtitle='Temperature [K]', $
      ytitle='Fv [Jmol^-1]'
endif
openw, lun, output_files + '.fv', /get_lun
for i=0,num-1 do printf, lun, temper_array(i), f_v_array(i)
free_lun, lun

; calculation of specific heat at constant volume

integrand = dos_p*(energy_p/kappa_T_meV)^2*$
	  exp(energy_p/kappa_T_meV)/(exp(energy_p/kappa_T_meV)-1.)^2
cv = 3.*k_boltz*int_tabulated(energy_p, integrand)
cv_err = 3.*k_boltz*$
   sqrt(int_tabulated(energy_p, ((energy_p/kappa_T_meV)^2*$
     exp(energy_p/kappa_T_meV)/(exp(energy_p/kappa_T_meV)-1.)^2)^2*$
     dos_p_err^2))

Ines_Print, ''
Ines_Print, 'Specific heat at constant volume = '+string(cv*avog)+ ' +/- '+ $
        string(cv_err*avog)+ '   JK^-1mol^-1'
Ines_Print, 'Specific heat at constant volume = '+string(cv*avog*0.239)+ ' +/- '+ $
        string(cv_err*avog*0.239)+ '   calK^-1mol^-1'

printf, risultati, ''
printf, risultati, ''
printf, risultati,$
'-----------------------------------------------------------------'
printf, risultati,$
'|                                                               |'
printf, risultati,$
'|                    SPECIFIC HEAT FROM DOS                     |'
printf, risultati,$
'|                                                               |'
printf, risultati,$
'-----------------------------------------------------------------'
printf, risultati, ''
printf, risultati, 'Specific heat at constant volume = ', cv*avog, $
	' +/- ', cv_err*avog, '   JK^-1mol^-1'
printf, risultati, 'Specific heat at constant volume = ', cv*avog*0.239, $
        ' +/- ', cv_err*avog*0.239, '   calK^-1mol^-1'

cv_array = dblarr(num)
for i = 0, num-1 do begin
    integr_array(i,*) = dos_p(*)*(energy_p(*)/kT_meV_array(i))^2*$
     exp(energy_p(*)/kT_meV_array(i))/$
     (exp(energy_p(*)/kT_meV_array(i))-1.)^2
    cv_array(i) = 3.*k_boltz*int_tabulated(energy_p, integr_array(i,*))
endfor

if not(keyword_set(gui)) then begin
  plot, temper_array, cv_array*avog, $
      title='Specific heat at constant volume', $
      xtitle='Temperature [K]', $
      ytitle='Cv [JK^-1mol^-1]'
  !p.multi = 0
endif


openw, lun, output_files + '.cv', /get_lun
for i=0,num-1 do printf, lun, temper_array(i), cv_array(i)
free_lun, lun

Ines_Print, ''

if not(keyword_set(gui)) then begin
  print, 'Press any key to continue ...'
  signal = strlowcase(get_kbrd(1))
endif
; calculation of vibrational contribution to internal energy per atom

integrand = dos_p*energy_p*(exp(energy_p/kappa_T_meV)+1.)/$
	  (exp(energy_p/kappa_T_meV)-1.)
u_T = 3./2.*int_tabulated(energy_p, integrand)
u_T_err = 3./2.*$
  sqrt(int_tabulated(energy_p, (energy_p*$
	  (exp(energy_p/kappa_T_meV)+1.)/$
	  (exp(energy_p/kappa_T_meV)-1.))^2*dos_p_err^2))

Ines_Print, ''
Ines_Print, 'Vibrational part of internal energy = '+string(u_T)+ ' +/- '+ $
        string(u_T_err)+ '   meV'

printf, risultati, ''
printf, risultati, ''
printf, risultati,$
'-----------------------------------------------------------------'
printf, risultati,$
'|                                                               |'
printf, risultati,$
'|                  VIBRATIONAL CONTRIBUTION                     |'
printf, risultati,$
'|                 TO INTERNAL ENERGY PER ATOM                   |'
printf, risultati,$
'|                                                               |'
printf, risultati,$
'-----------------------------------------------------------------'
printf, risultati, ''
printf, risultati, 'Vibrational part of internal energy = ', u_T, $
        ' +/- ', u_T_err, '   meV'

u_T_array = dblarr(num)
for i = 0, num-1 do begin
    integr_array(i,*) = dos_p(*)*energy_p(*)*$
      (exp(energy_p(*)/kT_meV_array(i))+1.)/$
	  (exp(energy_p(*)/kT_meV_array(i))-1.)
    u_T_array(i) = 3./2.*int_tabulated(energy_p, integr_array(i,*))
endfor

if not(keyword_set(gui)) then begin
  !p.multi = [0,2,2]
  plot, temper_array, u_T_array, /ynoz, $
      title='Vibrational part of internal energy', $
      xtitle='Temperature [K]', ytitle='U [meV]'
endif
openw, lun, output_files + '.u', /get_lun
for i=0,num-1 do printf, lun, temper_array(i), u_T_array(i)
free_lun, lun

; calculation of vibrational entropy

integrand = dos_p*(energy_p/(2.*kappa_T_meV)*$
     (exp(energy_p/kappa_T_meV)+1.)/(exp(energy_p/kappa_T_meV)-1.)-$
     alog(exp(energy_p/(2.*kappa_T_meV))-$
     exp(-energy_p/(2.*kappa_T_meV))))
s_atom = 3.*k_boltz*int_tabulated(energy_p, integrand)
s_atom_err = 3.*k_boltz*$
  sqrt(int_tabulated(energy_p, (energy_p/(2.*kappa_T_meV)*$
     (exp(energy_p/kappa_T_meV)+1.)/(exp(energy_p/kappa_T_meV)-1.)-$
     alog(exp(energy_p/(2.*kappa_T_meV))-$
     exp(-energy_p/(2.*kappa_T_meV))))^2*dos_p_err^2))

Ines_Print, ''
Ines_Print, 'Vibrational entropy per atom = '+string(s_atom)+ $
       ' +/- '+string(s_atom_err)+ '   JK^-1'
Ines_Print, 'Vibrational entropy per atom = '+string(s_atom*0.239)+ $
       ' +/- '+string(s_atom_err*0.239)+ '   calK^-1'
Ines_Print, 'Vibrational entropy per mole = '+string(s_atom*avog)+ $
       ' +/- '+string(s_atom_err*avog)+ '   JK^-1mol^-1'
Ines_Print, 'Vibrational entropy per mole = '+string(s_atom*avog*0.239)+ $
       ' +/- '+string(s_atom_err*avog*0.239)+ '   calK^-1mol^-1'

printf, risultati, ''
printf, risultati, ''
printf, risultati,$
'-----------------------------------------------------------------'
printf, risultati,$
'|                                                               |'
printf, risultati,$
'|                      VIBRATIONAL ENTROPY                      |'
printf, risultati,$
'|                                                               |'
printf, risultati,$
'-----------------------------------------------------------------'
printf, risultati, ''
printf, risultati, 'Vibrational entropy per atom = ', s_atom, $
       ' +/- ', s_atom_err, '   JK^-1'
printf, risultati, 'Vibrational entropy per atom = ', s_atom*0.239, $
       ' +/- ', s_atom_err*0.239, '   calK^-1'
printf, risultati, 'Vibrational entropy per mole = ', s_atom*avog, $
       ' +/- ', s_atom_err*avog, '   JK^-1mol^-1'
printf, risultati, 'Vibrational entropy per mole = ', s_atom*avog*0.239, $
       ' +/- ', s_atom_err*avog*0.239, '   calK^-1mol^-1'

s_atom_array = dblarr(num)
for i = 0, num-1 do begin
    integr_array(i,*) = dos_p(*)*(energy_p(*)/(2.*kT_meV_array(i))*$
     (exp(energy_p(*)/kT_meV_array(i))+1.)/$
     (exp(energy_p(*)/kT_meV_array(i))-1.)-$
     alog(exp(energy_p(*)/(2.*kT_meV_array(i)))-$
     exp(-energy_p(*)/(2.*kT_meV_array(i)))))
    s_atom_array(i) = 3.*k_boltz*$
     int_tabulated(energy_p, integr_array(i,*))
endfor

if not(keyword_set(gui)) then begin
  plot, temper_array, s_atom_array*avog, $
      title='Vibrational entropy per mole', $
      xtitle='Temperature [K]', $
      ytitle='S [JK^-1mol^-1]'
endif

openw, lun, output_files + '.s', /get_lun
for i=0,num-1 do printf, lun, temper_array(i), s_atom_array(i)*avog
free_lun, lun

; calculation of the mean kinetic energy from dos

integrand = dos_p*energy_p*((exp(energy_p/kappa_T_meV)+1.)/$
	  (exp(energy_p/kappa_T_meV)-1.))
mean_ke_dos = 1./4.*int_tabulated(energy_p, integrand)
mean_ke_dos_err = 1./4.*$
    sqrt(int_tabulated(energy_p, (energy_p*$
	  ((exp(energy_p/kappa_T_meV)+1.)/$
	  (exp(energy_p/kappa_T_meV)-1.)))^2*dos_p_err^2))/2.

Ines_Print, ''
Ines_Print, 'Mean kinetic energy = '+string(mean_ke_dos)+ $
       ' +/- '+string(mean_ke_dos_err)+ '   meV'

printf, risultati, ''
printf, risultati, ''
printf, risultati,$
'-----------------------------------------------------------------'
printf, risultati,$
'|                                                               |'
printf, risultati,$
'|                      MEAN KINETIC ENERGY                      |'
printf, risultati,$
'|                                                               |'
printf, risultati,$
'-----------------------------------------------------------------'
printf, risultati, ''
printf, risultati, 'Mean kinetic energy = ', mean_ke_dos, $
       ' +/- ', mean_ke_dos_err, '   meV'

mean_T_array = dblarr(num)
for i = 0, num-1 do begin
    integr_array(i,*) = dos_p(*)*energy_p(*)*$
	 ((exp(energy_p(*)/kT_meV_array(i))+1.)/$
	 (exp(energy_p(*)/kT_meV_array(i))-1.))
    mean_T_array(i) = 1./4.*int_tabulated(energy_p, integr_array(i,*))
endfor

if not(keyword_set(gui)) then begin
  plot, temper_array, mean_T_array, $
      title='Mean kinetic energy', $
      xtitle='Temperature [K]', $
      ytitle='T [meV]'
endif

openw, lun, output_files + '.kin', /get_lun
for i=0,num-1 do printf, lun, temper_array(i), mean_T_array(i)
free_lun, lun

; calculation of mean force constant from dos

integrand = dos_p*energy_p^2
mean_Vzz_dos = mass/(hbar/elch*1.d3)^2*int_tabulated(energy_p, integrand)
mean_Vzz_dos_err = mass/(hbar/elch*1.d3)^2*$
    sqrt(int_tabulated(energy_p, energy_p^4*dos_p_err^2))/2.

Ines_Print, ''
Ines_Print, 'Mean force constant = '+string(mean_Vzz_dos)+ $
       ' +/- '+string(mean_Vzz_dos_err)+ '   Nm^-1'

printf, risultati, ''
printf, risultati, ''
printf, risultati,$
'-----------------------------------------------------------------'
printf, risultati,$
'|                                                               |'
printf, risultati,$
'|                      MEAN FORCE CONSTANT                      |'
printf, risultati,$
'|                                                               |'
printf, risultati,$
'-----------------------------------------------------------------'
printf, risultati, ''
printf, risultati, 'Mean force constant = ', mean_Vzz_dos, $
       ' +/- ', mean_Vzz_dos_err, '   Nm^-1'

; display if using GUI
if keyword_set(gui) then begin
	xplot,parent=p1,/no_block,coltitles=['Temperature [K]',$
		  'Vibrational part of internal energy U [meV]','Vibrational entropy per mole S [JK^-1mol^-1]',$
		  'Mean kinetic energy T [meV]',$
		  'Lamb-Moessbauer fLM','Mean square displacement <u^2> [A^2]',$
		  'Vibrational part of Helmholtz free energy Fv [Jmol^-1]',$
		  'Specific heat Cv [JK^-1mol^-1]'],$
		  xtitle='-1',ytitle='-1',wtitle='Thermodynamic properties',$
		  [transpose(temper_array),transpose(u_T_array),transpose(s_atom_array*avog),$
			transpose(mean_T_array),transpose(flm_array),transpose(mean_sq_displ_array),$
			transpose(f_v_array*avog),transpose(cv_array*avog)]
	xplot_p = [xplot_p,p1]
endif

;VFN- removed postscript generation
;; write postscript files with thermodynamic parameters


;out_flm_ps = output_files + '.flm.ps'

;mydevice = !D.NAME
;set_plot, 'ps'
;device, filename = out_flm_ps, /landscape
;plot, temper_array, flm_array, title='Lamb-Moessbauer factor', $
;       xtitle='Temperature [K]', ytitle='fLM'
;device, /close

;out_msd_ps = output_files + '.msd.ps'
;device, filename = out_msd_ps, /landscape
;plot, temper_array, mean_sq_displ_array, $
;      title='Mean square displacement', $
;      xtitle='Temperature [K]', ytitle='<u^2> [A^2]'
;device, /close
;
;out_f_v_ps = output_files + '.fv.ps'
;device, filename = out_f_v_ps, /landscape
;plot, temper_array, f_v_array*avog, $
;      title='Vibrational part of Helmholtz free energy', $
;      xtitle='Temperature [K]', $
;      ytitle='Fv [Jmol^-1]'
;device, /close
;
;out_cv_ps = output_files + '.cv.ps'
;device, filename = out_cv_ps, /landscape
;plot, temper_array, cv_array*avog, $
;      title='Specific heat at constant volume', $
;      xtitle='Temperature [K]', $
;      ytitle='Cv [JK^-1mol^-1]'
;device, /close
;
;out_u_ps = output_files + '.u.ps'
;device, filename = out_u_ps, /landscape
;plot, temper_array, u_T_array, /ynoz, $
;      title='Vibrational part of internal energy', $
;      xtitle='Temperature [K]', ytitle='U [meV]'
;device, /close
;
;out_s_ps = output_files + '.s.ps'
;device, filename = out_s_ps, /landscape
;plot, temper_array, s_atom_array*avog, $
;      title='Vibrational entropy per mole', $
;      xtitle='Temperature [K]', $
;      ytitle='S [JK^-1mol^-1]'
;device, /close
;
;out_T_ps = output_files + '.kin.ps'
;device, filename = out_T_ps, /landscape
;plot, temper_array, mean_T_array,$
;    title='Mean kinetic energy', $
;      xtitle='Temperature [K]', $
;      ytitle='T [meV]'
;device, /close
;
;
;SET_PLOT, mydevice
END

PRO INES_READ_INPUT_FILE, entrance_file,error=error
; Reads parameters from input file

COMMON INPUT_PARAM


catch, error_status
if error_status ne 0 then begin
   error=1
   itmp = Dialog_Message(/Error,$
       'INES_READ_INPUT_FILE: error caught: '+!error_state.msg)
   Ines_ErrorMessage
   catch, /cancel
   on_error,2
   RETURN
endif

error=0
Ines_Print, ''
Ines_Print, ''
Ines_Print, '***********************************************************'
Ines_Print, '*                                                         *'
Ines_Print, '*                   READING INPUT FILE                    *'
Ines_Print, '*                                                         *'
Ines_Print, '***********************************************************'
Ines_Print, ''
Ines_Print, ''


stringa = ''
file_structure=''
while(entrance_file eq '') do begin
  entrance_file = Dialog_pickfile(/read, /fix_filter, filter='*.in')
  if (entrance_file eq '') then begin
    Ines_Print, ''
    Ines_Print, ' Please select a file! -->'
  endif
endwhile

openr, inp_par, entrance_file, /get_lun
Ines_Print, 'Read file '+string(entrance_file)
Ines_Print, 'Found following parameters: '
Ines_Print, ''
while not EOF(inp_par) do begin
      readf, inp_par, stringa
      case strmid(stringa,0,4) of
	   '(01)': begin
                   readf, inp_par, file_structure
		   reads, file_structure, inst_f_switch
                   case inst_f_switch of
                     0: begin
                        reads, file_structure, inst_f_switch, nhr, en_col, data_col
                        if data_col gt en_col then arr_size=data_col else arr_size=en_col
                     end
                     1: begin
                        reads, file_structure, inst_f_switch, nhr, en_col, data_col, inst_data_col
                        arr_size=en_col
                        if data_col gt arr_size then arr_size=data_col
                        if inst_data_col gt arr_size then arr_size=inst_data_col
                     end
                     2: begin
                        reads, file_structure, inst_f_switch, nhr, en_col, data_col, $
                                                inst_nhr, inst_en_col, inst_data_col
                        if data_col gt en_col then arr_size=data_col else arr_size=en_col
                        if inst_data_col gt inst_en_col then inst_arr_size=inst_data_col $
                        else inst_arr_size=inst_en_col
                     end
                   endcase
		   Ines_Print, stringa+ ' = '+ file_structure
		   end
	   '(02)': begin
		   readf, inp_par, resonant_energy
		   Ines_Print, stringa+ ' = '+string(resonant_energy)
		   end
	   '(03)': begin
		   readf, inp_par, atomic_mass
		   Ines_Print, stringa+' = '+string(atomic_mass)
		   end
	   '(04)': begin
		   readf, inp_par, max_en
		   Ines_Print, stringa+' = '+string(max_en)
		   end
	   '(05)': begin
		   readf, inp_par, back_min, back_max
		   Ines_Print, stringa+' = '+string(back_min)+string(back_max)
		   end
           '(06)': begin
		   readf, inp_par, en_1, en_2, sub_flag
		   Ines_Print, stringa+ ' = '+string(en_1)+string(en_2)+string(sub_flag)
		   end
           '(07)': begin
                   readf, inp_par, pif
                   Ines_Print, stringa+' = '+string(pif)
                   end
            else:
       endcase
endwhile
free_lun, inp_par
END


PRO INES_READ_DATA_FILE, row_num, inst_row_num

; read data file, build arrays with data and plot data

COMMON FILE_DATA
COMMON FILE_NAMES
COMMON INPUT_PARAM

CASE inst_f_switch OF

  0: INES_READ_ARRAYS_FROM_FILE, nhr, arr_size, row_num, energy, en_col, cts_inc_r, data_col
  1: begin
     INES_READ_ARRAYS_FROM_FILE, nhr, arr_size, row_num, energy, en_col, cts_inc_r, data_col, $
                            cts_for_r, inst_data_col
     inst_energy=energy
     err_for_r=SQRT(abs(cts_for_r))
     end
  2: begin
     INES_READ_ARRAYS_FROM_FILE, nhr, arr_size, row_num, energy, en_col, cts_inc_r, data_col
     INES_READ_ARRAYS_FROM_FILE, inst_nhr, inst_arr_size, inst_row_num, inst_energy, inst_en_col, $
                            cts_for_r, inst_data_col, /INST
     err_for_r=SQRT(abs(cts_for_r))
     end
ENDCASE

err_inc_r=SQRT(abs(cts_inc_r))

Ines_Print, ''
Ines_Print, 'Data read from file(s) are shown -->'
Ines_Print, ''

INES_PLOT_DATA, inst_f_switch, 'NIS spectrum', energy, cts_inc_r, err_inc_r, 'Energy [meV]', 'Counts', $
           'Instrumental function', inst_energy, cts_for_r, err_for_r, 'Energy [meV]', 'Counts'
INES_PLOT_DATA, inst_f_switch, 'NIS spectrum', energy, cts_inc_r, err_inc_r, 'Energy [meV]', 'Counts', $
           'Instrumental function', inst_energy, cts_for_r, err_for_r, 'Energy [meV]', 'Counts', $
           /POSTSCRIPT, FILE_NAME=data_file+'.ps'

END



PRO INES_READ_ARRAYS_FROM_FILE, n, size, nrows, arr1, c1, arr2, c2, arr3, c3, INST=x,$
	 title=title,file_name=file_name,error=error
;this procedures reads up to three arrays from a file having n header lines
;c1, c2, c3 are the numbers of the columns containing these arrays and must be
;smaller than size, which represents the size of a temporary array used to
;read the file line by line. Returns the number of data lines in file, nrows
COMMON FILE_NAMES

catch, error_status
if error_status ne 0 then begin
   error=1
   itmp = Dialog_Message(/Error,$
       'INES_READ_ARRAYS_FROM_FILE: error caught: '+!error_state.msg)
   Ines_ErrorMessage
   catch, /cancel
   on_error,2
   RETURN
endif


error=0
stringa=''
temp=fltarr(size)

Ines_Print, ''
Ines_Print, ''
Ines_Print, '***********************************************************'
Ines_Print, '*                                                         *'
if N_ELEMENTS(x) > 0 then $
Ines_Print, '*           READING INSTRUMENTAL FUNCTION FILE            *'$
else $
Ines_Print, '*                   READING DATA FILE                     *'
Ines_Print, '*                                                         *'
Ines_Print, '***********************************************************'
Ines_Print, ''
Ines_Print, ''

;selects data file
if not(keyword_set(file_name)) then begin
	 repeat begin
	   if not(keyword_set(title)) then file_name = Dialog_pickfile(/read, /fix_filter, filter='*.dat') $
		else file_name = Dialog_pickfile(/fix_filter, filter='*.dat',title=title)
		if (file_name eq '') then begin
		  tmp = Dialog_Message(/Question,'Abort INES run?')
		  IF tmp EQ 'Yes' THEN BEGIN
			error=1
			Ines_ErrorMessage
			RETURN
		  ENDIF
   		  Ines_Print, ''
   		  Ines_Print, ' Please select a file! ---> '
		endif
	 endrep until file_name ne ''
endif
if N_ELEMENTS(x) eq 0 then data_file = file_name $
else inst_file = file_name

; counts the number of lines in the data file (except the header lines)
nrows=-n
openr, unit_in, file_name, /get_lun
while not EOF(unit_in) do begin
  readf, unit_in, stringa
  nrows = nrows+1
endwhile
free_lun, unit_in

;sizes the proper arrays
arr1=dblarr(nrows)
arr2=dblarr(nrows)
IF N_ELEMENTS(c3) >0 then arr3=dblarr(nrows)

openr, unit_in, file_name, /get_lun

;reads the data header
i=n
while i gt 0 do begin
  readf, unit_in, stringa
  i=i-1
endwhile

;reads the data and stores them in arrays

for i=0, nrows-1 do begin
  readf, unit_in, temp
  arr1(i)=temp(c1-1)
  arr2(i)=temp(c2-1)
  IF N_ELEMENTS(c3) > 0 then arr3(i)=temp(c3-1)
endfor
free_lun, unit_in

END

PRO INES_PLOT_DATA, flag, title1, x1, y1, yerr1, xtitle1, ytitle1, title2, x2, y2, yerr2, xtitle2, ytitle2,$
               POSTSCRIPT=ps, FILE_NAME=fname

;This procedures plots x-y data in a one-row (switch=0) or two-rows (switch ne 0) format

  if N_ELEMENTS(ps) > 0 then begin
     set_plot, 'ps'
     device, filename=fname, /landscape
	  mydevice = !D.NAME
  endif

  if flag ne 0 then begin
      !p.multi=[0,1,2]
      plot, x1, y1,  psym=4, title=title1, xtitle=xtitle1, ytitle=ytitle1, yrange=[0,max(y1)]
      oploterr, x1, y1, yerr1, 4
      plot, x2, y2, psym=4, title=title2, xtitle=xtitle2, ytitle=ytitle2, yrange=[0,max(y2)]
      oploterr, x2, y2, yerr2, 4
      !p.multi=0
  endif else begin
      plot, x1, y1, psym=4, title=title1, xtitle=xtitle1, ytitle=ytitle1, yrange=[0,max(y1)]
      oploterr, x1, y1, yerr1, 4
  endelse
  if N_ELEMENTS(ps) > 0 then begin
    device, /close
    set_plot, mydevice
  endif
END

PRO INES_SUBTRACT_BACKGROUND, risultati

;This procedure makes an average of the counts where energies < back_min OR > back_max. If no
;energies matching this condition are found, no background is subtracted.

  COMMON FILE_DATA
  COMMON INPUT_PARAM

  back_inc=0
  back_for=0

  Ines_Print, ''
  Ines_Print, ''
  Ines_Print, '***********************************************************'
  Ines_Print, '*                                                         *'
  Ines_Print, '*                BACKGROUND SUBTRACTION                   *'
  Ines_Print, '*                                                         *'
  Ines_Print, '***********************************************************'
  Ines_Print, ''
  Ines_Print, ''


  back_inc_index=where(energy le back_min or energy ge back_max, counter)
  if back_inc_index(0) ne -1 then begin
     back_inc=total(cts_inc_r(back_inc_index))/counter
     ;back_inc_err=sqrt(total((cts_inc_r(back_inc_index)-back_inc)^2)/counter)
     cts_inc_r=cts_inc_r - back_inc
  endif

  ;makes the same for the instrumental function, using the same limiting values
  if inst_f_switch ne 0 then begin
    back_for_index=where(inst_energy le back_min or energy ge back_max, counter)
    if back_for_index(0) ne -1 then begin
      back_for=total(cts_for_r(back_for_index))/counter
      ;back_for_err=sqrt(total((cts_for_r(back_for_index)-back_for)^2)/counter)
      cts_for_r=cts_for_r - back_for
    endif
  endif


  Ines_Print, 'Background in 4pi spectrum = '+string(back_inc)+' counts'
  Ines_Print, 'Background in forward spectrum = '+string(back_for)+' counts'

  printf, risultati,$
  '-----------------------------------------------------------------'
  printf, risultati, $
  '|                                                               |'
  printf, risultati, $
  '|                    BACKGROUND SUBTRACTION                     |'
  printf, risultati, $
  '|                                                               |'
  printf, risultati,$
  '-----------------------------------------------------------------'
  printf, risultati, ''
  printf, risultati, 'Background found in 4pi spectrum = ', $
       	back_inc, '   counts'
  printf, risultati, 'Background found in forward spectrum = ', $
	back_for, '   counts'

END




PRO INES_SYMMETRIZE_SPECTRUM,abort=abort
  ;This procedure eliminates the data where |E|> max_en and extends the data, on the low-energy
  ;side only, IF (|Emin| < max_en AND |Emin| < |Emax|) where Emin and Emax are the minimum and maximum
  ;energy in the spectrum.
  COMMON FILE_DATA
  COMMON INPUT_PARAM
  COMMON FILE_NAMES

  INES_RESIZE_ARRAYS, 1, max_en, energy, cts_inc_r, err_inc_r,abort=abort
	IF abort EQ 1 THEN RETURN
  INES_RESIZE_ARRAYS, 0, max_en, inst_energy, cts_for_r, err_for_r,abort=abort
	IF abort EQ 1 THEN RETURN



  ;INES_PLOT_DATA, inst_f_switch, 'NIS spectrum', energy, cts_inc_r, err_inc_r, 'Energy [meV]', 'Counts', $
  ;         'Instrumental function', inst_energy, cts_for_r, err_for_r, 'Energy [meV]', 'Counts'
  ;INES_PLOT_DATA, inst_f_switch, 'NIS spectrum', energy, cts_inc_r, err_inc_r, 'Energy [meV]', 'Counts', $
  ;         'Instrumental function', inst_energy, cts_for_r, err_for_r, 'Energy [meV]', 'Counts', $
  ;         /POSTSCRIPT, FILE_NAME=output_files+'.bgd.ps'

  ;writes the data to a file
  openw, lun, output_files+'.bgd', /get_lun
  for i=0, N_ELEMENTS(energy)-1 do begin
    printf, lun, energy(i), cts_inc_r(i), err_inc_r(i)
  endfor
  free_lun, lun


END

PRO INES_RESIZE_ARRAYS, flag, max, energy, counts, error, abort=abort
  COMMON CONSTANTS
  abort=0
  n=N_ELEMENTS(energy)
  index1=where(abs(energy) le max, counter1)
  ;if the number of data where |E| < max is less than the total number of data, cuts the arrays
  if counter1 lt n then begin
    energy=energy(index1)
    counts=counts(index1)
    error=error(index1)
    n=counter1        ;new number of elements in energy array
  endif
  index2=where(energy gt abs(energy(0)), counter2)
  if index2(0) eq -1 then return

  t_energy=dblarr(n+counter2)
  t_counts=dblarr(n+counter2)
  t_error=dblarr(n+counter2)
  t_energy(0:counter2-1)=-rotate(energy(index2),2)
  t_energy(counter2:counter2+n-1)=energy
  factor=dblarr(counter2)
  if flag eq 1 then begin
    Ines_Print, ''
    Ines_Print, 'The incoherent data are asymmetric in the energy scale.'
    Ines_Print, 'Please input temperature in order to extend negative side :'
    Ines_Print, ''
	 T=298
	 tmp=T
    xscrmenu,tmp,name='Experiment temperature:                         ',/notype,wtitle='Temperature, to symmetrize the spectrum', $
	non_modal=0,action=action
    IF action EQ 'DONT' THEN BEGIN
	tmp = Dialog_Message(/Question,'Abort INES run?')
	IF tmp EQ 'Yes' THEN BEGIN
		abort=1
		Ines_ErrorMessage
		RETURN
	ENDIF
    ENDIF
    reads,tmp,T
    kT_J=T*k_boltz
    kT_meV=kT_J/(1.e-3*elch)
    factor=exp(-abs(t_energy(0:counter2-1))/kT_meV)
  endif else factor(*)=1

  t_counts(0:counter2-1)=factor*rotate(counts(index2),2)
  t_counts(counter2:counter2+n-1)=counts
  t_error(0:counter2-1)=factor*rotate(error(index2),2)
  t_error(counter2:counter2+n-1)=error
  energy=t_energy
  counts=t_counts
  error=t_error
END


PRO INES_FIT_RESOLUTION, inst_FWHM, risultati,gui=gui

COMMON FILE_DATA
COMMON FILE_NAMES

   Ines_Print, ''
   Ines_Print, ''
   Ines_Print, '***********************************************************'
   Ines_Print, '*                                                         *'
   Ines_Print, '*              FIT OF INSTRUMENTAL FUNCTION               *'
   Ines_Print, '*                                                         *'
   Ines_Print, '***********************************************************'
   Ines_Print, ''
   Ines_Print, ''

fit_results = dblarr(6)
a = dblarr(6)
fit_cts_for_r = gaussfit(inst_energy, cts_for_r, fit_results)
errore_matematico = check_math()
index=where(inst_energy ge -(fit_results(2)*2.35)*5. and inst_energy le (fit_results(2)*2.35)*5.)
ene_restr = inst_energy(index)
cts_for_r_restr = cts_for_r(index)
fit_vero = gaussfit(ene_restr, cts_for_r_restr, a)
inst_FWHM=a(2)*2.35
Ines_Print, 'Instrumental function FWHM = '+string(inst_FWHM)+'   meV'

Ines_Print, ''
Ines_Print, 'Fit to instrumental function shown -->'

printf, risultati, ''
printf, risultati, ''
printf, risultati,$
'-----------------------------------------------------------------'
printf, risultati, $
'|                                                               |'
printf, risultati, $
'|                FIT OF INSTRUMENTAL FUNCTION                   |'
printf, risultati, $
'|                                                               |'
printf, risultati,$
'-----------------------------------------------------------------'
printf, risultati, ''
printf, risultati, 'Instrumental function FWHM = ', $
	a(2)*2.35, '   meV'
if not(keyword_set(gui)) then begin
	 plot, ene_restr, cts_for_r_restr, psym=4, $
      title='Fit to instrumental function', $
      xtitle='Energy [meV]', $
      ytitle='Intensity [a.u.]', $
      xrange=[min(ene_restr),max(ene_restr)], $
      yrange=[0,max(cts_for_r_restr)]
	 oplot, ene_restr, fit_vero, LINESTYLE=0
endif

openw, lun, output_files + '.fif', /get_lun
for i=0, N_ELEMENTS(ene_restr)-1 do printf, lun, ene_restr(i), cts_for_r_restr(i), fit_vero(i)
free_lun, lun

END

PRO INES_NORMALIZE, risultati,gui=gui

  COMMON MOMENTS
  COMMON FILE_DATA
  COMMON NORM_DATA
  COMMON INPUT_PARAM
  COMMON FILE_NAMES
  COMMON CONSTANTS

  Ines_Print, ''
  Ines_Print, ''
  Ines_Print, '***********************************************************'
  Ines_Print, '*                                                         *'
  Ines_Print, '*                      NORMALIZATION                      *'
  Ines_Print, '*                                                         *'
  Ines_Print, '***********************************************************'
  Ines_Print, ''
  Ines_Print, ''

  Ines_Print, 'Inelastic spectrum will now be normalized using Lipkin sum rule'
  if inst_f_switch ne 0 then Ines_Print, 'Forward spectrum will be normalized to one'

  mass = atomic_mass*1.d-3/avog                     ; [kg]
  res_en_J = resonant_energy*1.d3*elch              ; [J]
  rec_en_J = res_en_J^2/(2.*mass*speed_of_light^2)  ; [J]
  rec_en = rec_en_J*1.d3/elch                       ; [meV]
  fm_inc = int_tabulated(energy, cts_inc_r*energy)
  fm_inc_err = sqrt(int_tabulated(energy,err_inc_r^2*energy^2))
  integral_inc = int_tabulated(energy, cts_inc_r)
  integral_inc_err = sqrt(int_tabulated(energy, err_inc_r^2))
  norm1 = rec_en/fm_inc
  norm1_err=fm_inc_err*rec_en/fm_inc^2
  if inst_f_switch ne 0 then begin
    fm_for = int_tabulated(inst_energy, cts_for_r*inst_energy)
    fm_for_err = sqrt(int_tabulated(inst_energy, err_for_r^2*inst_energy^2))
    integral_for = int_tabulated(inst_energy, cts_for_r)
    integral_for_err = sqrt(int_tabulated(inst_energy, err_for_r^2))
    norm2 = rec_en/(fm_inc - integral_inc * (fm_for/integral_for))
    norm2_err = norm2^2*sqrt(fm_inc_err^2+(integral_inc_err*fm_for/integral_for)^2 $
                + (integral_inc*fm_for_err/integral_for)^2 $
                + (integral_for_err*integral_inc*fm_for/integral_for^2)^2)/rec_en
    diff_12 = (norm2-norm1)/norm1*100.
  endif

  Ines_Print, ''
  Ines_Print, 'Recoil energy ='+string(rec_en)+'   meV'
  Ines_Print, 'Integral of 4pi spectrum = '+string(integral_inc)+' +-'+string(integral_inc_err)+' counts*meV'
  Ines_Print, 'First momentum of 4pi spectrum = '+string(fm_inc)+' +-'+string(fm_inc_err)+' counts*meV^2'
  Ines_Print, 'Normalization factor without asymmetry correction = '+string(norm1)+' +-'+string(norm1_err)+' 1/(counts*meV)'
  if inst_f_switch ne 0 then begin
    Ines_Print, 'Integral of forward spectrum = '+string(integral_for)+' +-'+string(integral_for_err)+' counts*meV'
    Ines_Print, 'First momentum of forward spectrum = '+string(fm_for)+' +-'+string(fm_for_err)+' counts*meV^2'
    Ines_Print, 'Normalization factor with asymmetry correction = '+string(norm2)+' +-'+string(norm2_err)+' 1/(counts*meV)'
    Ines_Print, 'Difference between two normalizations = '+string(diff_12)+'   %'
    norm=norm2
    norm_err=norm2_err
  endif else begin
    norm=norm1
    norm_err=norm1_err
  endelse

  printf, risultati, ''
  printf, risultati,$
  '-----------------------------------------------------------------'
  printf, risultati, $
  '|                                                               |'
  printf, risultati, $
  '|                NORMALIZATION OF 4PI SPECTRUM                  |'
  printf, risultati, $
  '|                                                               |'
  printf, risultati,$
  '-----------------------------------------------------------------'
  printf, risultati, ''
  printf, risultati, 'Recoil energy =', rec_en, '   meV'
  printf, risultati, 'Integral of 4pi spectrum = ', integral_inc, ' +-', integral_inc_err, ' counts*meV'
  printf, risultati, 'First momentum of 4pi spectrum = ', fm_inc, ' +-', fm_inc_err, ' counts*meV^2'
  printf, risultati, 'Normalization factor w/o asymmetry correction = ', norm1, ' +-', norm1_err, ' 1/(counts*meV)'
  if inst_f_switch ne 0 then begin
    printf, risultati, 'Integral of forward spectrum = ', integral_for, ' +-', integral_for_err, ' counts*meV'
    printf, risultati, 'First momentum of forward spectrum = ', fm_for, ' +-', fm_for_err, ' counts*meV^2'
    printf, risultati, 'Normalization factor with asymmetry correction = ', norm2, ' +-', norm2_err, ' 1/(counts*meV)'
    printf, risultati, 'Difference between two normalizations = ', diff_12, '  %'
  endif

  se_inc = cts_inc_r*norm
  se_err = err_inc_r*norm+cts_inc_r*norm_err
  if inst_f_switch ne 0 then begin
    cts_for_n = cts_for_r/integral_for
    err_for_n = err_for_r/integral_for+integral_for_err*cts_for_r/integral_for^2
  endif

  Ines_Print, ''
  Ines_Print, 'Normalized NIS spectrum is displayed -->'

  if not(keyword_set(gui)) then begin
    INES_PLOT_DATA, 0, 'NIS normalized spectrum', energy, se_inc, se_err, 'Energy [meV]', $
             'Probability of absorption [1/meV]'
    ;INES_PLOT_DATA, 0, 'NIS normalized spectrum', energy, se_inc, se_err, 'Energy [meV]', $
    ;         'Probability of absorption [1/meV]', /POSTSCRIPT, FILE_NAME = output_files + '.nrm.ps'
  endif ; else this is displayed in the gui procedure (ines_wizard)

  openw, lun, output_files + '.nrm', /get_lun

  for i=0, N_ELEMENTS(energy)-1 do begin
    printf, lun, energy(i), se_inc(i), se_err(i)
  endfor
  free_lun, lun

  ;Re-calculates moments after normalization
  integral_inc = int_tabulated(energy, se_inc)
  integral_inc_err = sqrt(int_tabulated(energy, se_err^2))
  fm_inc_exp = int_tabulated(energy, se_inc*energy)
  fm_inc_exp_err = sqrt(int_tabulated(energy, energy^2*se_err^2))
  if inst_f_switch ne 0 then begin
    fm_for=int_tabulated(inst_energy, cts_for_n*inst_energy)
    fm_for_err=sqrt(int_tabulated(inst_energy, inst_energy^2*err_for_n^2))
    integral_for= int_tabulated(inst_energy, cts_for_n)
    integral_for_err = sqrt(int_tabulated(inst_energy, err_for_n^2))
    fm_inc_real = fm_inc_exp - integral_inc*fm_for
    fm_inc_real_err = sqrt(fm_inc_exp_err^2 + fm_for^2*integral_inc_err^2 + $
                           integral_inc^2*fm_for_err^2)
  endif else begin
      fm_inc_real = fm_inc_exp
      fm_inc_real_err = fm_inc_exp_err
  endelse

  Ines_Print, ''
  Ines_Print, ''
  Ines_Print, 'Check after normalization:'
  Ines_Print, ''
  Ines_Print, 'Integral  of normalized 4pi spectrum = '+string(integral_inc)
  Ines_Print, 'First momentum of normalized 4pi spectrum = '+string(fm_inc_exp)+'   meV'
  Ines_Print, 'First momentum of 4pi spectrum after asymmetry correction= '+string(fm_inc_real)+' meV'
  if inst_f_switch ne 0 then begin
     Ines_Print, 'Integral of normalized forward spectrum = '+ $
       string(integral_for)+' +- '+string(integral_for_err)+' counts'
  endif

  printf, risultati, ''
  printf, risultati, ''
  printf, risultati,$
  '-----------------------------------------------------------------'
  printf, risultati, $
  '|                                                               |'
  printf, risultati, $
  '|                   CHECK AFTER NORMALIZATION                   |'
  printf, risultati, $
  '|                                                               |'
  printf, risultati,$
 '-----------------------------------------------------------------'
  printf, risultati, ''
  printf, risultati, 'Integral of normalized 4pi spectrum = ', $
	integral_inc, ' +- ', integral_inc_err, ' counts'
  printf, risultati, 'First momentum of normalized 4pi spectrum = ', $
	fm_inc_exp, ' +- ', fm_inc_exp_err, '   meV'
  printf, risultati, 'First momentum of 4pi spectrum with symmetry correction= ', $
              fm_inc_real, ' +- ', fm_inc_real_err, '   meV'
  if inst_f_switch ne 0 then begin
    printf, risultati, 'Integral of normalized forward spectrum = ', $
            integral_for, ' +- ', integral_for_err, ' counts'
  endif

END

PRO INES_HIGH_MOMENTS, risultati, inst_f_switch, mean_ke, mean_ke_err, mean_Vzz, mean_Vzz_err

   ; calculation of second and third order moments using Lipkin's rules

   COMMON MOMENTS
   COMMON CONSTANTS
   COMMON FILE_DATA
   COMMON NORM_DATA

   Ines_Print, ''
   Ines_Print, ''
   Ines_Print, '***********************************************************'
   Ines_Print, '*                                                         *'
   Ines_Print, '*          CALCULATION OF HIGHER ORDER MOMENTS            *'
   Ines_Print, '*                                                         *'
   Ines_Print, '***********************************************************'
   Ines_Print, ''
   Ines_Print, ''

   sm_inc_exp = int_tabulated(energy, se_inc*(energy-rec_en)^2)
   sm_inc_exp_err = $
     sqrt(int_tabulated(energy, (energy-rec_en)^4*se_err^2))
   tm_inc_exp = int_tabulated(energy, se_inc*(energy-rec_en)^3)
   tm_inc_exp_err = $
     sqrt(int_tabulated(energy, (energy-rec_en)^6*se_err^2))

   sm_for = int_tabulated(inst_energy, cts_for_n*(inst_energy)^2)
   sm_for_err = $
     sqrt(int_tabulated(inst_energy, inst_energy^4*err_for_n^2))
   tm_for = int_tabulated(inst_energy, cts_for_n*(inst_energy)^3)
   tm_for_err = $
     sqrt(int_tabulated(inst_energy, inst_energy^6*err_for_n^2))


   if inst_f_switch ne 0 then begin

     sm_inc_real = sm_inc_exp - 2.*fm_inc_real*fm_for - $
	    integral_inc*sm_for
     sm_inc_real_err = $
       sqrt(sm_inc_exp_err^2 + 4.*fm_for^2*fm_inc_real_err^2 +$
       4.*fm_inc_real^2*fm_for_err^2 +$
       integral_inc^2*sm_for_err^2 +$
       sm_for^2*integral_inc_err^2)
     tm_inc_real = tm_inc_exp - 3.*sm_inc_real*fm_for - $
	    3.*fm_inc_real*sm_for - $
	    integral_inc*tm_for
     tm_inc_real_err = $
     sqrt(tm_inc_exp_err^2 + 9.*fm_for^2*sm_inc_real_err^2 +$
        9.*sm_inc_real^2*fm_for_err^2 +$
	9.*sm_for^2*fm_inc_real_err^2 +$
	9.*fm_inc_real^2*sm_for_err^2 +$
	tm_for^2*integral_inc_err^2 +$
	integral_inc^2*tm_for_err^2)
   endif else begin
     sm_inc_real=sm_inc_exp
     sm_inc_real_err=sm_inc_exp_err
     tm_inc_real=tm_inc_exp
     tm_inc_real_err=tm_inc_exp_err
   endelse
   mean_ke = sm_inc_real/(4.*rec_en)
   mean_ke_err = sm_inc_real_err/(4.*rec_en)
   mean_Vzz = 2.*(tm_inc_real*1.e-9*elch^3)/$
	(2.*hbar^2*(rec_en*1.e-3*elch)/mass)
   mean_Vzz_err = 2.*(tm_inc_real_err*1.e-9*elch^3)/$
	(2.*hbar^2*(rec_en*1.e-3*elch)/mass)

   Ines_Print, 'Second momentum of 4pi spectrum = '+string(sm_inc_real)+ $
          ' +- '+string(sm_inc_real_err)+'   meV^2'
   Ines_Print, 'Mean kinetic energy = '+string(mean_ke)+' +/- '+string(mean_ke_err)+'   meV'
   Ines_Print, ''
   Ines_Print, 'Third momentum of 4pi spectrum = '+ $
      string(tm_inc_real)+ ' +- '+string(tm_inc_real_err)+ '   meV^3'
   Ines_Print, 'Mean force constant (harmonic approximation) = '+ $
       string(mean_Vzz)+ ' +/- '+string(mean_Vzz_err)+ '   Nm^-1'

   printf, risultati, ''
   printf, risultati, ''
   printf, risultati,$
   '-----------------------------------------------------------------'
   printf, risultati, $
   '|                                                               |'
   printf, risultati, $
   '|                       HIGHER ORDER MOMENTS                    |'
   printf, risultati, $
   '|                                                               |'
   printf, risultati,$
   '-----------------------------------------------------------------'
   printf, risultati, ''
   printf, risultati, 'Second momentum of 4pi spectrum = ', sm_inc_real, $
           ' +- ', sm_inc_real_err, ' meV^2'
   printf, risultati, 'Mean kinetic energy = ', mean_ke, ' +/- ',$
	mean_ke_err, '   meV'
   printf, risultati, 'Third momentum of 4pi spectrum = ', $
       tm_inc_real, ' +- ', tm_inc_real_err, ' meV^3'
   printf, risultati, 'Mean force constant (harmonic approximation) = ', $
       mean_Vzz, ' +/- ', mean_Vzz_err, '   Nm^-1'

END


PRO INES_INST_FUNCTION, FWHM

COMMON NORM_DATA
COMMON FILE_DATA

  Ines_Print, ''
  Ines_Print, '***********************************************************'
  Ines_Print, '*                                                         *'
  Ines_Print, '*              APPLYING INSTRUMENTAL FUNCTION             *'
  Ines_Print, '*                                                         *'
  Ines_Print, '***********************************************************'
  Ines_Print, ''
  Ines_Print, ''

  p=dblarr(N_ELEMENTS(energy))
  p_err=dblarr(N_ELEMENTS(energy))

  ;calculates the center of mass in an energy region defined by twice the FWHM of instrumental function
  range1=where(abs(energy) le FWHM)
  spec_CM=total(se_inc(range1)*energy(range1))/total(se_inc(range1))
  range2=where(abs(inst_energy) le FWHM)
  inst_CM=total(cts_for_n(range2)*inst_energy(range2))/total(cts_for_n(range2))
  energy_offset = inst_CM-spec_CM

  inst_energy=inst_energy - energy_offset

  inst_range=where(energy ge inst_energy(0) and energy le inst_energy(N_ELEMENTS(inst_energy)-1))
  p(*)=0.
  p_err(*)=0
  p(inst_range)=spline(inst_energy, cts_for_n, energy(inst_range))
  p_err(inst_range)=spline(inst_energy, err_for_n, energy(inst_range))
  ; After this procedure, it makes no longer sense to distinguish between inst_energy and energy
  ; therefore inst_energy is set equal to energy
  inst_energy=energy
  cts_for_n=p
  err_for_n=p_err

END



PRO INES_SUBTRACT_ELASTIC, inst_FWHM, risultati, e1, e2,gui=gui, abort=abort

  COMMON INPUT_PARAM
  COMMON FILE_NAMES
  COMMON NORM_DATA
  COMMON FILE_DATA

  Ines_Print, ''
  Ines_Print, '***********************************************************'
  Ines_Print, '*                                                         *'
  Ines_Print, '*              SUBTRACTION OF ELASTIC PEAK                *'
  Ines_Print, '*                                                         *'
  Ines_Print, '***********************************************************'
  Ines_Print, ''
  Ines_Print, ''

  se_inc_sub = se_inc
  se_err_sub = se_err
  ; If en_1=en_2=0 return
  if en_1 eq 0 and en_2 eq 0 then begin
    sub_flag=0
    RETURN
  endif

  range= where(energy ge en_1 and energy le en_2, counter)

  ; If no elements satisfy the condition given in the input file, return
  ; no subtraction of elastic peak is performed in this case
  if counter eq 0 then RETURN

  ; Finds the indexes corresponding to the minimum and maximum for data subtraction

  min = range(0)
  max=range(N_ELEMENTS(range)-1)
  ; Linear interpolation is the only option available if the instrumental function is not defined
  if inst_f_switch eq 0 then sub_flag = 0
  if sub_flag eq 0 then begin
    se_inc_sub(range)=(energy(range)-energy(min))*(se_inc(max)-se_inc(min))/(energy(max)-energy(min)) $
                      + se_inc(min)
    ; The error is considered as the average between the errors at the two limiting points
    se_err_sub(range)=(se_err(max)+se_err(min))/2.
  endif else begin
    ;Temporary arrays to be passed to procedure for subtraction of the elastic peak
    t_en=energy(range)
    t_s=se_inc_sub(range)
    t_err=se_err_sub(range)
    p=cts_for_n(range)
    p_err=err_for_n(range)
    INES_SUBTRACT_PEAK, inst_f_switch, t_en, t_s, t_err, p, p_err, $
                   inst_FWHM, e1, e2, risultati,gui=gui, abort=abort
	IF abort EQ 1 THEN RETURN
    se_inc_sub(range)=t_s
    se_err_sub(range)=t_err
  endelse

  Ines_Print, ''
  Ines_Print, 'Spectrum after removing elastic peak is shown -->'
  if not(keyword_set(gui)) then begin
    INES_PLOT_DATA, 0, 'NIS spectrum minus elastic peak', energy, se_inc_sub, se_err_sub, 'Energy [meV]', $
             'Probability of absorption [1/meV]'
    ;INES_PLOT_DATA, 0, 'NIS spectrum minus elastic peak', energy, se_inc_sub, se_err_sub, 'Energy [meV]', $
    ;         'Probability of absorption [1/meV]', /POSTSCRIPT, FILE_NAME = output_files + '.sub.ps'
  endif

  openw, lun, output_files + '.sub', /get_lun
  for i=0, N_ELEMENTS(energy)-1 do begin
    printf, lun, energy(i), se_inc_sub(i), se_err_sub(i)
  endfor
  free_lun, lun

END

PRO INES_SUBTRACT_PEAK, inst_f_switch, energy, spectrum, spectrum_err, $
                   p, p_err, FWHM, e1, e2, risultati,gui=gui, abort=abort
COMMON INES_GRAPHICAL_WINDOWS,xplot_p, xwindow_p

  abort=0
  accuracy=1500  ;number of steps to be performed in searching the optimum factor for subtraction
  max_factor=1.5 ; maximum factor for elastic peak subtraction

  max_spectrum=max(spectrum, indmax)

  n=N_ELEMENTS(energy)

  spectrum_0=(energy(indmax)-energy(0))*(spectrum(n-1)-spectrum(0))/(energy(n-1)-energy(0)) $
                      + spectrum(0)

  max_p=max(p)
  p=p*max_spectrum/max_p
  p_err=p_err*sqrt(max_spectrum/max_p)


  range3=where(energy gt 4.*FWHM, counter3)
  ;defines a level for minimum subtraction of elastic peak; this is just for visualization
  ;purposes, does not affect the subsequent calculations
  if counter3 eq 0 then ref_level=spectrum(n-1) else ref_level=spectrum(range3(0))

  delta=(1.-2.*ref_level/max_spectrum)

  if not(keyword_set(gui)) then begin
		plot, energy, spectrum, xrange=[energy(0), energy(n-1)], yrange=[0, 2.*ref_level], psym=4, $
      		xtitle='Energy (meV)', ytitle='Probability of absorption (1/meV)', $
      		title='Elastic peak subtraction'
		for i=0,10 do begin
		  t_spectrum=spectrum-p*(delta+(1-delta)*i*0.1)
		  oplot, energy, t_spectrum
		  oplot, energy, t_spectrum, psym=7
		endfor
  endif else begin
      xplot_array=[transpose(energy),transpose(spectrum)]
		for i=0,10 do begin
		  t_spectrum=spectrum-p*(delta+(1-delta)*i*0.1)
		  xplot_array=[xplot_array,transpose(t_spectrum)]
		endfor
  endelse

   Ines_Print, ''
   Ines_Print, '***********************************************************'
   Ines_Print, 'The spectra after elastic peak subtraction with different  '
   Ines_Print, 'scaling factors are shown. The data are strongly scattered '
   Ines_Print, 'in the central part, inside the interval (E1, E2), while   '
   Ines_Print, 'outside they are only weekly affected by the value of the  '
   Ines_Print, 'scaling factor.'
   Ines_Print, 'The best scale factor will be calculated and the spectrum  '
   Ines_Print, 'replaced by a straight line inside the interval (E1,E2).   '

USER_SATISFIED=0
;repeat begin
  if keyword_set(gui) then begin
    xplot,parent=p,xplot_array,/no_block,$
	 	   xtitle='Energy [meV]',ytitle='Intensity',$
		   xrange=[energy(0), energy(n-1)], yrange=[0, 2.*ref_level],$
			wtitle='Elastic peak subtraction'
    xplot_p = [xplot_p,p]
	 ; overplot
	 xplot_controls_action,p,linestyle=0,thick=2
	 xplot_changecol,p,ycol=2
	 xplot_savecurrent,p
	 xplot_controls_action,p,thick=1 ; set thin line
	 ; add legend (srio)
         mycolors = [255,7,9,12,16,17,19,23,24,25,28,31]
	 alpha = MakeArray1(11,0,1.0)
	 alpha = ['Original','Alpha = '+string(alpha,format='(G4.2)')]
         XPlot_Exebuffer,p,SetBuffer=$
	    "legend,"+Vect2String(alpha)+",psym=Replicate(8,12),/Fill,colors="+Vect2String(mycolors)+",TextColors="+Vect2String(mycolors)
	 for i=3,13 do begin
	 	  xplot_controls_action,p,clr_lines=mycolors[i-2]
	 	  xplot_changecol,p,ycol=i
	 	  IF i NE 13 THEN xplot_savecurrent,p ; do not save the last one (srio)
	 endfor

  endif
  Ines_Print, 'Please input your selected values for E1 and E2:'
  ok_flag=0
  if not(keyword_set(gui)) then begin
		repeat begin
   	  read, e1, e2
   	  index=where(energy gt e1, point1)
   	  index=where(energy lt e2, point2)
   	  if e1 ge e2 then Ines_Print, 'E1 must be less than E2! Insert new values:' else $
   	  if e1 lt energy(0) or e2 gt energy(n-1) then begin
      		Ines_Print, 'E1 and E2 must be inside the range for elastic peak subtraction'
      		Ines_Print, 'Insert new values:'
   	  endif else ok_flag=1
		endrep until ok_flag
  endif else begin
;		repeat begin
		  out	  =  { E1E2, E1: -3., E2: 3.}
		  titles = ['E1(min) for linear interpolation around elastic peak:',$
					 'E2(max) for linear interpolation around elastic peak:']
		  XSCRMENU,out,titles=titles,/notype,action=action,WTITLE='Elastic Peak removal',non_modal=0
		  IF action EQ 'DONT' THEN BEGIN
		    tmp = Dialog_Message(/Question,'Abort INES run?')
		    IF tmp EQ 'Yes' THEN BEGIN
			Ines_ErrorMessage
			abort=1
			RETURN
		    ENDIF
		  ENDIF
		  e1=out.E1
		  e2=out.E2
   	  index=where(energy gt e1, point1)
   	  index=where(energy lt e2, point2)
   	  if e1 ge e2 then junk=DIALOG_MESSAGE('E1 must be less than E2!',/error) else $
   	  if e1 lt energy(0) or e2 gt energy(n-1) then begin
      		junk=DIALOG_MESSAGE('E1 and E2 must be inside the range for elastic peak subtraction',/error)
   	  endif else ok_flag=1
;		endrep until ok_flag
;    if widget_info(p,/valid_id) then xplot_quit,p
  endelse

  point1=n-1-point1

  ;finds the optimum scaling factor

  chi=1.e10
  ; tries which factor minimizes the deviation from a straight line
  ; connecting points at e1 and e2. Performs n=accuracy steps from 0
  ; (no subtraction) up to max_factor. A maximum value > 1 is chosen because
  ; of the difference between instrumental function and elastic peak
  ; in incoeherent spectrum
  for i=0, accuracy do begin
     t_spectrum=spectrum-i*(max_factor/accuracy)*p  ;temporary spectrum
     deviation=0.
     for j=point1+1, point2-1 do begin
       deviation=deviation + t_spectrum(j)-t_spectrum(point1)-$
                 (t_spectrum(point2)-t_spectrum(point1))*(j-point1)/(point2-point1)
     endfor
     deviation = abs(deviation)
     if deviation lt chi then begin
        chi=deviation
        min_index=i
     endif
  endfor

  factor=min_index*(max_factor/accuracy)
  old_spectrum=spectrum
  spectrum=spectrum-factor*p

  t_spectrum=spectrum

  spectrum_err=sqrt(spectrum_err^2+(factor)*(p_err)^2)
  if not(keyword_set(gui)) then begin
    plot, energy, spectrum, psym=4, xtitle='Energy (meV)', ytitle='Probability of absorption (1/meV)', $
        title='Elastic peak subtraction', yrange=[min(spectrum), max(spectrum)]
  endif else begin
  endelse

  dx=energy(n-1)-energy(0)
  dy=max(spectrum)-min(spectrum)


  for j=point1+1, point2-1 do spectrum(j)= spectrum(point1)+$
                             (spectrum(point2)-spectrum(point1))*(j-point1)/(point2-point1)

  ;the error of the central points is taken as the average between the two extremes
  for j=point1+1, point2-1 do spectrum_err(j) = (spectrum_err(point1)+spectrum_err(point2))/2.

  if not(keyword_set(gui)) then begin
    oplot, energy, spectrum
    oplot, energy, old_spectrum, psym=7

    ;Puts the legends

    legendxy=[energy(0), max(spectrum)*0.66]
    plots, legendxy(0), legendxy(1), psym =4
    xyouts, legendxy(0)+dx/10., legendxy(1), 'Spectrum after subtraction'
    segmentx=[legendxy(0), legendxy(0)+dx/20.]
    segmenty=[legendxy(1)-dy/10.,legendxy(1)-dy/10.]
    oplot, segmentx, segmenty
    xyouts, legendxy(0)+dx/10., legendxy(1)-dy/10., 'Subtraction + linear interpolation'
    plots, legendxy(0), legendxy(1)-2*dy/10., psym =7
    xyouts, legendxy(0)+dx/10., legendxy(1)-2*dy/10., 'Original spectrum'
  endif else begin
      xplot,parent=p,[transpose(energy),transpose(old_spectrum),transpose(t_spectrum),transpose(spectrum)],/no_block,$
	 	   wtitle='Normalized spectrum before and after peak removal',$
	 	   yrange=[min(spectrum), max(spectrum)],$
			xtitle='-1',ytitle='-1',coltitles=['Energy [meV]','before removal [1/meV]','after removal [1/meV]','after removal + linear interpolation [1/meV]']
      xplot_p = [xplot_p,p]
		xplot_controls_action,p,linestyle=0,thick=2,clr_lines=7
		xplot_changecol,p,ycol=2
		xplot_savecurrent,p
		  xplot_controls_action,p,linestyle=0,thick=2,clr_lines=9
		  xplot_changecol,p,ycol=4
		  xplot_savecurrent,p
		    xplot_controls_action,p,linestyle=0,thick=1,clr_line=12
		    xplot_changecol,p,ycol=3
		xplot_exebuffer,p,setbuffer=[$
		  "xyouts,.12,.90,'Original spectrum',/norm,charthick=2,charsize=1.2,color=7",$
		  "xyouts,.12,.86,'Spectrum after subtraction',/norm,charthick=1,charsize=1.2,color=9",$
		  "xyouts,.12,.82,'Subtraction + linear interpolation',/norm,charthick=2,charsize=1.2,color=12"]
  endelse
  ;Waits for user input to continue
  Ines_Print, 'Spectrum after subtraction of elastic peak is shown.'
  Ines_Print, 'Do you want to change the interval (E1,E2) (y/n)?'
  if not(keyword_set(gui)) then begin
    signal = strlowcase(get_kbrd(1))
    if signal ne 'y' then USER_SATISFIED = 1 else spectrum=old_spectrum
  endif else begin
;	 if ines_gui_wait(button1='Continue',button2='Change interpolation points') eq 'Continue' then begin
;	 	USER_SATISFIED = 1
;	 endif else spectrum=old_spectrum
;	 if widget_info(p,/valid_id) then xplot_quit,p
  endelse

;endrep until USER_SATISFIED

  printf, risultati, ''
  printf, risultati, 'Spectra replaced by linear interpolation in the interval: ', e1, e2, ' meV'
  printf, risultati, ''
  printf, risultati, 'Scaling factor for elastic peak subtraction = ', factor

END

PRO INES_LAMB_MOESSBAUER, energy, spectrum, spectrum_err, flm, flm_err, risultati,gui=gui,abort=abort

abort=0

Ines_Print, ''
Ines_Print, '***********************************************************'
Ines_Print, '*                                                         *'
Ines_Print, '*         CALCULATION OF LAMB-MOESSBAUER FACTOR           *'
Ines_Print, '*                                                         *'
Ines_Print, '***********************************************************'
Ines_Print, ''
Ines_Print, ''

flm = 1. - int_tabulated(energy, spectrum)
flm_err = sqrt(int_tabulated(energy, (spectrum_err)^2))

Ines_Print, ''
Ines_Print, 'Integral of 4pi spectrum after subtraction = '+ $
       string(1.-flm)+ ' +- '+string(flm_err)
Ines_Print, 'Lamb-Moessbauer factor = '+string(flm)+ ' +- '+string(flm_err)


printf, risultati, ''
printf, risultati, ''
printf, risultati,$
'-----------------------------------------------------------------'
printf, risultati,$
'|                                                               |'
printf, risultati,$
'|                   LAMB-MOESSBAUER FACTOR                      |'
printf, risultati,$
'|                                                               |'
printf, risultati,$
'-----------------------------------------------------------------'
printf, risultati, ''
printf, risultati, 'Integral of 4pi spectrum after subtraction = ', $
       1.-flm, ' +- ', flm_err
printf, risultati, 'Lamb-Moessbauer factor = ', flm, ' +- ', flm_err

if not(keyword_set(gui)) then begin
	Ines_Print, 'Do you want to change it (y/n)?'
	ampel = strlowcase(get_kbrd(1))
	if ampel eq 'y' then begin
     Ines_Print, ''
     Ines_Print, 'New Lamb-Moessbauer factor: '
     read, flm
     Ines_Print, ''
     Ines_Print, 'New Lamb-Moessbauer factor = '+string(flm)
     printf, risultati, ''
     printf, risultati, 'Lamb-Moessbauer factor was changed by user'
     printf, risultati, ''
     printf, risultati, 'New Lamb-Moessbauer factor = ', flm
	endif
endif else begin
	tmp=flm
   xscrmenu,tmp,name='Lamb-Moessbauer factor:',/notype,wtitle='Lamb-Moessbauer',non_modal=0,$
	action=action
		  IF action EQ 'DONT' THEN BEGIN
		    tmp = Dialog_Message(/Question,'Abort INES run?')
		    IF tmp EQ 'Yes' THEN BEGIN
			abort=1
			Ines_ErrorMessage
			RETURN
		    ENDIF
		  ENDIF
	reads,tmp,flm
   Ines_Print, ''
   Ines_Print, 'New Lamb-Moessbauer factor = '+string(flm)
   printf, risultati, ''
   printf, risultati, 'Lamb-Moessbauer factor was changed by user'
   printf, risultati, ''
   printf, risultati, 'New Lamb-Moessbauer factor = ', flm
endelse

END

PRO INES_DET_TEMPERATURE, energy, se_inc_sub, se_err_sub, en_1, en_2, T, T_err, kappa_T_meV,  risultati,gui=gui, $
	abort=abort
  COMMON CONSTANTS

  abort=0

  Ines_Print, ''
  Ines_Print, ''
  Ines_Print, '***********************************************************'
  Ines_Print, '*                                                         *'
  Ines_Print, '*    DETERMINATION OF TEMPERATURE FROM DETAILED BALANCE   *'
  Ines_Print, '*                                                         *'
  Ines_Print, '***********************************************************'
  Ines_Print, ''
  Ines_Print, ''


  pos_range=where(energy gt en_2)
  pos_tail=se_inc_sub(pos_range)
  max_pos=max(pos_tail, pos_ind)
  pos_ind=pos_ind+pos_range(0)
  neg_ind=where(energy eq -energy(pos_ind))
  neg_ind=neg_ind(0)
  pos_se=se_inc_sub(pos_ind-1:pos_ind+1)
  pos_se_err=se_err_sub(pos_ind-1:pos_ind+1)
  neg_se=rotate(se_inc_sub(neg_ind-1:neg_ind+1),2)
  neg_se_err=rotate(se_err_sub(neg_ind-1:neg_ind+1),2)
  pos_en=energy(pos_ind-1:pos_ind+1)
  kappa_T_meV=total(pos_en/alog(pos_se/neg_se))/3.
  T=kappa_T_meV*1.e-3*elch/k_boltz
  kappa_T_meV_err=sqrt(total((pos_en/(alog(pos_se/neg_se)^2*pos_se))^2*pos_se_err^2+$
                             (pos_en/(alog(pos_se/neg_se)^2*neg_se))^2*neg_se_err^2))/3.

  T_err=kappa_T_mev_err*elch*1.e-3/k_boltz

  Ines_Print, 'kT = '+string(kappa_T_meV)+' +/- '+string(kappa_T_meV_err)+'   meV'
  Ines_Print, 'T = '+string(T)+' +/- '+string(T_err)+'   K'
  Ines_Print, 'determined at the energies between '+string(pos_en(0))+ ' and '+string(pos_en(2))+' meV'

  printf, risultati, ''
  printf, risultati, ''
  printf, risultati,$
  '-----------------------------------------------------------------'
  printf, risultati,$
  '|                                                               |'
  printf, risultati,$
  '|               TEMPERATURE FROM DETAILED BALANCE               |'
  printf, risultati,$
  '|                                                               |'
  printf, risultati,$
  '-----------------------------------------------------------------'
  printf, risultati, ''
  printf, risultati, 'kT = ', kappa_T_meV, ' +/- ', kappa_T_meV_err, '   meV'
  printf, risultati, 'T = ', T, ' +/- ', T_err, '   K'
  printf, risultati, 'determined at the energies between'
  printf, risultati, 'E_min = ', pos_en(0) , '   meV and E_max = ', pos_en(2), '   meV'

  if not(keyword_set(gui)) then begin
    Ines_Print, 'Do you want to change it (y/n)?'
    ampel = strlowcase(get_kbrd(1))

    if ampel eq 'y' then begin
      Ines_Print, ''
      Ines_Print, 'New temperature: '
      read, temperature
      kappa_T_meV = (temperature * k_boltz)/(1.e-3*elch)
      Ines_Print, ''
      Ines_Print, 'New kT = '+string(kappa_T_meV)+' meV'
      printf, risultati, ''
      printf, risultati, 'Temperature was changed by user'
      printf, risultati, ''
      printf, risultati, 'New T = ', temperature, '   K'
      printf, risultati, 'New kT = ', kappa_T_meV, ' meV'
    endif
  endif else begin
     temperature=T
	  tmp=temperature
     xscrmenu,tmp,name='Temperature (K):',/notype,wtitle='Choose Temperature',non_modal=0, $
	action=action
	 IF action EQ 'DONT' THEN BEGIN
	    tmp = Dialog_Message(/Question,'Abort INES run?')
	    IF tmp EQ 'Yes' THEN BEGIN
		abort=1
		Ines_ErrorMessage
		RETURN
	    ENDIF
	  ENDIF
     reads,tmp,temperature
     kappa_T_meV = (temperature * k_boltz)/(1.e-3*elch)
     Ines_Print, ''
     Ines_Print, 'New kT = '+string(kappa_T_meV)+' meV'
     printf, risultati, ''
     printf, risultati, 'Temperature was changed by user'
     printf, risultati, ''
     printf, risultati, 'New T = ', temperature, '   K'
     printf, risultati, 'New kT = ', kappa_T_meV, ' meV'
  endelse

END

PRO INES_MULTI_PHONON, energy, se_inc_sub, se_err_sub, one_phon, multi_phon, $
                  one_phon_err, multi_phon_err, n_multiph, flm, norm, result, risultati,gui=gui, $
		  abort=abort

COMMON FILE_NAMES
COMMON INES_GRAPHICAL_WINDOWS,xplot_p, xwindow_p


Ines_Print, ''
Ines_Print, ''
Ines_Print, '***********************************************************'
Ines_Print, '*                                                         *'
Ines_Print, '*	       SEPARATION OF 1-PHONON AND                 *'
Ines_Print, '*	       MULTI-PHONON CONTRIBUTIONS                 *'
Ines_Print, '*	        BY AN ITERATIVE PROCEDURE                 *'
Ines_Print, '*                                                         *'
Ines_Print, '***********************************************************'
Ines_Print, ''
Ines_Print, ''
  printf, risultati, $
  '-----------------------------------------------------------------'
  printf, risultati,$
  '|                                                               |'
  printf, risultati,$
  '|                        ITERATIVE PROCEDURE                    |'
  printf, risultati,$
  '|                                                               |'
  printf, risultati,$
  '-----------------------------------------------------------------'
flm_real = flm
new_factor = 1.0
rep_iuv: flm = flm_real*new_factor
se_inc_sub_n = se_inc_sub/flm
se_err_sub_n = se_err_sub/flm
kernel = dblarr(n_elements(se_inc_sub)-2)
kernel = se_inc_sub_n(1:n_elements(se_inc_sub)-2)
sn_try = dblarr(n_multiph, n_elements(se_inc_sub))
sn_try(0,*) = se_inc_sub_n
multi_phon = dblarr(n_elements(se_inc_sub))
chi_squared = dblarr(401)
en_int = (energy(n_elements(energy)-1)-energy(0))/$
       (n_elements(energy)-1)


ancora:index=0
window,0
!p.multi = [0,1,2]

repeat begin
    for i = 1, n_multiph-1 do sn_try(i,*) = $
	convol(transpose(sn_try(i-1,*)), rotate(kernel,2),$
	      /edge_truncate)/(i+1)*en_int
    for i = 0, n_elements(se_inc_sub)-1 do multi_phon(i) = $
	total(sn_try(*,i))-total(sn_try(0,i))
	;if not(keyword_set(gui)) then begin
      plot, energy(1:n_elements(se_inc_sub)-2), $
           kernel*flm, psym=4, $
	        title='1-phonon contribution', $
	        xtitle='Energy [meV]', $
	        ytitle='Probability of absorption [1/meV]', $
	        yrange=[0,max(kernel*flm)]
      oploterr, energy(1:n_elements(se_inc_sub)-2), $
           kernel*flm, sqrt(abs(kernel*flm)/norm)*norm, 4
      plot, energy, multi_phon*flm, psym=4, $
           title='multi-phonon contribution', $
           xtitle='Energy [meV]', $
	        ytitle='Probability of absorption [1/meV]', $
	        yrange=[0,max(multi_phon*flm)]
      oploterr, energy, multi_phon*flm, sqrt(abs(multi_phon*flm)/norm)*norm, 4
	 ;endif
    discrepancy = $
      (transpose(se_inc_sub_n(1:n_elements(se_inc_sub)-2))-$
      (kernel+multi_phon(1:n_elements(se_inc_sub)-2)))^2
    index = index + 1
    chi_squared(index) = total(discrepancy)
    Ines_Print, 'Iteration number = '+string(index)+' chi^2 = '+$
	    string(chi_squared(index))
    kernel = se_inc_sub_n(1:n_elements(se_inc_sub)-2) - $
	   multi_phon(1:n_elements(se_inc_sub)-2)
    sn_try(0,*) = se_inc_sub_n - transpose(multi_phon)
endrep until (((abs(chi_squared(index)-chi_squared(index-1)) $
       le 1.d-8) and (chi_squared(index)-chi_squared(1)) $
       lt 0.) or (index eq 100)) or (chi_squared(index) gt 1000.)

!p.multi = 0
wdelete,0

;
; repeat last plot (srio)
      data = { x1:energy(1:n_elements(se_inc_sub)-2), y1:kernel*flm, y1range:[0,max(kernel*flm)], $
	       y1e:sqrt(abs(kernel*flm)/norm)*norm, $
	       x2:energy, y2:  multi_phon*flm, y2range:[0,max(multi_phon*flm)], $
	       y2e:sqrt(abs(multi_phon*flm)/norm)*norm }
      buffer = [ "!p.multi = [0,1,2]" , $
        "plot, data.x1, data.y1, psym=4, title='1-phonon contribution', xtitle='Energy [meV]', ytitle='Probability of absorption [1/meV]',"+$
             "yrange=data.y1range", $
	"oploterr, data.x1, data.y1, data.y1e, 4", $
	"plot, data.x2, data.y2, psym=4, title='multi-phonon contribution', xtitle='Energy [meV]', "+$
	     "ytitle='Probability of absorption [1/meV]', yrange=data.y2range", $
	"oploterr, data.x2, data.y2, data.y2e, 4", $
	"!p.multi = 0" ] 
      XWindow,buffer=buffer,data=data,Edit=2, WTitle='INES', Parent=p
      xwindow_p = [xwindow_p,p]
	




if (index eq 100) or (chi_squared(index) gt 1000.) then begin
   Ines_Print, ''
   Ines_Print, 'Sorry, process did not converge!'
   Ines_Print, 'Chose your option:'
   Ines_Print, '1: perform other 100 iterations'
   Ines_Print, '2: go on using the results of Fourier-log method only'
;  print '3: try a different Lamb-Moessbauer factor (not recommended)'
   if keyword_set(gui) then begin
		out3	  =  { Out3, $
						    choice: ['0',$
						 					  'perform other 100 iterations',$
											  'Use only Fourier-log method']}
		titles3 = ['Iterative process did not converge ! Choose option:']
		XSCRMENU,out3,/interpret,titles=titles3,action=action,WTITLE='Iterative process',/notype,non_modal=0
		  IF action EQ 'DONT' THEN BEGIN
		    tmp = Dialog_Message(/Question,'Abort INES run?')
		    IF tmp EQ 'Yes' THEN BEGIN
			abort=1
			Ines_ErrorMessage
			RETURN
		    ENDIF
		  ENDIF
		reads,out3.choice,choice
		choice=choice+1
	endif else begin
      read, choice
	endelse
   case choice of
      1: goto, ancora
;     3: begin
;        print, 'Factor to multiply old Lamb-Moessbauer factor: '
;        read, new_factor
;        goto, rep_iuv
;     end
      else: begin
         result=-1 ;tells to the main program that the process did not converge
         printf, risultati, ''
         printf, risultati, 'Iterative process did not converge! '
         printf, risultati, '1-phonon term is not correctly separated from multiphonon contributions'
      endcase
   endcase
endif else begin
  result=1   ;the process converged
  Ines_Print, ''
  Ines_Print, 'Iterative process converged! '
  Ines_Print, '1-phonon term is separated from multiphonon contributions'
  printf, risultati, ''
  printf, risultati, 'Iterative process converged! '
  printf, risultati, '1-phonon term is separated from multiphonon contributions'
endelse

one_phon = dblarr(n_elements(se_inc_sub))
one_phon(1:n_elements(se_inc_sub)-2) = kernel*flm
one_phon(0) = 0
one_phon(n_elements(se_inc_sub)-1) = 0

;The error on the multiphonon is determined from Poisson statistics taking into account
;that the experimental data have been normalized. Then the error on the one_phonon term is
;calculated from Gauss formula. It is not easy to estimate the real error in the INES_multi_phonon
;term which comes from a very complicated procedure.The error estimates become then
;inaccurate for low Lamb-Moessbauer factors where the multiphonon contribution is big.

multi_phon = multi_phon*flm
multi_phon_err = sqrt(abs(multi_phon)*norm)
one_phon_err=sqrt(se_err_sub^2+multi_phon_err^2)

END

PRO INES_DOS_1PH, energy, one_phon, one_phon_err, dos, dos_err, dos_p, dos_p_err, $
             KT, Er, flm, dos_int, dos_int_err, risultati

COMMON FILE_NAMES

Ines_Print, ''
Ines_Print, ''
Ines_Print, '***********************************************************'
Ines_Print, '*                                                         *'
Ines_Print, '*         CALCULATION OF PHONON DENSITY OF STATES         *'
Ines_Print, '*                   FROM ONE PHONON TERM                  *'
Ines_Print, '*                                                         *'
Ines_Print, '***********************************************************'
Ines_Print, ''
Ines_Print, ''

  th_factor=energy*(1.-exp(-energy/KT))
  dos = one_phon*th_factor/(Er*flm)
  dos_err = one_phon_err*th_factor/(Er*flm)
  pos_range=where(energy gt 0)
  dos_p = dos(pos_range)
  dos_p_err = dos_err(pos_range)
  energy_p = energy(pos_range)
  dos_int = int_tabulated(energy_p, dos_p)
  dos_int_err = sqrt(int_tabulated(energy_p,dos_p_err^2))
  Ines_Print, ''
  Ines_Print, 'DOS is determined from one-phonon contribution'
  Ines_Print, 'Integral of DOS = '+string(dos_int)+' +/- '+string(dos_int_err)
  Ines_Print, 'DOS will be normalized to one!'
  printf, risultati, ''
  printf, risultati, 'DOS is determined from one-phonon contribution'
  printf, risultati, 'Integral of DOS = ', dos_int, ' +/- ', dos_int_err
  printf, risultati, 'DOS will be normalized to one!'

  dos_p = dos_p/dos_int
  dos_p_err = dos_p_err/dos_int

END

PRO INES_FOURIER_LOG, energy, se_inc_sub, se_err_sub, flm, norm, one_phon_fou, one_phon_fou_err, multi_phon_fou, $
                 multi_phon_fou_err, cts_for_n, risultati

COMMON INPUT_PARAM

  Ines_Print, ''
  Ines_Print, '***********************************************************'
  Ines_Print, '*                                                         *'
  Ines_Print, '*            SEPARATION OF 1-PHONON AND                   *'
  Ines_Print, '*            MULTI-PHONON CONTRIBUTIONS                   *'
  Ines_Print, '*             BY FOURIER-LOG METHOD                       *'
  Ines_Print, '*                                                         *'
  Ines_Print, '***********************************************************'
  Ines_Print, ''
  printf, risultati, $
  '-----------------------------------------------------------------'
  printf, risultati,$
  '|                                                               |'
  printf, risultati,$
  '|                        FOURIER-LOG METHOD                     |'
  printf, risultati,$
  '|                                                               |'
  printf, risultati,$
  '-----------------------------------------------------------------'

  num=N_ELEMENTS(energy)
  a=[512, 1024, 2048, 4096, 8192, 16384]
  ii=where(a ge 2.*num, counter)
  if counter eq 0 then numFFT=2.*num else numFFT=a(ii(0))   ;size of the array for FFT
  E_min=energy(0)
  E_max=energy(num-1)
  E_step=(E_max-E_min)/(num-1)
  e=(findgen(ROUND(numFFT))-ROUND(numFFT/2.))*E_step
  s=e*0.
  p=e*0.
  range=where(e ge E_min and e le E_max)
  s(range)=se_inc_sub

  zero_index=where(e eq 0)
  zero_index=zero_index(0)

  if inst_f_switch ne 0 then begin
    p(range)=cts_for_n
    int_p=int_tabulated(e,p)
    p=p/int_p
    q=E_step*FFT(SHIFT(p, -zero_index),1)
    q0_1=(1+pif)/(q+pif)
  endif else begin
    q0_1=dcomplexarr(numFFT)
    q0_1(*)=complex(1. , 0.)
  endelse

  j=E_step*FFT(SHIFT(s, -zero_index), 1,/double)*q0_1/flm
  m=alog(1+j)
  one_phon_fou=flm*FLOAT(SHIFT(FFT(m, /double),zero_index))/E_step
  one_phon_fou=one_phon_fou(range)
  ;one_phon_fou=spline(e(range), one_phon_fou(range), energy)
  ;dummy array for calculation of multi-phonons by subtraction
  s2=flm*FLOAT(SHIFT(FFT(j, /double),zero_index))/E_step
  s2=s2(range)
  ;s2=s(range)
  multi_phon_fou=s2-one_phon_fou
  two_phon_fou=0.5*flm*SHIFT(FFT(m^2, /double), zero_index)/E_step
  two_phon_fou=two_phon_fou(range)
  multi_phon_fou_err=sqrt(abs(multi_phon_fou)*norm)
  one_phon_fou_err = sqrt(se_err_sub^2+multi_phon_fou_err^2)
  Ines_Print, ''
  Ines_Print, 'One-phonon function determined using Fourier-log method'
  printf, risultati, ''
  printf, risultati, 'One-phonon function determined using Fourier-log method'

END

PRO INES_SHOW_RESULTS, x1, y1a, yerr1a, y1b, yerr1b, x2, y2a, yerr2a, y2b, yerr2b, $
                  conv, flag,gui=gui

  COMMON FILE_NAMES
  mydevice = !D.NAME
  if flag eq 'one_phon' then begin
     title1='1-phonon contribution'
     title2='multi-phonon contribution'
     ytitle1='Probability of absorption [1/meV]'
     ytitle2='Probability of absorption [1/meV]'
     header1='      E          1ph      1ph_fou      1ph_err  1ph_fou_err'
     file1=output_files+'.1ph'
     Ines_Print, ''
     Ines_Print, 'One-phonon and multiphonon contributions are shown -->'
  endif else begin
     title1='Normalized density of phonon states'
     title2='Non-normalized density of phonon states'
     ytitle1='DOS [1/meV]'
     ytitle2='DOS [1/meV]'
     header1='      E            g        g_fou        g_err    g_fou_err'
     file1=output_files+'.dos'
     Ines_Print, ''
     Ines_Print, 'Density of states is shown -->'
  endelse
  dx1=max(x1)-min(x1)
  dx2=max(x2)-min(x2)
  dy1=max(y1a)
  dy2=max(y2a)
  for i=0,0 do begin 	;do not output ps
    if i eq 1 then begin
       set_plot, 'ps'
       device, filename=file1+'.ps', /landscape
		 mydevice = !D.NAME
    endif
	 if (i eq 0) and not(keyword_set(gui)) then begin
   	 !p.multi=[0,1,2]
   	 plot, x1, y1a, psym=4, title=title1, xtitle='Energy [meV]', ytitle=ytitle1,$
         	 yrange=[0, max(y1a)], xrange=[min(x1), max(x1)]
   	 oploterr, x1, y1a, yerr1a, 4
   	 oploterr, x1, y1b, yerr1b, 7
   	 ;puts a legend
   	 legendxy=[min(x1), dy1*0.66]
   	 plots, legendxy(0), legendxy(1), psym =4
   	 xyouts, legendxy(0)+dx1/10., legendxy(1), 'Iterative procedure'
   	 plots, legendxy(0), legendxy(1)-dy1/10., psym =7
   	 xyouts, legendxy(0)+dx1/10., legendxy(1)-dy1/10., 'Fourier-log method'
   	 plot, x2, y2a, psym=4, title=title2, xtitle='Energy [meV]', ytitle=ytitle2, $
         	 yrange=[0, max(y2a)], xrange=[min(x2), max(x2)]
   	 oploterr, x2, y2a, yerr2a, 4
   	 oploterr, x2, y2b, yerr2b, 7
   	 legendxy=[min(x2), dy2*0.66]
   	 plots, legendxy(0), legendxy(1), psym =4
   	 xyouts, legendxy(0)+dx2/10., legendxy(1), 'Iterative procedure'
   	 plots, legendxy(0), legendxy(1)-dy2/10., psym =7
   	 xyouts, legendxy(0)+dx2/10., legendxy(1)-dy2/10., 'Fourier-log method'
   	 !p.multi=0
   	 if i eq 1 then begin
      	device, /close
			set_plot,mydevice
   	 endif
	 endif ;if using gui then nothing is displayed here
endfor

  openw, lun, file1, /get_lun
  printf, lun,  header1
  for i=0, N_ELEMENTS(x1)-1 do $
    printf, lun, format='(f7.2," ",4(f12.6,:, " "))', x1(i), y1a(i), y1b(i), yerr1a(i), yerr1b(i)
  free_lun, lun
  if flag eq 'one_phon' then begin
    openw, lun, output_files+'.mph', /get_lun
    printf, lun, '      E          mph      mph_fou      mph_err  mph_fou_err'
    for i=0, N_ELEMENTS(x1)-1 do $
       printf, lun, format='(f7.2," ",4(f12.6,:, " "))', x2(i), y2a(i), y2b(i), yerr2a(i), yerr2b(i)
    free_lun, lun
  endif
  SET_PLOT, mydevice
END

PRO INES_CROSS_CHECK, risultati
  COMMON  CHECK_PARAM

  INES_DEVIATION, flm, flm_err, flm_dos, flm_dos_err, dev_flm, err_flm
  INES_DEVIATION, 1., 0., int_g, int_g_err, dev_int, err_int
  INES_DEVIATION, mean_ke, mean_ke_err, mean_ke_dos, mean_ke_dos_err, dev_ke, err_ke
  INES_DEVIATION, mean_Vzz, mean_Vzz_err, mean_Vzz_dos, mean_Vzz_dos_err, dev_Vzz, err_Vzz


  Ines_Print, 'Consistency check'
  Ines_Print, string(format='(T30, a, T50, a)', 'NIS spectrum', 'DOS')
  Ines_Print, 'Lamb-Moessbauer factor'+string(flm)+string(flm_dos)
  Ines_Print, 'Normalization of DOS  '+string(1.)+string(int_g)
  Ines_Print, 'Mean kinetic energy (meV) '+string(mean_ke)+string(mean_ke_dos)
  Ines_Print, 'Mean force constant (N/m)  '+string(mean_Vzz)+string(mean_Vzz_dos)

  printf, risultati, $
  '-----------------------------------------------------------------'
  printf, risultati,$
  '|                                                               |'
  printf, risultati,$
  '|                        CONSISTENCY CHECK                      |'
  printf, risultati,$
  '|                                                               |'
  printf, risultati,$
  '-----------------------------------------------------------------'

  printf, risultati, '                          NIS spectrum       DOS      Deviation(%)'
  printf, risultati, format='("Lamb-Moessbauer factor",T30, f9.4, T40, f9.4, T50, f7.4,"+/-", f7.4)',$
                     flm, flm_dos, dev_flm, err_flm
  printf, risultati, format='("Normalization of DOS",T30, f9.4, T40, f9.4, T50, f7.4,"+/-", f7.4)', $
                     1., int_g,dev_int, err_int
  printf, risultati, format='("Mean kinetic energy (meV)",T30, f9.4, T40, f9.4, T50, f7.4,"+/-", f7.4)', $
                     mean_ke, mean_ke_dos, dev_ke, err_ke
  printf, risultati, format='("Mean force constant (N/m)",T30, f9.4, T40, f9.4, T50, f7.4,"+/-", f7.4)', $
                     mean_Vzz, mean_Vzz_dos, dev_Vzz, err_Vzz

END

PRO INES_DEVIATION, a, err_a, b, err_b, dev, err
  dev=100.*(1.-a/b)
  err=100.*(err_a/b+a*err_b/b^2)
END






PRO INES,nogui=nogui
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;       Inelastic Nuclear scattering Evaluation Software          ;;
;;            by Alessandro Barla and Luca Pasquini                ;;
;;                last updated 16/07/01 by LP                      ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Analyses nuclear inelastic scattering spectra:                  ;;
;; 1 - background subtraction                                      ;;
;; 2 - normalization using Lipkin's sum rule for first moment      ;;
;; 3 - calculation of mean kinetic energy and mean force constant  ;;
;;     using Lipkin's sum rules for second and third moments       ;;
;; 4 - subtraction of elastic peak                                 ;;
;; 5 - determination of temperature from detailed balance          ;;
;; 6 - calculation of Lamb-Moessbauer factor from NIS spectrum     ;;
;; 7 - separation of 1-phonon and multiphonon parts, both by       ;;
;;     iteration and Fourier-log method, using theory from Singwi- ;;
;;     Sjoelander; determination of the phonon DOS                 ;;
;; 8 - calculation from the DOS of:                                ;;
;;     - Lamb-Moessbauer factor                                    ;;
;;     - Mean square displacement                                  ;;
;;     - Debye temperature                                         ;;
;;     - Vibrational part of Helmholtz free energy                 ;;
;;     - Specific heat at constant volume                          ;;
;;     - Vibrational contribution to internal energy               ;;
;;     - Vibrational entropy                                       ;;
;;     - Mean kinetic energy                                       ;;
;;     - Mean force constant                                       ;;
;;                                                                 ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;Define some constants;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
COMMON CONSTANTS, avog, hbar, elch, speed_of_light, k_boltz, pi, n_multiph

avog = 6.0222d23                ; [nuclei/mole]
hbar = 1.0551d-34               ; [Js]
elch = 1.6022d-19               ; [C]
speed_of_light = 2.9979d8       ; [m/s]
k_boltz = 1.3806d-23            ; [JK^-1]
pi = acos(-1.0)                 ; pi
n_multiph = 30.                 ; number of multiphonon terms
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;Parameters read from input file;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
COMMON INPUT_PARAM, inst_f_switch, nhr, en_col, data_col, inst_nhr, inst_en_col, inst_data_col, $
                   arr_size, inst_arr_size, resonant_energy, atomic_mass, max_en, back_min, back_max, $
                   en_1, en_2, sub_flag, pif

; inst_f_switch defines wether the instrumental function data are absent (0), contained in the same
; data file as the inelastic data (1) or in another file(2)
; nhr and inst_nhr are the number of header lines in the inelastic and instrumental scans
; en_col, data_col, inst_en_col, inst_data_col define which columns are to be read in the file(s)
; arr-size and inst_arr_size define the size of temporary array(s) used to read the file(s) row by row
; resonant_energy and atomic_mass have a clear meaning
; max_en is the maximum energy considered
; back_min and back_max define the points where background has to be calculated
; The elastic peak is removed in the range en_1 < energy < en_2, using a simple linear interpolation
; (sub_flag=0) or subtracting the instrumental function after proper normalization (sub_flag<>0)
; pif is similar to the parameter of Kohn's DOS program: if pif << 1 then the instrumental
; function is deconvoluted completely, if pif >> 1 no deconvolution is performed.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;Arrays read from data file (and from instrumental function file);;;;;;;;;;;;;;;;;
COMMON FILE_DATA, energy, inst_energy, cts_inc_r, err_inc_r, cts_for_r, err_for_r
; energy and inst_energy: energy columns; cts_inc_r: counts in the incoherent channel
;(err_inc_r is the error), cts_for_r: counts in the incoherent channel (err_for_r is the error)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;Names of the file containing incoherent spectrum (and instrumental function spectrum);;;;;;
COMMON FILE_NAMES, data_file, inst_file, output_files
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;Energy moments of incoherent and forward spectra;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
COMMON MOMENTS, mass, rec_en, res_en_J, integral_inc, integral_inc_err, $
                fm_inc, fm_inc_err, fm_inc_exp, fm_inc_exp_err, $
                fm_inc_real, fm_inc_real_err, sm_inc_exp, sm_inc_exp_err, sm_inc_real, sm_inc_real_err, $
                tm_inc_exp, tm_inc_exp_err, tm_inc_real, tm_inc_real_err, integral_for, integral_for_err,$
                fm_for, fm_for_err, sm_for, sm_for_err, tm_for, tm_for_err, norm1, norm2, diff12, norm
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;Normalized arrays;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
COMMON CHECK_PARAM, flm, flm_err, flm_dos, flm_dos_err, mean_ke, mean_ke_err, mean_ke_dos, $
                    mean_ke_dos_err, mean_Vzz, mean_Vzz_err, mean_Vzz_dos, mean_Vzz_dos_err, $
                    int_g, int_g_err
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;Normalized arrays;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
COMMON NORM_DATA, se_inc, se_err, cts_for_n, err_for_n, se_inc_sub, se_err_sub

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; USING GRAPHICAL INTERFACE ?;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
COMMON INES_GUI,useGui,wInes,wInesLog,LogFileUnit,wStepIndex, ai
if not(keyword_set(no_gui)) then begin
	 Xop_Default_CT
	 INES_GUI
	 return
endif
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
abort=0
;Reads parameters from input file
entrance_file=''
INES_READ_INPUT_FILE, entrance_file

;Reads incoherent spectrum and instrumental function (if present); the number of rows in data file
;and instrumental file (if present) is calculated and stored in row_num and inst_row_num for subsequent
;calculations. Plots the data.

INES_READ_DATA_FILE, row_num, inst_row_num


;Defines the prefix of all autput files generated by the program
;remember to check whether this can be improved
output_files = strmid(data_file,0,strlen(data_file)-4)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Opens a file for subsequent writing the results of data treatment
openw, risultati, output_files + '.out', /get_lun
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

printf, risultati, 'Parameters read from file ', entrance_file
if inst_f_switch eq 0 then printf, risultati, 'Instrumental function not present' $
else printf, risultati, 'Instrumental function present'
printf, risultati, 'Resonant energy and atomic mass = ', resonant_energy, ' keV ', atomic_mass
printf, risultati, 'Maximum energy for data analysis = ', max_en, ' meV'
printf, risultati, 'Energy limits for background subtraction = ', back_min, back_max, ' meV'
if sub_flag ne 0 and inst_f_switch ne 0 then  printf, risultati, $
format='("Elastic peak removed by subraction of the instrumental function between ", f5.1, " and ", f5.1, " meV")',$
         en_1, en_2 $
else printf, risultati, format='("Elastic peak removed by linear interpolation between ", f5.1, " and ", f5.1, " meV")',$
         en_1, en_2
printf, risultati, 'Deconvolution parameter = ', pif
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;Waits for user input to continue
Ines_Print, 'Press q to quit or any other key to continue ...'
signal = strlowcase(get_kbrd(1))
if signal eq 'q' then goto, error

;Subtracts the background from the spectrum, prints the results in the output file

INES_SUBTRACT_BACKGROUND, risultati

;Symmetrizes the spectrum on the x scale, if not already symmetric

INES_SYMMETRIZE_SPECTRUM, abort=abort
	IF abort EQ 1 THEN RETURN

;Fit of instrumental function
if inst_f_switch ne 0 then INES_FIT_RESOLUTION, inst_FWHM, risultati

;Waits for user input to continue
Ines_Print, 'Press q to quit or any other key to continue ...'
signal = strlowcase(get_kbrd(1))
if signal eq 'q' then goto, error

; Normalization of 4pi spectrum using correction for non symmetricity of the instrumental function
; normalization of forward spectrum to one

INES_NORMALIZE, risultati

;Calculates mean kinetic energy and force constants from second and third moments

INES_HIGH_MOMENTS, risultati, inst_f_switch, mean_ke, mean_ke_err, mean_Vzz, mean_Vzz_err

;Waits for user input to continue
Ines_Print, 'Press q to quit or any other key to continue ...'
signal = strlowcase(get_kbrd(1))
if signal eq 'q' then goto, error

;if the instrumental function is in a different file, matches energy binning, range
;and zero-energy position for subsequent processing including subtraction of the
;elastic peak and Fourier transform

if inst_f_switch eq 2 then INES_INST_FUNCTION, inst_FWHM

; automatic subtraction of elastic peak using instrumental function as a reference
; x1 and x2 are to be defined by the user if sub_flag ne 0
INES_SUBTRACT_ELASTIC, inst_FWHM, risultati, x1, x2, abort=abort
	IF abort EQ 1 THEN RETURN

; if no subtraction of the instrumental function has to be performed, put x1=en_1
; and x2=en_2 for subsequent temperature determination
if sub_flag eq 0 then begin
  x1=en_1
  x2=en_2
endif

; calculation of Lamb-Moessbauer factor from area of 4pi spectrum
; after linear interpolation

INES_LAMB_MOESSBAUER, energy, se_inc_sub, se_err_sub, flm, flm_err, risultati, abort=abort
  IF abort EQ 1 THEN RETURN

; determination of temperature with detailed balance
; using the main peak at positive and negative energies

INES_DET_TEMPERATURE, energy, se_inc_sub, se_err_sub, x1, x2, temperature, $
                 temperature_err, kappa_T_meV, risultati, abort=abort
  IF abort EQ 1 THEN RETURN

;Calculation of phonon DOS using Fourier-log method

INES_FOURIER_LOG, energy, se_inc_sub, se_err_sub, flm, norm, one_phon_fou, one_phon_fou_err, multi_phon_fou, $
             multi_phon_fou_err, cts_for_n, risultati

INES_DOS_1PH, energy, one_phon_fou, one_phon_fou_err, dos_fou, dos_fou_err, dos_fou_p, $
         dos_fou_p_err, kappa_T_meV, rec_en, flm, dos_fou_int, dos_fou_int_err, risultati

;Calculation of phonon DOS using iterative procedure

;temp_flm=flm ;auxiliary variable to check wether the user changes L-M factor
INES_MULTI_PHONON, energy, se_inc_sub, se_err_sub, one_phon, multi_phon, one_phon_err, $
              multi_phon_err, n_multiph, flm, norm, conv, risultati

if conv eq 1 then begin
  INES_DOS_1PH, energy, one_phon, one_phon_err, dos, dos_err, dos_p, dos_p_err, $
         kappa_T_meV, rec_en, flm, dos_int, dos_int_err, risultati
endif else begin   ;sets the dos from iterative procedure to 0
  dos=energy*0.
  dos_err=energy*0.
  dos_p=energy(where(energy gt 0))*0.
  dos_p_err=energy(where(energy gt 0))*0.
endelse

;Displays the results of one-phonon separation from both methods
INES_SHOW_RESULTS, energy, one_phon, one_phon_err, one_phon_fou, one_phon_fou_err, $
              energy, multi_phon, multi_phon_err, multi_phon_fou, multi_phon_fou_err, $
              conv, 'one_phon'

;Waits for user input to continue
Ines_Print, 'Press q to quit or any other key to continue ...'
signal = strlowcase(get_kbrd(1))
if signal eq 'q' then goto, error

;Displays the DOS determined by both methods
energy_p=energy(where(energy gt 0))
INES_SHOW_RESULTS, energy_p, dos_p, dos_p_err, dos_fou_p, dos_fou_p_err, $
              energy, dos, dos_err, dos_fou, dos_fou_err, conv, 'dos'

;Selects the DOS to use for thermodynamic calculations. If no convergence was reached by the
;iterative procedure, uses the result of Fourier-log method

if conv eq 1 then begin
  Ines_Print, 'Chose which DOS you want to use to calculate some thermodynamic properties:'
  Ines_Print, 'iterative procedure(1) or Fourier-log(2)'
  read, dos_choice
endif else begin
  dos_choice = 2
  Ines_Print, 'Press any key to continue ...'
  signal = strlowcase(get_kbrd(1))
endelse

case dos_choice of
  2: begin
       g=dos_fou_p
       g_err=dos_fou_p_err
       int_g=dos_fou_int
       int_g_err=dos_fou_int_err
       messaggio='DOS from Fourier-log method chosen for thermodynamic calculations'
     end
;no longer used: avergae between the two DOS
;  3: begin
;       g=(dos_p+dos_fou_p)/2.
;       g_err=(dos_p_err+dos_fou_p_err)/2.
;       int_g=(dos_int+dos_fou_int)/2.
;       int_g_err=(dos_int_err+dos_fou_int_err)/2.
;       messaggio='Average DOS chosen for thermodynamic calculations'
;     end
 else: begin
          g=dos_p
          g_err=dos_p_err
          int_g=dos_int
          int_g_err=dos_int_err
          messaggio='DOS from iterative procedure chosen for thermodynamic calculations'
        end
endcase

;calculation of several thermodynamic parameters from DOS
printf, risultati, ''
printf, risultati, messaggio
INES_THERMODYNAMIC, energy, g, g_err, kappa_T_meV, risultati, flm_dos, flm_dos_err, mean_ke_dos, mean_ke_dos_err, $
               mean_Vzz_dos, mean_Vzz_dos_err

;Cross-check of the results obtained from NIS spectrum and from DOS
INES_CROSS_CHECK, risultati

;error condition
error: Ines_Print, '' & Ines_Print, 'End of program'

; passed to ines_gui (srio@esrf.fr)     free_lun, risultati

END




