
;=========================== copyright =========================================
;                       XAID (XAfs with IDl) package.                          ;
;     Copyright European Synchrotron Radiation Facility (1993-1996).           ;
; This software may be used, copied, or redistributed as long as it is not     ;
; sold and this copyright notice is reproduced on each copy made.              ;
; The software is provided as is without any express or implied warranties     ;
; whatsoever.                                                                  ;
; Other limitations apply as described in the file README.copyright.           ;
;                                                                              ;
; REFERENCE: "XAID: A package for XAFS data analysis based on IDL"             ;
;       Manuel Sanchez del Rio. To be published at the proceedings of          ;
;       the 9th International Conference on X-ray Absorption Fine Structure    ;
;       26th - 30th August 1996,  E S R F - Grenoble  France                   ;
;==============================================================================;
pro terminal,type,printer=printer
;+
; NAME:
;	TERMINAL
;
; PURPOSE:
;	This function procedure ask the user to define the IDL plotting
;	device ( x, tek or ps) presenting a menu. This simplifies the
;	number of IDL commands that the user has to remember and allow
;	an easy way to print the PostScript file.
;
; CATEGORY:
;	Input/Output general utilities
;
; CALLING SEQUENCE:
;
;	TERMINAL
;
; INPUTS:
;
; OPTIONAL INPUTS:
;	type: the type of terminal. Accepted values are:
;	x, xterm, vt, hirez, mac and ps
;	
; KEYWORD PARAMETERS:
;	PRINTER: the name of the printer for sending the PostScript 
;	output. Only useful with the PostScript option.
;
; OUTPUTS:
;	
;
; OPTIONAL OUTPUTS:
;
; COMMON BLOCKS:
;
; SIDE EFFECTS:
;	Alters the selected IDL output device. It may also send the 
;	file idl.ps to a printer and remove it.
;
; RESTRICTIONS:
;	None
;
; PROCEDURE:
;	Straightforward
;
; EXAMPLE:
;
;		TERMINAL
;
; MODIFICATION HISTORY:
; 	Written by:	Manuel Sanchez del Rio. ESRF
;	May, 1993
;-
on_error,2
;
n_arg = n_params()
;
if (n_arg eq 0) then begin
MENU:
  print,' Please select type of terminal you are using: '
  print,'		[0] cancel and continue'
  print,'		[1] xterminal or workstation'
  print,'		tektronix emulator:     '
  print,'			[2] xterm '
  print,'			[3] VTxx '
  print,'			[4] Macintosh-Versaterm'
  print,'			[5] Hirez-Pericom'
  print,'		[6] open PostScript file idl.ps'
  print,'		[7] close PostScript file and send to printer'
  i_term=getvalue('[Default=1] ? ',1)
endif else begin
  if (type eq 'x') then i_term=1
  if (type eq 'xterm') then i_term=2
  if (type eq 'vt') then i_term=3
  if (type eq 'mac') then i_term=4
  if (type eq 'hirez') then i_term=5
  if (type eq 'ps') then i_term=6
endelse
;
case i_term of
  0: 
  1: set_plot,'x'
  2: begin
       set_plot,'tek'
       device,set_string='\033\133\077\063\070\150'
       device,reset_string='\033\003'
     end
  3: begin
       set_plot,'tek'
       device,set_string='\033,\133,\077,\063,\070,\150'
       device,reset_string='\033,003'
     end
  4: begin
       set_plot,'tek'
       device,set_string='\033,\035'
       device,reset_string='\033,\117,\033,\062'
     end
  5: begin
       set_plot,'tek'
       device,set_string='\033,\035'
       device,reset_string='\033,\030'
     end
  6: set_plot,'ps'
  7: begin
       device,/close
       if not(keyword_set(printer)) then printer= $
        getvalue('Name of the printer [Default: p4bc244] ? ','p4bc244')
       spawn,'lp -d'+strcompress(printer,/rem)+' idl.ps'
       spawn,'/bin/rm idl.ps'
       goto,MENU
     end
endcase
;
return
end 
