
;=========================== copyright =========================================
;                       XAID (XAfs with IDl) package.                          ;
;     Copyright European Synchrotron Radiation Facility (1993-1996).           ;
; This software may be used, copied, or redistributed as long as it is not     ;
; sold and this copyright notice is reproduced on each copy made.              ;
; The software is provided as is without any express or implied warranties     ;
; whatsoever.                                                                  ;
; Other limitations apply as described in the file README.copyright.           ;
;                                                                              ;
; REFERENCE: "XAID: A package for XAFS data analysis based on IDL"             ;
;       Manuel Sanchez del Rio. To be published at the proceedings of          ;
;       the 9th International Conference on X-ray Absorption Fine Structure    ;
;       26th - 30th August 1996,  E S R F - Grenoble  France                   ;
;==============================================================================;
function GETYESORNOT,text
;+
; NAME:
;	GETYESORNOT
;
; PURPOSE:
;	This function returns a 1 when the user answer yes to the question
;	presented ("Y" , "y" or "1") and returns 0 if the answer is not
;	("N" , "n" , "0" or <return> )
;
; CATEGORY:
;	XAID XAFS data analysis package.
;
; CALLING SEQUENCE:
;	Result = GETYESORNOT(' tell me yes or not ? [y/n] ')
;
; INPUTS:
;	text:	the message to be displayed
;
; OPTIONAL INPUTS:
;	
; KEYWORD PARAMETERS:
;
; OUTPUTS:
;	1 (for yes) or 0 (for not)
;
; OPTIONAL OUTPUTS:
;
; COMMON BLOCKS:
;
; SIDE EFFECTS:
;	None
;
; RESTRICTIONS:
;	None
;
; PROCEDURE:
;	Straightforward
;
; EXAMPLE:
;
;	i_yes = GETYESORNOT(' Do you want a coffe ? ')
;
; MODIFICATION HISTORY:
; 	Written by:	Manuel Sanchez del Rio. ESRF
;	February, 1993	
;-
on_error,2
;
answer = ''
print,text
read,answer
repeat begin
  out = -1
  if ( (answer eq 'y') or (answer eq 'Y') or (answer eq '1') ) then out=1
  if ( (answer eq 'n') or (answer eq 'N') or (answer eq '0') $
       or (answer eq '') ) then out=0
  if ( (out ne 1) and (out ne 0)) then begin
    print,' Error: Answer not valid, enter again: ? '
    read,answer
  endif
endrep until ( (out eq 1) or (out eq 0) )
;
return,out
end
