
;=========================== copyright =========================================
;                       XAID (XAfs with IDl) package.                          ;
;     Copyright European Synchrotron Radiation Facility (1993-1996).           ;
; This software may be used, copied, or redistributed as long as it is not     ;
; sold and this copyright notice is reproduced on each copy made.              ;
; The software is provided as is without any express or implied warranties     ;
; whatsoever.                                                                  ;
; Other limitations apply as described in the file README.copyright.           ;
;                                                                              ;
; REFERENCE: "XAID: A package for XAFS data analysis based on IDL"             ;
;       Manuel Sanchez del Rio. To be published at the proceedings of          ;
;       the 9th International Conference on X-ray Absorption Fine Structure    ;
;       26th - 30th August 1996,  E S R F - Grenoble  France                   ;
;==============================================================================;
function GETJUMP, exper, nomouse=nomouse, Dialog_Parent=dialog_parent
;
;+
; NAME:
;	GETJUMP
;
; PURPOSE:
;	This function calculates the jump of a xafs spectrum
;
; CATEGORY:
;	XAID xafs data analysis package. 
;
; CALLING SEQUENCE:
;
;	myjump = GETJUMP(myset)
;
; INPUTS:
;	myset:	fltarr(2,npoints) set of data
;
; OPTIONAL INPUTS:
;	
; KEYWORD PARAMETERS:
;	NOMOUSE: when set, uses ASCII terminal dialog, otherwise uses
;		widget dialogs.
;	DIALOG_PARENT: this keyword is passed to dialogs for centering
;		the widget with a parent widget.
;
; OUTPUTS:
;	myjump: the value with the jump
;
; OPTIONAL OUTPUTS:
;
; COMMON BLOCKS:
;
; SIDE EFFECTS:
;	None
;
; RESTRICTIONS:
;	None
;
; PROCEDURE:
;	The jump value is read with the mouse 
;
; EXAMPLE:
;
;		jump = GETJUMP (set2)
;
; MODIFICATION HISTORY:
; 	Written by:	Manuel Sanchez del Rio. ESRF
;	February, 1993	
;	93-05-24 MSR small modifications
;	94-10-10 MSR NOMOUSE keyword.
;	96-08-13 MSR (srio@esrf.fr) changes wmenu->wmenu2 and 
;		xtext->Dialog_Message
;	00-02-12 MSR (srio@esrf.fr) adds Dialog_Parent keyword
;-
;
on_error,2
;
;
; automatic calculation of jump (mean value of the points sitting
; in the normalized interval interval [0.2,0.4]  where extrema are
; Eo and xmax )
;
  i_change = 0
  plotset,exper
  xmin = gete0(exper)
  xmax = max(exper(0,*))
  xmin_good = xmin + 0.2*(xmax-xmin)
  xmax_good = xmin + 0.4*(xmax-xmin)
  cutset,exper,good,xrange=[xmin_good,xmax_good]
  tmp1=(total(good(1,*)))/(n_elements(good(1,*)))  - min(exper(1,*))
  good(1,*) = good(1,*)*0.0+tmp1
  plotset,good,/over
  oplot,good(0,*),good(1,*)*0.0+ min(exper(1,*))
  if keyword_set(nomouse) then begin
    print,' The selected value for Jump is : ',tmp1
    i_change=getyesornot(' Do you want to change this value ? [y/n]')
  endif else begin
    i_change=wmenu2(['Store this value ('+$
	strcompress(tmp1,/rem)+') and continue','Change Jump value'],$
	Dialog_Parent=dialog_parent)
  endelse
;
; manual calculation of jump
;
if i_change then begin
  repeat begin
    plotset,exper
    if keyword_set(nomouse) then begin
      print,' Get the jump by: '
      print,'	[0] Selecting a point with the mouse '
      print,'	[1] Entering the value '
      read,i_how
    endif else begin
	i_how = wmenu2(['Selecting jump with the mouse ',$
	'Entering the value'],$
	Dialog_Parent=dialog_parent)
    endelse
    if (i_how eq 0) then begin
      if keyword_set(nomouse) then begin
        print,$
        'Please, move the cursor until the selected value for JUMP and click '
        cursor,tmp,tmp1,3
        plotset,[tmp,tmp1],/over,psym=1
        ;
        print,$
        'Please, move the cursor until the selected baseline and click'
        cursor,tmp,tmp2,3
        print,' The selected value for baseline is : ',tmp2
        plotset,[tmp,tmp2],/over,psym=1
        ;
      endif else begin
        ;Xtext,text=['Click two points:','The upper and the ', $
	;' baseline for jump']
        itmp = Dialog_Message(/info,['Click two points:','The upper and the ', $
	' baseline for jump'],Dialog_Parent=dialog_parent)
        cursor,tmp,tmp1,3
        plotset,[tmp,tmp1],/over,psym=1
        cursor,tmp,tmp2,3
        plotset,[tmp,tmp2],/over,psym=1
      endelse
      tmp1 = tmp1-tmp2
      itmp=Dialog_Message(/info,' The selected value for Jump is : '+$
	strcompress(abs(tmp1)),Dialog_Parent=dialog_parent)
    endif else begin
      if keyword_set(nomouse) then begin
        print,' Give me the new value for jump ? '
        read,tmp1
        plotset,[[-1000000,tmp1],[1000000,tmp1]],/over
      endif else begin
        tmp = { n:1.0 }
        XscrMenu,tmp,/NoType,Titles='Jump value:',Wtitle='Input Jump', $
	action=action,Dialog_Parent=dialog_parent
        if action eq 'DO' then tmp1=tmp.n else tmp1=0.0
      endelse
    endelse
    if keyword_set(nomouse) then $
	i_change=getyesornot(' Do you want to change this value ? [y/n]') $
	else i_change=0
  endrep until (i_change eq 0)
endif
;
return,abs(tmp1)
end
