;+
; NAME:
;	CW_XShCol
;
; PURPOSE:
;	CW_PICKFILE is a compound widget that permits the selection
;	of a SHADOW column.
;
; CATEGORY:
;	Shadow Compound widgets.
;
; CALLING SEQUENCE:
;	Widget = CW_XshColParent)
;
; INPUTS:
;	Parent:	  The ID of the parent widget.
;
; KEYWORD PARAMETERS:
;	UVALUE:	The user value for the widget.
;	VALUE:	The initial column.  
;	TITLE:	A title or label.
;	COLUMN:	If set, ranges the widgets in column format.
;	FRAME:	Displays a frame around the compound widget.
;	ZEROCOL: When set, displays also the zeroth column ('0: <none>')
;
; OUTPUTS:
;	The ID of the created widget is returned.
;
; SIDE EFFECTS:
;
; PROCEDURE:
;	Uses XSh_ColDes to get the menu structure.
;
; EXAMPLE:
;	;
;	; To test cw_xshcol
;	;
;	Pro test_col_event, event
;	Widget_Control, event.id, get_UValue=eventUValue
;	if not(keyword_set(eventUValue)) then eventUValue=''
;	
;	stateid = Widget_Info(event.handler,/Child)
;	Widget_Control, stateid, get_UValue=state, /No_Copy
;	
;	Case eventUValue OF
;	    'DONE': Begin
;		Widget_Control, event.top, /destroy
;		Return
;		End
;	    'SET0': Begin
;		Widget_Control,state.file,Set_Value=0
;		End
;	    'SET10': Begin
;		Widget_Control,state.file,Set_Value=10
;		End
;	    'GETVALUE': Begin
;		Widget_Control,state.file,Get_Value=aa
;		help,aa
;		message,/info,'>> value is: '+string(aa)
;		end
;	    else:
;	ENDCASE
;	Widget_Control, stateid, Set_UValue=state, /No_Copy
;	END ; test_col_event
;	;
;	;
;	Pro test_col
;	tlb=widget_base(/col)
;	wtmp=widget_base(tlb) ; to store state
;	
;	wtmp = Widget_Button(tlb,Value='DONE',UValue='DONE')
;	wtmp = Widget_Button(tlb,Value='GETVALUE',UValue='GETVALUE')
;	wtmp = Widget_Button(tlb,Value='Set Column 0',UValue='SET0')
;	wtmp = Widget_Button(tlb,Value='Set Column 10',UValue='SET10')
;	; the important part:
;	wfile = cw_xshcol(tlb,Title='SHADOW col:',/Frame, Value=1,/ZeroCol)
;	
;	state = {file:wfile}
;	
;	widget_control,Widget_Info(tlb,/Child),set_uvalue=state
;	widget_control,tlb,/realize
;	xmanager, 'test_col', tlb
;	end ; test_col
;	
; MODIFICATION HISTORY:
; 	Written by:	M. Sanchez del Rio, srio@esrf.fr
;	July, 1996	
;	97-12-05 First used version. Added ZEROCOL keyword. Documented.
;	02-03-13 srio@esrf.fr str_sep substituted by strsplit
;-
Pro CW_XShCol_Set, id, value
;
child=Widget_Info(id, /Child)
Widget_Control, child, Get_UValue=state, /No_Copy

value2=fix(value)
; update the pulldown menu title
; get the id of the first pull-down menu button
child2 = Widget_Info(state.dropid, /Child)
;set the value as the selected item
Widget_Control,child2,Set_Value=XSh_ColDes(value2)
state.shcol=value2

Widget_Control, child, Set_UValue=state, /No_Copy
END
;
;===============================================================
;
Function CW_XShCol_Get, id
child=Widget_Info(id, /Child)
Widget_Control, child, Get_UValue=state, /No_Copy
value = state.shcol
Widget_Control, child, Set_UValue=state, /No_Copy
Return, value
END
;
;===============================================================
;
Function CW_XShCol_Event, event

child = Widget_Info(event.handler, /Child)
Widget_Control, child, Get_UValue=state, /No_Copy
; 
; update the pulldown menu title
;
; get the id of the first pull-down menu button
child2 = Widget_Info(state.dropid, /Child)
;set the value as the selected item
tmp = event.value
widget_control,child2,set_value=tmp
;
;update state
;
; state.shcol = fix( (str_sep(tmp,':'))(0) )
state.shcol = fix( (StrSplit(tmp,':',/Extract))(0) )
Widget_Control, child, Set_UValue=state, /No_Copy

;
; return event structure
;
WIDGET_CONTROL, event.id, get_uvalue=uvalue
return, { ID:event.handler, TOP:event.top, HANDLER:0L, value:uvalue }

END
;
;
;===============================================================
;
Function CW_XShCol, parent, UValue=uval, Title=init_label, $
  Value=init_text, Column=Column,Frame=Frame, ZeroCol=zerocol

On_Error,1
If N_Params() NE 1 THEN Message,'Must have one parameter'
If N_Elements(uval) EQ 0 THEN uval = 0
If N_Elements(frame) EQ 0 THEN frame = 0
If N_Elements(init_label) EQ 0 THEN init_label = 'Shadow column: '
If N_Elements(init_text) EQ 0 THEN init_text = '5'
row=1
If keyword_set(column) then row=0 else Column=0


cw_tlb = Widget_Base(parent, $
   Row=Row, Column=Column, $
   Frame=Frame, Uvalue=uval, $
   Event_Func='CW_XShCol_Event',$
   Pro_Set_Value='CW_XShCol_Set', $
   Func_Get_Value='CW_XShCol_Get')

label = Widget_Label(cw_tlb, Value=init_label)

drop = CW_PDMenu(cw_tlb,XSh_ColDes(/STR, ZeroCol=zerocol),/Return_Name)


state = {labelid:label, dropid:drop, shcol:fix(init_text)}
Widget_Control, label, Set_UValue=state , /No_Copy

widget_control,cw_tlb,set_value=fix(init_text)

Return, cw_tlb
END
