function getrays,fname,group=group
;+
; NAME:
;	GETRAYS
; PURPOSE:
;       equivalent to RBEAM in shadow library.
;       reads fortran77 unformatted shadow image file
;       and stored the output in an array of double precision
;       real numbers.
; CATEGORY:
;	General
; CALLING SEQUENCE:
;	a= GETRAYS('shadow_file_name')
; INPUTS:
;	shadow_file_name name of the shadow file
; OUTPUTS:
;	an array with the SHADOW file
; KEYWORDS
;	group = the widget id of the parent leader (used for positioning 
;		error and question windows).
; COMMON BLOCKS:
;	None.
; SIDE EFFECTS:
;	None.
; RESTRICTIONS:
;	None.
; PROCEDURE:
;	Straightforward.
; MODIFICATION HISTORY:
;       Original fron Steve Turner (CXrL)
;       1-Sep-1992 M. Sanchez del Rio: Cosmetics
;	1-Mar-1995 Jean-Francois Hochedez change procedure
;	to increase lecture speed using ASSOC command
;	7-Jun-95 MSR checks for file existence.
;	97-11-12 sio@esrf.fr adapts for Windows95. Makes a uniform code for
;		Unix and Windows.
;	98/04/02 srio@esrf.fr checks and filters NaN values. Adds Group kw.
;-
on_error,2
catch, error
if error NE 0 then begin
  message,/info,'Error while processing file: '+fname
  catch,/cancel
  if sdep(/w) then $
     itmp = Dialog_Message(Dialog_Parent=group, $
     'GETRAYS: Error while processing file: '+fname)
  return,0
endif

ncols = 0L                 ;give the template to the target variables
npoints = 0L
iflag = 0L
;if sdep() EQ 'UNIX' then begin
;  old code working for Unix
;  openr,Unit,fname,/f77_unformatted,/get_lun 
;  readu,Unit,ncols,npoints,iflag      ;read the header information
;  point_lun,-Unit,offset
;  x=assoc(Unit,dblarr(ncols+1,npoints),offset+4)
;  y=x(0)
;  rays=y(0:ncols-1,*)
;endif else  begin
  openr,Unit,fname,/get_lun
  readu,Unit,ncols,ncols,npoints,iflag      ;read the header information
  point_lun,-Unit,offset
  x=assoc(Unit,dblarr(ncols+1,npoints),offset) 
  y=x(0)
  rays=y(1:ncols,*)
;endelse
free_lun,Unit
;
; check for infinities
;
if n_elements(rays) NE total(finite(rays)) then begin
   nn = n_elements(rays)-long(total(finite(rays)))
   message,/info,'Number of infinites or NaN found '+strcompress(nn)
   ifilter = 1
   if sdep(/w) then begin
     itmp = Dialog_Message(Dialog_Parent=group, $
       ['The GETRAYS routine has detected '+strcompress(nn)+$
	  ' NaN/Inf/Undefined',$
       'values. It is possible to filter them out by assigned zero values',$
       'to them and negative flags ( -22 ) to the "lost ray flag" column.',$
       'Do you want to perform the filtering?'],/Question)
     if itmp EQ 'Yes' then ifilter=1 else ifilter=0
   endif
   if ifilter EQ 1 then begin
     message,/info,'Correcting: Assigning lost flag -22 to rays with NaN/Inf'
     count = 0
     for i=0,ncols-1 do begin
       tmp = where(finite(rays(i,*)) EQ 0,count)
       if count NE 0 then begin
	 rays(9,tmp) = -22
	 rays(i,tmp) = 0
       endif
     endfor
   endif
endif

return,rays
end

