;+
; NAME:
;       blv_beam_to_image.
;
; PURPOSE:
;       This procedure return an 'idlgrimage' thanks to a 'beam'.
;
; CATEGORY:
;       BLViewer.
;
; CALLING SEQUENCE:
;       idlgrimage=blv_beam_to_image, beam, sisei=int, xRep=int, yRep=int, 
;	xrange=int, yrange=int, imageTab=imageTab, /good, /select
;
; INPUTS:
;		beam: a 'beam' object
;		sizei: the size of the returned image (pixels)
;		xRep, yRep : a beam containe 3D points(rayons) so xRep and 
;		yRep define a projection
;					0->x (default xRep)
;					1->y (default yRep)
;					2->z
;		xrange, yrange: 1 by 2 matrix, the procedure considere only 
;		data include between these value.
;						default: all data are 
;						considered.
;		select: if select is used then only good or out rays are
;			considered depending on "good" keyword.
;		good: actif only if select is used. Then if good is used 
;			only good rays are considered else only bad rays 
;			are considered.
;
; OUTPUT:
;		imageTab: a sizei*sizei matrix representing the created 
;			picture ,
;
; EXAMPLE:;
;		beam=obj_new('beam')
;		...
;		idlgrimage=blv_beam_to_image, beam,sisei=520, xRep=0, yRep=1
;		(see 'idlgrimage' class)
;
; PROCEDURE:
;
; REFERENCE:
;
; MODIFICATION HISTORY:
;       Written by CP:  ESRF, EXP, May 2001
;-
;***************************
function blv_beam_to_image, beam, sizei=sizei, xRep=x, yRep=y, xrange=xr, yrange=yr, imageTab=imageTab, select=select, good=good

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Catch, /cancel
   Message,/Info,'error caught: '+!error_state.msg
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
        'blv_beam_to_image: error caught: '+!error_state.msg)
   RETURN,0
ENDIF


	if n_elements(sizei) eq 0 then sizei=256
	if n_elements(x) eq 0 then x=0
	if n_elements(y) eq 0 then y=2
	if select eq 0 then type_rays='all' else begin
			if good eq 1 then type_rays='good' else type_rays='bad'
		endelse

	nb_ray=beam->count()
	tab=fltarr(3,nb_ray)
	pos=0
	for r=0, nb_ray-1 do begin
	ray=beam->get(r)
;	print, ray[6]
	case type_rays of
		'all': begin
				tab[0:2,pos]=ray[0:2]
				pos=pos+1
				end
		'good': begin
				if ray[6] eq 1. then begin tab[0:2,pos]=ray[0:2]
				pos=pos+1
				endif
				end
		'bad': begin
				if ray[6] ne 1. then begin tab[0:2,pos]=ray[0:2]
				pos=pos+1
				endif
				end
	endcase
	endfor

	if pos eq 0 then begin
			imageTab=intarr(sizei, sizei)
			return, obj_new('idlgrimage',/Greyscale,dimensions=[1,1])
			endif
	tab=tab[*,0:pos-1]

	if n_elements(xr) eq 0 then begin
		xmin=min(tab[x,*])
		xmax=max(tab[x,*])
	endif else begin
		xmin=xr[0]
		xmax=xr[1]
	endelse
	if n_elements(yr) eq 0 then begin
		ymin=min(tab[y,*])
		ymax=max(tab[y,*])
	endif else begin
		ymin=yr[0]
		ymax=yr[1]
	endelse

	im=uintarr(sizei,sizei)


	point=[(tab[x,*]-xmin)*((sizei-1)/(xmax-xmin)), $
			(tab[y,*]-ymin)*((sizei-1)/(ymax-ymin))]


	nb_ray=(size(tab))[2]
	for r=0, nb_ray-1	do begin
		i=uint(point[0,r])
		j=uint(point[1,r])
		if (i lt sizei) and (j lt sizei)  then $
			;im[i,j]=im[i,j]+1
			im[i,j]=1
		endfor

	maxi=max(im)
	im=im*uint((255./maxi))
	imageTab=im

	image=obj_new('idlgrimage',im, /Greyscale,dimensions=[1,1])
	return, image
	end

