PRO nbragg_out,str
;+
; NAME:
;       NBRAGG_OUT
;
; PURPOSE:
;	Writes the structure returned by nbragg_calc to a disk file.
;
; CATEGORY:
;       Neutron optics.
;
; CALLING SEQUENCE:
;	nbragg_out,str
; INPUTS:
;	str: the structure with the data to be written down.
;
; KEYWORDS:
;
; OUTPUT:
;	A disk file (str.outfil)
;
; PROCEDURE:
;
; EXAMPLE:
;	str = daban_defaults('nbragg')
;	str1 = nbragg_calc(str)
;	nbragg_out,str1
;
; SEE ALSO:
;       nbragg_calc, nbragg_inp, daban_defaults.
;
; MODIFICATION HISTORY:
;       2003-03-14 M. Sanchez del Rio (srio@esrf.fr)
;
;-
on_error,2
;
; Now prepare the file for SHADOW.
;
outfil = str.outfil
RN = str.rn
d_spacing = str.d_spacing
noverV = str.noverV	; NEW!!
NsigA = str.NsigA	; NEW!!
nbatom = str.nbatom
atnum = str.atnum
fract = str.fract
sig_tds = str.sig_tds	; NEW!!
DWf = str.DWf	; NEW!!
expans = str.expans	; NEW!!
;;srio Alpha = str.alpha	; NEW!!
G_0 = str.G_0
G = str.G
G_BAR = str.G_BAR
;;srio f0coeff = str.f0coeff
NPOINT = str.NPOINT
energy = str.Energy
f1 = str.f1
f2 = str.f2

        OPENW,UnitOut,OUTFIL,/get_lun
        printf,UnitOut,  '# NBragg version, Data file type'
        tp1=2.3
        tp2=1
        printf,UnitOut,  tp1,tp2
        printf,UnitOut,  '# RN = (e^2/(m c^2))/V) [cm^-2],  d spacing [cm]'+$
			',  linear cell expansion coeff'
        printf,UnitOut,  RN,D_SPACING,EXPANS
        printf,UnitOut,  '# noverV (n/V) [m^-3],  Dummy'
        printf,UnitOut,  noverV,0.0
        printf,UnitOut,  '# Absorption Cross Section '+$
            '[barn],   TDS Cross Section [barn]'
        printf,UnitOut,  NsigA,sig_tds

        printf,UnitOut,  '# Number of different element-sites in unit cell NBATOM:'
        printf,UnitOut, nbatom
        printf,UnitOut, '# for each element-site, the atomic number'
        printf,UnitOut, ATNUM
        printf,UnitOut, '# for each element-site, the occupation factor'
	    printf,UnitOut, FRACT
        printf,UnitOut, '# for each element-site, The Debye Waller factor'
	    printf,UnitOut, DWf
        printf,UnitOut,  '# for each type of element-site, COOR_NR=G_0'
	    printf,UnitOut,G_0
        printf,UnitOut,  '# for each type of element-site, G and G_BAR (both complex)'
		for i=0,nbatom-1 do begin
          printf,UnitOut,  G(I)
          printf,UnitOut,  G_BAR(I)
	      endfor
        printf,UnitOut, '# for each type of element-site, the number of element in the datafile line followed by them'
;; fake data srio
f0coeff=fltarr(nbatom,11)
	ncoe = n_elements(f0coeff(0,*))
	format = '(I2,X,'+string(ncoe)+'(G12.6," "))'
	for i=0,nbatom-1 do printf,UnitOut,format=format,ncoe,f0coeff(i,*)
        printf,UnitOut,  '# The number of energy points NPOINT: '
        printf,UnitOut, NPOINT
	printf,UnitOut, '# for each energy point, energy, F1(1)-like (bc/re),F2(1)-like (bi/rc),...,'+$
		'F1(nbatom)-like,F2(nbatom)-like'

        FOR I = 0, NPOINT-1 DO BEGIN
          printf,UnitOut,  energy(i)
	  for j=0,nbatom-1 do begin
	    printf,UnitOut,  F1(j,i),F2(j,i)
	  endfor
	ENDFOR
        message,/info,'File '+OUTFIL+' written to disk.'
	free_lun,UnitOut
end

