

PRO Ines_Print,str
; If the text window of the graphical user interface of Ines
	;COMMON INES_GUI
	COMMON INES_GUI,useGui,wInes,wInesLog,LogFileUnit,wStepIndex, ai

	if widget_info(wInesLog,/valid_id) then begin
		widget_control,wInesLog,set_value=string(str),/append
	endif else begin
		print,str
	endelse
IF (FStat(logFileUnit)).open EQ 1 THEN printf,logFileUnit,str
END


PRO INES_GUI_RUN,step
	;COMMON INES_GUI,useGui,wInes,wInesLog
	;COMMON INES_GUI
COMMON INES_GUI_WAIT,wInesWait,status,flagquit
COMMON INES_GUI,useGui,wInes,wInesLog,LogFileUnit,wStepIndex, ai
; to backup variables needed from one step to another (srio@esrf.fr)
COMMON INES_GUI_RUN_BACKUP,risultati, inst_FWHM, x1, x2, kappa_T_meV, conv 
COMMON INES_GRAPHICAL_WINDOWS,xplot_p, xwindow_p
;, one_phon, one_phon_err, dos, dos_err, $
;        multi_phon, multi_phon_err, multi_phon_fou, multi_phon_fou_err
	;
	; This procedure creates a Graphical User Interface for INES.
	; It asks to the user all relevant information in subsequent 
	; windows (wizard-like)
	; it is a replacement for the INES procedure.
	;
	COMMON CONSTANTS
	;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;Define some constants;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	avog = 6.0222d23                ; [nuclei/mole]
	hbar = 1.0551d-34               ; [Js]
	elch = 1.6022d-19               ; [C]
	speed_of_light = 2.9979d8       ; [m/s]
	k_boltz = 1.3806d-23            ; [JK^-1]
	pi = acos(-1.0)                 ; pi
	n_multiph = 30.                 ; number of multiphonon terms
	COMMON INPUT_PARAM
	COMMON FILE_DATA
	COMMON FILE_NAMES
	COMMON MOMENTS
	COMMON CHECK_PARAM
	COMMON NORM_DATA
	
	ines_print,'Start STEP: '+String(step,Format='(I2)')
	IF N_Elements(step) EQ 0 THEN GOTO,STEP_0
	CASE step OF
	0: GOTO,STEP_0
	1: GOTO,STEP_1
	2: GOTO,STEP_2
	3: GOTO,STEP_3
	4: GOTO,STEP_4
	5: GOTO,STEP_5
	6: GOTO,STEP_6
	7: GOTO,STEP_7
	8: GOTO,STEP_8
	9: GOTO,STEP_9
	10: GOTO,STEP_10
	11: GOTO,STEP_11
	else:
	ENDCASE

	STEP_0:
	
	Ines_Print, ''
	Ines_Print, ''
	Ines_Print, '***********************************************************************'
	Ines_Print, '*                                                                     *'
	Ines_Print, '*                                    INES                             *'
	Ines_Print, '*  A program for the Evaluation of Nuclear Inelastic Scattering data  *'
	Ines_Print, '*                  by Luca Pasquini and Alessandro Barla              *'
	Ines_Print, '*                                                                     *'
	Ines_Print, '***********************************************************************'
	Ines_Print, ''
	Ines_Print, ''

		;set some default values
			;01
				inst_f_switch=1
				nhr=1
				en_col=1
				data_col=2
				inst_nhr=1
				inst_en_col=1
				inst_data_col=3
			;02
				resonant_energy=14.4125
			;03
				atomic_mass=57
			;04
				max_en=70
			;05
				back_min=-65
				back_max=100
			;06
				en_1=-25
				en_2=25
				sub_flag=1
			;07
				pif=.1
		;let the user choose a ines.in file, if available
		filename='ines.in'
		filename=dialog_pickfile(filter='*.in',title='Choose *.in file or cancel for default')
   	openr,optfile,filename,/get_lun,error=err
   	if err eq 0 then BEGIN
		INES_READ_INPUT_FILE,filename,error=error
		IF error EQ 1 THEN RETURN
	endif else begin
		Ines_Print,'no ines.in -> Using default values'
	endelse
		
ines_print,'END STEP: '+StrCompress(step)+';  Click on " >> " button to continue...'
RETURN
	STEP_1:
	;input data
		
		;what is the data format ?
		out1	  =  { Data_Format, $
						 nhr: nhr, $
						 en_col: en_col, $
						 data_col: data_col, $
						 inst_f_switch: [string(inst_f_switch),$
						 					  '0 no instrumental function',$
											  '1 in data file','2 in separate data file'],$
						 inst_data_col: inst_data_col, $
						 inst_en_col: inst_en_col}
		titles1 = ['Number of header lines to skip:',$
					 'Energy column:', $
					 'Data column:',$
					 'Instrumental function',$
					 'Data column for Inst Func:',$
					 'Energy column for Inst Func (if in a different file):']
		XSCRMENU,out1,/interpret,titles=titles1,/notype,action=action,WTITLE='Data Format',non_modal=0
		if action eq 'DONT' then begin
		  ; srio
		  tmp = Dialog_Message(/Question,'Abort INES run?')
		  IF tmp EQ 'Yes' THEN BEGIN
			Ines_ErrorMessage
			RETURN
		  ENDIF
		endif
		nhr = out1.nhr
		en_col = out1.en_col
		data_col = out1.data_col
		reads,out1.inst_f_switch,inst_f_switch
		inst_data_col = out1.inst_data_col
		inst_en_col = out1.inst_en_col
		;
	 Ines_Print,'INES_GUI 2: reading data'
		CASE inst_f_switch OF
		  0: begin
	 	   	Ines_Print,'INES_GUI 2: reading data(0)'
		     if data_col gt en_col then arr_size=data_col else arr_size=en_col
		     INES_READ_ARRAYS_FROM_FILE, nhr, arr_size, row_num, energy, en_col,$
		   							   cts_inc_r, data_col,title="Select input data file",error=error
		     IF error EQ 1 THEN RETURN
		  endcase
		  1: begin
	 	     Ines_Print,'INES_GUI 2: reading data(1)'
   		  arr_size=en_col
           if data_col gt arr_size then arr_size=data_col
           if inst_data_col gt arr_size then arr_size=inst_data_col
			  INES_READ_ARRAYS_FROM_FILE, nhr, arr_size, row_num, energy, en_col, cts_inc_r, data_col, $
                           		 cts_for_r, inst_data_col,title="Select input data file",error=error
			  IF error EQ 1 THEN RETURN
   		  inst_energy=energy
   		  err_for_r=SQRT(abs(cts_for_r))
   	  endcase
		  2: begin
	 	     Ines_Print,'INES_GUI 2: reading data(2)'
           if data_col gt en_col then arr_size=data_col else arr_size=en_col
           if inst_data_col gt inst_en_col then inst_arr_size=inst_data_col $
           else inst_arr_size=inst_en_col
   		  INES_READ_ARRAYS_FROM_FILE, nhr, arr_size, row_num, energy, en_col, cts_inc_r, data_col,title="Select input data file",$
			error=error
			IF error EQ 1 THEN RETURN
   		  INES_READ_ARRAYS_FROM_FILE, inst_nhr, inst_arr_size, inst_row_num, inst_energy, inst_en_col, $
                           		 cts_for_r, inst_data_col, /INST,title="Select input data file for Instrumental Function", $
			error=error
			IF error EQ 1 THEN RETURN
   		  err_for_r=SQRT(abs(cts_for_r))
   	  endcase
		ENDCASE
		err_inc_r=SQRT(abs(cts_inc_r))

		;Opens an xplot window to show spectrum
		case inst_f_switch of
			0: begin
				xplot,parent=p,/no_block,coltitles=['Energy [meV]-Spectrum','Intensity (counts)'],$
	 	   	   		wtitle='NIS Spectrum',$
					xtitle='-1',ytitle='-1',[transpose(energy),transpose(cts_inc_r)]
				xplot_p = [xplot_p,p]
			endcase
			1: begin
				xplot,parent=p,/no_block,coltitles=['Energy [meV]','Intensity (counts)',$
					'Instrumental Function (counts)'],wtitle='NIS Spectrum & instrumental function',$
				         [transpose(energy),transpose(cts_inc_r),transpose(cts_for_r)]
				xplot_p = [xplot_p,p]
			endcase
			2:begin
				xplot,parent=p,/no_block,coltitles=['Energy [meV]','Intensity (counts)','E (Instr. Func.) [meV]',$
					'Instrumental Function (counts)'],wtitle='NIS Spectrum & instrumental function',$
				   	[transpose(energy),transpose(cts_inc_r)]
					;:TODO: add instrumental function,transpose(inst_energy),transpose(cts_for_r)]
				xplot_p = [xplot_p,p]
			endcase
		endcase
		
		
		;Defines the prefix of all autput files generated by the program
		;remember to check whether this can be improved
		output_files = strmid(data_file,0,strlen(data_file)-4)
		
		;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
		; Opens a file for subsequent writing the results of data treatment
		Ines_Print,'Opening file for writing the results of data treatment: '+output_files + '.out'
		openw, risultati, output_files + '.out', /get_lun
		;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

		;printf, risultati, 'Parameters read from file ', entrance_file
		if inst_f_switch eq 0 then printf, risultati, 'Instrumental function not present' $
		else printf, risultati, 'Instrumental function present'		   
		printf, risultati, 'Resonant energy and atomic mass = ', resonant_energy, ' keV ', atomic_mass
		printf, risultati, 'Maximum energy for data analysis = ', max_en, ' meV'
		printf, risultati, 'Energy limits for background subtraction = ', back_min, back_max, ' meV' 
		if sub_flag ne 0 and inst_f_switch ne 0 then  printf, risultati, $
		format='("Elastic peak removed by subraction of the instrumental function between ", f5.1, " and ", f5.1, " meV")',$
         		en_1, en_2 $
		else printf, risultati, format='("Elastic peak removed by linear interpolation between ", f5.1, " and ", f5.1, " meV")',$
         		en_1, en_2 
		printf, risultati, 'Deconvolution parameter = ', pif
		;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
		

ines_print,'END STEP: '+StrCompress(step)+' Click on ">>" to continue...'
RETURN
	STEP_2:
		;non-interactive
		INES_SUBTRACT_BACKGROUND, risultati
		
		;non-interactive (saves in file *.bgd)
		INES_SYMMETRIZE_SPECTRUM,abort=abort
			IF abort EQ 1 THEN RETURN
		
ines_print,'END STEP: '+StrCompress(step)+' Click on ">>" to continue...'
RETURN
	STEP_3:
		;non-interactive
		;saves to *.fif
		if inst_f_switch ne 0 then INES_FIT_RESOLUTION, inst_FWHM, risultati,/gui
		;xplot,parent=p,/no_block,coltitles=['','']
		;xplot_loadfile,p,[transpose(),transpose(),transpose()]
	
ines_print,'END STEP: '+StrCompress(step)+' Click on ">>" to continue...'
RETURN
	STEP_4:
		INES_NORMALIZE, risultati,/gui
		xplot,parent=p,/no_block,coltitles=['Energy [meV]','Prob. of absorption [1/meV]'],$
		     xtitle='-1',ytitle='-1',wtitle='NIS normalized spectrum',$
			  [transpose(energy),transpose(se_inc)]
		xplot_p = [xplot_p,p]
		
		
ines_print,'END STEP: '+StrCompress(step)+' Click on ">>" to continue...'
RETURN
	STEP_5:
		;if widget_info(xplot_p,/valid_id) then xplot_quit,xplot_p
		;non-interactive
		INES_HIGH_MOMENTS, risultati, inst_f_switch, mean_ke, mean_ke_err, mean_Vzz, mean_Vzz_err

ines_print,'END STEP: '+StrCompress(step)+' Click on ">>" to continue...'
RETURN
	STEP_6:
		;non-interactive
		if inst_f_switch eq 2 then INES_INST_FUNCTION, inst_FWHM
		
ines_print,'END STEP: '+StrCompress(step)+' Click on ">>" to continue...'
RETURN
	STEP_7:
		;interactive ->Choose points (in INES_SUBTRACT_PEAK)
		INES_SUBTRACT_ELASTIC, inst_FWHM, risultati, x1, x2,/gui,abort=abort
			IF abort EQ 1 THEN RETURN
		;display graph with subtracted peak -> In INES_SUBTRACT_ELASTIC
		
		
		if sub_flag eq 0 then begin
		  x1=en_1
		  x2=en_2
		endif
		
ines_print,'END STEP: '+StrCompress(step)+' Click on ">>" to continue...'
RETURN
	STEP_8:
		;interactive: change Lamb-Mossbauer factor (optional)
		INES_LAMB_MOESSBAUER, energy, se_inc_sub, se_err_sub, flm, flm_err, risultati,/gui, $
			abort=abort
			IF abort EQ 1 THEN RETURN

ines_print,'END STEP: '+StrCompress(step)+' Click on ">>" to continue...'
RETURN
	STEP_9:
		;interactive: change temperature (optional)
		INES_DET_TEMPERATURE, energy, se_inc_sub, se_err_sub, x1, x2, temperature, $
                 temperature_err, kappa_T_meV, risultati,/gui,abort=abort
			IF abort EQ 1 THEN RETURN
		
ines_print,'END STEP: '+StrCompress(step)+' Click on ">>" to continue...'
RETURN
	STEP_10:
		;non-interactive
		INES_FOURIER_LOG, energy, se_inc_sub, se_err_sub, flm, norm, one_phon_fou, one_phon_fou_err, multi_phon_fou, $
             multi_phon_fou_err, cts_for_n, risultati

		;non-interactive
		INES_DOS_1PH, energy, one_phon_fou, one_phon_fou_err, dos_fou, dos_fou_err, dos_fou_p, $
         dos_fou_p_err, kappa_T_meV, rec_en, flm, dos_fou_int, dos_fou_int_err, risultati
	
	
		INES_MULTI_PHONON, energy, se_inc_sub, se_err_sub, one_phon, multi_phon, one_phon_err, $
              multi_phon_err, n_multiph, flm, norm, conv, risultati,/gui
	
		if conv eq 1 then begin  
		  INES_DOS_1PH, energy, one_phon, one_phon_err, dos, dos_err, dos_p, dos_p_err, $
         		kappa_T_meV, rec_en, flm, dos_int, dos_int_err, risultati
		endif else begin   ;sets the dos from iterative procedure to 0
		  dos=energy*0.
		  dos_err=energy*0.  
		  dos_p=energy(where(energy gt 0))*0.
		  dos_p_err=energy(where(energy gt 0))*0.  
		endelse
		
	   ;:TODO: change display using only two xplot windows (and still call
		; INES_SHOW_RESULTS to save the postscrip files)
	
		;Displays the results of one-phonon separation from both methods
		INES_SHOW_RESULTS, energy, one_phon, one_phon_err, one_phon_fou, one_phon_fou_err, $
              energy, multi_phon, multi_phon_err, multi_phon_fou, multi_phon_fou_err, $
              conv, 'one_phon',/gui
				  
		;Displays the DOS determined by both methods
		energy_p=energy(where(energy gt 0))
		INES_SHOW_RESULTS, energy_p, dos_p, dos_p_err, dos_fou_p, dos_fou_p_err, $
            		  energy, dos, dos_err, dos_fou, dos_fou_err, conv, 'dos',/gui
		xplot,parent=p1,/no_block,coltitles=['Energy [meV]',$
			  'OnePh,Iterative','OnePh,Fourier-log','MultiPh,Iterative','MultiPh,Fourier-log'],$
		     xtitle='-1',ytitle='-1',wtitle='One-phonon and multi-phonon contributions',$
			  [transpose(energy),transpose(one_phon),transpose(one_phon_fou),$
			   transpose(multi_phon),transpose(multi_phon_fou)]
		xplot_p = [xplot_p,p1]
		xplot,parent=p2,/no_block,coltitles=['Energy [meV]',$
			  'Iterative [1/meV]','Fourier-log [1/meV]'],$
		     xtitle='-1',ytitle='-1',wtitle='Non-Normalized Density of States',$
			  [transpose(energy),transpose(dos),transpose(dos_fou)]
		xplot_p = [xplot_p,p2]

		xplot,parent=p3,/no_block,coltitles=['Energy [meV]',$
			  'Iterative Method [1/meV]','Fourier-log [1/meV]'],$
		     xtitle='-1',ytitle='-1',wtitle='Normalized Density of States',$
			  [transpose(energy_p),transpose(dos_p),transpose(dos_fou_p)]
		xplot_p = [xplot_p,p3]
		
;		if ines_gui_wait() ne 'Continue' then begin
;			if widget_info(xplot_p1,/valid_id) then xplot_quit,xplot_p1
;			if widget_info(xplot_p2,/valid_id) then xplot_quit,xplot_p2
;			if widget_info(xplot_p3,/valid_id) then xplot_quit,xplot_p3
;			Ines_ErrorMessage
;			return 
;		endif
;		if widget_info(xplot_p1,/valid_id) then xplot_quit,xplot_p1
;		if widget_info(xplot_p2,/valid_id) then xplot_quit,xplot_p2
;		if widget_info(xplot_p3,/valid_id) then xplot_quit,xplot_p3
	 	
		if conv eq 1 then begin
		  Ines_Print, 'Chose which DOS you want to use to calculate some thermodynamic properties:'
		  Ines_Print, 'iterative procedure(1) or Fourier-log(2)'
		  out2	  =  { Out2, $
						    dos_choice: ['0',$
						 					  'iterative procedure',$
											  'Fourier-log']}
		  titles2 = ['Chose which DOS you want to use to calculate some thermodynamic properties:']
		  XSCRMENU,out2,/interpret,titles=titles2,action=action,WTITLE='DOS Choice',non_modal=0,/NoType
		  IF action EQ 'DONT' THEN BEGIN
		    tmp = Dialog_Message(/Question,'Abort INES run?')
		    IF tmp EQ 'Yes' THEN BEGIN
			Ines_ErrorMessage
			RETURN
		    ENDIF
		  ENDIF
		  reads,out2.dos_choice,dos_choice
		  dos_choice=dos_choice+1
		endif else begin
		  dos_choice = 2
		  ;Ines_Print, 'Press any key to continue ...'
		  ;signal = strlowcase(get_kbrd(1))
		endelse

		case dos_choice of
		  2: begin
      		 g=dos_fou_p
      		 g_err=dos_fou_p_err
      		 int_g=dos_fou_int
      		 int_g_err=dos_fou_int_err
      		 messaggio='DOS from Fourier-log method chosen for thermodynamic calculations'
   		  end
		 else: begin
         		 g=dos_p
         		 g_err=dos_p_err
         		 int_g=dos_int 
         		 int_g_err=dos_int_err
         		 messaggio='DOS from iterative procedure chosen for thermodynamic calculations'
      		  end
		endcase

		;calculation of several thermodynamic parameters from DOS
		printf, risultati, ''
		printf, risultati, messaggio
		INES_THERMODYNAMIC, energy, g, g_err, kappa_T_meV, risultati, flm_dos, flm_dos_err, mean_ke_dos, mean_ke_dos_err, $
               		mean_Vzz_dos, mean_Vzz_dos_err,/gui

		;Cross-check of the results obtained from NIS spectrum and from DOS
		INES_CROSS_CHECK, risultati

ines_print,'END STEP: '+StrCompress(step)+' Click on ">>" to continue...'
RETURN

STEP_11:
	Ines_Print,' Closing file '+ (FStat(risultati)).name
	free_lun, risultati
        ines_print,'END STEP: '+StrCompress(step)
	Ines_Print,'END OF INES PROGRAM'


END

PRO INES_GUI_EVENT,event
	COMMON INES_GRAPHICAL_WINDOWS,xplot_p, xwindow_p
	COMMON INES_GUI,useGui,wInes,wInesLog,LogFileUnit,wStepIndex, ai
	;COMMON INES_GUI
	;Widget_Control, event.top, Get_UValue=info
	;thisEvent = Tag_Names(event, /Structure_Name)
	;print,thisEvent,event
	;if  thisEvent eq 'WIDGET_TEXT_CH' then begin
	;	Ines_Print,event.ch
	;	return
	;endif
	;if  thisEvent eq 'WIDGET_KBRD_FOCUS' then begin
	;	return
	;endif
	IF N_Elements(ai) EQ 0 THEN ai=0 
	IF Widget_Info(event.id,/Name) EQ 'TEXT' THEN BEGIN ; IDL prompt
	  
          Widget_Control,event.id,Get_UValue=uvalue
          Widget_Control,event.id,Get_Value=value
	  CASE uvalue OF
	  'IDLPROMPT': BEGIN
              itmp = Execute(value[0])
              if itmp NE 1 THEN itmp = $
			Dialog_Message(/Error,'Error executing: '+value[0])
	      END
	  'STEPINDEX': BEGIN
	      Widget_Control,event.id,Get_Value=value
              ai = Fix(value[0]) 
	      ai=ai<11>0
	      Widget_Control,wStepIndex,Set_Value=String(ai,Format='(I2)')
	      INES_GUI_RUN,ai
	      END
	  else: Message,'Case not found: '+uvalue
	  ENDCASE
	  RETURN
	ENDIF
	
	IF Widget_Info(event.id,/Name) EQ 'BUTTON' THEN BEGIN 
		Widget_Control,event.id,Get_Value=action
	ENDIF ELSE BEGIN
		action = event.value
	ENDELSE
	case action of
		'Start INES': BEGIN
			;IF N_Elements(ai) EQ 0 THEN ai=0 ELSE ai=ai+1
			;xedit,ai
			ai = 0
			Widget_Control,wStepIndex,Set_Value=String(ai,Format='(I2)')
			INES_GUI_RUN,ai
			END
		'Start INES': BEGIN
			ai = 0
			Widget_Control,wStepIndex,Set_Value=String(ai,Format='(I2)')
			INES_GUI_RUN,ai
			END
		'  <<  ': BEGIN
			Widget_Control,wStepIndex,Get_Value=tmp
			IF tmp EQ '..' THEN RETURN
			ai = ai-1>0
			Widget_Control,wStepIndex,Set_Value=String(ai,Format='(I2)')
			INES_GUI_RUN,ai
			END
		'  >>  ': BEGIN
			Widget_Control,wStepIndex,Get_Value=tmp
			IF tmp EQ '..' THEN RETURN
			ai = ai+1<11
			Widget_Control,wStepIndex,Set_Value=String(ai,Format='(I2)')
			INES_GUI_RUN,ai
			IF ai EQ 11 THEN  Widget_Control,wStepIndex,Set_Value='..'
			END
		'Abort INES': BEGIN
			Widget_Control,wStepIndex,Get_Value=tmp
			IF tmp EQ '..' THEN RETURN
			Ines_ErrorMessage
			ai = 0
			;Widget_Control,wStepIndex,Set_Value=String(ai,Format='(I2)')
			END
		'Repeat Step': BEGIN
			Widget_Control,wStepIndex,Get_Value=tmp
			IF tmp EQ '..' THEN RETURN
			INES_GUI_RUN,ai
			END
		'Kill Graphs': BEGIN
			FOR i=0L,N_Elements(xplot_p)-1 DO $
				IF Widget_Info(xplot_p[i],/Valid_Id) THEN Xplot_Quit,xplot_p[i]
			xplot_p = 0L
			FOR i=0L,N_Elements(xwindow_p)-1 DO $
				IF Widget_Info(xwindow_p[i],/Valid_Id) THEN XWindow_Quit,xwindow_p[i]
			xwindow_p = 0L
			END
		'Convert ID18 SPEC data':phona
		'Quit': BEGIN
			itmp = Dialog_Message(/Cancel,'End INES session?',Title='Confirmation')
			IF itmp EQ 'Cancel' THEN RETURN
			Free_Lun,logFileUnit
			widget_control,wInes,/destroy
			END
		'Xplot':BEGIN
			Xplot
			END
		'TextEditor':BEGIN
			XDisplayFileNative
			END
		'Help':BEGIN
	                IF sdep() EQ 'WINDOWS' THEN BEGIN
	                  spawn,'start '+xop_getenv('XOP_HOME')+'\extensions\ines\doc\ines.pdf'
	                ENDIF ELSE BEGIN
	                  spawn,'acroread '+xop_getenv('XOP_HOME')+'/extensions/ines/doc/ines.pdf'
                	ENDELSE
			END
	endcase
END


PRO INES_GUI,Group=group
	;COMMON INES_GUI
	COMMON INES_GUI,useGui,wInes,wInesLog,LogFileUnit,wStepIndex, ai
	COMMON INES_GRAPHICAL_WINDOWS,xplot_p, xwindow_p

	;Avoid warning from xplot
	Device,Decomposed=0
	; define array where to store the wID of graphical windows
	xplot_p = 0L
	xwindow_p = 0L
	;
	; log file
	; 
   IF(XRegistered("INES_GUI")) THEN RETURN  ; to avoid multiple windows!!!
	logFileUnit=-1
	openw,logFileUnit,'ines.log',/Get_Lun
	wInes=widget_base(title='INES 1.1 - Inelastic Scattering',/column,/base_align_center);,xsize=200,ysize=150
   wInesButtons=cw_bgroup(wInes,['Quit','Start INES','Convert ID18 SPEC data','Xplot','TextEditor','Help'], /row,/frame,/return_name)
   w1=Widget_Base(wInes,/Row)
     wtmp=Widget_Label(w1,Value='IDL prompt>',/Align_Left)
     wInesIDL=Widget_Text(w1,XSIZE=80,UVALUE='IDLPROMPT',/Editable)
   w1=Widget_Base(wInes,/Row)
     wtmp=Widget_Label(w1,Value='INES analysis step: ',/Align_Left)
     wtmp = Widget_Button(w1,Value='Start INES')
     wtmp = Widget_Button(w1,Value='  <<  ')
     tmp = Widget_Text(w1,Value='..',XSize=2,UValue='STEPINDEX') ;,/Edit)
     wStepIndex = tmp
     wtmp = Widget_Button(w1,Value='  >>  ')
     wtmp = Widget_Button(w1,Value='Repeat Step')
     wtmp = Widget_Button(w1,Value='Abort INES')
     wtmp = Widget_Button(w1,Value='Kill Graphs')
   wInesLog=widget_text(wInes,/scroll,xsize=100,ysize=40);,/all_events,/KBRD_FOCUS_EVENTS
   widget_control,wInes,/realize
	widget_control, wInesLog, /INPUT_FOCUS
	; must use no_block or else the popped windows (ines_gui_wait) will not
	; block the procedure while waiting for the user input...

   Ines_Print,'Started INES_GUI at: '+SysTime()
   cd,current=pwd
   Ines_Print,'Log file is '+pwd+SDep(/ds)+'ines.log'
   xmanager,'INES_GUI',wInes,no_block=0,Group_Leader=group
END
