;;
;; IMD4XOP
;;
;; This is the procedure used to create the imd4xop.sav files.
;;

pro imd4xop,group=group

common imd, $
  imd,imdhome,imd_nkpath,imd_nkpath_ptr, $
  imdsplot,imdsplot_fc,imdsplot_bangpy, $
  imdnplot,imdnplot_fc, $
  imdfplot,imdfplot_fc, $
  imdcplot,imdcplot_fc, $
  imdprint
common imd_str,iv_str,fp_str,cp_str,ambient_str,layer_str,substrate_str
common imd_pars, $
  iv,fp,fp_c,cp,ambient,ambient_nc,ambient_f1f2, $
  layer,layer_nc,layer_f1f2, $
  substrate,substrate_nc,substrate_f1f2, $
  iv0,ambient0,ambient_nc0,ambient_f1f20, $
  layer0,layer_nc0,layer_f1f20, $
  substrate0,substrate_nc0,substrate_f1f20, $
  seed
common imd_vars, $
  theta,lambda,idvar,fitpar,chi_2,nc,z,sigma,sigma_from_psd,interface, $
  f,q,ares,pres, $
  r,rs,rp,prs,prp,psi,delta,t,ts,tp,pts,ptp,a,as,ap, $
  user1,user2,user3
common imd_fpars,pt_spacing,ambient_depth,substrate_depth
common imd_fvars,depth,int,ints,intp
common imd_nsvars,q_range, $
  theta_in,theta_out,phi, $
  psd_xi_perp,sigma_d, $
  psd_sigma_r,psd_xi_par,psd_h, $
  psd_omega,psd_nu,psd_n, $
  didomega_dwba,didomega_baa,didomega_bas,didomega_bap
common imd_m,x_m,y_m,sigy_m
common imd_f1f2,atwt_list,element_list, $
  f1f2_compound,f1f2_density,f1f2_number,f1f2_element, $
  f1f2_lambda,f1f2_n,f1f2_k,f1f2_autoplot
common imd_widget, $
  mainw,ambw,layw,mlw,subw,ivw,open_mw,fitw,cpw,fpw, $
  pmfcw,ppsdw,psavw, $
  pfldw,nkvieww,pnkpathw,printw,f1f2w

;; disable decomposed colors for true-color displays:
device,decomposed=0

;; check IDL version and select IMD save file:
case 1 of
    float(strmid(!version.release,0,3)) eq 5.0: imdfile='imd_50'
    float(strmid(!version.release,0,3)) eq 5.1: imdfile='imd_51'
    float(strmid(!version.release,0,3)) eq 5.2: imdfile='imd_52'
    else: begin
        print,' '
        message,'This version of IMD will only run under IDL V5.0/5.1/V5.2.'
    end
endcase

;; load IMD:
print,' '
print,format="($,'Loading IMD...')"
@imdsiteconfig

case !version.os of
    'Win32': sep='\'
    'Mac': sep=':'
    else: sep='/'
endcase

restore,getenv('XOP_HOME')+sep+'extensions'+sep+'imd'+sep+imdfile
print,'done.'
print,' '

;; print message, and start imd:
imd_version='4.1, December 1998'

print,' '
print,'-------------------------------IMD-------------------------------'
print,' '
print,'                      Version '+imd_version
print,' '
print,'                           David L. Windt'
print,'                        windt@bell-labs.com'
print,'                 www.bell-labs.com/user/windt/idl'
print,' '
print,'                Copyright (c) 1997-1998, David L. Windt'
print,'                         All rights reserved'
print,' '
print,'-----------------------------------------------------------------'
print,' '

imd

end
