/* path.h: path and mount data structures

   Copyright 1996, 1997, 1998 Cygnus Solutions.

This file is part of Cygwin.

This software is a copyrighted work licensed under the terms of the
Cygwin license.  Please consult the file "CYGWIN_LICENSE" for
details. */

struct suffix_info
{
  const char *name;
  int addon;
  suffix_info (const char *s, int addit = 0) {name = s, addon = addit;}
};

enum symlink_follow
{
  SYMLINK_FOLLOW,
  SYMLINK_NOFOLLOW,
  SYMLINK_IGNORE,
  SYMLINK_CONTENTS
};

class path_conv
{
  char path[MAX_PATH];
 public:

  char binary_p;
  char silent_p;
  int  symlink_p;
  int  exec_p;
  int  script_p;

  char *known_suffix;

  int error;
  DWORD devn;
  int unit;

  DWORD fileattr;

  path_conv (const char * const, symlink_follow follow_mode = SYMLINK_FOLLOW,
	     int use_full_path = 0, const suffix_info *suffixes = NULL);
  inline char *get_win32 () { return path; }
  BOOL is_device () {return devn != FH_BAD;}
  DWORD get_devn () {return devn == FH_BAD ? FH_DISK : devn;}
  short get_unitn () {return devn == FH_BAD ? 0 : unit;}
  DWORD file_attributes () {return fileattr;}
};

/* Symlink marker */
#define SYMLINK_COOKIE "!<symlink>"

/* Maximum depth of symlinks (after which ELOOP is issued).  */
#define MAX_LINK_DEPTH 10

/* Mount table entry.  */

class mount_item
{
public:
  /* FIXME: Nasty static allocation.  Need to have a heap in the shared
     area [with the user being able to configure at runtime the max size].  */

  /* DOS-style mounted partition source ("F:").
     device[0] == 0 for unused entries.  */
  char device[MAX_PATH];
  int devicelen;

  /* UNIX-style mount point ("/mnt") */
  char path[MAX_PATH];
  int pathlen;

  char binary;
  char silent;

  void init (const char *dev, const char *path, int flags);

  struct mntent *getmntent ();
};

/* Mount table.  */

/* Warning: Decreasing this value will cause cygwin.dll to ignore existing
   higher numbered registry entries.  Don't change this number willy-nilly.
   What we need is to have a more dynamic allocation scheme, but the current
   scheme should be satisfactory for a long while yet.  */
#define MAX_MOUNTS 30

class mount_info
{
 public:
  int nmounts;
  mount_item mount[MAX_MOUNTS];

  void init ();
  int add_item (const char *dev, const char *path, int flags);
  int del_item (const char *path);
  void sort ();
  void to_registry ();
  void from_registry ();

/* Return non-zero if paths should be interpreted as Posix paths.
   Otherwise return zero (WIN32 Rules).

   This is a hold-over from the time we had two incompatible styles:
   win32 and posix.  Today there's one "unified" style.  This function
   is still used in case we ever want to implement the suggestion above
   of allowing the user[/app] to disable the posix enhancements (specifically
   the mount table and //<letter>).  For now we always return 1.  */
  int posix_path_p () {return 1;}

  int binary_win32_path_p (const char *path);
  int conv_to_win32_path (const char *src_path, char *win32_path,
			  char *full_win32_path, DWORD &devn, int &unit);
  int conv_to_posix_path (const char *src_path, char *posix_path,
			  int keep_rel_p);
  struct mntent *getmntent (int x);
};

extern suffix_info std_suffixes[];

int get_device_number (const char *name, int &unit);
BOOL win32_device_name (const char *src_path, char *win32_path);

/* These are exported from the dll as cygwin_foo.  */
extern "C" {
  void conv_to_win32_path (const char *src_path, char *win32_path);
  void conv_to_full_win32_path (const char *src_path, char *win32_path);
  void conv_to_posix_path (const char *src_path, char *posix_path);
  void conv_to_full_posix_path (const char *src_path, char *posix_path);
  int posix_path_list_p (const char *path);
  int win32_to_posix_path_list_buf_size (const char *path_list);
  int posix_to_win32_path_list_buf_size (const char *path_list);
  void win32_to_posix_path_list (const char *win32, char *posix);
  void posix_to_win32_path_list (const char *posix, char *win32);
  void split_path (const char *path, char *dir, char *file);
}

/* Common macros for checking for invalid path names */
#define check_null_empty_path(src) \
  (!(src) ? EFAULT : *(src) ? 0 : ENOENT)

#define check_null_empty_path_errno(src) \
({ \
  int __err; \
  if ((__err = check_null_empty_path(src))) \
    set_errno (__err); \
  __err; \
})
