/* ioctl.cc: ioctl routines.

   Copyright 1996, 1998 Cygnus Solutions.

   Written by Doug Evans of Cygnus Support
   dje@cygnus.com

This file is part of Cygwin.

This software is a copyrighted work licensed under the terms of the
Cygwin license.  Please consult the file "CYGWIN_LICENSE" for
details. */

#include <sys/termios.h>
#include <sys/ioctl.h>
#include <errno.h>
#include "winsup.h"

extern "C"
int
ioctl (int fd, int cmd, void *buf)
{
  if (dtable.not_open (fd))
    {
      set_errno (EBADF);
      return -1;
    }

  return dtable[fd]->ioctl (cmd, buf);
}
