/* Simulator model support for m32rb.

THIS FILE IS MACHINE GENERATED WITH CGEN.

Copyright (C) 1996, 1997, 1998 Free Software Foundation, Inc.

This file is part of the GNU Simulators.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

*/

#define WANT_CPU
#define WANT_CPU_M32RB

#include "sim-main.h"
#include "cpu-sim.h"
#include "cpu-opc.h"

/* The profiling data is recorded here, but is accessed via the profiling
   mechanism.  After all, this is information for profiling.  */

#if WITH_PROFILE_MODEL_P

/* Track function unit usage for an instruction.  */

void
m32rb_model_profile_insn (SIM_CPU *current_cpu, ARGBUF *abuf)
{
  const IDESC *id = abuf->idesc;
  const CGEN_INSN *insn = id->opcode;
  const UNIT *unit = & id->timing->units[0];
  const UNIT *unit_end = unit + MAX_UNITS;
  PROFILE_DATA *profile = CPU_PROFILE_DATA (current_cpu);
  unsigned long cycles = 0;

  do
    {
      switch (unit->name)
        {
        case UNIT_M32R_D_U_STORE :
          cycles += unit->done;
  m32rb_model_mark_unbusy_reg (current_cpu, abuf);
          break;
        case UNIT_M32R_D_U_LOAD :
          cycles += unit->done;
  m32rb_model_mark_busy_reg (current_cpu, abuf);
          break;
        case UNIT_M32R_D_U_EXEC :
          cycles += unit->done;
  m32rb_model_mark_unbusy_reg (current_cpu, abuf);
          break;
        case UNIT_TEST_U_EXEC :
          cycles += unit->done;
          break;
        }
      ++unit;
    }
  while (unit != unit_end && unit->name != UNIT_NONE);

  m32r_model_record_cycles (current_cpu, cycles);
}

/* Track function unit usage for an instruction.  */

void
m32rb_model_profile_cti_insn (SIM_CPU *current_cpu, ARGBUF *abuf, int taken_p)
{
  const IDESC *id = abuf->idesc;
  const CGEN_INSN *insn = id->opcode;
  const UNIT *unit = & id->timing->units[0];
  const UNIT *unit_end = unit + MAX_UNITS;
  PROFILE_DATA *profile = CPU_PROFILE_DATA (current_cpu);
  unsigned long cycles = 0;

  do
    {
      switch (unit->name)
        {
        case UNIT_M32R_D_U_STORE :
          cycles += unit->done;
  m32rb_model_mark_unbusy_reg (current_cpu, abuf);
          break;
        case UNIT_M32R_D_U_LOAD :
          cycles += unit->done;
  m32rb_model_mark_busy_reg (current_cpu, abuf);
          break;
        case UNIT_M32R_D_U_EXEC :
          cycles += unit->done;
  if (taken_p) m32r_model_record_cti (current_cpu, abuf);
  m32rb_model_mark_unbusy_reg (current_cpu, abuf);
          break;
        case UNIT_TEST_U_EXEC :
          cycles += unit->done;
          break;
        }
      if (taken_p)
        PROFILE_MODEL_TAKEN_COUNT (profile) += 1;
      else
        PROFILE_MODEL_UNTAKEN_COUNT (profile) += 1;
      ++unit;
    }
  while (unit != unit_end && unit->name != UNIT_NONE);

  m32r_model_record_cycles (current_cpu, cycles);
}

/* We assume UNIT_NONE == 0 because the tables don't always terminate
   entries with it.  */

/* Model timing data for `m32r/d'.  */

static const INSN_TIMING m32r_d_timing[] = {
  { 0, { (UQI) UNIT_NONE } }, /* illegal insn */
  { M32RB_XINSN_ADD, { (UQI) UNIT_M32R_D_U_EXEC, 1, 1 } },
  { M32RB_XINSN_ADD3, { (UQI) UNIT_M32R_D_U_EXEC, 1, 1 } },
  { M32RB_XINSN_AND, { (UQI) UNIT_M32R_D_U_EXEC, 1, 1 } },
  { M32RB_XINSN_AND3, { (UQI) UNIT_M32R_D_U_EXEC, 1, 1 } },
  { M32RB_XINSN_OR, { (UQI) UNIT_M32R_D_U_EXEC, 1, 1 } },
  { M32RB_XINSN_OR3, { (UQI) UNIT_M32R_D_U_EXEC, 1, 1 } },
  { M32RB_XINSN_XOR, { (UQI) UNIT_M32R_D_U_EXEC, 1, 1 } },
  { M32RB_XINSN_XOR3, { (UQI) UNIT_M32R_D_U_EXEC, 1, 1 } },
  { M32RB_XINSN_ADDI, { (UQI) UNIT_M32R_D_U_EXEC, 1, 1 } },
  { M32RB_XINSN_ADDV, { (UQI) UNIT_M32R_D_U_EXEC, 1, 1 } },
  { M32RB_XINSN_ADDV3, { (UQI) UNIT_M32R_D_U_EXEC, 1, 1 } },
  { M32RB_XINSN_ADDX, { (UQI) UNIT_M32R_D_U_EXEC, 1, 1 } },
  { M32RB_XINSN_BC8, { (UQI) UNIT_M32R_D_U_EXEC, 1, 1 } },
  { M32RB_XINSN_BC24, { (UQI) UNIT_M32R_D_U_EXEC, 1, 1 } },
  { M32RB_XINSN_BEQ, { (UQI) UNIT_M32R_D_U_EXEC, 1, 1 } },
  { M32RB_XINSN_BEQZ, { (UQI) UNIT_M32R_D_U_EXEC, 1, 1 } },
  { M32RB_XINSN_BGEZ, { (UQI) UNIT_M32R_D_U_EXEC, 1, 1 } },
  { M32RB_XINSN_BGTZ, { (UQI) UNIT_M32R_D_U_EXEC, 1, 1 } },
  { M32RB_XINSN_BLEZ, { (UQI) UNIT_M32R_D_U_EXEC, 1, 1 } },
  { M32RB_XINSN_BLTZ, { (UQI) UNIT_M32R_D_U_EXEC, 1, 1 } },
  { M32RB_XINSN_BNEZ, { (UQI) UNIT_M32R_D_U_EXEC, 1, 1 } },
  { M32RB_XINSN_BL8, { (UQI) UNIT_M32R_D_U_EXEC, 1, 1 } },
  { M32RB_XINSN_BL24, { (UQI) UNIT_M32R_D_U_EXEC, 1, 1 } },
  { M32RB_XINSN_BNC8, { (UQI) UNIT_M32R_D_U_EXEC, 1, 1 } },
  { M32RB_XINSN_BNC24, { (UQI) UNIT_M32R_D_U_EXEC, 1, 1 } },
  { M32RB_XINSN_BNE, { (UQI) UNIT_M32R_D_U_EXEC, 1, 1 } },
  { M32RB_XINSN_BRA8, { (UQI) UNIT_M32R_D_U_EXEC, 1, 1 } },
  { M32RB_XINSN_BRA24, { (UQI) UNIT_M32R_D_U_EXEC, 1, 1 } },
  { M32RB_XINSN_CMP, { (UQI) UNIT_M32R_D_U_EXEC, 1, 1 } },
  { M32RB_XINSN_CMPI, { (UQI) UNIT_M32R_D_U_EXEC, 1, 1 } },
  { M32RB_XINSN_CMPU, { (UQI) UNIT_M32R_D_U_EXEC, 1, 1 } },
  { M32RB_XINSN_CMPUI, { (UQI) UNIT_M32R_D_U_EXEC, 1, 1 } },
  { M32RB_XINSN_DIV, { (UQI) UNIT_M32R_D_U_EXEC, 37, 37 } },
  { M32RB_XINSN_DIVU, { (UQI) UNIT_M32R_D_U_EXEC, 37, 37 } },
  { M32RB_XINSN_REM, { (UQI) UNIT_M32R_D_U_EXEC, 37, 37 } },
  { M32RB_XINSN_REMU, { (UQI) UNIT_M32R_D_U_EXEC, 37, 37 } },
  { M32RB_XINSN_JL, { (UQI) UNIT_M32R_D_U_EXEC, 1, 1 } },
  { M32RB_XINSN_JMP, { (UQI) UNIT_M32R_D_U_EXEC, 1, 1 } },
  { M32RB_XINSN_LD, { (UQI) UNIT_M32R_D_U_LOAD, 1, 1 } },
  { M32RB_XINSN_LD_D, { (UQI) UNIT_M32R_D_U_LOAD, 2, 2 } },
  { M32RB_XINSN_LDB, { (UQI) UNIT_M32R_D_U_LOAD, 1, 1 } },
  { M32RB_XINSN_LDB_D, { (UQI) UNIT_M32R_D_U_LOAD, 2, 2 } },
  { M32RB_XINSN_LDH, { (UQI) UNIT_M32R_D_U_LOAD, 1, 1 } },
  { M32RB_XINSN_LDH_D, { (UQI) UNIT_M32R_D_U_LOAD, 2, 2 } },
  { M32RB_XINSN_LDUB, { (UQI) UNIT_M32R_D_U_LOAD, 1, 1 } },
  { M32RB_XINSN_LDUB_D, { (UQI) UNIT_M32R_D_U_LOAD, 2, 2 } },
  { M32RB_XINSN_LDUH, { (UQI) UNIT_M32R_D_U_LOAD, 1, 1 } },
  { M32RB_XINSN_LDUH_D, { (UQI) UNIT_M32R_D_U_LOAD, 2, 2 } },
  { M32RB_XINSN_LD_PLUS, { (UQI) UNIT_M32R_D_U_LOAD, 1, 1 } },
  { M32RB_XINSN_LD24, { (UQI) UNIT_M32R_D_U_EXEC, 1, 1 } },
  { M32RB_XINSN_LDI8, { (UQI) UNIT_M32R_D_U_EXEC, 1, 1 } },
  { M32RB_XINSN_LDI16, { (UQI) UNIT_M32R_D_U_EXEC, 1, 1 } },
  { M32RB_XINSN_LOCK, { (UQI) UNIT_M32R_D_U_EXEC, 1, 1 } },
  { M32RB_XINSN_MACHI, { (UQI) UNIT_M32R_D_U_EXEC, 1, 1 } },
  { M32RB_XINSN_MACLO, { (UQI) UNIT_M32R_D_U_EXEC, 1, 1 } },
  { M32RB_XINSN_MACWHI, { (UQI) UNIT_M32R_D_U_EXEC, 1, 1 } },
  { M32RB_XINSN_MACWLO, { (UQI) UNIT_M32R_D_U_EXEC, 1, 1 } },
  { M32RB_XINSN_MUL, { (UQI) UNIT_M32R_D_U_EXEC, 4, 4 } },
  { M32RB_XINSN_MULHI, { (UQI) UNIT_M32R_D_U_EXEC, 1, 1 } },
  { M32RB_XINSN_MULLO, { (UQI) UNIT_M32R_D_U_EXEC, 1, 1 } },
  { M32RB_XINSN_MULWHI, { (UQI) UNIT_M32R_D_U_EXEC, 1, 1 } },
  { M32RB_XINSN_MULWLO, { (UQI) UNIT_M32R_D_U_EXEC, 1, 1 } },
  { M32RB_XINSN_MV, { (UQI) UNIT_M32R_D_U_EXEC, 1, 1 } },
  { M32RB_XINSN_MVFACHI, { (UQI) UNIT_M32R_D_U_EXEC, 2, 2 } },
  { M32RB_XINSN_MVFACLO, { (UQI) UNIT_M32R_D_U_EXEC, 2, 2 } },
  { M32RB_XINSN_MVFACMI, { (UQI) UNIT_M32R_D_U_EXEC, 2, 2 } },
  { M32RB_XINSN_MVFC, { (UQI) UNIT_M32R_D_U_EXEC, 1, 1 } },
  { M32RB_XINSN_MVTACHI, { (UQI) UNIT_M32R_D_U_EXEC, 1, 1 } },
  { M32RB_XINSN_MVTACLO, { (UQI) UNIT_M32R_D_U_EXEC, 1, 1 } },
  { M32RB_XINSN_MVTC, { (UQI) UNIT_M32R_D_U_EXEC, 1, 1 } },
  { M32RB_XINSN_NEG, { (UQI) UNIT_M32R_D_U_EXEC, 1, 1 } },
  { M32RB_XINSN_NOP, { (UQI) UNIT_M32R_D_U_EXEC, 0, 0 } },
  { M32RB_XINSN_NOT, { (UQI) UNIT_M32R_D_U_EXEC, 1, 1 } },
  { M32RB_XINSN_RAC, { (UQI) UNIT_M32R_D_U_EXEC, 1, 1 } },
  { M32RB_XINSN_RACH, { (UQI) UNIT_M32R_D_U_EXEC, 1, 1 } },
  { M32RB_XINSN_RTE, { (UQI) UNIT_M32R_D_U_EXEC, 1, 1 } },
  { M32RB_XINSN_SETH, { (UQI) UNIT_M32R_D_U_EXEC, 1, 1 } },
  { M32RB_XINSN_SLL, { (UQI) UNIT_M32R_D_U_EXEC, 1, 1 } },
  { M32RB_XINSN_SLL3, { (UQI) UNIT_M32R_D_U_EXEC, 1, 1 } },
  { M32RB_XINSN_SLLI, { (UQI) UNIT_M32R_D_U_EXEC, 1, 1 } },
  { M32RB_XINSN_SRA, { (UQI) UNIT_M32R_D_U_EXEC, 1, 1 } },
  { M32RB_XINSN_SRA3, { (UQI) UNIT_M32R_D_U_EXEC, 1, 1 } },
  { M32RB_XINSN_SRAI, { (UQI) UNIT_M32R_D_U_EXEC, 1, 1 } },
  { M32RB_XINSN_SRL, { (UQI) UNIT_M32R_D_U_EXEC, 1, 1 } },
  { M32RB_XINSN_SRL3, { (UQI) UNIT_M32R_D_U_EXEC, 1, 1 } },
  { M32RB_XINSN_SRLI, { (UQI) UNIT_M32R_D_U_EXEC, 1, 1 } },
  { M32RB_XINSN_ST, { (UQI) UNIT_M32R_D_U_STORE, 1, 1 } },
  { M32RB_XINSN_ST_D, { (UQI) UNIT_M32R_D_U_STORE, 2, 2 } },
  { M32RB_XINSN_STB, { (UQI) UNIT_M32R_D_U_STORE, 1, 1 } },
  { M32RB_XINSN_STB_D, { (UQI) UNIT_M32R_D_U_STORE, 2, 2 } },
  { M32RB_XINSN_STH, { (UQI) UNIT_M32R_D_U_STORE, 1, 1 } },
  { M32RB_XINSN_STH_D, { (UQI) UNIT_M32R_D_U_STORE, 2, 2 } },
  { M32RB_XINSN_ST_PLUS, { (UQI) UNIT_M32R_D_U_STORE, 1, 1 } },
  { M32RB_XINSN_ST_MINUS, { (UQI) UNIT_M32R_D_U_STORE, 1, 1 } },
  { M32RB_XINSN_SUB, { (UQI) UNIT_M32R_D_U_EXEC, 1, 1 } },
  { M32RB_XINSN_SUBV, { (UQI) UNIT_M32R_D_U_EXEC, 1, 1 } },
  { M32RB_XINSN_SUBX, { (UQI) UNIT_M32R_D_U_EXEC, 1, 1 } },
  { M32RB_XINSN_TRAP, { (UQI) UNIT_M32R_D_U_EXEC, 1, 1 } },
  { M32RB_XINSN_UNLOCK, { (UQI) UNIT_M32R_D_U_EXEC, 1, 1 } },
};

/* Model timing data for `test'.  */

static const INSN_TIMING test_timing[] = {
  { 0, { (UQI) UNIT_NONE } }, /* illegal insn */
  { M32RB_XINSN_ADD, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_ADD3, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_AND, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_AND3, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_OR, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_OR3, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_XOR, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_XOR3, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_ADDI, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_ADDV, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_ADDV3, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_ADDX, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_BC8, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_BC24, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_BEQ, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_BEQZ, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_BGEZ, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_BGTZ, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_BLEZ, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_BLTZ, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_BNEZ, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_BL8, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_BL24, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_BNC8, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_BNC24, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_BNE, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_BRA8, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_BRA24, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_CMP, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_CMPI, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_CMPU, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_CMPUI, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_DIV, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_DIVU, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_REM, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_REMU, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_JL, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_JMP, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_LD, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_LD_D, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_LDB, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_LDB_D, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_LDH, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_LDH_D, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_LDUB, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_LDUB_D, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_LDUH, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_LDUH_D, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_LD_PLUS, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_LD24, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_LDI8, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_LDI16, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_LOCK, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_MACHI, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_MACLO, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_MACWHI, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_MACWLO, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_MUL, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_MULHI, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_MULLO, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_MULWHI, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_MULWLO, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_MV, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_MVFACHI, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_MVFACLO, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_MVFACMI, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_MVFC, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_MVTACHI, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_MVTACLO, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_MVTC, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_NEG, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_NOP, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_NOT, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_RAC, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_RACH, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_RTE, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_SETH, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_SLL, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_SLL3, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_SLLI, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_SRA, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_SRA3, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_SRAI, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_SRL, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_SRL3, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_SRLI, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_ST, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_ST_D, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_STB, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_STB_D, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_STH, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_STH_D, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_ST_PLUS, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_ST_MINUS, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_SUB, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_SUBV, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_SUBX, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_TRAP, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
  { M32RB_XINSN_UNLOCK, { (UQI) UNIT_TEST_U_EXEC, 1, 1 } },
};

#endif /* WITH_PROFILE_MODEL_P */

#if WITH_PROFILE_MODEL_P
#define TIMING_DATA(td) td
#else
#define TIMING_DATA(td) 0
#endif

static const MODEL m32r_models[] =
{
  { "m32r/d", & m32r_mach, TIMING_DATA (& m32r_d_timing[0]) },
  { "test", & m32r_mach, TIMING_DATA (& test_timing[0]) },
  { 0 }
};

/* The properties of this cpu's implementation.  */

static const MACH_IMP_PROPERTIES m32rb_imp_properties =
{
  sizeof (SIM_CPU),
#if WITH_SCACHE
  sizeof (SCACHE)
#else
  0
#endif
};

static const CGEN_INSN *
m32rb_opcode (SIM_CPU *cpu, int inum)
{
  return CPU_IDESC (cpu) [inum].opcode;
}

static void
m32r_init_cpu (SIM_CPU *cpu)
{
  CPU_REG_FETCH (cpu) = m32rb_fetch_register;
  CPU_REG_STORE (cpu) = m32rb_store_register;
  CPU_PC_FETCH (cpu) = m32rb_h_pc_get;
  CPU_PC_STORE (cpu) = m32rb_h_pc_set;
  CPU_OPCODE (cpu) = m32rb_opcode;
  m32rb_init_idesc_table (cpu);
}

const MACH m32r_mach =
{
  "m32r", 32, 32, & m32r_models[0], & m32rb_imp_properties,
  m32r_init_cpu
};

