/* m32r simulator support code
   Copyright (C) 1996, 1997, 1998 Free Software Foundation, Inc.
   Contributed by Cygnus Support.

This file is part of GDB, the GNU debugger.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#define WANT_CPU
#define WANT_CPU_M32RB

#include "sim-main.h"
#include "cgen-mem.h"
#include "cgen-ops.h"

/* The contents of BUF are in target byte order.  */

int
m32rb_fetch_register (SIM_CPU *current_cpu, int rn, unsigned char *buf, int len)
{
  if (rn < 16)
    SETTWI (buf, GET_H_GR (rn));
  else if (rn < 21)
    {
      /* FIXME: use cover fn */
      /* ??? new regs figuratively collide with numbers chosen for
	 pc, accum.  Will need a discontiguous numbering scheme or some
	 careful coordination.  */
      SETTWI (buf, GET_H_CR (rn - 16));
    }
  else switch (rn) {
    case PC_REGNUM:
      SETTWI (buf, GET_H_PC ());
      break;
    case ACCL_REGNUM:
      SETTWI (buf, GETLODI (GET_H_ACCUM ()));
      break;
    case ACCH_REGNUM:
      SETTWI (buf, GETHIDI (GET_H_ACCUM ()));
      break;
#if 0
    case 23: *reg = STATE_CPU_CPU (sd, 0)->h_cond;		break;
    case 24: *reg = STATE_CPU_CPU (sd, 0)->h_sm;		break;
    case 25: *reg = STATE_CPU_CPU (sd, 0)->h_bsm;		break;
    case 26: *reg = STATE_CPU_CPU (sd, 0)->h_ie;		break;
    case 27: *reg = STATE_CPU_CPU (sd, 0)->h_bie;		break;
    case 28: *reg = STATE_CPU_CPU (sd, 0)->h_bcarry;		break; /* rename: bc */
    case 29: memcpy (buf, &STATE_CPU_CPU (sd, 0)->h_bpc, sizeof(WI));	break; /* duplicate */
#endif
    default: abort ();
  }

  return -1; /*FIXME*/
}
 
/* The contents of BUF are in target byte order.  */

int
m32rb_store_register (SIM_CPU *current_cpu, int rn, unsigned char *buf, int len)
{
  if (rn < 16)
    SET_H_GR (rn, GETTWI (buf));
  else if (rn < 21)
    {
      /* FIXME: use cover fn */
      /* ??? new regs figuratively collide with numbers chosen for
	 pc, accum.  Will need a discontiguous numbering scheme or some
	 careful coordination.  */
      SET_H_CR (rn - 16, GETTWI (buf));
    }
  else switch (rn) {
    case PC_REGNUM:
      SET_H_PC (GETTWI (buf));
      break;
    case ACCL_REGNUM:
      SETLODI (CPU (h_accum), GETTWI (buf));
      break;
    case ACCH_REGNUM:
      SETHIDI (CPU (h_accum), GETTWI (buf));
      break;
#if 0
    case 23: STATE_CPU_CPU (sd, 0)->h_cond   = *reg;			break;
    case 24: STATE_CPU_CPU (sd, 0)->h_sm     = *reg;			break;
    case 25: STATE_CPU_CPU (sd, 0)->h_bsm    = *reg;			break;
    case 26: STATE_CPU_CPU (sd, 0)->h_ie     = *reg;			break;
    case 27: STATE_CPU_CPU (sd, 0)->h_bie    = *reg;			break;
    case 28: STATE_CPU_CPU (sd, 0)->h_bcarry = *reg;			break; /* rename: bc */
    case 29: memcpy (&STATE_CPU_CPU (sd, 0)->h_bpc, buf, sizeof(DI));	break; /* duplicate */
#endif
  }

  return -1; /*FIXME*/
}

USI
m32rb_h_cr_get (SIM_CPU *current_cpu, UINT cr)
{
  switch (cr)
    {
    case H_CR_PSW : /* psw */
      return ((CPU (h_bsm) << 15)
	      | (CPU (h_bie) << 14)
	      | (CPU (h_bcond) << 8)
	      | (CPU (h_sm) << 7)
	      | (CPU (h_ie) << 6)
	      | (CPU (h_cond) << 0));
    case H_CR_CBR : /* condition bit */
      return CPU (h_cond);
    case H_CR_SPI : /* interrupt stack pointer */
      if (! CPU (h_sm))
	return CPU (h_gr[H_GR_SP]);
      else
	return CPU (h_cr[H_CR_SPI]);
    case H_CR_SPU : /* user stack pointer */
      if (CPU (h_sm))
	return CPU (h_gr[H_GR_SP]);
      else
	return CPU (h_cr[H_CR_SPU]);
    case H_CR_BPC : /* backup pc */
      return CPU (h_bpc);
    case 4 : /* unused */
    case 5 : /* unused */
      return CPU (h_cr[cr]);
    default :
      return 0;
    }
}

void
m32rb_h_cr_set (SIM_CPU *current_cpu, UINT cr, USI newval)
{
  switch (cr)
    {
    case H_CR_PSW : /* psw */
      {
	int old_sm = CPU (h_sm);
	CPU (h_bsm) = (newval & (1 << 15)) != 0;
	CPU (h_bie) = (newval & (1 << 14)) != 0;
	CPU (h_bcond) = (newval & (1 << 8)) != 0;
	CPU (h_sm) = (newval & (1 << 7)) != 0;
	CPU (h_ie) = (newval & (1 << 6)) != 0;
	CPU (h_cond) = (newval & (1 << 0)) != 0;
	/* When switching stack modes, update the registers.  */
	if (old_sm != CPU (h_sm))
	  {
	    if (old_sm)
	      {
		/* Switching user -> system.  */
		CPU (h_cr[H_CR_SPU]) = CPU (h_gr[H_GR_SP]);
		CPU (h_gr[H_GR_SP]) = CPU (h_cr[H_CR_SPI]);
	      }
	    else
	      {
		/* Switching system -> user.  */
		CPU (h_cr[H_CR_SPI]) = CPU (h_gr[H_GR_SP]);
		CPU (h_gr[H_GR_SP]) = CPU (h_cr[H_CR_SPU]);
	      }
	  }
	break;
      }
    case H_CR_CBR : /* condition bit */
      CPU (h_cond) = (newval & 1) != 0;
      break;
    case H_CR_SPI : /* interrupt stack pointer */
      if (! CPU (h_sm))
	CPU (h_gr[H_GR_SP]) = newval;
      else
	CPU (h_cr[H_CR_SPI]) = newval;
      break;
    case H_CR_SPU : /* user stack pointer */
      if (CPU (h_sm))
	CPU (h_gr[H_GR_SP]) = newval;
      else
	CPU (h_cr[H_CR_SPU]) = newval;
      break;
    case H_CR_BPC : /* backup pc */
      CPU (h_bpc) = newval;
      /* drop through */
    case 4 : /* unused */
    case 5 : /* unused */
      CPU (h_cr[cr]) = newval;
      break;
    default :
      /* ignore */
      break;
    }
}

/* Cover fns to access h-accum.  */

DI
m32rb_h_accum_get (SIM_CPU *current_cpu)
{
  /* Sign extend the top 8 bits.  */
  DI r;
#if 1
  r = ANDDI (GET_H_ACCUM (), MAKEDI (0xffffff, 0xffffffff));
  r = XORDI (r, MAKEDI (0x800000, 0));
  r = SUBDI (r, MAKEDI (0x800000, 0));
#else
  SI hi,lo;
  r = GET_H_ACCUM ();
  hi = GETHIDI (r);
  lo = GETLODI (r);
  hi = ((hi & 0xffffff) ^ 0x800000) - 0x800000;
  r = MAKEDI (hi, lo);
#endif
  return r;
}

void
m32rb_h_accum_set (SIM_CPU *current_cpu, DI newval)
{
  SET_H_ACCUM (newval);
}

#if WITH_PROFILE_MODEL_P

/* FIXME: Some of these should be inline or macros.  Later.  */
/* FIXME: Fns m32r_foo should be in a cpu-family independent file.  */

/* Initialize cycle counting for an insn.
   FIRST_P is non-zero if this is the first insn in a set of parallel
   insns.  */

void
m32r_model_init_insn_cycles (SIM_CPU *cpu, int first_p)
{
  M32R_MISC_PROFILE *mp = & CPU_M32R_MISC_PROFILE (cpu);
  mp->insn_cycles = 0;
  mp->cti_stall = 0;
  mp->load_stall = 0;
  if (first_p)
    mp->biggest_cycles = 0;
}

/* Record the cycles computed for an insn.
   LAST_P is non-zero if this is the last insn in a set of parallel insns,
   and we update the total cycle count.  */

void
m32r_model_update_insn_cycles (SIM_CPU *cpu, int last_p)
{
  PROFILE_DATA *p = CPU_PROFILE_DATA (cpu);
  M32R_MISC_PROFILE *mp = & CPU_M32R_MISC_PROFILE (cpu);
  unsigned long total = mp->insn_cycles + mp->cti_stall + mp->load_stall;

  if (last_p)
    {
      unsigned long biggest = total > mp->biggest_cycles ? total : mp->biggest_cycles;
      PROFILE_MODEL_TOTAL_CYCLES (p) += biggest;
      PROFILE_MODEL_CUR_INSN_CYCLES (p) = total;
    }
  else
    {
      /* Here we take advantage of the fact that !last_p -> first_p.  */
      mp->biggest_cycles = total;
      PROFILE_MODEL_CUR_INSN_CYCLES (p) = total;
    }

  /* Branch and load stall counts are recorded independently of the
     total cycle count.  */
  PROFILE_MODEL_CTI_STALL_CYCLES (p) += mp->cti_stall;
  PROFILE_MODEL_LOAD_STALL_CYCLES (p) += mp->load_stall;
}

void
m32r_model_record_cti (SIM_CPU *cpu, ARGBUF *abuf)
{
  M32R_MISC_PROFILE *mp = & CPU_M32R_MISC_PROFILE (cpu);

  mp->cti_stall += 2;
}

void
m32r_model_record_cycles (SIM_CPU *cpu, unsigned long cycles)
{
  M32R_MISC_PROFILE *mp = & CPU_M32R_MISC_PROFILE (cpu);

  mp->insn_cycles = cycles;
}

void
m32rb_model_mark_get_h_gr (SIM_CPU *cpu, ARGBUF *abuf)
{
  if ((CPU_CGEN_PROFILE (cpu)->h_gr & abuf->h_gr_get) != 0)
    {
      CPU_M32R_MISC_PROFILE (cpu).load_stall += 2;
      if (TRACE_INSN_P (cpu))
	cgen_trace_printf (cpu, " ; Load stall of 2 cycles.");
    }
}

void
m32rb_model_mark_set_h_gr (SIM_CPU *cpu, ARGBUF *abuf)
{
}

void
m32rb_model_mark_busy_reg (SIM_CPU *cpu, ARGBUF *abuf)
{
  CPU_CGEN_PROFILE (cpu)->h_gr = abuf->h_gr_set;
}

void
m32rb_model_mark_unbusy_reg (SIM_CPU *cpu, ARGBUF *abuf)
{
  CPU_CGEN_PROFILE (cpu)->h_gr = 0;
}

#endif /* WITH_PROFILE_MODEL_P */
