/* Simulator instruction decoder for m32rb.

THIS FILE IS MACHINE GENERATED WITH CGEN.

Copyright (C) 1996, 1997, 1998 Free Software Foundation, Inc.

This file is part of the GNU Simulators.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

*/

#define WANT_CPU
#define WANT_CPU_M32RB

#include "sim-main.h"
#include "cpu-sim.h"
#include "cpu-opc.h"

/* FIXME: wip, may eventually only want one form so this would then go
   away.  However, in the mean time, having both keeps a stable version
   around while the cache version is being developed.
   It may still be useful to allow two versions to exist though.  */
#if WITH_SCACHE
#define EX(fn) CONCAT3 (m32rb,_ex_,fn)
#else
#define EX(fn) 0
#endif

#ifdef HAVE_PARALLEL_EXEC
#ifdef __GNUC__
#define READ(n) 0
#else
#define READ(n) CONCAT2 (READ_,n)
#endif
#endif

/* FIXME: Need to review choices for the following.  */

#if WITH_SEM_SWITCH_FULL
#define FULL(fn) 0
#else
#define FULL(fn) CONCAT3 (m32rb,_sem_,fn)
#endif

#if WITH_FAST
#if WITH_SEM_SWITCH_FAST
#define FAST(fn) 0
#else
#define FAST(fn) CONCAT3 (m32rb,_semf_,fn) /* f for fast */
#endif
#else
#define FAST(fn) 0
#endif

/* The instruction descriptor array.
   This is computed at runtime.  Space for it is not malloc'd to save a
   teensy bit of cpu in the decoder.  Moving it to malloc space is trivial
   but won't be done until necessary (we don't currently support the runtime
   addition of instructions nor an SMP machine with different cpus).  */
static IDESC m32rb_insn_data[MAX_INSNS];

/* Instruction semantic handlers and support.
   This struct defines the part of an IDESC that can be computed at
   compile time.  */

struct insn_sem {
  /* Index in IDESC table.  */
  int index;

  /* The instruction type (a number that identifies each insn over the
     entire architecture).  */
  CGEN_INSN_TYPE type;

  /* The routine to extract the operands of an insn.  */
  EXTRACT_FN *extract;

  /* The read handler is only used by chips that support parallel
     execution of several insns.  It is always implemented as a `switch'.
     In the case of GNUC we use computed gotos.  When not GNUC, this is the
     argument to `switch'.  */
#ifdef HAVE_PARALLEL_EXEC
  int read;
#endif

  /* Routines to execute the insn.
     The full version has all features (profiling,tracing) compiled in.
     The fast version has none of that.
     If a switch is being used, these are NULL.  */
  SEMANTIC_FN *sem_full;
  SEMANTIC_FN *sem_fast;
};
#define IDX(insn) CONCAT2 (M32RB_X,insn)
#define TYPE(insn) CONCAT2 (M32R_,insn)

const struct insn_sem m32rb_insn_sem[] =
{
  { IDX (INSN_ADD), TYPE (INSN_ADD), EX (fmt_add), FULL (add), FAST (add) },
  { IDX (INSN_ADD3), TYPE (INSN_ADD3), EX (fmt_add3), FULL (add3), FAST (add3) },
  { IDX (INSN_AND), TYPE (INSN_AND), EX (fmt_add), FULL (and), FAST (and) },
  { IDX (INSN_AND3), TYPE (INSN_AND3), EX (fmt_and3), FULL (and3), FAST (and3) },
  { IDX (INSN_OR), TYPE (INSN_OR), EX (fmt_add), FULL (or), FAST (or) },
  { IDX (INSN_OR3), TYPE (INSN_OR3), EX (fmt_or3), FULL (or3), FAST (or3) },
  { IDX (INSN_XOR), TYPE (INSN_XOR), EX (fmt_add), FULL (xor), FAST (xor) },
  { IDX (INSN_XOR3), TYPE (INSN_XOR3), EX (fmt_and3), FULL (xor3), FAST (xor3) },
  { IDX (INSN_ADDI), TYPE (INSN_ADDI), EX (fmt_addi), FULL (addi), FAST (addi) },
  { IDX (INSN_ADDV), TYPE (INSN_ADDV), EX (fmt_addv), FULL (addv), FAST (addv) },
  { IDX (INSN_ADDV3), TYPE (INSN_ADDV3), EX (fmt_addv3), FULL (addv3), FAST (addv3) },
  { IDX (INSN_ADDX), TYPE (INSN_ADDX), EX (fmt_addx), FULL (addx), FAST (addx) },
  { IDX (INSN_BC8), TYPE (INSN_BC8), EX (fmt_bc8), FULL (bc8), FAST (bc8) },
  { IDX (INSN_BC24), TYPE (INSN_BC24), EX (fmt_bc24), FULL (bc24), FAST (bc24) },
  { IDX (INSN_BEQ), TYPE (INSN_BEQ), EX (fmt_beq), FULL (beq), FAST (beq) },
  { IDX (INSN_BEQZ), TYPE (INSN_BEQZ), EX (fmt_beqz), FULL (beqz), FAST (beqz) },
  { IDX (INSN_BGEZ), TYPE (INSN_BGEZ), EX (fmt_beqz), FULL (bgez), FAST (bgez) },
  { IDX (INSN_BGTZ), TYPE (INSN_BGTZ), EX (fmt_beqz), FULL (bgtz), FAST (bgtz) },
  { IDX (INSN_BLEZ), TYPE (INSN_BLEZ), EX (fmt_beqz), FULL (blez), FAST (blez) },
  { IDX (INSN_BLTZ), TYPE (INSN_BLTZ), EX (fmt_beqz), FULL (bltz), FAST (bltz) },
  { IDX (INSN_BNEZ), TYPE (INSN_BNEZ), EX (fmt_beqz), FULL (bnez), FAST (bnez) },
  { IDX (INSN_BL8), TYPE (INSN_BL8), EX (fmt_bl8), FULL (bl8), FAST (bl8) },
  { IDX (INSN_BL24), TYPE (INSN_BL24), EX (fmt_bl24), FULL (bl24), FAST (bl24) },
  { IDX (INSN_BNC8), TYPE (INSN_BNC8), EX (fmt_bc8), FULL (bnc8), FAST (bnc8) },
  { IDX (INSN_BNC24), TYPE (INSN_BNC24), EX (fmt_bc24), FULL (bnc24), FAST (bnc24) },
  { IDX (INSN_BNE), TYPE (INSN_BNE), EX (fmt_beq), FULL (bne), FAST (bne) },
  { IDX (INSN_BRA8), TYPE (INSN_BRA8), EX (fmt_bra8), FULL (bra8), FAST (bra8) },
  { IDX (INSN_BRA24), TYPE (INSN_BRA24), EX (fmt_bra24), FULL (bra24), FAST (bra24) },
  { IDX (INSN_CMP), TYPE (INSN_CMP), EX (fmt_cmp), FULL (cmp), FAST (cmp) },
  { IDX (INSN_CMPI), TYPE (INSN_CMPI), EX (fmt_cmpi), FULL (cmpi), FAST (cmpi) },
  { IDX (INSN_CMPU), TYPE (INSN_CMPU), EX (fmt_cmp), FULL (cmpu), FAST (cmpu) },
  { IDX (INSN_CMPUI), TYPE (INSN_CMPUI), EX (fmt_cmpi), FULL (cmpui), FAST (cmpui) },
  { IDX (INSN_DIV), TYPE (INSN_DIV), EX (fmt_div), FULL (div), FAST (div) },
  { IDX (INSN_DIVU), TYPE (INSN_DIVU), EX (fmt_div), FULL (divu), FAST (divu) },
  { IDX (INSN_REM), TYPE (INSN_REM), EX (fmt_div), FULL (rem), FAST (rem) },
  { IDX (INSN_REMU), TYPE (INSN_REMU), EX (fmt_div), FULL (remu), FAST (remu) },
  { IDX (INSN_JL), TYPE (INSN_JL), EX (fmt_jl), FULL (jl), FAST (jl) },
  { IDX (INSN_JMP), TYPE (INSN_JMP), EX (fmt_jmp), FULL (jmp), FAST (jmp) },
  { IDX (INSN_LD), TYPE (INSN_LD), EX (fmt_ld), FULL (ld), FAST (ld) },
  { IDX (INSN_LD_D), TYPE (INSN_LD_D), EX (fmt_ld_d), FULL (ld_d), FAST (ld_d) },
  { IDX (INSN_LDB), TYPE (INSN_LDB), EX (fmt_ldb), FULL (ldb), FAST (ldb) },
  { IDX (INSN_LDB_D), TYPE (INSN_LDB_D), EX (fmt_ldb_d), FULL (ldb_d), FAST (ldb_d) },
  { IDX (INSN_LDH), TYPE (INSN_LDH), EX (fmt_ldh), FULL (ldh), FAST (ldh) },
  { IDX (INSN_LDH_D), TYPE (INSN_LDH_D), EX (fmt_ldh_d), FULL (ldh_d), FAST (ldh_d) },
  { IDX (INSN_LDUB), TYPE (INSN_LDUB), EX (fmt_ldb), FULL (ldub), FAST (ldub) },
  { IDX (INSN_LDUB_D), TYPE (INSN_LDUB_D), EX (fmt_ldb_d), FULL (ldub_d), FAST (ldub_d) },
  { IDX (INSN_LDUH), TYPE (INSN_LDUH), EX (fmt_ldh), FULL (lduh), FAST (lduh) },
  { IDX (INSN_LDUH_D), TYPE (INSN_LDUH_D), EX (fmt_ldh_d), FULL (lduh_d), FAST (lduh_d) },
  { IDX (INSN_LD_PLUS), TYPE (INSN_LD_PLUS), EX (fmt_ld_plus), FULL (ld_plus), FAST (ld_plus) },
  { IDX (INSN_LD24), TYPE (INSN_LD24), EX (fmt_ld24), FULL (ld24), FAST (ld24) },
  { IDX (INSN_LDI8), TYPE (INSN_LDI8), EX (fmt_ldi8), FULL (ldi8), FAST (ldi8) },
  { IDX (INSN_LDI16), TYPE (INSN_LDI16), EX (fmt_ldi16), FULL (ldi16), FAST (ldi16) },
  { IDX (INSN_LOCK), TYPE (INSN_LOCK), EX (fmt_lock), FULL (lock), FAST (lock) },
  { IDX (INSN_MACHI), TYPE (INSN_MACHI), EX (fmt_machi), FULL (machi), FAST (machi) },
  { IDX (INSN_MACLO), TYPE (INSN_MACLO), EX (fmt_machi), FULL (maclo), FAST (maclo) },
  { IDX (INSN_MACWHI), TYPE (INSN_MACWHI), EX (fmt_machi), FULL (macwhi), FAST (macwhi) },
  { IDX (INSN_MACWLO), TYPE (INSN_MACWLO), EX (fmt_machi), FULL (macwlo), FAST (macwlo) },
  { IDX (INSN_MUL), TYPE (INSN_MUL), EX (fmt_add), FULL (mul), FAST (mul) },
  { IDX (INSN_MULHI), TYPE (INSN_MULHI), EX (fmt_mulhi), FULL (mulhi), FAST (mulhi) },
  { IDX (INSN_MULLO), TYPE (INSN_MULLO), EX (fmt_mulhi), FULL (mullo), FAST (mullo) },
  { IDX (INSN_MULWHI), TYPE (INSN_MULWHI), EX (fmt_mulhi), FULL (mulwhi), FAST (mulwhi) },
  { IDX (INSN_MULWLO), TYPE (INSN_MULWLO), EX (fmt_mulhi), FULL (mulwlo), FAST (mulwlo) },
  { IDX (INSN_MV), TYPE (INSN_MV), EX (fmt_mv), FULL (mv), FAST (mv) },
  { IDX (INSN_MVFACHI), TYPE (INSN_MVFACHI), EX (fmt_mvfachi), FULL (mvfachi), FAST (mvfachi) },
  { IDX (INSN_MVFACLO), TYPE (INSN_MVFACLO), EX (fmt_mvfachi), FULL (mvfaclo), FAST (mvfaclo) },
  { IDX (INSN_MVFACMI), TYPE (INSN_MVFACMI), EX (fmt_mvfachi), FULL (mvfacmi), FAST (mvfacmi) },
  { IDX (INSN_MVFC), TYPE (INSN_MVFC), EX (fmt_mvfc), FULL (mvfc), FAST (mvfc) },
  { IDX (INSN_MVTACHI), TYPE (INSN_MVTACHI), EX (fmt_mvtachi), FULL (mvtachi), FAST (mvtachi) },
  { IDX (INSN_MVTACLO), TYPE (INSN_MVTACLO), EX (fmt_mvtachi), FULL (mvtaclo), FAST (mvtaclo) },
  { IDX (INSN_MVTC), TYPE (INSN_MVTC), EX (fmt_mvtc), FULL (mvtc), FAST (mvtc) },
  { IDX (INSN_NEG), TYPE (INSN_NEG), EX (fmt_mv), FULL (neg), FAST (neg) },
  { IDX (INSN_NOP), TYPE (INSN_NOP), EX (fmt_nop), FULL (nop), FAST (nop) },
  { IDX (INSN_NOT), TYPE (INSN_NOT), EX (fmt_mv), FULL (not), FAST (not) },
  { IDX (INSN_RAC), TYPE (INSN_RAC), EX (fmt_rac), FULL (rac), FAST (rac) },
  { IDX (INSN_RACH), TYPE (INSN_RACH), EX (fmt_rac), FULL (rach), FAST (rach) },
  { IDX (INSN_RTE), TYPE (INSN_RTE), EX (fmt_rte), FULL (rte), FAST (rte) },
  { IDX (INSN_SETH), TYPE (INSN_SETH), EX (fmt_seth), FULL (seth), FAST (seth) },
  { IDX (INSN_SLL), TYPE (INSN_SLL), EX (fmt_add), FULL (sll), FAST (sll) },
  { IDX (INSN_SLL3), TYPE (INSN_SLL3), EX (fmt_sll3), FULL (sll3), FAST (sll3) },
  { IDX (INSN_SLLI), TYPE (INSN_SLLI), EX (fmt_slli), FULL (slli), FAST (slli) },
  { IDX (INSN_SRA), TYPE (INSN_SRA), EX (fmt_add), FULL (sra), FAST (sra) },
  { IDX (INSN_SRA3), TYPE (INSN_SRA3), EX (fmt_sll3), FULL (sra3), FAST (sra3) },
  { IDX (INSN_SRAI), TYPE (INSN_SRAI), EX (fmt_slli), FULL (srai), FAST (srai) },
  { IDX (INSN_SRL), TYPE (INSN_SRL), EX (fmt_add), FULL (srl), FAST (srl) },
  { IDX (INSN_SRL3), TYPE (INSN_SRL3), EX (fmt_sll3), FULL (srl3), FAST (srl3) },
  { IDX (INSN_SRLI), TYPE (INSN_SRLI), EX (fmt_slli), FULL (srli), FAST (srli) },
  { IDX (INSN_ST), TYPE (INSN_ST), EX (fmt_st), FULL (st), FAST (st) },
  { IDX (INSN_ST_D), TYPE (INSN_ST_D), EX (fmt_st_d), FULL (st_d), FAST (st_d) },
  { IDX (INSN_STB), TYPE (INSN_STB), EX (fmt_stb), FULL (stb), FAST (stb) },
  { IDX (INSN_STB_D), TYPE (INSN_STB_D), EX (fmt_stb_d), FULL (stb_d), FAST (stb_d) },
  { IDX (INSN_STH), TYPE (INSN_STH), EX (fmt_sth), FULL (sth), FAST (sth) },
  { IDX (INSN_STH_D), TYPE (INSN_STH_D), EX (fmt_sth_d), FULL (sth_d), FAST (sth_d) },
  { IDX (INSN_ST_PLUS), TYPE (INSN_ST_PLUS), EX (fmt_st_plus), FULL (st_plus), FAST (st_plus) },
  { IDX (INSN_ST_MINUS), TYPE (INSN_ST_MINUS), EX (fmt_st_plus), FULL (st_minus), FAST (st_minus) },
  { IDX (INSN_SUB), TYPE (INSN_SUB), EX (fmt_add), FULL (sub), FAST (sub) },
  { IDX (INSN_SUBV), TYPE (INSN_SUBV), EX (fmt_addv), FULL (subv), FAST (subv) },
  { IDX (INSN_SUBX), TYPE (INSN_SUBX), EX (fmt_addx), FULL (subx), FAST (subx) },
  { IDX (INSN_TRAP), TYPE (INSN_TRAP), EX (fmt_trap), FULL (trap), FAST (trap) },
  { IDX (INSN_UNLOCK), TYPE (INSN_UNLOCK), EX (fmt_unlock), FULL (unlock), FAST (unlock) },
  { 0 }
};

const struct insn_sem m32rb_insn_sem_illegal =
{
  IDX (INSN_ILLEGAL), TYPE (INSN_ILLEGAL), EX (illegal), FULL (illegal), FAST (illegal)
};

/* Initialize the instruction descriptor table.  */

void
m32rb_init_idesc_table (SIM_CPU *cpu)
{
  IDESC *id,*tabend;
  const struct insn_sem *t;
  const CGEN_INSN *opcode_table = m32r_cgen_insn_table_entries;
  int tabsize = MAX_INSNS;
  IDESC *table = m32rb_insn_data;

  memset (table, 0, tabsize * sizeof (IDESC));

  /* First set all entries to the `illegal insn'.  */
  t = & m32rb_insn_sem_illegal;
  for (id = table, tabend = table + tabsize; id < tabend; ++id)
    {
      id->num = 0;
      id->opcode = & opcode_table[t->type];
      id->extract = t->extract;
#if defined (HAVE_PARALLEL_EXEC) && ! defined (__GNUC__)
      id->read = t->read;
#endif
#if ! WITH_SEM_SWITCH_FULL
      id->sem_full = t->sem_full;
#endif
#if ! WITH_SEM_SWITCH_FAST
      id->sem_fast = t->sem_fast;
#endif
    }

  /* Now fill in the values for the chosen cpu.  */
  for (t = m32rb_insn_sem; t->type != 0; ++t)
    {
      id = & table[t->index];
      id->num = t->index;
      id->opcode = & opcode_table[t->type];
      id->extract = t->extract;
#if defined (HAVE_PARALLEL_EXEC) && ! defined (__GNUC__)
      id->read = t->read;
#endif
#if ! WITH_SEM_SWITCH_FULL
      id->sem_full = t->sem_full;
#endif
#if ! WITH_SEM_SWITCH_FAST
      id->sem_fast = t->sem_fast;
#endif
#if WITH_PROFILE_MODEL_P
      id->timing = & MODEL_TIMING (CPU_MODEL (cpu)) [t->index];
#endif
    }

  /* Link the IDESC table into the cpu.  */
  CPU_IDESC (cpu) = table;
}

/* The decoder needs a slightly different computed goto switch control.  */
#ifdef __GNUC__
#define DECODE_SWITCH(N, X) goto *labels_##N[X];
#else
#define DECODE_SWITCH(N, X) switch (X)
#endif

/* Given an instruction, return a pointer to its IDESC entry.  */

const IDESC *
m32rb_decode (current_cpu, pc, insn)
     SIM_CPU *current_cpu;
     PCADDR pc;
     insn_t insn;
{
#define I(insn) & m32rb_insn_data[CONCAT2 (M32RB_X,insn)]
  {
#ifdef __GNUC__
    static void *labels_0[256] = {
      && default_0, && default_0, && default_0, && default_0, 
      && default_0, && default_0, && default_0, && default_0, 
      && default_0, && default_0, && default_0, && default_0, 
      && default_0, && default_0, && default_0, && default_0, 
      && default_0, && default_0, && default_0, && default_0, 
      && default_0, && default_0, && default_0, && default_0, 
      && default_0, && default_0, && default_0, && default_0, 
      && case_0_28, && default_0, && default_0, && default_0, 
      && default_0, && default_0, && default_0, && default_0, 
      && default_0, && default_0, && default_0, && default_0, 
      && default_0, && default_0, && default_0, && default_0, 
      && default_0, && default_0, && default_0, && default_0, 
      && default_0, && default_0, && default_0, && default_0, 
      && default_0, && default_0, && default_0, && default_0, 
      && default_0, && default_0, && default_0, && default_0, 
      && default_0, && default_0, && default_0, && default_0, 
      && default_0, && default_0, && default_0, && default_0, 
      && default_0, && default_0, && default_0, && default_0, 
      && default_0, && default_0, && default_0, && default_0, 
      && default_0, && default_0, && default_0, && default_0, 
      && default_0, && default_0, && default_0, && default_0, 
      && default_0, && default_0, && default_0, && case_0_87, 
      && default_0, && default_0, && default_0, && default_0, 
      && default_0, && default_0, && default_0, && case_0_95, 
      && default_0, && default_0, && default_0, && default_0, 
      && default_0, && default_0, && default_0, && default_0, 
      && default_0, && default_0, && default_0, && default_0, 
      && default_0, && default_0, && default_0, && default_0, 
      && case_0_112, && case_0_113, && case_0_114, && case_0_115, 
      && case_0_116, && case_0_117, && case_0_118, && case_0_119, 
      && case_0_120, && case_0_121, && case_0_122, && case_0_123, 
      && case_0_124, && case_0_125, && case_0_126, && case_0_127, 
      && default_0, && default_0, && default_0, && default_0, 
      && default_0, && default_0, && default_0, && default_0, 
      && default_0, && default_0, && default_0, && default_0, 
      && default_0, && default_0, && default_0, && default_0, 
      && default_0, && default_0, && default_0, && default_0, 
      && default_0, && default_0, && default_0, && default_0, 
      && default_0, && default_0, && default_0, && default_0, 
      && default_0, && default_0, && default_0, && default_0, 
      && default_0, && default_0, && default_0, && default_0, 
      && default_0, && default_0, && default_0, && default_0, 
      && default_0, && default_0, && default_0, && default_0, 
      && default_0, && default_0, && default_0, && default_0, 
      && default_0, && default_0, && default_0, && default_0, 
      && default_0, && default_0, && default_0, && default_0, 
      && default_0, && default_0, && default_0, && default_0, 
      && default_0, && default_0, && default_0, && default_0, 
      && default_0, && default_0, && default_0, && default_0, 
      && default_0, && default_0, && default_0, && default_0, 
      && default_0, && default_0, && default_0, && default_0, 
      && default_0, && default_0, && default_0, && default_0, 
      && default_0, && default_0, && default_0, && default_0, 
      && default_0, && default_0, && default_0, && default_0, 
      && default_0, && default_0, && default_0, && default_0, 
      && default_0, && default_0, && default_0, && default_0, 
      && default_0, && default_0, && default_0, && default_0, 
      && default_0, && default_0, && default_0, && default_0, 
      && default_0, && default_0, && default_0, && default_0, 
      && default_0, && default_0, && default_0, && default_0, 
      && case_0_240, && case_0_241, && case_0_242, && case_0_243, 
      && case_0_244, && case_0_245, && case_0_246, && case_0_247, 
      && case_0_248, && case_0_249, && case_0_250, && case_0_251, 
      && case_0_252, && case_0_253, && case_0_254, && case_0_255, 
    };
#endif
    static IDESC *insns[256] = {
      I (INSN_SUBV), I (INSN_SUBX), I (INSN_SUB), I (INSN_NEG), 
      I (INSN_CMP), I (INSN_CMPU), I (INSN_ILLEGAL), I (INSN_ILLEGAL), 
      I (INSN_ADDV), I (INSN_ADDX), I (INSN_ADD), I (INSN_NOT), 
      I (INSN_AND), I (INSN_XOR), I (INSN_OR), I (INSN_ILLEGAL), 
      I (INSN_SRL), I (INSN_ILLEGAL), I (INSN_SRA), I (INSN_ILLEGAL), 
      I (INSN_SLL), I (INSN_ILLEGAL), I (INSN_MUL), I (INSN_ILLEGAL), 
      I (INSN_MV), I (INSN_MVFC), I (INSN_MVTC), I (INSN_ILLEGAL), 
      0, I (INSN_RTE), I (INSN_ILLEGAL), I (INSN_TRAP), 
      I (INSN_STB), I (INSN_ILLEGAL), I (INSN_STH), I (INSN_ILLEGAL), 
      I (INSN_ST), I (INSN_UNLOCK), I (INSN_ST_PLUS), I (INSN_ST_MINUS), 
      I (INSN_LDB), I (INSN_LDUB), I (INSN_LDH), I (INSN_LDUH), 
      I (INSN_LD), I (INSN_LOCK), I (INSN_LD_PLUS), I (INSN_ILLEGAL), 
      I (INSN_MULHI), I (INSN_MULLO), I (INSN_MULWHI), I (INSN_MULWLO), 
      I (INSN_MACHI), I (INSN_MACLO), I (INSN_MACWHI), I (INSN_MACWLO), 
      I (INSN_ILLEGAL), I (INSN_ILLEGAL), I (INSN_ILLEGAL), I (INSN_ILLEGAL), 
      I (INSN_ILLEGAL), I (INSN_ILLEGAL), I (INSN_ILLEGAL), I (INSN_ILLEGAL), 
      I (INSN_ADDI), I (INSN_ADDI), I (INSN_ADDI), I (INSN_ADDI), 
      I (INSN_ADDI), I (INSN_ADDI), I (INSN_ADDI), I (INSN_ADDI), 
      I (INSN_ADDI), I (INSN_ADDI), I (INSN_ADDI), I (INSN_ADDI), 
      I (INSN_ADDI), I (INSN_ADDI), I (INSN_ADDI), I (INSN_ADDI), 
      I (INSN_SRLI), I (INSN_SRLI), I (INSN_SRAI), I (INSN_SRAI), 
      I (INSN_SLLI), I (INSN_SLLI), I (INSN_ILLEGAL), 0, 
      I (INSN_RACH), I (INSN_RAC), I (INSN_ILLEGAL), I (INSN_ILLEGAL), 
      I (INSN_ILLEGAL), I (INSN_ILLEGAL), I (INSN_ILLEGAL), 0, 
      I (INSN_LDI8), I (INSN_LDI8), I (INSN_LDI8), I (INSN_LDI8), 
      I (INSN_LDI8), I (INSN_LDI8), I (INSN_LDI8), I (INSN_LDI8), 
      I (INSN_LDI8), I (INSN_LDI8), I (INSN_LDI8), I (INSN_LDI8), 
      I (INSN_LDI8), I (INSN_LDI8), I (INSN_LDI8), I (INSN_LDI8), 
      0, 0, 0, 0, 
      0, 0, 0, 0, 
      0, 0, 0, 0, 
      0, 0, 0, 0, 
      I (INSN_ILLEGAL), I (INSN_ILLEGAL), I (INSN_ILLEGAL), I (INSN_ILLEGAL), 
      I (INSN_CMPI), I (INSN_CMPUI), I (INSN_ILLEGAL), I (INSN_ILLEGAL), 
      I (INSN_ADDV3), I (INSN_ILLEGAL), I (INSN_ADD3), I (INSN_ILLEGAL), 
      I (INSN_AND3), I (INSN_XOR3), I (INSN_OR3), I (INSN_ILLEGAL), 
      I (INSN_DIV), I (INSN_DIVU), I (INSN_REM), I (INSN_REMU), 
      I (INSN_ILLEGAL), I (INSN_ILLEGAL), I (INSN_ILLEGAL), I (INSN_ILLEGAL), 
      I (INSN_SRL3), I (INSN_ILLEGAL), I (INSN_SRA3), I (INSN_ILLEGAL), 
      I (INSN_SLL3), I (INSN_ILLEGAL), I (INSN_ILLEGAL), I (INSN_LDI16), 
      I (INSN_STB_D), I (INSN_ILLEGAL), I (INSN_STH_D), I (INSN_ILLEGAL), 
      I (INSN_ST_D), I (INSN_ILLEGAL), I (INSN_ILLEGAL), I (INSN_ILLEGAL), 
      I (INSN_LDB_D), I (INSN_LDUB_D), I (INSN_LDH_D), I (INSN_LDUH_D), 
      I (INSN_LD_D), I (INSN_ILLEGAL), I (INSN_ILLEGAL), I (INSN_ILLEGAL), 
      I (INSN_BEQ), I (INSN_BNE), I (INSN_ILLEGAL), I (INSN_ILLEGAL), 
      I (INSN_ILLEGAL), I (INSN_ILLEGAL), I (INSN_ILLEGAL), I (INSN_ILLEGAL), 
      I (INSN_BEQZ), I (INSN_BNEZ), I (INSN_BLTZ), I (INSN_BGEZ), 
      I (INSN_BLEZ), I (INSN_BGTZ), I (INSN_ILLEGAL), I (INSN_ILLEGAL), 
      I (INSN_ILLEGAL), I (INSN_ILLEGAL), I (INSN_ILLEGAL), I (INSN_ILLEGAL), 
      I (INSN_ILLEGAL), I (INSN_ILLEGAL), I (INSN_ILLEGAL), I (INSN_ILLEGAL), 
      I (INSN_ILLEGAL), I (INSN_ILLEGAL), I (INSN_ILLEGAL), I (INSN_ILLEGAL), 
      I (INSN_ILLEGAL), I (INSN_ILLEGAL), I (INSN_ILLEGAL), I (INSN_ILLEGAL), 
      I (INSN_ILLEGAL), I (INSN_ILLEGAL), I (INSN_ILLEGAL), I (INSN_ILLEGAL), 
      I (INSN_ILLEGAL), I (INSN_ILLEGAL), I (INSN_ILLEGAL), I (INSN_ILLEGAL), 
      I (INSN_ILLEGAL), I (INSN_ILLEGAL), I (INSN_ILLEGAL), I (INSN_ILLEGAL), 
      I (INSN_SETH), I (INSN_ILLEGAL), I (INSN_ILLEGAL), I (INSN_ILLEGAL), 
      I (INSN_LD24), I (INSN_LD24), I (INSN_LD24), I (INSN_LD24), 
      I (INSN_LD24), I (INSN_LD24), I (INSN_LD24), I (INSN_LD24), 
      I (INSN_LD24), I (INSN_LD24), I (INSN_LD24), I (INSN_LD24), 
      I (INSN_LD24), I (INSN_LD24), I (INSN_LD24), I (INSN_LD24), 
      0, 0, 0, 0, 
      0, 0, 0, 0, 
      0, 0, 0, 0, 
      0, 0, 0, 0, 
    };
    unsigned int val;
    val = (((insn >> 8) & (15 << 4)) | ((insn >> 4) & (15 << 0)));
    DECODE_SWITCH (0, val)
      {
      CASE (0, 28) :
        {
          static IDESC *insns[16] = {
            I (INSN_ILLEGAL), I (INSN_ILLEGAL), I (INSN_ILLEGAL), I (INSN_ILLEGAL), 
            I (INSN_ILLEGAL), I (INSN_ILLEGAL), I (INSN_ILLEGAL), I (INSN_ILLEGAL), 
            I (INSN_ILLEGAL), I (INSN_ILLEGAL), I (INSN_ILLEGAL), I (INSN_ILLEGAL), 
            I (INSN_ILLEGAL), I (INSN_ILLEGAL), I (INSN_JL), I (INSN_JMP), 
          };
          unsigned int val = (((insn >> 8) & (15 << 0)));
          return insns[val];
        }
      CASE (0, 87) :
        {
          static IDESC *insns[16] = {
            I (INSN_MVTACHI), I (INSN_MVTACLO), I (INSN_ILLEGAL), I (INSN_ILLEGAL), 
            I (INSN_ILLEGAL), I (INSN_ILLEGAL), I (INSN_ILLEGAL), I (INSN_ILLEGAL), 
            I (INSN_ILLEGAL), I (INSN_ILLEGAL), I (INSN_ILLEGAL), I (INSN_ILLEGAL), 
            I (INSN_ILLEGAL), I (INSN_ILLEGAL), I (INSN_ILLEGAL), I (INSN_ILLEGAL), 
          };
          unsigned int val = (((insn >> 0) & (15 << 0)));
          return insns[val];
        }
      CASE (0, 95) :
        {
          static IDESC *insns[16] = {
            I (INSN_MVFACHI), I (INSN_MVFACLO), I (INSN_MVFACMI), I (INSN_ILLEGAL), 
            I (INSN_ILLEGAL), I (INSN_ILLEGAL), I (INSN_ILLEGAL), I (INSN_ILLEGAL), 
            I (INSN_ILLEGAL), I (INSN_ILLEGAL), I (INSN_ILLEGAL), I (INSN_ILLEGAL), 
            I (INSN_ILLEGAL), I (INSN_ILLEGAL), I (INSN_ILLEGAL), I (INSN_ILLEGAL), 
          };
          unsigned int val = (((insn >> 0) & (15 << 0)));
          return insns[val];
        }
      CASE (0, 112) :
        {
          static IDESC *insns[16] = {
            I (INSN_NOP), I (INSN_ILLEGAL), I (INSN_ILLEGAL), I (INSN_ILLEGAL), 
            I (INSN_ILLEGAL), I (INSN_ILLEGAL), I (INSN_ILLEGAL), I (INSN_ILLEGAL), 
            I (INSN_ILLEGAL), I (INSN_ILLEGAL), I (INSN_ILLEGAL), I (INSN_ILLEGAL), 
            I (INSN_BC8), I (INSN_BNC8), I (INSN_BL8), I (INSN_BRA8), 
          };
          unsigned int val = (((insn >> 8) & (15 << 0)));
          return insns[val];
        }
      CASE (0, 113) : /* fall through */
      CASE (0, 114) : /* fall through */
      CASE (0, 115) : /* fall through */
      CASE (0, 116) : /* fall through */
      CASE (0, 117) : /* fall through */
      CASE (0, 118) : /* fall through */
      CASE (0, 119) : /* fall through */
      CASE (0, 120) : /* fall through */
      CASE (0, 121) : /* fall through */
      CASE (0, 122) : /* fall through */
      CASE (0, 123) : /* fall through */
      CASE (0, 124) : /* fall through */
      CASE (0, 125) : /* fall through */
      CASE (0, 126) : /* fall through */
      CASE (0, 127) :
        {
          static IDESC *insns[16] = {
            I (INSN_ILLEGAL), I (INSN_ILLEGAL), I (INSN_ILLEGAL), I (INSN_ILLEGAL), 
            I (INSN_ILLEGAL), I (INSN_ILLEGAL), I (INSN_ILLEGAL), I (INSN_ILLEGAL), 
            I (INSN_ILLEGAL), I (INSN_ILLEGAL), I (INSN_ILLEGAL), I (INSN_ILLEGAL), 
            I (INSN_BC8), I (INSN_BNC8), I (INSN_BL8), I (INSN_BRA8), 
          };
          unsigned int val = (((insn >> 8) & (15 << 0)));
          return insns[val];
        }
      CASE (0, 240) : /* fall through */
      CASE (0, 241) : /* fall through */
      CASE (0, 242) : /* fall through */
      CASE (0, 243) : /* fall through */
      CASE (0, 244) : /* fall through */
      CASE (0, 245) : /* fall through */
      CASE (0, 246) : /* fall through */
      CASE (0, 247) : /* fall through */
      CASE (0, 248) : /* fall through */
      CASE (0, 249) : /* fall through */
      CASE (0, 250) : /* fall through */
      CASE (0, 251) : /* fall through */
      CASE (0, 252) : /* fall through */
      CASE (0, 253) : /* fall through */
      CASE (0, 254) : /* fall through */
      CASE (0, 255) :
        {
          static IDESC *insns[16] = {
            I (INSN_ILLEGAL), I (INSN_ILLEGAL), I (INSN_ILLEGAL), I (INSN_ILLEGAL), 
            I (INSN_ILLEGAL), I (INSN_ILLEGAL), I (INSN_ILLEGAL), I (INSN_ILLEGAL), 
            I (INSN_ILLEGAL), I (INSN_ILLEGAL), I (INSN_ILLEGAL), I (INSN_ILLEGAL), 
            I (INSN_BC24), I (INSN_BNC24), I (INSN_BL24), I (INSN_BRA24), 
          };
          unsigned int val = (((insn >> 8) & (15 << 0)));
          return insns[val];
        }
      DEFAULT (0) : return insns[val];
      }
    ENDSWITCH (0)
  }
#undef I
}
