
/* @(#)z_cosh.c 1.0 98/08/13 */
/******************************************************************
 * Hyperbolic Cosine
 *
 * Input:
 *   x - floating point value
 *
 * Output:
 *   hyperbolic cosine of x
 *
 * Description:
 *   This routine returns the hyperbolic cosine of x.
 *
 *****************************************************************/

#include "../math/fdlibm.h"
#include "zmath.h"

#ifndef _DOUBLE_IS_32BITS

double
_DEFUN (cosh, (double),
        double x)
{
  return (sineh (x, 1));
}

#endif /* _DOUBLE_IS_32BITS */
