
/* @(#)z_atan2.c 1.0 98/08/13 */
/******************************************************************
 * Arctangent2
 *
 * Input:
 *   v, u - floating point values
 *
 * Output:
 *   arctan2 of v / u 
 *
 * Description:
 *   This routine returns the arctan2 of v / u.
 *
 *****************************************************************/

#include "../math/fdlibm.h"
#include "zmath.h"

#ifndef _DOUBLE_IS_32BITS

double
_DEFUN (atan2, (double, double),
        double v _AND
        double u)
{
  return (atangent (0.0, v, u, 1));
}

#endif /* _DOUBLE_IS_32BITS */
