/* routine to read manifiest files
   Copyright 1995
   Free Software Foundation, Inc.

   This file is part of INSTALL.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "manifest.h"

void
get_manifest (char *root)
{
  int rn;
  int depth;
  int disk;
  char buf[100];


  FILE *f;

  sprintf (buf, "%s\\MANIFEST", root);

  f = fopen (buf, "r");

  if (!f)
    {
      printf ("Unable to open %s\n", buf);
      exit (1);
    }

  /* Skip first line */
  fscanf (f, "** RELEASE MANIFEST **\n");
  fgets (prodname, sizeof (prodname), f);
  fgets (prodver, sizeof (prodver), f);
  fscanf (f, "Total uncompressed file size %ld\n", &needed_size);
  fscanf (f, "Total compressed file size %ld\n", &compressed_size);
  fscanf (f, "Number of floppies %d\n", &floppies);

  fscanf (f, "\nDirectory structure:\n");
  rn = fscanf (f, "%d %s\n", &depth, buf);
  while (rn == 2)
    {
      struct dirlist *n = malloc (sizeof (struct dirlist));
      n->name = strdup (buf);

      n->next = 0;
      if (dirs_head)
	dirs_tail->next = n;
      else
	dirs_head = n;
      dirs_tail = n;
      rn = fscanf (f, "%d %s\n", &depth, buf);
    }


  fscanf (f, "File structure:\n");

  rn = fscanf (f, "%d %d %s\n", &disk, &depth, buf);
  while (rn == 3)
    {

      struct filelist *n = malloc (sizeof (struct filelist));
      n->name = strdup (buf);
      n->next = 0;
      n->disk = disk;
      n->depth = depth;
      if (files_head)
	files_tail->next = n;
      else
	files_head = n;
      files_tail = n;
      rn = fscanf (f, "%d %d %s\n", &disk, &depth, buf);

    }
  fclose (f);
}
