dnl
dnl SHADOW GUI menu description. This file must be processed by m4 before
dnl it can be used with SHADOW.
dnl
dnl Maintainer note: GNU m4 tries very hard to avoid calling builtins when
dnl it sees `define', `include', etc tokens, but other m4's do not do so.
dnl Solution is to add empty tokens in between, eg., include -> incl`'ude.
dnl
*234567890123456789012345678901234567890123456789012345678901234567890123456789              
OE      ALFA            R       0.0         
OE      ALPHA           R       0.0         
OE      ALPHA_I         R       0.0         
OE      ALPHA_S         R       0.0              
OE      AXMAJ           R       0.0              
OE      AXMIN           R       0.0    
OE      AZIM_FAN        R       0.0    
OE      A_BRAGG         R       0.0
OE      BLAZE           R       0.0         
OE      CIL_ANG         R       0.0       
OE      COD_LEN         R       0.0              
OE      COD_WID         R       0.0    
OE      COMA_FAC        R       0.0              
OE      CONE_A          R       0.0       
OE      DIST_FAN        R     100.0    
OE      D_SPACING       R       0.0         
OE      DUMMY           R       0.0   
OE      ELL_THE         R       0.0       
OE      FCYL            Y       NO           
OE      FDUMMY          Y       NO
OE      FHIT_C          Y       OFF           
OE      FILE_FAC        F       NONE SPECIFIED
OE      FILE_KOMA       F       NONE SPECIFIED
OE      FILE_KOMA_CA    F       NONE SPECIFIED
OE      FILE_MIR        F       NONE SPECIFIED   
OE      FILE_REFL       F       NONE SPECIFIED        
OE      FILE_RIP        F       NONE SPECIFIED             
OE      FILE_ROUGH      F       NONE SPECIFIED
OE      FILE_SEGMENT    F       NONE SPECIFIED
OE      FILE_SEGP       F       NONE SPECIFIED
OE      FILE_SOURCE     F       begin.dat              
OE      FMIRR           E       PLANE           
OE      FSHAPE          E       RECTANGLE              
OE      FSLIT           Y       NO         
OE      FSTAT           E       NO       
OE      FWRITE          E       ALL
OE      FZP             Y       NO 
OE      F_ANGLE         Y       NO
OE      F_BRAGG_A       Y       NO
OE      F_CENTRAL       Y       NO            
OE      F_CONVEX        E       CONCAVE           
OE      F_CRYSTAL       Y       NO               
OE      F_DEFAULT       E       COINCIDENT         
OE      F_EXT           E       INTERNAL              
OE      F_EXIT_SHAPE    Y       NO
OE      F_FACET         Y       NO
OE      F_FAC_ORIENT    E       Y-AXIS
OE      F_FAC_LATT      E       RECTANG
OE      F_GRATING       E       MIRROR       
OE      F_G_S           E       SINE              
OE      F_HUNT          E       FIRST       
OE      F_INC_MNOR_ANG  Y       NO
OE      F_KOMA          Y       NO
OE      F_KOMA_BOUNCE   Y       NO
OE      F_KOMA_CA       Y       NO
OE      F_MONO          E       TGM              
OE      F_JOHANSSON     Y       NO
OE      F_MOSAIC        Y       NO
OE      F_MOVE          Y       NO       
OE      F_PHOT_CENT     E       eV       
OE      F_PLATE         Y       NO         
OE      F_POLSEL        E       FARTHEST
OE      F_PW            E       SPSP              
OE      F_PW_C          E       SPSP    
OE      F_REFL          E       FILE              
OE      F_REFLEC        E       OFF       
OE      F_REFRAC        E       REFLECTOR    
OE      F_RIPPLE        Y       NO           
OE      F_ROUGHNESS     Y       NO
OE      F_RULING        E       CONSTANT     
OE      F_RUL_ABS       E       ABSOLUTE   
OE      F_R_RAN         E       SINE   
OE      F_SCREEN        Y       OFF         
OE      F_SEGMENT       Y       NO
OE      F_SIDE          E       SOURCE              
OE      F_THICK         Y       NO
OE      F_TORUS         E       LOWER/OUTER           
OE      F_VIRTUAL       E       R/R      
OE      GAMMA           R       0.0              
OE      HOLO_DEL        R       -20.0              
OE      HOLO_GAM        R       -20.0              
OE      HOLO_R1         R       300              
OE      HOLO_R2         R       300.0    
OE      HOLO_RT1        R       0.0    
OE      HOLO_RT2        R       0.0              
OE      HOLO_W          R       4879.86         
OE      HUNT_H          R       0.0       
OE      HUNT_L          R       0.0         
OE      IFAC_X          I       11
OE      IFAC_Y          I       11
OE      ISEG_XNUM       I       1
OE      ISEG_YNUM       I       1
OE      MOSAIC_SEED     I       1626261131
OE      N_PLATES        I       0       
OE      N_SCREEN        I       0         
OE      OE_NUMBER       I       0              
OE      OFFX            R       0.0              
OE      OFFY            R       0.0              
OE      OFFZ            R       0.0              
OE      OFF_SOUX        R       0.0              
OE      OFF_SOUY        R       0.0              
OE      OFF_SOUZ        R       0.0              
OE      ORDER           R       -1.0         
OE      PARAM           R       0.0         
OE      PHOT_CENT       R       5.0         
OE      RDSOUR          R       0.0              
OE      RFAC_LENX       R       10.0
OE      RFAC_LENY       R       10.0
OE      RFAC_PHAX       R       0.0
OE      RFAC_PHAY       R       0.0
OE      RFAC_DELX1      R       0.0
OE      RFAC_DELX2      R       0.0
OE      RFAC_DELY1      R       0.0
OE      RFAC_DELY2      R       0.0
OE      RKOMA_CX        R       0.0
OE      RKOMA_CY        R       0.0
OE      RLEN1           R       0.0              
OE      RLEN2           R       0.0              
OE      RMIRR           R       0.0              
OE      ROUGH_X         R       0.0
OE      ROUGH_Y         R       0.0
OE      RTHETA          R       0.0              
OE      RULING          R       12000.0              
OE      RUL_A1          R       0.0   
OE      RUL_A2          R       0.0   
OE      RUL_A3          R       0.0   
OE      RUL_A4          R       0.0   
OE      RWIDX1          R       0.0              
OE      RWIDX2          R       0.0              
OE      R_IND_OBJ       R       1.0   
OE      R_IND_IMA       R       1.0   
OE      R_JOHANSSON     R       0.0
OE      R_LAMBDA        R       5000.0         
OE      R_MAJ           R       0.0              
OE      R_MIN           R       0.0              
OE      SEG_LENX        R       0.0
OE      SEG_LENY        R       0.0
OE      SIMAG           R       0.0              
OE      SLLEN           R       0.0         
OE      SLWID           R       0.0         
OE      SLTILT          R       0.0
OE      SPREAD_MOS      R       0.0         
OE      SSOUR           R       0.0         
OE      THETA           R       0.0         
OE      THETA_I         R       0.0         
OE      THICKNESS       R       0.0
OE      T_IMAGE         R       0.0              
OE      T_INCIDENCE     R       0.0              
OE      T_REFLECTION    R       0.0              
OE      T_SOURCE        R       0.0              
OE      X_PHASE         R       0.0              
OE      X_RIP_AMP       R       0.0              
OE      X_RIP_WAV       R       0.0              
OE      X_ROT           R       0.0              
OE      X_SOUR          R       0.0       
OE      X_SOUR_ROT      R       0.0       
OE      Y_PHASE         R       0.0              
OE      Y_RIP_AMP       R       0.0              
OE      Y_RIP_WAV       R       0.0              
OE      Y_ROT           R       0.0       
OE      Y_SOUR          R       0.0       
OE      Y_SOUR_ROT      R       0.0              
OE      ZKO_LENGTH      R       0.0
OE      Z_ROT           R       0.0       
OE      Z_SOUR          R       0.0       
OE      Z_SOUR_ROT      R       0.0              
SCR     FILE_ABS        F       NONE SPECIFIED      
SCR     FILE_SCR_EXT    F       NONE SPECIFIED      
SCR     I_ABS           Y       OFF      
SCR     I_SCREEN        E       BEFORE      
SCR     I_SLIT          Y       OFF      
SCR     I_STOP          E       SLIT      
SCR     K_SLIT          E       RECT      
SCR     RX_SLIT         R       10.0      
SCR     RZ_SLIT         R       10.0      
SCR     CX_SLIT         R       0.0      
SCR     CZ_SLIT         R       0.0      
SCR     SCR_NUMBER      I       0        
SCR     SL_DIS          R       0.0      
SCR     THICK           R       0.0      
SRC     PLASMA_ANGLE    R       0.0
SRC     BENER           R       1.0         
SRC     CONE_MAX        R       0.0              
SRC     CONE_MIN        R       0.0              
SRC     CONV_FACT       R       0.0         
SRC     EPSI_DX         R       0.0         
SRC     EPSI_DZ         R       0.0         
SRC     EPSI_X          R       0.0         
SRC     EPSI_Z          R       0.0         
SRC     FDISTR          E       FLAT           
SRC     FGRID           E       RAN/RAN              
SRC     FILE_BOUND      F       NONE SPECIFIED
SRC     FILE_SOURCE     F       begin.dat   
SRC     FILE_TRAJ       F       NONE SPECIFIED   
SRC     FSOUR           E       POINT         
SRC     FSOURCE_DEPTH   E       OFF         
SRC     F_BOUND_SOUR    Y       NO
SRC     F_COHER         E       COHERENT   
SRC     F_COLOR         E       OFF              
SRC     F_NEW           Y       NO         
SRC     F_OPD           Y       OFF            
SRC     F_PHOT          E       eV         
SRC     F_POL           E       TOTAL         
SRC     F_POLAR         Y       OFF   
SRC     F_WIGGLER       E       NONE
SRC     F_SR_TYPE       E       PHOTON
SRC     HDIV1           R       0.0              
SRC     HDIV2           R       0.0              
SRC     IDO_VX          I       1         
SRC     IDO_VZ          I       1         
SRC     IDO_XL          I       1   
SRC     IDO_XN          I       1   
SRC     IDO_ZL          I       1   
SRC     IDO_ZN          I       1   
SRC     IDO_X_S         I       1         
SRC     IDO_Y_S         I       1         
SRC     IDO_Z_S         I       1         
SRC     ISTAR1          I       12853         
SRC     NPOINT          I       1000         
SRC     N_CIRCLE        I       7         
SRC     N_COLOR         I       1         
SRC     N_CONE          I       1         
SRC     PH1             R       10.0      
SRC     PH10            R       10.0      
SRC     PH2             R       10.0      
SRC     PH3             R       10.0      
SRC     PH4             R       10.0      
SRC     PH5             R       10.0      
SRC     PH6             R       10.0      
SRC     PH7             R       10.0      
SRC     PH8             R       10.0      
SRC     PH9             R       10.0      
SRC     RL1             R       1.0      
SRC     RL10            R       1.0      
SRC     RL2             R       1.0      
SRC     RL3             R       1.0      
SRC     RL4             R       1.0      
SRC     RL5             R       1.0      
SRC     RL6             R       1.0      
SRC     RL7             R       1.0      
SRC     RL8             R       1.0      
SRC     RL9             R       1.0      
SRC     POL_ANGLE       R       0.0         
SRC     POL_DEG         R       0.0         
SRC     R_ALADDIN       R       208.33        
SRC     R_MAGNET        R       2.0833       
SRC     SIGDIX          R       0.0              
SRC     SIGDIZ          R       0.0         
SRC     SIGMAX          R       0.0              
SRC     SIGMAY          R       0.0              
SRC     SIGMAZ          R       0.0              
SRC     SIGXL1          R       0.0   
SRC     SIGXL10         R       0.0   
SRC     SIGXL2          R       0.0   
SRC     SIGXL3          R       0.0   
SRC     SIGXL4          R       0.0   
SRC     SIGXL5          R       0.0   
SRC     SIGXL6          R       0.0   
SRC     SIGXL7          R       0.0   
SRC     SIGXL8          R       0.0   
SRC     SIGXL9          R       0.0   
SRC     SIGZL1          R       0.0   
SRC     SIGZL10         R       0.0   
SRC     SIGZL2          R       0.0   
SRC     SIGZL3          R       0.0   
SRC     SIGZL4          R       0.0   
SRC     SIGZL5          R       0.0   
SRC     SIGZL6          R       0.0   
SRC     SIGZL7          R       0.0   
SRC     SIGZL8          R       0.0   
SRC     SIGZL9          R       0.0   
SRC     VDIV1           R       0.0              
SRC     VDIV2           R       0.0              
SRC     WXSOU           R       0.0              
SRC     WYSOU           R       0.0              
SRC     WZSOU           R       0.0              

*
* Force the user to supply the filename or let more intelligent choice?
*
PLX     PLX_SPEC_FILE   Y       NO
PLX     PLX_INFILE      F       star.01
PLX     PLX_IMAGE       E       Cont Plane
PLX     PLX_PLOT_WHAT   E       OE
*
* Option to pick what columns and what kind of rays
*
PLX     PLX_RAYOPTS     E       GOOD ONLY
PLX     PLX_COMMENTS    A       NONE SPECIFIED
PLX     PLX_ROW_HORIZ   E       X
PLX     PLX_ROW_VERT    E       Z
*
* If photon energy is plotted, must know what units to use.
*
PLX     PLX_UNIT        E       cm-1
PLX     PLX_SCALE_OPTS  E       Automatic
PLX     PLX_EXT_HMIN    R       0.0
PLX     PLX_EXT_HMAX    R       0.0
PLX     PLX_EXT_VMIN    R       0.0
PLX     PLX_EXT_VMAX    R       0.0
PLX     PLX_PLOT_TYPE   E       Scattered
PLX     PLX_HAIRLINE    Y       NO
PLX     PLX_OVL_MIRROR  Y       NO
PLX     PLX_DO_HIST     Y       YES
PLX     PLX_HIST_LIM    Y       NO
PLX     PLX_HIST_XCTR   R       0.0
PLX     PLX_HIST_XWID   R       0.0
PLX     PLX_HIST_YCTR   R       0.0
PLX     PLX_HIST_YWID   R       0.0
PLX     PLX_HIST_XBINS  I       25
PLX     PLX_HIST_YBINS  I       25
PLX     PLX_DEVICE      E       ifdef(`_WIN32', `Postscript', `X Windows')

*
* Force the user to supply the filename or let more intelligent choice?
*
PL2     PL2_SPEC_FILE   Y       NO
PL2     PL2_INFILE      F       star.01
PL2     PL2_IMAGE       E       Cont Plane
PL2     PL2_PLOT_WHAT   E       OE
*
* Option to pick what columns and what kind of rays
*
PL2     PL2_RAYOPTS     E       GOOD ONLY
PL2     PL2_COMMENTS    A       NONE SPECIFIED
PL2     PL2_ROW_HORIZ   E       X
PL2     PL2_ROW_VERT    E       Z
*
* If photon energy is plotted, must know what units to use.
*
PL2     PL2_UNIT        E       cm-1
PL2     PL2_SCALE_OPTS  E       Automatic
PL2     PL2_EXT_HMIN    R       0.0
PL2     PL2_EXT_HMAX    R       0.0
PL2     PL2_EXT_VMIN    R       0.0
PL2     PL2_EXT_VMAX    R       0.0
PL2     PL2_PLOT_TYPE   E       Scattered
PL2     PL2_HAIRLINE    Y       NO
PL2     PL2_OVL_MIRROR  Y       NO
PL2     PL2_DO_HIST     Y       YES
PL2     PL2_HIST_LIM    Y       NO
PL2     PL2_HIST_XCTR   R       0.0
PL2     PL2_HIST_XWID   R       0.0
PL2     PL2_HIST_YCTR   R       0.0
PL2     PL2_HIST_YWID   R       0.0
PL2     PL2_HIST_XBINS  I       25
PL2     PL2_HIST_YBINS  I       25
PL2     PL2_DEVICE      E       ifdef(`_WIN32', `Postscript', `X Windows')

*
* Force the user to supply the filename or let more intelligent choice?
*
PL3     PL3_SPEC_FILE   Y       NO
PL3     PL3_INFILE      F       star.01
PL3     PL3_IMAGE       E       Cont Plane
PL3     PL3_PLOT_WHAT   E       OE
*
* Option to pick what columns and what kind of rays
*
PL3     PL3_RAYOPTS     E       GOOD ONLY
PL3     PL3_COMMENTS    A       NONE SPECIFIED
PL3     PL3_ROW_HORIZ   E       X
PL3     PL3_ROW_VERT    E       Z
*
* If photon energy is plotted, must know what units to use.
*
PL3     PL3_UNIT        E       cm-1
PL3     PL3_SCALE_OPTS  E       Automatic
PL3     PL3_EXT_HMIN    R       0.0
PL3     PL3_EXT_HMAX    R       0.0
PL3     PL3_EXT_VMIN    R       0.0
PL3     PL3_EXT_VMAX    R       0.0
PL3     PL3_PLOT_TYPE   E       Scattered
PL3     PL3_HAIRLINE    Y       NO
PL3     PL3_OVL_MIRROR  Y       NO
PL3     PL3_DO_HIST     Y       YES
PL3     PL3_HIST_LIM    Y       NO
PL3     PL3_HIST_XCTR   R       0.0
PL3     PL3_HIST_XWID   R       0.0
PL3     PL3_HIST_YCTR   R       0.0
PL3     PL3_HIST_YWID   R       0.0
PL3     PL3_HIST_XBINS  I       25
PL3     PL3_HIST_YBINS  I       25
PL3     PL3_DEVICE      E       ifdef(`_WIN32', `Postscript', `X Windows')

*
* MIRINFO is known as MIR here.
*
MIR     MIR_INFILE      F       end.01
MIR     MIR_TITLE       A       None
MIR     MIR_COMMENTS    A       None
MIR     MIR_OUTFILE     A       mirinfo.txt

*
* SOURCINFO is known as SRI here.
*
SRI     SRI_INFILE      F       end.00
SRI     SRI_TITLE       A       None
SRI     SRI_COMMENTS    A       None
SRI     SRI_OUTFILE     A       sourcinfo.txt

*
* MINMAX is known as MIN here.
*
MIN     MIN_INFILE      F       begin.dat
MIN     MIN_RAYOPTS     E       GOOD ONLY
MIN     MIN_OE_LOSS     I       1
MIN     MIN_COMMENTS    A       None

*
* PREREFL is known as PRL here.
*
PRL     PRL_COMPOSITION A       Au
PRL     PRL_DENSITY     R       19.3
PRL     PRL_ENERGY_MIN  R       100
PRL     PRL_ENERGY_MAX  R       500
PRL     PRL_ENERGY_STEP R       2
PRL     PRL_OUTFILE     F       au.refl

====================================================================              
I_SCREEN        AFTER           00      
I_SCREEN        BEFORE          01      

I_STOP          SLIT            00      
I_STOP          SOLID           01      

K_SLIT          RECTANGULAR     00      
K_SLIT          ELLIPTICAL      01      
K_SLIT          EXTERNAL        02      

FDISTR          FLAT            01              
FDISTR          UNIFORM         02              
FDISTR          GAUSSIAN        03              
FDISTR          SYNCHR          04              
FDISTR          CONICAL         05              
FDISTR          EXACT-SR        06       
FDISTR          PHASE-ELLIPSE   07   
               
FGRID           RAN/RAN         00       
FGRID           GRID/GRID       01       
FGRID           GRID/RAN        02       
FGRID           RAN/GRID        03       
FGRID           ELLI/RAN        04   
FGRID           ELLI/GRID       05   

F_WIGGLER       NONE            00   
F_WIGGLER       WIGGLER         01   
F_WIGGLER       UNDULATOR       02   
F_WIGGLER       ELLI_WIGG       03   

F_SR_TYPE       PHOTON          00   
F_SR_TYPE       POWER           01   

FMIRR           SPHERICAL       01              
FMIRR           ELLIPTICAL      02              
FMIRR           TOROIDAL        03              
FMIRR           PARABOLICAL     04              
FMIRR           PLANE           05              
FMIRR           CODLING SLIT    06              
FMIRR           HYPERBOLICAL    07              
FMIRR           CONICAL         08              
FMIRR           POLYNOMIAL      09    
FMIRR           EXTERNAL__NA    10              
FMIRR           SPLINE__NA      11              

FSHAPE          RECTANGLE       01              
FSHAPE          ELLIPSE         02              
FSHAPE          HOLE            03         

FSOUR           POINT           00              
FSOUR           RECTANGLE       01              
FSOUR           ELLIPSE         02              
FSOUR           GAUSSIAN        03              
FSOUR           PHASE-ELLIPSE   04   
FSOUR           DENSE-PLASMA    06
               
FSOURCE_DEPTH   OFF             01              
FSOURCE_DEPTH   UNIFORM         02              
FSOURCE_DEPTH   GAUSSIAN        03              
FSOURCE_DEPTH   SYNCHROTRON     04              
               
FSTAT           YES             01              
FSTAT           NO              00              

FWRITE          ALL             00
FWRITE          MIRROR          01
FWRITE          IMAGE           02
FWRITE          NONE            03

FZP             YES             01 
FZP             NO              00 

F_BOUND_SOUR    YES             01
F_BOUND_SOUR    NO              00

F_COHER         INCOHERENT      00   
F_COHER         COHERENT        01   
               
F_COLOR         OFF             00              
F_COLOR         SLINE           01              
F_COLOR         MLINE           02              
F_COLOR         CONTINUOUS      03              
F_COLOR         REL_MLINE       04              

F_CONVEX        CONCAVE         00              
F_CONVEX        CONVEX          01              
               
F_DEFAULT       DIFFERENT       00              
F_DEFAULT       COINCIDENT      01              
               
F_EXT           INTERNAL        00              
F_EXT           EXTERNAL        01              

F_EXIT_SHAPE    YES             01
F_EXIT_SHAPE    NO              00

F_FACET         ON              01
F_FACET         OFF             00

F_FAC_ORIENT    Y-AXIS          00
F_FAC_ORIENT    OTHER           01

F_POLSEL        FARTHEST        04
F_POLSEL        2ND FRTST       01
F_POLSEL        2ND CLSEST      02
F_POLSEL        CLOSEST         03

F_FAC_LATT      RECTANGLE       00
F_FAC_LATT      HEXAGONAL       01

F_GRATING       MIRROR          00              
F_GRATING       GRATING         01              

F_G_S           SINE            00              
F_G_S           GAUSSIAN        01              
F_G_S           SPLINE          02              

F_HUNT          FIRST           01      
F_HUNT          SECOND          02           

F_INC_MNOR_ANG  NO              00
F_INC_MNOR_ANG  YES             01
               
F_KOMA          OFF             00
F_KOMA          ON              01

F_KOMA_BOUNCE   NO              00
F_KOMA_BOUNCE   YES             01

F_KOMA_CA       OFF             00
F_KOMA_CA       ON              01

F_MONO          TGM             00              
F_MONO          ERG             01              
F_MONO          CIA             02              
F_MONO          CDA             03              
F_MONO          HUNTER          04

F_PHOT          eV              00         
F_PHOT          Angstroms       01         

F_PHOT_CENT     eV              00         
F_PHOT_CENT     Angstroms       01         
               
F_POL           TOTAL           03         
F_POL           PERPENDICULAR   02         
F_POL           PARALLEL        01         

F_PW            SPSP            00              
F_PW            PLSP            01              
F_PW            SPPL            02              
F_PW            PLPL            03              

F_PW_C          SPSP            00    
F_PW_C          CLSP            01    
F_PW_C          SPCL            02    
F_PW_C          CLCL            03    

F_REFL          FILE            00         
F_REFL          TT              01         
F_REFL          MLAYER          02    

F_REFLEC        OFF             00         
F_REFLEC        POLARIZED       01         
F_REFLEC        SCALAR          02         

F_REFRAC        REFLECTOR       00              
F_REFRAC        REFRACTOR       01              
F_REFRAC        EMPTY           02              

F_ROUGHNESS     ON              01
F_ROUGHNESS     OFF             00

F_RULING        CONSTANT        00              
F_RULING        UNIFORM         01              
F_RULING        HOLOG           02              
F_RULING        FANTYPE         03   
F_RULING        RESERVED        04    
F_RULING        POLYNOM         05   

F_RUL_ABS       ABSOLUTE        00   
F_RUL_ABS       SIGNED          01   

F_R_RAN         SINE            00   
F_R_RAN         GAUSSIAN        01   
               
F_SEGMENT       NO              00
F_SEGMENT       YES             01

F_SIDE          IMAGE           01              
F_SIDE          SOURCE          00              
               
F_TORUS         LOWER/OUTER     00              
F_TORUS         LOWER/INNER     01              
F_TORUS         UPPER/INNER     02              
F_TORUS         UPPER/OUTER     03              

F_VIRTUAL       R/R             00      
F_VIRTUAL       R/V             01      
F_VIRTUAL       V/R             02      
F_VIRTUAL       V/V             03      
               
STO_TYPE        STRING          01              
STO_TYPE        ENUMERATED      02              
STO_TYPE        INTEGER         03              
STO_TYPE        REAL            04              
STO_TYPE        YESNO           05              

PLX_IMAGE       Cont Plane      00
PLX_IMAGE       Mirr Plane      01
PLX_PLOT_WHAT   SOURCE          00
PLX_PLOT_WHAT   OE              01
PLX_PLOT_WHAT   SCREEN          02
PLX_RAYOPTS     GOOD ONLY       00
PLX_RAYOPTS     BAD ONLY        01
PLX_RAYOPTS     ALL RAYS        02
PLX_ROW_HORIZ   X               01
PLX_ROW_HORIZ   Y               02
PLX_ROW_HORIZ   Z               03
PLX_ROW_HORIZ   phase-X         04
PLX_ROW_HORIZ   phase-Y         05
PLX_ROW_HORIZ   phase-Z         06
PLX_ROW_HORIZ   PH-ENERGY       11
PLX_ROW_HORIZ   N-APERTURE      20
PLX_ROW_VERT    X               01
PLX_ROW_VERT    Y               02
PLX_ROW_VERT    Z               03
PLX_ROW_VERT    phase-X         04
PLX_ROW_VERT    phase-Y         05
PLX_ROW_VERT    phase-Z         06
PLX_ROW_VERT    PH-ENERGY       11
PLX_ROW_VERT    N-APERTURE      20
PLX_UNIT        cm-1            00
PLX_UNIT        eV              01
PLX_UNIT        Angstroms       02
PLX_SCALE_OPTS  Automatic       00
PLX_SCALE_OPTS  Cartesian       01
PLX_SCALE_OPTS  External        02
PLX_PLOT_TYPE   Scattered       00
PLX_PLOT_TYPE   Connected       01
PLX_PLOT_TYPE   Contour         02
PLX_DEVICE      X Windows       00
PLX_DEVICE      Postscript      02

PL2_IMAGE       Cont Plane      00
PL2_IMAGE       Mirr Plane      01
PL2_PLOT_WHAT   SOURCE          00
PL2_PLOT_WHAT   OE              00
PL2_PLOT_WHAT   SCREEN          01
PL2_RAYOPTS     GOOD ONLY       00
PL2_RAYOPTS     BAD ONLY        01
PL2_RAYOPTS     ALL RAYS        02
PL2_ROW_HORIZ   X               01
PL2_ROW_HORIZ   Y               02
PL2_ROW_HORIZ   Z               03
PL2_ROW_HORIZ   phase-X         04
PL2_ROW_HORIZ   phase-Y         05
PL2_ROW_HORIZ   phase-Z         06
PL2_ROW_HORIZ   PH-ENERGY       11
PL2_ROW_HORIZ   N-APERTURE      20
PL2_ROW_VERT    X               01
PL2_ROW_VERT    Y               02
PL2_ROW_VERT    Z               03
PL2_ROW_VERT    phase-X         04
PL2_ROW_VERT    phase-Y         05
PL2_ROW_VERT    phase-Z         06
PL2_ROW_VERT    PH-ENERGY       11
PL2_ROW_VERT    N-APERTURE      20
PL2_UNIT        cm-1            00
PL2_UNIT        eV              01
PL2_UNIT        Angstroms       02
PL2_SCALE_OPTS  Automatic       00
PL2_SCALE_OPTS  Cartesian       01
PL2_SCALE_OPTS  External        02
PL2_PLOT_TYPE   Scattered       00
PL2_PLOT_TYPE   Connected       01
PL2_PLOT_TYPE   Contour         02
PL2_DEVICE      X Windows       00
PL2_DEVICE      Postscript      02

PL3_IMAGE       Cont Plane      00
PL3_IMAGE       Mirr Plane      01
PL3_PLOT_WHAT   SOURCE          00
PL3_PLOT_WHAT   OE              00
PL3_PLOT_WHAT   SCREEN          01
PL3_RAYOPTS     GOOD ONLY       00
PL3_RAYOPTS     BAD ONLY        01
PL3_RAYOPTS     ALL RAYS        02
PL3_ROW_HORIZ   X               01
PL3_ROW_HORIZ   Y               02
PL3_ROW_HORIZ   Z               03
PL3_ROW_HORIZ   phase-X         04
PL3_ROW_HORIZ   phase-Y         05
PL3_ROW_HORIZ   phase-Z         06
PL3_ROW_HORIZ   PH-ENERGY       11
PL3_ROW_HORIZ   N-APERTURE      20
PL3_ROW_VERT    X               01
PL3_ROW_VERT    Y               02
PL3_ROW_VERT    Z               03
PL3_ROW_VERT    phase-X         04
PL3_ROW_VERT    phase-Y         05
PL3_ROW_VERT    phase-Z         06
PL3_ROW_VERT    PH-ENERGY       11
PL3_ROW_VERT    N-APERTURE      20
PL3_UNIT        cm-1            00
PL3_UNIT        eV              01
PL3_UNIT        Angstroms       02
PL3_SCALE_OPTS  Automatic       00
PL3_SCALE_OPTS  Cartesian       01
PL3_SCALE_OPTS  External        02
PL3_PLOT_TYPE   Scattered       00
PL3_PLOT_TYPE   Connected       01
PL3_PLOT_TYPE   Contour         02
PL3_DEVICE      X Windows       00
PL3_DEVICE      Postscript      02

MIN_RAYOPTS     GOOD ONLY       00
MIN_RAYOPTS     OE LOSSES       01
MIN_RAYOPTS     ALL RAYS        02

============================================================================              
AOE     OE_NUMBER       I       0              
ASC     SCR_NUMBER      I       1              
D       NAME            A              
D       OWN1            I       1              
D       OWN2            I       1              
D       REC             A              
DOE     OE_NUMBER       I       0              
DSC     SCR_NUMBER      I       1              
LS      DIR_NAME        A       ./
LS      FILE_NAME       A       start   
LS      OLD_OE          I       0   
LS      CUR_OE          I       0              
LS      NEW_OE          I       0              
GTO     NUMB            I       1   
RSC     NEW_SCR         I       1              
RSC     OLD_SCR         I       1              
SOE     OE_NUMBER       I       0              
SSC     SCR_NUMBER      I       0              
XM      MENU_NAME       A              
=============================================================================              
?                               -1              
DEFINE          OE              0401              
DEFINE          SCREEN          0501              
DELETE          OE              0202              
DELETE          SCR             0203              
DIRECTORY                       -3              
EXECUTE         MENU            0601              
GOTO                            1201      
HELP                            -1              
LIST                            1100       
LIST            SCREEN          1101       
LOAD                            0801              
LOAD            OE              0802              
LOAD            SOURCE          0803              
LOAD            SYSTEM          0801              
SAVE                            0901              
SAVE            OE              0902              
SAVE            SOURCE          0903              
SAVE            SYSTEM          0901              
SELECT          OE              0302   
SELECT          SCREEN          0303   
SELECT          SOURCE          0301   
SPAWN                           -2              
VERSION                         -4              
==============================================================================              
*234567890123456789012345678901234567890123456789012345678901234567890123456789 
*          Y   (Read only column)
*

HLPM MENUROOT:HMENU                                                  Menu              
HLPC MENUROOT:HCOMMAND                                               Command              
MENU OE         OE_DATA                 MAIN MENU
DATA OE         FWRITE                  Files to write out
DATA OE         T_SOURCE                Source plane distance              
DATA OE         T_IMAGE                 Image  plane distance              
DATA OE         T_INCIDENCE             Incidence  angle         
DATA OE         T_REFLECTION            Reflection angle         
DATA OE         F_ANGLE                 Write out Inc/Ref angles
DATA OE         ALPHA                   Mirror Orientation Angle        
DATA OE         FILE_SOURCE             Source file                        
TEXT                 >>>  Sub-menus <<<
DATA OE         F_REFRAC                Type of element                  REFRAC   
DATA OE         FMIRR                   Figure                           MSETUP              
DATA OE         F_GRATING               Diffraction                      GRATING              
DATA OE         F_CRYSTAL               Crystal                          CRYSTAL    
DATA OE         F_MOVE                  Mirror movement                  MOVMIR              
DATA OE         FSLIT                   Exit Slit                        SLIT    
DATA OE         FDUMMY                  Modified Surface                 ERROR
DATA OE         FSTAT                   Source Movement                  MOVSOUR    
DATA OE         GOTO_OE                     Goto OE                      OE_DATA              

MENU OE         REFRAC                  Refractive Index   
SET     %A      OE      F_REFRAC        EQ              REFRACTOR 
SET     %B      OE      F_CRYSTAL       NE              YES
SET     %C      %A                      AND     %B
SKIP   
DATA OE  C      R_IND_OBJ               in object space 
DATA OE  C      R_IND_IMA               in image  space   
DATA OE         FZP                     Fresnel Zone Plate 

MENU OE         SLIT                    Exit slit    
SET     %A      OE      FSLIT           EQ              YES 
DATA OE  A      SLLEN                   Slit length ( Sagittal )    
DATA OE  A      SLWID                        width  ( Tangential )    
DATA OE  A      SLTILT                       tilt   ( CCW )    

MENU OE         CRYSTAL                 Crystal Specifications 
SET     %A      OE      F_CRYSTAL       EQ              YES
SET     %B      OE      F_MOSAIC        EQ              YES
SET     %C      OE      F_MOSAIC        NE              YES
SET     %D      OE      F_CENTRAL       EQ              YES    
SET     %X      OE      F_PHOT_CENT     EQ              EV    
SET     %Y      OE      F_PHOT_CENT     NE              EV    
SET     %L      OE      F_REFRAC        EQ              REFRACTOR 
SET     %K      %A                      AND     %D
DATA OE  A      FILE_REFL               File with crystal parameters  
DATA OE  A      F_REFLEC                Reflectivity mode 
DATA OE  AY     F_CENTRAL               Auto setting    
DATA OE  KY     F_PHOT_CENT             Units in use    
SET     %W      %K                      AND     %X
SET     %Z      %K                      AND     %Y
DATA OE  W      PHOT_CENT               Set photon energy    
DATA OE  Z      R_LAMBDA                         wavelength    
DATA OE  FY     F_BRAGG_A               Asymmetric cut
DATA OE  SY     F_JOHANSSON             Johansson Geometry
DATA OE  AY     F_MOSAIC                Mosaic crystal
SET     %E      %A                      AND     %B
SET     %F      %A                      AND     %C
SET     %G      OE      F_BRAGG_A       EQ              YES
SET     %H      OE      F_JOHANSSON     EQ              YES
SET     %I      %F                      AND     %G
SET     %J      %S                      AND     %H
SET     %N      %A                      AND     %L
SET     %O      OE      F_REFRAC        NE              REFRACTOR
SET     %Q      %I                      AND     %L
SET     %S      %F                      AND     %O
SET     %T      %E                      OR      %N
DATA OE  I      A_BRAGG                 Planes angle [ deg ]
DATA OE  Q      ORDER                   Below[-1]/onto[1] bragg planes
DATA OE  J      R_JOHANSSON             Johansson Radius
DATA OE  E      SPREAD_MOS              Angle spread FWHM [ deg ]
DATA OE  T      THICKNESS               Thickness [ cm ]
DATA OE  E      MOSAIC_SEED             Seed for mosaic [ > 10^5 ]

MENU OE         MSETUP                  OE specifications  
SET     %B      OE      FCYL            EQ              YES    
DATA OE         F_EXT                   Mirror parameters                MIRPAR              
DATA OE         F_CONVEX                Surface curvature    
DATA OE   Y     FCYL                    Cylindrical              
DATA OE  B      CIL_ANG                  orient.  [ CCW from X axis ]    
DATA OE         F_REFLEC                Reflectivity                     REFLEC              
DATA OE         FHIT_C                  Limits check                     SHAPE              
               
MENU OE         MIRPAR                  Mirror Parameters              
SET     %I      OE      FMIRR           EQ              SPLINE    
SET     %J      OE      FMIRR           EQ              POLYNOM    
SET     %L      %I                      OR      %J    
SET     %K      OE      FMIRR           EQ              EXTERNAL    
SET     %E      OE      FMIRR           EQ              CODLING SLIT 
SET     %P      OE      F_DEFAULT       EQ              DIFFERENT 
SET     %Q      OE      F_EXT           EQ              EXTERNAL 
SET     %A      OE      FMIRR           EQ              PARABOL              
SET     %C      OE      FMIRR           EQ              TOROIDAL              
DATA OE   Y     FMIRR                   Type selected              
DATA OE  Q      DUMMY                   External parameters def`'ine       MIRRDEF   
DATA OE   Y     F_DEFAULT               Focii and Continuation Planes     
DATA OE  P      SSOUR                   Object side focal distance       
DATA OE  P      SIMAG                   Image side focal distance       
DATA OE  P      THETA                   Incidence angle              
DATA OE  L      FILE_MIR                File with SPLINE/ POLYNOMIAL          
DATA OE  A      F_SIDE                  Focus location              
DATA OE  C      F_TORUS                 Toroidal mirror pole location            
DATA OE  E      COD_LEN                 Codling Slit length              
DATA OE  E      COD_WID                              width              

MENU OE         MIRRDEF                 External parameters   
SET     %A      OE      FMIRR           EQ              PARABOL              
SET     %B      OE      FMIRR           EQ              ELLIPTI       
SET     %C      OE      FMIRR           EQ              PLANE       
SET     %D      OE      FMIRR           EQ              SPHERIC       
SET     %E      OE      FMIRR           EQ              CODLING       
SET     %F      OE      FMIRR           EQ              TOROIDA       
SET     %G      OE      FMIRR           EQ              HYPERBO       
SET     %H      OE      FMIRR           EQ              CONICAL       
SET     %I      %B                      OR      %G    
DATA OE   Y     FMIRR                   Type selected              
DATA OE  D      RMIRR                   Spherical radius              
*
* Workaround for "same variable name" bug. See below.
*
DATA OE  I      AXMAJ                   Ellipse/Hyperbola major Axis 
DATA OE  I      AXMIN                              minor axis    
DATA OE  I      ELL_THE                 Angle of MajAx and Pole [CCW]    
*
* There is a bug that causes neither Elliptical nor Hyperbolical params
* to show up since both have the same variable names. FIXME.
*DATA OE  B      AXMAJ                   Ellipse major Axis              
*DATA OE  B      AXMIN                            minor Axis              
*DATA OE  B      ELL_THE                 Angle of MajAx and Pole [CCW]    
*
DATA OE  A      PARAM                   Paraboloid param.              
*
* There is a bug that causes neither Elliptical nor Hyperbolical params
* to show up since both have the same variable names. FIXME.
*DATA OE  G      AXMAJ                   Hyperbola major Axis              
*DATA OE  G      AXMIN                              minor axis    
*DATA OE  G      ELL_THE                 Angle of MajAx and Pole [CCW]    
*
DATA OE  F      R_MAJ                   Torus major Radius              
DATA OE  F      R_MIN                          minor Radius              
DATA OE  H      CONE_A                  Cone half-aperture [deg]              

MENU OE         MOVMIR                  Displacements              
SET     %A      OE      F_MOVE          EQ              YES 
DATA OE    Y    F_MOVE                  Mirror moved              
DATA OE  A      OFFX                    Mirror Offset X              
DATA OE  A      OFFY                                   Y              
DATA OE  A      OFFZ                                    Z              
DATA OE  A      X_ROT                   Mirror Rotat. X              
DATA OE  A      Y_ROT                                  Y              
DATA OE  A      Z_ROT                                   Z              

MENU OE         MOVSOUR                 Source Movements    
SET     %A      OE      FSTAT           EQ              YES 
DATA OE    Y    FSTAT                   Source moved    
DATA OE  A      RTHETA                  Angle of incidence     
DATA OE  A      RDSOUR                  Distance from mirror    
DATA OE  A      ALPHA_S                 Z-rotation      
SKIP 
*        1         2         3         4         5         6         7
*234567890123456789012345678901234567890123456789012345678901234567890
TEXT                                    In MIRROR reference frame:    
DATA OE  A      OFF_SOUX                  offset X              
DATA OE  A      OFF_SOUY                           Y              
DATA OE  A      OFF_SOUZ                             Z              
TEXT                                    In SOURCE reference frame:    
DATA OE  A      X_SOUR                    offset X    
DATA OE  A      Y_SOUR                            Y    
DATA OE  A      Z_SOUR                             Z    
DATA OE  A      X_SOUR_ROT                rotation [ CCW ] around X    
DATA OE  A      Y_SOUR_ROT                                         Y    
DATA OE  A      Z_SOUR_ROT                                          Z    
               
MENU OE         ERROR                   Surface Changes
SET     %A      OE      FDUMMY          EQ              YES 
SKIP
DATA OE  A      F_RIPPLE                Surface error                    RIPPLE
DATA OE  A      F_FACET                 Faceted Surface                  FACET 
DATA OE  A      F_ROUGHNESS             Surface Roughness                ROUGH
DATA OE  A      F_KOMA                  Kumakhov lens                    KOMA
DATA OE  A      F_SEGMENT               Segmented Mirror                 SEGMENT

MENU OE         RIPPLE                  Surface Quality              
SET     %A      OE      F_RIPPLE        EQ              YES 
SET     %B      OE      F_G_S           EQ              SINE 
SET     %C      OE      F_G_S           EQ              GAUSSIAN 
SET     %D      OE      F_G_S           EQ              SPLINE 
SET     %E      %C                      OR      %D    
SET     %F      %A                      AND     %E    
SET     %G      %A                      AND     %B    
DATA OE  AY     F_G_S                   Type of defect              
DATA OE  F      FILE_RIP                File-name              
DATA OE  G      X_RIP_WAV               Ripple Wavel. X              
DATA OE  G      Y_RIP_WAV                              Y              
DATA OE  G      X_RIP_AMP                      Ampli. X              
DATA OE  G      Y_RIP_AMP                              Y              
DATA OE  G      X_PHASE                        Phase  X              
DATA OE  G      Y_PHASE                                Y              
               
MENU OE         FACET                   Faceted Mirror
SET     %A      OE      F_FACET         EQ              YES
SKIP
DATA OE    Y    F_FACET                 Facets selection
DATA OE  A      FILE_FAC                File w/ facet descr.
DATA OE  A      F_FAC_LATT              Lattice type
DATA OE  A      F_FAC_ORIENT            Orientation
DATA OE  A      F_POLSEL                Intercept to use
TEXT                                    In X-direction ------
DATA OE  A      IFAC_X                  Number of facets
DATA OE  A      RFAC_LENX               Facet width
DATA OE  A      RFAC_PHAX                     phase  (0-360)
DATA OE  A      RFAC_DELX1              Dead width   (abs, for -X)
DATA OE  A      RFAC_DELX2                           (abs, for +X)
TEXT                                    In Y-direction ------
DATA OE  A      IFAC_Y                  Number of facets
DATA OE  A      RFAC_LENY               Facet width  (in Y)
DATA OE  A      RFAC_PHAY                     phase  (0-360)
DATA OE  A      RFAC_DELY1              Dead width   (abs, for -Y)
DATA OE  A      RFAC_DELY2                           (abs, for +Y)

MENU OE         ROUGH                   Scattering
SET     %A      OE      F_ROUGHNESS     EQ              YES
SKIP
DATA OE    Y    F_ROUGHNESS             Surface Roughness
DATA OE  A      FILE_ROUGH              File w/ power spec. dens. fn
DATA OE  A      ROUGH_Y                 Roughness RMS in Y (Angstroms)
DATA OE  A      ROUGH_X                 Roughness RMS in X (Angstroms)

MENU OE         KOMA                    Kumakhov Lens
SET     %A      OE      F_KOMA          EQ              YES
SET     %B      OE      F_KOMA_CA       EQ              YES
SET     %C      OE      F_KOMA_CA       EQ              NO
SKIP
DATA OE    Y    F_KOMA                  Kumakhov lens selection
SKIP
DATA OE  AY     F_KOMA_CA               Specify r(z)^2 (Y/N)
DATA OE  C      FILE_KOMA               File with parameters(r(z))
DATA OE  B      FILE_KOMA_CA            File with parameters(r(z)^2)
SKIP
DATA OE  A      F_KOMA_BOUNCE           Save intercept and bounces

MENU OE         SEGMENT                 Segmented Mirror
SET     %A      OE      F_SEGMENT       EQ              YES
SKIP
DATA OE    Y    F_SEGMENT               Segmented Mirror selection
SKIP
DATA OE  A      ISEG_XNUM               Number of segments (X)
DATA OE  A      ISEG_YNUM               Number of segments (Y)
DATA OE  A      SEG_LENX                Length of segments (X)
DATA OE  A      SEG_LENY                Length of segments (Y)
DATA OE  A      FILE_SEGMENT            File w/ orientations
DATA OE  A      FILE_SEGP               File w/ polynomial

MENU            SOURCE                  Source Definition              
*        1         2         3         4         5         6         7
*234567890123456789012345678901234567890123456789012345678901234567890
*          Y   (Read only column)
DATA SRC   Y    FILE_SOURCE             File to store the rays             
DATA SRC        FGRID                   Source Type                      SRCMODE      
DATA SRC        NPOINT                  Number of random rays            OPTIM 
DATA SRC        F_WIGGLER               Wiggler,undulator,elli_wigg      WIGGLE 
DATA SRC        FSOUR                   Spatial Type                     SPATIAL              
DATA SRC        FSOURCE_DEPTH           Depth   
DATA SRC        FDISTR                  Angle Distribution               ANGLE              
DATA SRC        F_COLOR                 Photon Energy distribution       ENERGY      
DATA SRC        F_OPD                   Store optical path                      
DATA SRC        F_POLAR                 Polarization                     AVECT     
DATA SRC        F_COHER                 Coherence                           

MENU            OPTIM                   Source Optimization
SET     %A      SRC     FGRID           EQ              RAN/RAN
SET     %B      SRC     F_BOUND_SOUR    EQ              YES
SET     %C      %A                      AND     %B      
DATA SRC AY     F_BOUND_SOUR            Optimization of source
DATA SRC B      FILE_BOUND              File-name

MENU            SRCMODE                 Source Modelling                         
SET     %A      SRC     FDISTR          EQ              CONICAL   
SET     %Z      SRC     FDISTR          NE              CONICAL   
SET     %W      SRC     FSOUR           NE              POINT   
SET     %B      SRC     FGRID           EQ              GRID/GRID   
SET     %C      SRC     FGRID           EQ              RAN/GRID   
SET     %R      SRC     FGRID           EQ              RAN/RAN   
SET     %S      SRC     FGRID           EQ              GRID/RAN   
SET     %J      SRC     FGRID           EQ              ELLI/RAN                   
SET     %K      SRC     FGRID           EQ              ELLI/GRID                  
SET     %T      SRC     FSOURCE_DEPTH   NE              OFF                        
SET     %L      %J                      OR      %K                                 
SET     %D      %B                      OR      %C                                
SET     %F      %S                      OR      %R                                 
SET     %G      %F                      OR      %C                                
SET     %O      %G                      OR      %J                              
SET     %H      %B                      OR      %S                                 
SET     %N      %H                      AND     %W                                
SET     %I      %N                      AND     %T                                
SET     %Y      %Z                      AND     %D                                 
SET     %E      %A                      AND     %D                                
DATA SRC  Y     FGRID                   Mode selected     
DATA SRC O      NPOINT                  Number of random rays      
DATA SRC O      ISTAR1                  Random number seed   
SKIP     
TEXT                                    ... GRID part     
SKIP     
DATA SRC N      IDO_X_S                 Points along X      
DATA SRC I      IDO_Y_S                               Y      
DATA SRC N      IDO_Z_S                                Z      
DATA SRC Y      IDO_VX                               VX      
DATA SRC Y      IDO_VZ                                VZ      
DATA SRC E      N_CONE                  Points along cone radius   
DATA SRC E      N_CIRCLE                                  circle   
SKIP 
DATA SRC L      IDO_XL                  No. of X phase space ellipse     SLX        
DATA SRC L      IDO_ZL                         Z                         SLZ        
DATA SRC K      IDO_XN                  Points along each X ellipse               
DATA SRC K      IDO_ZN                                    Z                      
SKIP
MENU            SLX                     X phase space ellipses   
SET     %J      SRC     FGRID           EQ              ELLI/RAN   
SET     %K      SRC     FGRID           EQ              ELLI/GRID   
SET     %P      %J                      OR      %K   
DATA SRC P      IDO_XL                      no. of ellipses   
DATA SRC P      SIGMAX                      sigma X       
DATA SRC P      SIGDIX                      sigma X' [ rad ]   
DATA SRC P      SIGXL1                      sigma level 1   
DATA SRC P      SIGXL2                                  2   
DATA SRC P      SIGXL3                                  3   
DATA SRC P      SIGXL4                                  4   
DATA SRC P      SIGXL5                                  5   
DATA SRC P      SIGXL6                                  6   
DATA SRC P      SIGXL7                                  7   
DATA SRC P      SIGXL8                                  8   
DATA SRC P      SIGXL9                                  9   
DATA SRC P      SIGXL10                                 10   

MENU            SLZ                     Z phase space ellipses   
SET     %J      SRC     FGRID           EQ              ELLI/RAN   
SET     %K      SRC     FGRID           EQ              ELLI/GRID   
SET     %L      %J                      OR      %K   
DATA SRC L      IDO_ZL                      no. of ellipses   
DATA SRC L      SIGMAZ                      sigma Z       
DATA SRC L      SIGDIZ                      sigma Z' [ rad ]   
DATA SRC L      SIGZL1                      sigma level 1   
DATA SRC L      SIGZL2                                  2   
DATA SRC L      SIGZL3                                  3   
DATA SRC L      SIGZL4                                  4   
DATA SRC L      SIGZL5                                  5   
DATA SRC L      SIGZL6                                  6   
DATA SRC L      SIGZL7                                  7   
DATA SRC L      SIGZL8                                  8   
DATA SRC L      SIGZL9                                  9   
DATA SRC L      SIGZL10                                 10   

MENU            WIGGLE                  Wiggler specification 
SET     %P      SRC     F_WIGGLER       EQ              WIGGLER 
SET     %Q      SRC     F_WIGGLER       EQ              UNDULATOR 
SET     %S      SRC     F_WIGGLER       EQ              ELLI_WIGG
SET     %T      %P                      OR      %S   
SET     %R      %Q                      OR      %T   
DATA SRC R      FILE_TRAJ               External file 
DATA SRC T      CONV_FACT               Conversion factor 
SKIP 
TEXT                                    Electron emit. [rads*user units] 
DATA SRC R      EPSI_X                    Emittance in X 
DATA SRC R      EPSI_Z                                 Z 
DATA SRC R      EPSI_DX                   Device's center from X waist 
DATA SRC R      EPSI_DZ                                        Z 
SKIP 
DATA SRC R      F_POL                   Polarization component 

MENU            SPATIAL                 Source Spatial Characteristics        
DATA SRC  Y     FSOUR                   Source type     
DATA SRC  Y     FSOURCE_DEPTH            Depth     
SET     %A      SRC     FSOUR           EQ              ELLIPSE     
SET     %B      SRC     FSOUR           EQ              RECTANGLE     
SET     %C      SRC     FSOUR           EQ              GAUSSIAN     
SET     %D      SRC     FSOURCE_DEPTH   EQ              GAUSSIAN     
SET     %E      SRC     FSOURCE_DEPTH   EQ              UNIFORM     
SET     %J      SRC     FGRID           EQ              ELLI/RAN   
SET     %K      SRC     FGRID           EQ              ELLI/GRID   
SET     %G      SRC     F_WIGGLER       NE              NONE 
SET     %N      SRC     FSOUR           EQ              DENSE-PLASMA
SET     %H      %G                      OR      %C  
SET     %L      %J                      OR      %K  
SET     %P      %L                      OR      %H  
SET     %F      %A                      OR      %B  
DATA SRC F      WXSOU                      width  [ X ]     
DATA SRC F      WZSOU                      height [ Z ]     
DATA SRC E      WYSOU                      depth  [ Y ]     
DATA SRC P      SIGMAX                  sigma X     
DATA SRC P      SIGMAZ                  sigma Z     
DATA SRC D      SIGMAY                  sigma Y     
DATA SRC N      PLASMA_ANGLE            Source cone full opening (radians)

MENU            AVECT                   Source Polarization     
SET     %A      SRC     F_POLAR         EQ              ON    
SET     %C      SRC     FDISTR          EQ              SYNCHR     
SET     %D      SRC     FDISTR          EQ              EXACT-SR     
SET     %E      %C                      OR      %D   
DATA SRC  Y     F_POLAR                 Polarization   
DATA SRC A      POL_ANGLE               Phase difference   
DATA SRC A      POL_DEG                 Polarization degree     
DATA SRC E      F_POL                   Component type (synchr.)         SYNCHR      

MENU            ANGLE                   Source Angle Distribution      
SET     %A      SRC     FDISTR          EQ              FLAT     
SET     %B      SRC     FDISTR          EQ              UNIFORM     
SET     %C      SRC     FDISTR          EQ              GAUSSIAN     
SET     %D      SRC     FDISTR          EQ              SYNCHR     
SET     %E      SRC     FDISTR          EQ              CONICAL     
SET     %F      SRC     FDISTR          EQ              EXACT-SR     
SET     %Q      SRC     FGRID           EQ              ELLI/RAN   
SET     %N      SRC     FGRID           EQ              ELLI/GRID   
SET     %O      %Q                      OR      %N   
SET     %P      %O                      OR      %C   
SET     %K      %F                      OR      %D     
SET     %G      %A                      OR      %B     
SET     %L      %G                      OR      %K     
SET     %H      %L                      OR      %C   
DATA SRC  Y     FDISTR                  Angle distribution               SYNCHR     
SKIP     
TEXT                                    Use RADIANS for angles here.     
TEXT                                    Use ABSOLUTE values.   
DATA SRC H      HDIV1                   Horizontal divergence [X(+)]     
DATA SRC H      HDIV2                                         [X(-)]     
DATA SRC H      VDIV1                   Vertical   divergence [Z(+)]     
DATA SRC H      VDIV2                                         [Z(-)]     
DATA SRC E      CONE_MIN                Cone internal half-aperture         
DATA SRC E      CONE_MAX                     external                  
DATA SRC P      SIGDIX                  Horizontal Sigma      [ X ]     
DATA SRC P      SIGDIZ                  Vertical Sigma        [ Z ]     

MENU            SYNCHR                  Synchrotron Machine Description     
SET     %B      SRC     FDISTR          EQ              SYNCHR     
SET     %C      SRC     FDISTR          EQ              EXACT-SR   
SET     %A      %B                      OR      %C   
DATA SRC  Y     FDISTR                  Source selected     
TEXT                                    Emittances: [ rads*OE units ]     
DATA SRC A      EPSI_X                  Electron Beam X emittance     
DATA SRC A      EPSI_Z                                Z     
DATA SRC A      EPSI_DX                 Distance from X waist     
DATA SRC A      EPSI_DZ                               Z     
SKIP     
DATA SRC A      BENER                   Electron Beam Energy [ GeV ]     
DATA SRC A      R_MAGNET                Orbit radius         [ m   ]     
DATA SRC A      R_ALADDIN               Orbit rad. [ same units as OE ]     
SKIP
DATA SRC B      F_SR_TYPE               Distribution type        
SKIP     
DATA SRC A      F_POL                   Polarization selected     

MENU            ENERGY                  Source Photon Energy     
SET     %A      SRC     F_COLOR         NE              OFF     
SET     %B      SRC     F_COLOR         EQ              SLINE     
SET     %C      SRC     F_COLOR         EQ              MLINE     
SET     %D      SRC     F_COLOR         EQ              CONTINUOUS     
SET     %J      SRC     F_COLOR         EQ              REL_MLINE
SET     %S      SRC     FDISTR          NE              EXACT-SR   
SET     %E      %D                      OR      %C     
SET     %E      %E                      OR      %J     
SET     %G      %E                      OR      %B   
SET     %K      %C                      OR      %J   
SET     %H      %K                      AND     %S   
SET     %I      %E                      AND     %S   
SKIP     
DATA SRC  Y     F_COLOR                 Energy distribution     
DATA SRC A      F_PHOT                  Units      
DATA SRC H      N_COLOR                 Number of lines to use     
DATA SRC G      PH1                     Line # 1     
DATA SRC I      PH2                            2     
DATA SRC H      PH3                            3     
DATA SRC H      PH4                            4     
DATA SRC H      PH5                            5     
DATA SRC H      PH6                            6     
DATA SRC H      PH7                            7     
DATA SRC H      PH8                            8     
DATA SRC H      PH9                            9     
DATA SRC H      PH10                          10     
SKIP     
DATA SRC J      F_COLOR                 Relative Intensities             RELINT

MENU            RELINT                  Relative Multi-line
SET     %A      SRC     F_COLOR         EQ              REL_MLINE
SKIP     
DATA SRC  Y     F_COLOR                 Energy distribution     
DATA SRC AY     F_PHOT                  Units      
DATA SRC AY     N_COLOR                 Number of lines to use     
DATA SRC A      RL1                     Line # 1     
DATA SRC A      RL2                            2     
DATA SRC A      RL3                            3     
DATA SRC A      RL4                            4     
DATA SRC A      RL5                            5     
DATA SRC A      RL6                            6     
DATA SRC A      RL7                            7     
DATA SRC A      RL8                            8     
DATA SRC A      RL9                            9     
DATA SRC A      RL10                          10     

MENU OE         SHAPE                   Mirror Shape              
SET     %A      OE      FHIT_C          EQ              ON 
SET     %B      OE      FSHAPE          NE              ELLIPSE    
SET     %C      %B                      AND     %A      
DATA OE   Y     FSHAPE                  Shape selected    
SKIP    
TEXT                                    Mirror dimensions along axis:     
TEXT                                    use ABSOLUTE values.    
SKIP    
TEXT                                      rectangle   /  ellipse    
SKIP    
DATA OE  C      RWIDX1                  X(+) Half Width / Int Maj Ax              
DATA OE  A      RWIDX2                  X(-)            / Ext Maj Ax              
DATA OE  C      RLEN1                   Y(+)            / Int Min Ax              
DATA OE  A      RLEN2                   Y(-)            / Ext Min Ax              
               
MENU OE         REFLEC                  Optical Constants              
DATA OE    Y    F_REFLEC                Reflectivity mode              
SET     %A      OE      F_REFLEC        EQ              SCALAR      
SET     %B      OE      F_REFLEC        EQ              POLARIZED           
SET     %C      %B                      OR      %A      
SET     %D      OE      F_REFL          EQ              FILE      
SET     %X      %C                      AND     %D      
SET     %L      OE      F_REFL          EQ              MLAYER    
SET     %U      %C                      AND     %L    
SET     %N      %U                      OR      %X    
SET     %E      OE      F_REFL          EQ              TT      
SET     %Z      %E                      AND     %C      
SET     %S      OE      F_REFRAC        EQ              REFRACTOR   
SET     %T      %Z                      OR      %S   
DATA OE  CY     F_REFL                  Source of Reflectivity  
DATA OE  N      FILE_REFL               File name              
DATA OE  U      F_THICK                 Mlayer thick. vary as cosine from pole
DATA OE  T      ALFA                    Alfa              
DATA OE  Z      GAMMA                   Gamma              
               
MENU OE         GRATING                 Define grating              
SET     %P      OE      F_GRATING       EQ              GRATING 
SET     %A      OE      F_RULING        EQ              CONSTANT              
SET     %L      OE      F_RULING        EQ              UNIFORM 
SET     %H      OE      F_RULING        EQ              FANTYPE    
SET     %I      OE      F_RULING        EQ              POLYNOM   
SET     %J      %A                      OR      %L 
SET     %N      %H                      OR      %I 
SET     %K      %J                      OR      %N    
SET     %O      %K                      AND     %P    
SET     %B      OE      F_CENTRAL       EQ              YES              
SET     %C      OE      F_CENTRAL       EQ              NO              
SET     %D      OE      F_PHOT_CENT     EQ              EV    
SET     %E      OE      F_PHOT_CENT     NE              EV    
SET     %F      %D                      AND     %B    
SET     %G      %E                      AND     %B    
DATA OE  PY     F_RULING                Ruling type                      HOLOG          
DATA OE  H      DIST_FAN                Grooves Pole distance        
DATA OE  H      AZIM_FAN                             azimuth    
DATA OE  H      COMA_FAC                Coma correction factor    
DATA OE  O      RULING                  Lines/CM (at origin)             
TEXT                                    Polynomial line density coeff:   
DATA OE  I      RUL_A1                      linear   
DATA OE  I      RUL_A2                      quadratic   
DATA OE  I      RUL_A3                      third power   
DATA OE  I      RUL_A4                      fourth power   
DATA OE  I      F_RUL_ABS               Signed/Absolute   
DATA OE  PY     F_CENTRAL               Auto tuning          
DATA OE  P      ORDER                   Diffraction order          
DATA OE  BY     F_PHOT_CENT             Energy/wavelength         
DATA OE  G      R_LAMBDA                            at Angs.       
DATA OE  F      PHOT_CENT                           at eV.        
DATA OE  B      F_MONO                  Mount type                       HUNTER      

MENU OE         HUNTER                  Define Hunter Monochromator      
SET     %A      OE      F_MONO          EQ              HUNTER    
DATA OE  A      BLAZE                   Blaze angle [ degrees ]      
DATA OE  A      F_HUNT                  Grating selected    
DATA OE  A      HUNT_L                  Monochromator length      
DATA OE  A      HUNT_H                  Distance between beams       
               
MENU OE         HOLOG                   Define hologram          
SET     %A      OE      F_RULING        EQ              HOLOG    
DATA OE  A      HOLO_R1                 "left"  distance (cm)              
DATA OE  A      HOLO_DEL                        incidence angle     
DATA OE  A      HOLO_RT1                        azimuth from +Y [CCW]    
DATA OE  A      HOLO_R2                 "right" distance (cm)              
DATA OE  A      HOLO_GAM                        incidence angle             
DATA OE  A      HOLO_RT2                        azimuth from +Y [CCW]    
TEXT                                    SP = spherical, PL = plane     
DATA OE  A      F_PW                    Pattern type              
TEXT                                    V = virtual, R = real    
DATA OE  A      F_VIRTUAL               Source type      
TEXT                                    SP = spherical, CL = cylinder    
DATA OE  A      F_PW_C                  Cylindrical source        
DATA OE  A      HOLO_W                  Recording wavelength (Angs.)       
               
MENU            LOAD_ALL                Load Optical System Description              
DATA LS         DIR_NAME                Directory name              
DATA LS         FILE_NAME               File name              
               
MENU            LOAD_SOURCE             Load Source Description              
DATA LS         DIR_NAME                Directory name              
DATA LS         FILE_NAME               File name              
               
MENU            LOAD_OE                 Load Optical Element Description              
TEXT                                    The file is specified as xxxxx.yy,    
TEXT                                    where xxxxx is the root, yy the    
TEXT                                    position counter in the system   
DATA LS         DIR_NAME                Directory name              
DATA LS         FILE_NAME               OLD File name              
DATA LS         OLD_OE                  Disk file number  [ 1-10 ]   
DATA LS         NEW_OE                  NEW OE number in the current OS   
               
MENU            SAVE_ALL                Save Optical System Description              
DATA LS         DIR_NAME                Directory name              
DATA LS         FILE_NAME               File name              
               
MENU            SAVE_SOURCE             Save Source Description              
DATA LS         DIR_NAME                Directory name              
DATA LS         FILE_NAME               File name              
               
MENU            SAVE_OE                 Save Optical Element Description              
TEXT                                    The file is specified as xxxxx.yy,    
TEXT                                    where xxxxx is the root, yy the    
TEXT                                    position counter in the system   
DATA LS         DIR_NAME                Directory name              
DATA LS         FILE_NAME                File name              
DATA LS         CUR_OE                  Current OE number     
DATA LS         NEW_OE                  Disk file number [ 1-10 ]   
               
MENU            MENU_NAME               Execute Menu Menu              
DATA XM         MENU_NAME               Menu Name              
               
MENU            ADD_OE                  Add Optical Element              
DATA AOE        OE_NUMBER               Element              
               
MENU OE         ADD_SCR                 Add Screen/Slit              
DATA ASC        SCR_NUMBER              Screen/Slit              
               
MENU            SEL_OE                  Select Optical Element              
DATA SOE        OE_NUMBER               Number of Element                   
               
MENU OE         SEL_SCR                 Select Screen/Slit              
DATA SSC        SCR_NUMBER              Screen/Slit                        

MENU            GOTOOE                  OE selection   
DATA GTO        NUMB                    New OE   
               
MENU SCR        SCR_DATA                View Screen/Slit Data              
SET     %A      SCR     I_SLIT          EQ              ON    
SET     %B      SCR     I_ABS           EQ              ON      
SET     %C      SCR     K_SLIT          NE              EXTERNAL      
SET     %D      SCR     K_SLIT          EQ              EXTERNAL
SET     %E      %A                      AND     %C
SET     %F      %A                      AND     %D
DATA SCR        I_SCREEN                Position rel. to mirror      
DATA SCR        SL_DIS                  Distance (abs) from mirror   
DATA SCR  Y     I_SLIT                  Aperturing   
DATA SCR A      I_STOP                  Open slit/ solid stop      
DATA SCR AY     K_SLIT                  Aperture shape      
DATA SCR E      RX_SLIT                 Slit width/  x-axis      
DATA SCR E      RZ_SLIT                 Slit heigth/ z-axis      
DATA SCR E      CX_SLIT                      center/  x-axis      
DATA SCR E      CZ_SLIT                      center/  z-axis      
DATA SCR F      FILE_SCR_EXT            External file with coordinates
DATA SCR  Y     I_ABS                   Absorption      
DATA SCR B      THICK                   Thickness [ CM ]   
DATA SCR B      FILE_ABS                Opt. Const. File-name      
SKIP      
DATA SCR        GOTO_SCR                    Goto Screen/Slit             SCR_D              
               
MENU            DELETE_OE               Delete Optical Element              
DATA DOE        OE_NUMBER               Optical Element              
               
MENU OE         DELETE_SCR              Delete Screen/Slit              
DATA DSC        SCR_NUMBER              Screen/Slit              

MENU            PLOTXY                  Plot SHADOW Results
SET     %E      PLX     PLX_ROW_HORIZ   EQ              PH-Energy
SET     %F      PLX     PLX_ROW_VERT    EQ              PH-Energy
SET     %G      %E                      OR      %F
*EXAMPL %F      %D                      AND     %B    
DATA PLX B      PLX_INFILE                 Image file (eg., begin.dat)
SKIP
DATA PLX        PLX_RAYOPTS             What rays to pick?
DATA PLX        PLX_COMMENTS            Any comments in output?
DATA PLX  Y     PLX_ROW_HORIZ           Column to plot in horizontal
DATA PLX  Y     PLX_ROW_VERT                       and in vertical
DATA PLX G      PLX_UNIT                What unit to choose
DATA PLX        PLX_SCALE_OPTS          What kind of scaling to use      PLX_SCALE
DATA PLX        PLX_DO_HIST             Draw the histograms?             PLX_HISTO
DATA PLX   Y    PLX_PLOT_TYPE           Kind of plot                     PLX_PLWHAT
TEXT                                    Other hairy options you can set  PLX_OPTS
changequote([, ])dnl
ifdef([_WIN32], [
SKIP
TEXT                                    If you choose X Window display,
TEXT                                    make sure your X Windows Server
TEXT                                    or your DISPLAY variable is set.
TEXT                                    If not, GUI will hang.
SKIP
])dnl
changequote(`, ')dnl
DATA PLX        PLX_DEVICE                    and the plotting device 

MENU            PLX_SCALE               Scaling options
SET     %A      PLX     PLX_SCALE_OPTS  EQ              EXTERNAL
DATA PLX  Y     PLX_SCALE_OPTS          What kind of scaling to use
SKIP
DATA PLX A      PLX_EXT_HMIN            External horizontal min
DATA PLX A      PLX_EXT_HMAX                     horizontal max
DATA PLX A      PLX_EXT_VMIN                     vertical max
DATA PLX A      PLX_EXT_VMAX                     vertical max

MENU            PLX_OPTS                Other hairy PLOTXY options
DATA PLX   Y    PLX_HAIRLINE            Hairline at [0,0]?
DATA PLX   Y    PLX_OVL_MIRROR          Overlay mirror/slit?

MENU            PLX_HISTO               Histogram options
*EXAMPL %F      %D                      AND     %B    
SET     %A      PLX     PLX_DO_HIST     EQ              YES
SET     %B      PLX     PLX_HIST_LIM    EQ              YES
SET     %C      %A                      AND     %B
DATA PLX  Y     PLX_DO_HIST             Draw the histograms? 
DATA PLX A      PLX_HIST_XBINS            Number of bins in X
DATA PLX A      PLX_HIST_YBINS            Number of bins in Y
SKIP
DATA PLX AY     PLX_HIST_LIM            Specify limits
DATA PLX C      PLX_HIST_XCTR               X Center
DATA PLX C      PLX_HIST_XWID                 Width
DATA PLX C      PLX_HIST_YCTR               Y Center
DATA PLX C      PLX_HIST_YWID                 Width


MENU            MIRINFO                 Get Mirror Information
DATA MIR        MIR_INFILE              Input file (eg., end.01)
DATA MIR        MIR_TITLE               Specify a title in output
DATA MIR        MIR_COMMENTS              and any comments
DATA MIR        MIR_OUTFILE             The output file created 

MENU            SRCINFO                 Get Source Information
DATA SRI        SRI_INFILE              Input file (eg., end.00)
DATA SRI        SRI_TITLE               Specify a title in output
DATA SRI        SRI_COMMENTS              and any comments
DATA SRI        SRI_OUTFILE             The output file created 

MENU            MINMAX                  Get Image info
SET     %A      MIN     MIN_RAYOPTS     EQ              OE LOSSES
*EXAMPL %F      %D                      AND     %B    

DATA MIN        MIN_INFILE              Input image file (eg., begin.dat)
DATA MIN        MIN_COMMENTS              and any comments in output file
SKIP
TEXT                                    You can also choose to exclude or
TEXT                                    incl`'ude losses; you can also
TEXT                                    choose to incl`'ude losses at a
TEXT                                    particular OE. 
SKIP
DATA MIN  Y     MIN_RAYOPTS             What rays to pick
DATA MIN A      MIN_OE_LOSS                to incl`'ude losses at what OE?
SKIP
TEXT                                    The output also goes to MINMAX

MENU            PREREFL                 Calculate mirror reflectivity
DATA PRL        PRL_COMPOSITION         At. Composition (eg., Si1O2)
DATA PRL        PRL_DENSITY             Material density (g/cm^3)
DATA PRL        PRL_ENERGY_MIN          Starting energy
DATA PRL        PRL_ENERGY_MAX            ending
DATA PRL        PRL_ENERGY_STEP           step
DATA PRL        PRL_OUTFILE             The output file created 

============================================================================          
*
* VARIABLES SECTION (6). This is empty for now.
*

============================================================================          
*
* ALIAS SECTION (7). NEW IN SHADOW
*

PLX	PLOTXY
SRI	SRCINFO
MIR	MIRINFO
MIN	MINMAX
PRL	PREREFL

============================================================================          
*
* TESTING STUFF HERE. Ignored by MENU reader.
*
MENU            PLOTOE                  Plot SHADOW Results (PLOTXY/OE)
SET     %A      PL2_SPEC_FILE           NE              YES
SET     %B      PL2_SPEC_FILE           EQ              YES
SET     %E      PL2     PL2_ROW_HORIZ   EQ              PH-Energy
SET     %F      PL2     PL2_ROW_VERT    EQ              PH-Energy
SET     %G      %E                      OR      %F
*EXAMPL %F      %D                      AND     %B    
DATA PL2  Y     PL2_SPEC_FILE           Specify image filename?
DATA PL2 A      PL2_IMAGE                  Where to plot image?
DATA PL2 B      PL2_INFILE                 Image file (eg., star.01)
SKIP
DATA PL2        PL2_RAYOPTS             What rays to pick?
DATA PL2        PL2_COMMENTS            Any comments in output?
DATA PL2  Y     PL2_ROW_HORIZ           Column to plot in horizontal
DATA PL2  Y     PL2_ROW_VERT                       and in vertical
DATA PL2 G      PL2_UNIT                What unit to choose
DATA PL2        PL2_SCALE_OPTS          What kind of scaling to use      PL2_SCALE
DATA PL2        PL2_DO_HIST             Draw the histograms?             PL2_HISTO
DATA PL2   Y    PL2_PLOT_TYPE           Kind of plot                     PL2_PLWHAT
TEXT                                    Other hairy options you can set  PL2_OPTS
DATA PL2        PL2_DEVICE                    and the plotting device 

MENU            PL2_SCALE               Scaling options
SET     %A      PL2     PL2_SCALE_OPTS  EQ              EXTERNAL
DATA PL2  Y     PL2_SCALE_OPTS          What kind of scaling to use
SKIP
DATA PL2 A      PL2_EXT_HMIN            External horizontal min
DATA PL2 A      PL2_EXT_HMAX                     horizontal max
DATA PL2 A      PL2_EXT_VMIN                     vertical max
DATA PL2 A      PL2_EXT_VMAX                     vertical max

MENU            PL2_OPTS                Other hairy PLOTXY options
DATA PL2   Y    PL2_HAIRLINE            Hairline at [0,0]?
DATA PL2   Y    PL2_OVL_MIRROR          Overlay mirror/slit?

MENU            PL2_HISTO               Histogram options
*EXAMPL %F      %D                      AND     %B    
SET     %A      PL2     PL2_DO_HIST     EQ              YES
SET     %B      PL2     PL2_HIST_LIM    EQ              YES
SET     %C      %A                      AND     %B
DATA PL2  Y     PL2_DO_HIST             Draw the histograms? 
DATA PL2 A      PL2_HIST_XBINS            Number of bins in X
DATA PL2 A      PL2_HIST_YBINS            Number of bins in Y
SKIP
DATA PL2 AY     PL2_HIST_LIM            Specify limits
DATA PL2 C      PL2_HIST_XCTR               X Center
DATA PL2 C      PL2_HIST_XWID                 Width
DATA PL2 C      PL2_HIST_YCTR               Y Center
DATA PL2 C      PL2_HIST_YWID                 Width

MENU            PLOTSCR                 Plot SHADOW Results (PLOTXY/SRC)
SET     %E      PL3     PL3_ROW_HORIZ   EQ              PH-Energy
SET     %F      PL3     PL3_ROW_VERT    EQ              PH-Energy
SET     %G      %E                      OR      %F
*EXAMPL %F      %D                      AND     %B    
DATA PL3        PL3_RAYOPTS             What rays to pick?
DATA PL3        PL3_COMMENTS            Any comments in output?
DATA PL3  Y     PL3_ROW_HORIZ           Column to plot in horizontal
DATA PL3  Y     PL3_ROW_VERT                       and in vertical
DATA PL3 G      PL3_UNIT                What unit to choose
DATA PL3        PL3_SCALE_OPTS          What kind of scaling to use      PL3_SCALE
DATA PL3        PL3_DO_HIST             Draw the histograms?             PL3_HISTO
DATA PL3   Y    PL3_PLOT_TYPE           Kind of plot                     PL3_PLWHAT
TEXT                                    Other hairy options you can set  PL3_OPTS
DATA PL3        PL3_DEVICE                    and the plotting device 

MENU            PL3_SCALE               Scaling options
SET     %A      PL3     PL3_SCALE_OPTS  EQ              EXTERNAL
DATA PL3  Y     PL3_SCALE_OPTS          What kind of scaling to use
SKIP
DATA PL3 A      PL3_EXT_HMIN            External horizontal min
DATA PL3 A      PL3_EXT_HMAX                     horizontal max
DATA PL3 A      PL3_EXT_VMIN                     vertical max
DATA PL3 A      PL3_EXT_VMAX                     vertical max

MENU            PL3_OPTS                Other hairy PLOTXY options
DATA PL3   Y    PL3_HAIRLINE            Hairline at [0,0]?
DATA PL3   Y    PL3_OVL_MIRROR          Overlay mirror/slit?

MENU            PL3_HISTO               Histogram options
*EXAMPL %F      %D                      AND     %B    
SET     %A      PL3     PL3_DO_HIST     EQ              YES
SET     %B      PL3     PL3_HIST_LIM    EQ              YES
SET     %C      %A                      AND     %B
DATA PL3  Y     PL3_DO_HIST             Draw the histograms? 
DATA PL3 A      PL3_HIST_XBINS            Number of bins in X
DATA PL3 A      PL3_HIST_YBINS            Number of bins in Y
SKIP
DATA PL3 AY     PL3_HIST_LIM            Specify limits
DATA PL3 C      PL3_HIST_XCTR               X Center
DATA PL3 C      PL3_HIST_XWID                 Width
DATA PL3 C      PL3_HIST_YCTR               Y Center
DATA PL3 C      PL3_HIST_YWID                 Width

