//
// relation.h: 
//
// ------------------------------------------------
// Mumit Khan <khan@xraylith.wisc.edu>
// Center for X-ray Lithography
// University of Wisconsin-Madison
// 3731 Schneider Dr., Stoughton, WI, 53589
// ------------------------------------------------
//
// Copyright (c) 1994-1996 Mumit Khan
//

#ifndef relation_h
#define relation_h

/***************************************************************************/

#include <string>
#include <list>

#include "xrtypes.h"

/***************************************************************************/

class Beamline;
class SynonymTable;
class RelationItem;

class Relation {
public:
    Relation();
    virtual ~Relation();

    int add(RelationItem*);

    int evaluate(const Beamline*, const SynonymTable*);
    bool get_flag_value(const char*) const;

    virtual void dump() const;

private:
    void reset_flags(bool def_val = true);
    int eval_1_flag(const Beamline*, const SynonymTable*, const RelationItem*);
    void set_flag_value(const char*, bool);

private:
    std::list<void*> item_list_;
    std::list<std::string> item_names_;
    bool* flag_values_;
};

class RelationItem {
public:
    RelationItem(const char* flag,
	const char* rec1, const char* name1, 
	const char* rel, 
	const char* rec2, const char* name2,
	bool def_value = true
    );
    virtual ~RelationItem();

    virtual const char* flag() const;
    virtual const char* rec1() const;
    virtual const char* name1() const;
    virtual const char* rel() const;
    virtual const char* rec2() const;
    virtual const char* name2() const;
    virtual bool value() const;
    virtual void value(bool);

    virtual void dump() const;

private:
    char* flag_;
    char* rec1_;
    char* name1_;
    char* rel_;
    char* rec2_;
    char* name2_;
    bool value_;
};

/***************************************************************************/

#endif/*relation_h*/
