#if __GNUG__ && !USE_GNU_FREPO

#include <deque>
#include <list>
#include <map>
#include "mystring.h"
#include <string>

template class deque<void*>;

/* Not needed for SGI STL and egcs */
#ifndef __STL_CONFIG_H

template bool operator!=(
    deque<void*>::iterator const &,
    deque<void*>::iterator const &
);
template bool operator!=(
    deque<void*>::const_iterator const &,
    deque<void*>::const_iterator const &
);
template bool operator!=(
    deque<void*>::const_iterator const &, 
    deque<void *>::iterator const &
);
#endif /* __STL_CONFIG_H */

template class list<void*>;
#ifndef __STL_CONFIG_H
template bool operator!=(
    list<void*>::const_iterator const &, 
    list<void*>::const_iterator const &
);
template bool operator!=(
    list<void*>::const_iterator const &, 
    list<void*>::iterator const &
);
#endif /* __STL_CONFIG_H */

template class less<string>;
template class less<Mystring>;

template class list<string>;
#ifndef __STL_CONFIG_H
template bool operator!=(
    list<string>::const_iterator const &, 
    list<string>::const_iterator const &
);
template bool operator!=(
    list<string>::const_iterator const &, 
    list<string>::iterator const &
);
#endif /* __STL_CONFIG_H */

template class map<string, void*, less<string> >;
#ifndef __STL_CONFIG_H
template class rb_tree<string, pair<string const, void*>, 
    select1st<pair<string const, void*>, string>, less<string> >;

template bool operator!=(rb_tree<string, pair<string const, void*>, 
    select1st<pair<string const, void*>, string>, 
    less<string> >::iterator const &, 
    rb_tree<string, pair<string const, void*>, 
    select1st<pair<string const, void*>, string>, 
    less<string> >::iterator const &);

template bool operator!=(rb_tree<string, pair<string const, void*>, 
    select1st<pair<string const, void*>, string>, 
    less<string> >::const_iterator const &, 
    rb_tree<string, pair<string const, void*>, 
    select1st<pair<string const, void*>, string>, 
    less<string> >::const_iterator const &);

//
// needed in Beamline::clear when cleaning out the tool_map_.
//
template bool operator!=(rb_tree<string, pair<string const, void *>,
    select1st<pair<string const, void *>, string>,
    less<string > >::const_iterator const &, 
    rb_tree<string, pair<string const, void *>,
    select1st<pair<string const, void *>, string>,
    less<string > >::iterator const &);
#endif /* __STL_CONFIG_H */

//
// need for ToolMgr::map<Mystring, Mystring, less<Mystring> >
//
template class map<Mystring, Mystring, less<Mystring> >;
#ifndef __STL_CONFIG_H
template class rb_tree<Mystring, pair<Mystring const, Mystring>, 
    select1st<pair<Mystring const, Mystring>, Mystring>, less<Mystring> >;

template bool operator!=(rb_tree<Mystring, pair<Mystring const, Mystring>, 
    select1st<pair<Mystring const, Mystring>, Mystring>, 
    less<Mystring> >::const_iterator const &, 
    rb_tree<Mystring, pair<Mystring const, Mystring>, 
    select1st<pair<Mystring const, Mystring>, Mystring>, 
    less<Mystring> >::const_iterator const &);
#endif /* __STL_CONFIG_H */

//
// When compiling with -O on an HP, this one is needed in addition to
// all the rest below.
//
#if defined(__hppa) || defined(__sgi__)
template void max(unsigned int const &, unsigned int const &);
#endif

//
// when compiling on DEC OSF/1, the following are needed, with or without
// -g (unlike HP). Also needed on SunOS 4.1.x, AIX, etc, so I'm lumping
// all of these here. Looks like linux is the only one where these are
// *not* needed.
//
#if !defined(__linux)

template void construct(string *, string const &);
template void construct(void **, void *const &);
template void destroy(string *);
template void destroy(void **);
template void max(unsigned long const &, unsigned long const &);

template class deque_iterator<void *>;
template class rb_tree_const_iterator<string, 
    pair<string const, void *>, 
    select1st<pair<string const, void *>, string >, less<string > >;

template class rb_tree_const_iterator<Mystring, 
    pair<Mystring const, Mystring>, 
    select1st<pair<Mystring const, Mystring>, Mystring>, less<Mystring> >;

template bool operator!=(
    list<string >::iterator const &, 
    list<string >::iterator const &);

template bool operator!=(
    list<void *>::iterator const &, 
    list<void *>::iterator const &);

#endif

#endif
