//
// shadow-nml.h: SHADOW namelist class
//
// ------------------------------------------------
// Mumit Khan <khan@xraylith.wisc.edu>
// Center for X-ray Lithography
// University of Wisconsin-Madison
// 3731 Schneider Dr., Stoughton, WI, 53589
// ------------------------------------------------
//
// Copyright (c) 1994-1996 Mumit Khan
//

#ifndef shadow_nml_h
#define shadow_nml_h

// ====================================================================== //

#include <string>
#include <list>
#include <map>

#include "xrtypes.h"

// ====================================================================== //

class Var;
class Value;

class ShadowNamelist {
public:
    typedef list<string> VariableList;

public:
    ShadowNamelist(const ShadowNamelist* parent = nil);
    ShadowNamelist(const ShadowNamelist&);
    virtual ~ShadowNamelist();

    ShadowNamelist* clone() const;
    int copy(const ShadowNamelist&);

    bool exists(const string& name) const;
    const Var* get(const string& name) const;

    int add(Var*);
    int replace(Var*);
    int change(const string& name, Value*);

    const VariableList& variables() const;
    void dump() const;

private:
    typedef map<string, void*, less<string> > VariableMap;

private:
    const ShadowNamelist* parent_;
    VariableMap var_map_;
    VariableList var_list_;
};

// ====================================================================== //

#endif/*shadow_nml_h*/
