//
// menu-page.cc: MENU pages implementation
//
// ------------------------------------------------
// Mumit Khan <khan@xraylith.wisc.edu>
// Center for X-ray Lithography
// University of Wisconsin-Madison
// 3731 Schneider Dr., Stoughton, WI, 53589
// ------------------------------------------------
//
// Copyright (c) 1994-1996 Mumit Khan
//

// =================================================================== //

#ifdef __GNUG__
# include <iostream.h>
# include <cassert>
#else
# include <iostream>
# include <assert>
#endif

#include "beamline.h"
#include "menu.h"
#include "menu-page.h"
#include "relation.h"
#include "synonym.h"

// =================================================================== //
 
MenuPage::MenuPage(
    const Menu* menu, const string& name, const string& title, 
    const string& type
) : 
    menu_(menu), 
    name_(name), 
    title_(title), 
    type_(type) ,
    relation_(new Relation)
{ }

MenuPage::~MenuPage() {
    delete relation_;
}

void MenuPage::add_item(MenuItem* item) {
    item_tab_[item->name()] = item;
    item_list_.push_back(item->name());
}

void MenuPage::set_relation(Relation* relation) {
    assert(relation);
    delete relation_;
    relation_ = relation;
}

const MenuItem* MenuPage::find_item(const string& item_name) const {
    map< string, void*, less<string> >::const_iterator it = 
	item_tab_.find(item_name);
    return (it != item_tab_.end()) ?
	reinterpret_cast<const MenuItem*>((*it).second) : nil;
}

const list<string>& MenuPage::get_items() const { return item_list_;}
const char* MenuPage::name() const { return name_.c_str(); }
const char* MenuPage::title() const { return title_.c_str(); }
const char* MenuPage::type() const { return type_.c_str(); }

int MenuPage::evaluate_flags(const Beamline* bline) {
    return relation_->evaluate(bline, menu_->get_synonym_table());
}

bool MenuPage::get_flag_value(const string& flag) const {
    return relation_->get_flag_value(flag.c_str());
}

void MenuPage::dump() const {
    cerr << "Dumping page \"" << name() << "\"..." << endl;
    list<string>::const_iterator it = item_list_.begin();
    for(; it != item_list_.end(); ++it) {
        const string& item_name = *it;
	const MenuItem* item = find_item(item_name);
	item->dump();
    }
    relation_->dump();
    cerr << "done." << endl;
}

// =================================================================== //

