/* 
 * tixWinMain.c --
 *
 *	Main entry point for wish and other Tk-based applications.
 *
 * Copyright (c) 1995 Sun Microsystems, Inc.
 *
 * See the file "docs/license.tcltk" for information on usage and
 * redistribution of this file, and for a DISCLAIMER OF ALL
 * WARRANTIES.
 *
 */

#include <tk.h>
#include <tix.h>
#include <blt.h>

#include "xmenu.h"
#include "shdata_cmds.h"

#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#undef WIN32_LEAN_AND_MEAN
#include <malloc.h>
#include <string>

extern "C" {
#if ((TCL_MAJOR_VERSION == 7) && (TCL_MINOR_VERSION == 5))

/*
 * The TixConsole stuff was implemented for Tcl 7.5 only
 */

extern void TixConsoleCreate _ANSI_ARGS_((Tcl_Interp *interp));
extern int TixConsoleInit _ANSI_ARGS_((Tcl_Interp *interp));

#else

extern void TkConsoleCreate _ANSI_ARGS_((void));
extern int TkConsoleInit _ANSI_ARGS_((Tcl_Interp *interp));

#define TixConsoleCreate(x)	TkConsoleCreate()
#define TixConsoleInit(x)	TkConsoleInit(x)

}
#endif


/*
 * Forward declarations for procedures defined later in this file:
 */

static void		WishPanic _ANSI_ARGS_(TCL_VARARGS(char *,format));
static int		Tix_ConsoleInitCmd _ANSI_ARGS_((ClientData clientData,
			    Tcl_Interp *interp, int argc, char **argv));

/*
 * The following string is the startup script executed in new
 * interpreters.  It looks on disk in several different directories
 * for a script "shadow.tcl" that is compatible with this version
 * of Tk.  The shadow.tcl script does all of the real work of
 * initialization.
 */

static char *initScript =
"proc shadow:init {} {\n\
    global shadow_library env\n\
    rename shadow:init {}\n\
    set dirs {}\n\
    if [info exists env(SHADOW_TCL_LIBRARY)] {\n\
	lappend dirs $env(SHADOW_TCL_LIBRARY)\n\
    }\n\
    if [info exists env(SHADOW_GUI_ROOT)] {\n\
	lappend dirs $env(SHADOW_GUI_ROOT)/lib/tcl/shadow\n\
    }\n\
    if [info exists env(SHADOW_ROOT)] {\n\
	lappend dirs $env(SHADOW_ROOT)/lib/tcl/shadow\n\
    }\n\
    lappend dirs $shadow_library\n\
    lappend dirs [file dirname [file dirname [info nameofexecutable]]]/lib/tcl/shadow\n\
    lappend dirs [file dirname [file dirname [info nameofexecutable]]]/tcl\n\
    foreach i $dirs {\n\
	set shadow_library $i\n\
	if ![catch {uplevel #0 source [list $i/shadow.tcl]}] {\n\
	    return\n\
	}\n\
    }\n\
    set msg \"Can't find a usable shadow.tcl in the following directories: \n\"\n\
    append msg \"    $dirs\n\"\n\
    append msg \"This probably means that SHADOW GUI wasn't installed properly.\n\"\n\
    error $msg\n\
}\n\
shadow:init";

/*
 *----------------------------------------------------------------------
 *
 * WinMain --
 *
 *	Main entry point from Windows.
 *
 * Results:
 *	Returns false if initialization fails, otherwise it never
 *	returns. 
 *
 * Side effects:
 *	Just about anything, since from here we call arbitrary Tcl code.
 *
 *----------------------------------------------------------------------
 */

int APIENTRY
WinMain(hInstance, hPrevInstance, lpszCmdLine, nCmdShow)
    HINSTANCE hInstance;
    HINSTANCE hPrevInstance;
    LPSTR lpszCmdLine;
    int nCmdShow;
{
    char **argv, **argvlist, *p;
    int argc, size, i;
    char buffer[MAX_PATH];

    Tcl_SetPanicProc(WishPanic);

    /*
     * Increase the application queue size from default value of 8.
     * At the default value, cross application SendMessage of WM_KILLFOCUS
     * will fail because the handler will not be able to do a PostMessage!
     * This is only needed for Windows 3.x, since NT dynamically expands
     * the queue.
     */
    SetMessageQueue(64);

    /*
     * Precompute an overly pessimistic guess at the number of arguments
     * in the command line by counting non-space spans.  Note that we
     * have to allow room for the executable name and the trailing NULL
     * argument.
     */

    for (size = 3, p = lpszCmdLine; *p != '\0'; p++) {
	if (isspace(*p)) {
	    size++;
	    while (isspace(*p)) {
		p++;
	    }
	    if (*p == '\0') {
		break;
	    }
	}
    }
    argvlist = (char **) ckalloc((unsigned) (size * sizeof(char *)));
    argv = argvlist;

    /*
     * Parse the Windows command line string.  If an argument begins with a
     * double quote, then spaces are considered part of the argument until the
     * next double quote.  The argument terminates at the second quote.  Note
     * that this is different from the usual Unix semantics.
     */

    for (i = 1, p = lpszCmdLine; *p != '\0'; i++) {
	while (isspace(*p)) {
	    p++;
	}
	if (*p == '\0') {
	    break;
	}
	if (*p == '"') {
	    p++;
	    argv[i] = p;
	    while ((*p != '\0') && (*p != '"')) {
		p++;
	    }
	} else {
	    argv[i] = p;
	    while (*p != '\0' && !isspace(*p)) {
		p++;
	    }
	}
	if (*p != '\0') {
	    *p = '\0';
	    p++;
	}
    }
    argv[i] = NULL;
    argc = i;

    /*
     * Since Windows programs don't get passed the command name as the
     * first argument, we need to fetch it explicitly.
     */

    GetModuleFileName(NULL, buffer, sizeof(buffer));
    argv[0] = buffer;

    Tk_Main(argc, argv, Tcl_AppInit);
    return 1;
}


/*
 *----------------------------------------------------------------------
 *
 * Tcl_AppInit --
 *
 *	This procedure performs application-specific initialization.
 *	Most applications, especially those that incorporate additional
 *	packages, will have their own version of this procedure.
 *
 * Results:
 *	Returns a standard Tcl completion code, and leaves an error
 *	message in interp->result if an error occurs.
 *
 * Side effects:
 *	Depends on the startup script.
 *
 *----------------------------------------------------------------------
 */

int
Tcl_AppInit(interp)
    Tcl_Interp *interp;		/* Interpreter for application. */
{

    /*
     * Create the console channels and install them as the standard
     * channels.  All I/O will be discarded until TkConsoleInit is
     * called to attach the console to a text widget.
     */
    TixConsoleCreate(interp);

    if (Tcl_Init(interp) == TCL_ERROR) {
	if (Tcl_GetVar(interp, "errorInfo", TCL_GLOBAL_ONLY)) {
	    MessageBox(NULL, Tcl_GetVar(interp, "errorInfo", TCL_GLOBAL_ONLY),
		"Tcl Init Error", MB_OK|MB_ICONSTOP);
	} else {
	    MessageBox(NULL, interp->result, "Tcl Init Error",
		MB_OK|MB_ICONSTOP );
	}
	return TCL_ERROR;
    }
    if (Tk_Init(interp) == TCL_ERROR) {
	if (Tcl_GetVar(interp, "errorInfo", TCL_GLOBAL_ONLY)) {
	    MessageBox(NULL, Tcl_GetVar(interp, "errorInfo", TCL_GLOBAL_ONLY),
		"Tk Init Error", MB_OK|MB_ICONSTOP);
	} else {
	    MessageBox(NULL, interp->result, "Tk Init Error",
		MB_OK|MB_ICONSTOP);
	}
	return TCL_ERROR;
    }
    Tcl_StaticPackage(interp, "Tk", Tk_Init, (Tcl_PackageInitProc *) NULL);
    if (Tix_Init(interp) == TCL_ERROR) {
	if (Tcl_GetVar(interp, "errorInfo", TCL_GLOBAL_ONLY)) {
	    MessageBox(NULL, Tcl_GetVar(interp, "errorInfo", TCL_GLOBAL_ONLY),
		"Tix Init Error", MB_OK|MB_ICONSTOP);
	} else {
	    MessageBox(NULL, interp->result, "Tix Init Error",
		MB_OK|MB_ICONSTOP);
	}
	return TCL_ERROR;
    }
    Tcl_StaticPackage(interp, "Tix", Tix_Init, (Tcl_PackageInitProc *) NULL);
    if (Blt_Init(interp) == TCL_ERROR) {
	if (Tcl_GetVar(interp, "errorInfo", TCL_GLOBAL_ONLY)) {
	    MessageBox(NULL, Tcl_GetVar(interp, "errorInfo", TCL_GLOBAL_ONLY),
		"Blt Init Error", MB_OK|MB_ICONSTOP);
	} else {
	    MessageBox(NULL, interp->result, "Blt Init Error",
		MB_OK|MB_ICONSTOP);
	}
	return TCL_ERROR;
    }
    Tcl_StaticPackage(interp, "Blt", Blt_Init, (Tcl_PackageInitProc *) NULL);
    if (Xmenu_Init(interp) == TCL_ERROR) {
	if (Tcl_GetVar(interp, "errorInfo", TCL_GLOBAL_ONLY)) {
	    MessageBox(NULL, Tcl_GetVar(interp, "errorInfo", TCL_GLOBAL_ONLY),
		"SHADOW Menu Init Error", MB_OK|MB_ICONSTOP);
	} else {
	    MessageBox(NULL, interp->result, "SHADOW Menu Init Error",
		MB_OK|MB_ICONSTOP);
	}
	return TCL_ERROR;
    }
    Tcl_StaticPackage(interp, "Xmenu", Xmenu_Init, 
        (Tcl_PackageInitProc *) NULL
    );

    if (Shdata_Init(interp) == TCL_ERROR) {
	if (Tcl_GetVar(interp, "errorInfo", TCL_GLOBAL_ONLY)) {
	    MessageBox(NULL, Tcl_GetVar(interp, "errorInfo", TCL_GLOBAL_ONLY),
		"SHADOW Plot Init Error", MB_OK|MB_ICONSTOP);
	} else {
	    MessageBox(NULL, interp->result, "SHADOW Plot Init Error",
		MB_OK|MB_ICONSTOP);
	}
	return TCL_ERROR;
    }
    Tcl_StaticPackage(interp, "Shdata", Shdata_Init, 
        (Tcl_PackageInitProc *) NULL
    );

    char* libDir = Tcl_GetVar(interp, "shadow_library", TCL_GLOBAL_ONLY);
    if (libDir == NULL) {
	libDir = "c:/Programs/shadow/lib/tcl/shadow";
	char libdir[256];
	strcpy(libdir, libDir);
	if (!Tcl_SetVar(interp, "shadow_library", libdir, TCL_GLOBAL_ONLY)) {
	    if (Tcl_GetVar(interp, "errorInfo", TCL_GLOBAL_ONLY)) {
		MessageBox(NULL, 
		    Tcl_GetVar(interp, "errorInfo", TCL_GLOBAL_ONLY),
		    "Error setting shadow_library variable", MB_OK|MB_ICONSTOP
		);
	    } else {
		MessageBox(NULL, interp->result, 
		    "Error setting shadow_library variable",
		    MB_OK|MB_ICONSTOP
		);
	    }
	}
    }

    if (Tcl_Eval(interp, initScript) != TCL_OK) {
	if (Tcl_GetVar(interp, "errorInfo", TCL_GLOBAL_ONLY)) {
	    MessageBox(NULL, Tcl_GetVar(interp, "errorInfo", TCL_GLOBAL_ONLY),
		"SHADOW Menu Init Error", MB_OK|MB_ICONSTOP);
	} else {
	    MessageBox(NULL, interp->result, "SHADOW Menu Init Error",
		MB_OK|MB_ICONSTOP);
	}
	/*
	 * Initialize the console only if we are running as an interactive
	 * application.
	 */

	if (strcmp(Tcl_GetVar(interp, "tcl_interactive", TCL_GLOBAL_ONLY), "1")
		== 0) {
	    if (TixConsoleInit(interp) == TCL_ERROR) {
		return TCL_ERROR;
	    }
	}
    } else {
	Tcl_SetVar(interp, "tcl_interactive", "0", TCL_GLOBAL_ONLY);
    }

    /*
     * No startup file to exec!
     */
    return TCL_OK;
}

/*
 *----------------------------------------------------------------------
 *
 * WishPanic --
 *
 *	Display a message and exit.
 *
 * Results:
 *	None.
 *
 * Side effects:
 *	Exits the program.
 *
 *----------------------------------------------------------------------
 */

void
WishPanic TCL_VARARGS_DEF(char *,arg1)
{
    va_list argList;
    char buf[1024];
    char *format;
    
    format = TCL_VARARGS_START(char *,arg1,argList);
    vsprintf(buf, format, argList);

    MessageBeep(MB_ICONEXCLAMATION);
    MessageBox(NULL, buf, "Fatal Error in Wish",
	MB_ICONSTOP | MB_OK | MB_TASKMODAL | MB_SETFOREGROUND);
    ExitProcess(1);
}

