//
// mystring.h: horrible HACK'y derivation from std string class
//
// ------------------------------------------------
// Mumit Khan <khan@xraylith.wisc.edu>
// Center for X-ray Lithography
// University of Wisconsin-Madison
// 3731 Schneider Dr., Stoughton, WI, 53589
// ------------------------------------------------
//
// Copyright (c) 1991-1996 Mumit Khan
//
//

#ifndef shadow_mystring_h
#define shadow_mystring_h

// ====================================================================== //

#include <string>
#include "xrtypes.h"

#if !CXX_NO_NAMESPACE
using namespace std;
#endif

// ====================================================================== //
//
// GCC (2.7.2 and older) is very inefficient in mangling of names
// involving the standard string class since its templated name is quite
// long basic_string <char, string_char_traits <char> > and this causes
// most assemblers to choke when creating something like the following:
//     map<string, string, less <string> >
//
// To avoid this temporarily, I'm supplying this horrible hack which
// should be removed as soon as gcc makes mangled names shorter.
//
// This class is *ONLY* usable for a simple map, and since there are no
// i/ostream operators and other operators defined, it's pretty useless
// as a string substitute.
//
// HACK/FIXME: Now it's always turned on by default (see || 1 below).
//
// hopefully gcc 2.8.0 will solve this problem on all platforms (only 
// shows up on certain platforms, eg., hppa1.1-hp-hpux9.07,  right now)
//
// ====================================================================== //

#ifndef GCC_STRING_MANGLING_HACK
# if __GNUC__ <= 2 && __GNUC_MINOR__ <= 7
#  define GCC_STRING_MANGLING_HACK 1
# else
#  define GCC_STRING_MANGLING_HACK 0
# endif
#endif

#if GCC_STRING_MANGLING_HACK 

class Mystring : public string {
public:
    Mystring()  : string() { }
    Mystring(const string& str)  : string(str) { }
    Mystring(const char* str)  : string(str) { }

    Mystring& operator=(const Mystring& str) {
	string::operator=(str);
	return *this;
    }

    const string& operator()() const {return *this;}
};

inline bool operator< (const Mystring& lhs, const Mystring& rhs) {
    return (const string&)lhs < (const string&)rhs;
}

#else

#define Mystring string

#endif

// ====================================================================== //

#endif /*shadow_mystring_h*/
