C +++
C
C Source: src/utils/post/ffresnel2d.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C+++
C	PROGRAM		FFRESNEL
C
C	PURPOSE		To compute the diffracted image generated by the interf.
C			of a given ray file.
C
C---
     	PROGRAM		FFRESNEL
     	IMPLICIT	REAL*8	(A-H,O-Z)
#if defined(unix) || HAVE_F77_CPP
#       include	        <dim.par>
#elif defined(vms)
        INCLUDE	        'SHADOW$INC:DIM.PAR/LIST'
#endif
C     	IMPLICIT	REAL*8	(A-H,O-Z)
	PARAMETER	(IMAXDIM = 1001)
     	CHARACTER*80	INFILE1,RSTRING
     	DIMENSION	RAY(18,N_DIM)
     	DIMENSION	RDIS(2,IMAXDIM)
	DIMENSION	STEP(2), RMIN(2), RMAX(2), NP(2)
     	COMPLEX*16	ARG_S,ARG_P,JEI,
     $  		STOREX(IMAXDIM,IMAXDIM),STOREY(IMAXDIM,IMAXDIM),
     $			STOREZ(IMAXDIM,IMAXDIM)
        REAL*8      	TWOPI, TORAD
     	DATA	TWOPI 	/  6.2831 85307 17958 64769 25287 D0 /
	DATA    TORAD   /  0.0174 53292 51994 32957 69237 D0 /
C
     	JEI	=   (0.0D0,1.0D0)
     	
	CALL CLSCREEN
C
     	WRITE(6,*) 'Define integration limits in X [ cm ].'
1     	RMIN(1)	=   RNUMBER	('From               ')
     	RMAX(1)	=   RNUMBER	(' to                ')
	NP(1)	=   IRINT	('No. of points      ')
	STEP(1)	=   ABS(RMAX(1)-RMIN(1))/(NP(1)-1)
     	IF (NP(1).GT.IMAXDIM) THEN
     	  STEP(1) = (RMAX(1)-RMIN(1))/(IMAXDIM-1)
     	  WRITE(6,*) 'Too small a step. Smallest allowed is ',STEP(1)
     	  GO TO 1
     	END IF
C
     	WRITE(6,*) 'Define integration limits in Z [ cm ].'
2     	RMIN(2)	=   RNUMBER	('From               ')
     	RMAX(2)	=   RNUMBER	(' to                ')
	NP(2)	=   IRINT	('No. of points      ')
	STEP(2)	=   ABS(RMAX(2)-RMIN(2))/(NP(2)-1)
     	IF (NP(2).GT.IMAXDIM) THEN
     	  STEP(2) = (RMAX(2)-RMIN(2))/(IMAXDIM-1)
     	  WRITE(6,*) 'Too small a step. Smallest allowed is ',STEP(2)
     	  GO TO 2
     	END IF
C
     	DIST	=  RNUMBER	('Distance from plane [ cm ] ? ')
     	INFILE1 =  RSTRING	('Ray input file ? ')
     	KLOSS	=  IRINT		
     $('[ 0 ] to discard losses, [ 1 ] to keep them. ')
C
	CALL	RBEAM18	(INFILE1,RAY,NCOL,NP1,IFLAG,IERR)
	IF (IERR.NE.0)	STOP 'Error in reading ray file.'
	IF (NCOL.NE.18)	STOP	
     $'The ray file doesn"t contain polarization and phase information.'
	IOVER	=  IYES		
     $	    ('Do you want to override the wavelength in the file ? ')
	IF (IOVER.EQ.1) THEN
     	  WAVE	=  RNUMBER	('New wavelength [ Angs ]  ? ')
     	  QNEW	=   WAVE*1.0D-8
     	  QNEW	=   TWOPI/QNEW
	END IF

C
C Starts integration loop
C
     	WRITE(6,*) 'Files read OK. '
     	FACTOR	=   RNUMBER	('Conversion to [ cm ] factor (*) ? ')
	F_INC	=   IRINT	
     $('Include the S- and P- phase shifts in the computations ?')
	KOUNT	=   0
C First set up the array of image location 
	DO J = 1, NP(2)
	  DO I = 1, NP(1)
	    STOREX(I,J)	= (0.0D0,0.0D0)
	    STOREY(I,J)	= (0.0D0,0.0D0)
	    STOREZ(I,J)	= (0.0D0,0.0D0)
	  END DO
	END DO
	DO J = 1,2
	  DO I = 1, NP(J)
	    RDIS(J,I)	= RMIN(J) + (I-1)*STEP(J)
	  END DO
	END DO

C
C Now for each ray, do the whole 2D image.
C
     	DO J=1,NP1

     	 IF (KLOSS.EQ.0) THEN
     	   IF (RAY(10,J).LT.0.0D0) GO TO 100
     	 END IF
	 IF (IOVER.EQ.0) THEN
	   QVEC	= RAY(11,J)
	 ELSE
	   QVEC = QNEW
	 END IF
     	 KOUNT = KOUNT + 1

	 DO L=1,NP(2)
	   R	=   RAY (13,J)*FACTOR
	   RR_Z	=   RDIS(2,L)
	   VEC2 =   RR_Z - RAY(3,J)*FACTOR
	   DO K=1,NP(1)
	     RR_X	=   RDIS(1,K)
	     VEC1 	=   RR_X - RAY(1,J)*FACTOR
	     RR		=   SQRT(VEC1**2 + DIST**2 + VEC2**2)
** Common factor in front of the exponential :
	     FACTOR_INC	= RAY(5,J) + DIST/RR
	     FACTOR_NOR	= FACTOR_INC*QVEC/TWOPI/R/RR
** Exponential factor :
	     IF (F_INC.EQ.1) THEN
	       ARG_S	=   ((RR+R)*QVEC + RAY(14,J))*JEI
	       ARG_P	=   ((RR+R)*QVEC + RAY(15,J))*JEI
	     ELSE
	       ARG_S	=   (RR+R)*QVEC*JEI
	       ARG_P	=   (RR+R)*QVEC*JEI
	     END IF

	     ARG_S	=   EXP(ARG_S)
	     ARG_S	=   FACTOR_NOR*ARG_S
	     ARG_P	=   EXP(ARG_P)
	     ARG_P	=   FACTOR_NOR*ARG_P

	     STOREX(K,L) = STOREX(K,L) + (ARG_S*RAY(7,J) + 
     $			 ARG_P*RAY(16,J))
	     STOREY(K,L) = STOREY(K,L) + (ARG_S*RAY(8,J) + 
     $			 ARG_P*RAY(17,J))
	     STOREZ(K,L) = STOREZ(K,L) + (ARG_S*RAY(9,J) + 
     $			 ARG_P*RAY(18,J))

	   END DO
	 END DO
100	END DO
#ifdef vms
	OPEN	(20, FILE='FFPAR',STATUS='NEW',CARRIAGECONTROL='LIST')
#else
     	OPEN	(20, FILE='FFPAR', STATUS='UNKNOWN')
	REWIND (20)
#endif
     	  WRITE (20,*) 'X: From ',RMIN(1),' to ',RMAX(1)
	  WRITE (20,*) '     Step ',STEP(1)
     	  WRITE (20,*) 'Z: From ',RMIN(2),' to ',RMAX(2)
	  WRITE (20,*) '     Step ',STEP(2)
     	  WRITE (20,*) 'Wavelength ',WAVE,' angs.'
     	  WRITE (20,*) 'Image located at ',DIST
     	  WRITE (20,*) 'Scale factor [ units ] * ',FACTOR,' = [ cm ]'
     	 IF (KLOSS.EQ.0) THEN
     	  WRITE (20,*) 'Losses: NOT INCLUDED'
     	 ELSE
     	  WRITE (20,*) 'Losses:     INCLUDED'
     	 END IF
	 IF (F_INC.EQ.1) THEN
	  WRITE (20,*) 'S- and P- phase shifts :     INCLUDED'
	 ELSE
	  WRITE (20,*) 'S- and P- phase shifts : NOT INCLUDED'
	 END IF
     	  WRITE (20,*) 'Files used: ',INFILE1
     	CLOSE   (20)
#ifdef vms
     	OPEN	(20, FILE='FFRESNEL', STATUS='NEW')
#else
     	OPEN	(20, FILE='FFRESNEL', STATUS='UNKNOWN')
	REWIND (20)
#endif
C
C write out in CXrL Toolset aerial image format. Note the conversion
C to nanometers
C
	WRITE (20,*) 1
	WRITE (20,*) STEP(1) * 1.0e9
	WRITE (20,*) STEP(2) * 1.0e9
	WRITE (20,*) NP(1)
	WRITE (20,*) NP(2)
	WRITE (20,*) 0.0
     	DO L=1,NP(2)
	  DO K=1,NP(1)
	    RIMAG = (ABS(STOREX(K,L)))**2 + (ABS(STOREY(K,L)))**2
     $		  + (ABS(STOREZ(K,L)))**2
	    WRITE (20,*) RIMAG/KOUNT
	  END DO
     	END DO
     	CLOSE 	(20)
     	END
