	subroutine command (prompt,iverb,imodifier,exitCode)
	implicit integer (a-z)
c++
c	subroutine command (prompt,iverb,imodifier,exitCode)
c
c  Called by user to get very simple one and two word commands
c  decoded.  Validates command using data from the meundata file
c
c	prompt		- input/string
c			  prompt for user
c
c	iverb		- output/integer
c			  indicates verb user typed in
c			    example: TRACE=1, RECOLOR=2, etc.
c
c	imodifier	- output/integer
c			  indicates modifier uses with verb
c			    example: RECOLOR DEFINE = 1
c			    	     RECOLOR LOAD = 2
c
c	exitCode	- output/integer
c			    0 => normal exit
c			    2 => EXIT/QUIT/RETURN/STOP/END
c				 (verb table consulted first)
c			    3 => control/C
c--
	character*(*) prompt
c
#if defined(unix) || HAVE_F77_CPP
#       include "parms.inc"
#       include "verb.inc"
#       include "helplib.inc"
#       include "pushstr.inc"
#elif defined(vms)
	include 'parms.inc'
	include 'verb.inc'
	include 'helplib.inc'
	include 'pushstr.inc'
#endif
c
#ifndef vms
	character*132 tempstr
#endif
c
c
c  status words
c
	character*(l_symbol) exit_word (5)
	data exit_word /'EXIT','QUIT','RETURN','STOP','END'/
c
c  input line
c
	character*80 string
c
c  last token parsed
c
	character*(l_symbol) thisVerb,thisModifier
c
c  get next input line
c
 100	iverb=0
	imodifier=0
c
	call tt_Prompt (prompt,string,lString,ttCode)
c
c  space fill/left justify/ and capitalize string
c
	if (lstring .eq. 0) then
	  string=' '
	else
	  string=string(1:lString)
	endif
c
c  What kind of terminator did the user type
c
	if (ttCode .ne. 0) goto 3000
c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c  normal end-of-line as far as program is concerned
c  get the first token
c
 1100	posIn=0
	call getToken (string,posIn,thisVerb,posOut)
	if (thisVerb .eq. ' ') goto 100
	call upcase (thisVerb)
c
c  check for unambiguous verb name match
c
	lpushString=0
	call pushStr ('Ambiguous - use')
	match=0
	ambig=0
	ltoken=ltrim(thisVerb)
	do i=1,N_verb
	  if (v_name(i)(1:ltoken) .eq. thisVerb(1:ltoken)) then
	    if (match .eq. 0) then
	      match=i
	      call pushStr (v_name(i))
	    else if (v_name(i) .ne. v_name(match)) then
	      ambig=1
	      match=i
	      call pushStr (v_name(i))
	    endif
	  endif
	end do
c
c  print out message if ambiguous
c
	if (ambig .ne. 0) then
	  message=pushString(:lpushString)
	  call simpleMessage
	  goto 100
	endif
	if (match .ne. 0) goto 1200
c
c  no match to verb
c  check for terminaters
c
	do i=1,5
	  if (exit_word(i) .eq. thisVerb) then
	    exitCode=1
	    goto 9900
	  endif
	enddo
c
c  give error message
c
	write (message,1102) thisVerb
	call simpleMessage
 1102	format ('Unrecognized command "',a,'"')
	goto 100
c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c  found verb - there is at least one possible modifier
c  special case when verbCode is negative
c
 1200	thisVerb=v_name(match)
	iverb=v_verbCode(match)
	if (iverb .lt. 0) goto 2000
c
c  find extent of verb/modifiers with same verb
c  they are in alphabetical order
c  check whether there is a non-null and a null modifier
c
	nullMod=0
	nonNullMod=0
	do i=match,n_verb
	  if (v_name(i) .ne. thisVerb) goto 1210
	  if (v_modifier(i) .eq. ' ') then
	    nullMod=1
	  else
	    nonNullMod=1
	  endif
	enddo
c
c  this must be last command in the table
c
	matchTop=n_verb
	goto 1220
c
c  found extent of verb name matches
c
 1210	matchTop=i-1
 1220	continue
c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c  get modifier and analyze
c
	posIn=posOut
	call getToken (string,posIn,thisModifier,posOut)
	if (thisModifier .eq. ' ') goto 1600
c
c  check for extra modifiers
c
	if (string(posOut:) .ne. ' ') then
	  write (message,1222) string(posOut:)
 1222	  format('Ignoring "',a,'"')
	  call simpleMessage
	endif
c
c  the user has supplied a non-null modifier
c  is this a possible match
c
	if (nonNullMod .eq. 0) then
	  write (message,1221) thisVerb,thisModifier
 1221	  format ('Command "',a,'" has no modifiers - "',a,'" ignored')
	  call simpleMessage
	  goto 1700
	endif
	call upcase (thisModifier)
	l=ltrim(thisModifier)
	lpushString=0
	call pushStr ('Ambiguous modifier - use')
	matchMod=0
	ambig=0
	do j=match,matchTop
	  if (v_modifier(j)(:l) .eq. thisModifier(:l)) then
	    call pushStr (v_modifier(j))
	    if (matchMod .eq. 0) then
	      matchMod=j
	    else
	      ambig=1
	    endif
	  endif
	end do
c
c  ambiguity
c
	if (ambig .ne. 0) then
	  message=pushString(:lpushString)
	  call simpleMessage
	  goto 100
	endif
c
c  no modifier match
c
	if (matchMod .eq. 0) goto 1650
c
c  found matching modifier
c
 1300	iVerb=v_verbCode (matchMod)
	iModifier=v_modifierCode (matchMod)
	if (iverb .lt. 0) goto 2000
	exitCode=0
	goto 9900
c
c  The user supplied no modifier
c  Is there a version of the command that requires no modifier
c
 1600	do j=match,matchTop
	  if (v_modifier (j) .eq. ' ') goto 1700
	enddo
c
c  This command must be supplied with a modifier
c  For the moment treat this as an error
c
 1650	lpushstring=0
	call pushstr (thisVerb)
	call pushstr ('modifiers:')
	do i=match,matchTop
	  lvmod=ltrim(v_modifier(i))
	  if (lpushstring+lvmod .gt. 65) then
	    message=pushString(:lpushString)
	    call simpleMessage
	    lpushstring=0
	    call pushStr ('   and')
	  endif
	  call pushstr (v_modifier(i)(:lvmod))
	enddo
	message=pushString(:lpushString)
	call simpleMessage
	goto 100
c
c   User supplied no modifier and the command requires none
c
 1700	iverb=v_verbCode(j)
	imodifier=v_modifierCode(j)
	exitCode=0
	goto 9900
c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c  Special cases
c
 2000	j=-iverb
	if (j .lt. 1 .or. j .gt. 4) then
	  write (message,2001) j
 2001	  format ('Implementation error: Internal command ',i3,
     *			' does not exist')
	  call simpleMessage
	  goto 100
	endif
c
	goto (2100,2200,2300,2400) j
c
c  HELP
c
 2100	call help ( helplibc, 1, string (posOut:))
	goto 100
c
c  SPAWN
c
 2200	if (string(posOut:) .eq. ' ') then
#ifdef vms
	  sscode=lib$spawn ()
#else
	  call getenv ("SHELL", tempstr)
	  if (tempstr(1:1) .eq. ' ') then
	      tempstr = '/bin/sh'
	  endif
	  call curses_suspend
	  write (*,*) 
	  write (*,*) '           Entering Unix shell. Exit to return'
	  write (*,*) 
	  call system (tempstr)
	  call curses_restart
#endif
	else
#ifdef vms
	  sscode=lib$spawn (string(posOut:))
#else
	  message = 'SPAWN COMMAND not implemented yet.'
	  call simpleMessage
#endif
	endif
	call Check (sscode)
	goto 100
c
c  DIR
c
 2300	message='Directory command not yet implemented'
	call simpleMessage
	goto 100
c
c  Version of program
c
 2400	message='Version of  JUNE 1992'
	call simpleMessage
	goto 100
c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c  Control/C
c
 3000	exitCode=2
c
 9900	return
	end

	subroutine getToken (string,posIn,token,posOut)
	implicit integer (a-z)
c++
c	subroutine getToken (string,posIn,token,posOut)
c
c  Search string starting at position posIn for token
c
c	string		- input/string
c			  command line to be searched
c
c	posIn		- input/integer
c			  position at which to start search for token
c
c	token		- output/string
c			  where token found is to be put
c			  blank if no token found
c
c	posOut		- output/integer
c			  position in string of last char of previous token
c--
	character*(*) string,token
c
	l=len(string)
c
c  check for end-of-string or null string
c
	if (posIn .ge. l .or. l .le. 0) goto 900
c
c  skip leading spaces
c
	p=posIn
 40	p=p+1
	if (p .gt. l) goto 900
	if (string(p:p) .eq. ' ') goto 40
c
	posOut=p
 100	if (posOut .ge. l) goto 200
	if (string(posOut:posOut) .eq. ' ') goto 200
	posOut=posOut+1
	goto 100
c
 200	token=string(p:posOut)
	goto 999
c
 900	token=' '
	posOut=l
c
 999	return
	end
