C +++
C
C Source: src/source/id/undul_phot.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: undul_phot.F
C Revision 1.8  1992/02/11  21:28:01  khan
C unroll read/write implicit loops and what not ...
C
C Revision 1.7  1992/02/11  14:07:36  cwelnak
C loop unrolling attempt
C
C Revision 1.6  92/01/22  21:44:56  cwelnak
C 6000 changes
C 
C Revision 1.5  1991/07/06  20:03:58  khan
C Grenoble and after. Minor changes
C
C Revision 1.4  90/11/13  14:01:03  khan
C Cleanup and SAVE statements
C 
C Revision 1.3  90/10/30  00:01:45  khan
C Fix Ultrix -> VMS things that got screwed up in VMS -> Ultrix.
C 
C Revision 1.2  90/07/17  23:10:07  khan
C Fix File OPEN=NEW to UNKNOWN for Unix.
C Replace the use of VMS LOGICALS to communicate with the driver script
C with "known" exit codes. Depending on the particular exit code, the
C driver (make_id, undul, etc) takes appropriate action. Caveat is,
C of course, that the exit code used in the programs MUST be kept the
C same as the ones used in the driver scripts.
C 
C Revision 1.1  90/07/17  15:36:38  khan
C Initial revision
C 
C 
C ---


C+++
C
C	PROGRAM		UNDUL_PHOT
C
C	PURPOSE		This is the main calling program to
C			a) read in the (energy, theta, phi) array
C			b) compute the # of photon
C			c) write out all the arrays
C
C---
	PROGRAM		UNDUL_PHOT
	IMPLICIT	REAL*8	(A-H,O-Z)

	EXTERNAL	CPUTIM

#if defined(unix) || HAVE_F77_CPP
#	include 	"pre_rad.blk"
#elif defined(vms)
	INCLUDE		'PRE_RAD.BLK/LIST'
#endif


	NAMELIST	/PARAIN/	NCOMP,RCURR,ICOMP,BPASS,
     $					IANGLE,IAPERTURE,IEXTERNAL,
     $					FOUT,FIN,FTRAJ,EMIN,EMAX,
     $					THEMIN,THEMAX,PHIMIN,PHIMAX,
     $					NE,NT,NP,NCHECK,IOPT,ITER,IPASS,
     $					I_EDIV,EDIVX,EDIVY,FINT,IINT

	DIMENSION	UPHI(31,31,51),UTHETA(31,51),UENER(51)
	DIMENSION	RN0(31,31,51)
	DIMENSION	POL_DEG(31,31,51)

C
C Read in the parameters from namelist file
C
#ifdef vms
	OPEN	(21, FILE='UPHOT.PAR', STATUS='OLD', READONLY)
#else
	OPEN	(21, FILE='uphot.par', STATUS='OLD')
#endif
	READ	(21, NML=PARAIN)
	CLOSE	(21)
C
C Read in the (energy, theta, phi) array
C
#ifdef vms
	OPEN	(40, FILE='UPHOT.DAT', STATUS='OLD', FORM='UNFORMATTED',
     $		READONLY)
#else
	OPEN	(40, FILE='uphot.dat', STATUS='OLD', FORM='UNFORMATTED')
#endif
	READ	(40)	NE, NT, NP
	DO 99 K = 1, NE
 99	    READ (40)	UENER(K)

	DO 199 K = 1, NE
	    DO 199 J = 1, NT
 199		READ (40) UTHETA(J,K)

	DO 299 K = 1, NE
	    DO 299 J = 1, NT
		DO 299 I = 1, NP
 299		    READ (40) UPHI(I,J,K)

  
D	READ	(40)	(UENER(K), K = 1, NE)
D	READ	(40)	((UTHETA(J,K), J = 1, NT), K = 1, NE)
D	READ	(40)	(((UPHI(I,J,K), I = 1, NP), J = 1, NT), K = 1, NE)

C
C Read in the trajectory file
C
	CALL	UREAD
C
	  write(6,*) ' '
     	  write(6,*) '----------------------------',
     $'-----------------------------------------------'
     	  write(6,*) ' '
     	  write(6,*) ' '
     	  write(6,*) '----------------------------',
     $'-----------------------------------------------'
     	  write(6,*) ' '
	  write(6,*) ' '
	  write(6,*) 'Begin calculations.'
	  write(6,*) ' '
C
C Sets up REPORT
C
          CALL     REPORT ( UENER(1), UTHETA(1,1), UPHI(1,1,1), 
     $ TTIME, PERC, -1)
C
C  Compute the # of photons from internal routine UPHOTON
C  All preliminaries completed. Starts real calculations.
C
	  TIME0 = CPUTIM()
	  TOTPOINTS	= NP*NT*NE
     	  KCHECK = 0
     	  IPOINTS = 0
C
C Compute the # of photons at each (energy, theta, phi).
C
	  DO 19 K = 1,NE
	   ENER		= UENER(K)
	   DO 29 J = 1, NT
	     THETA	= UTHETA(J,K)
	     DO 39 I = 1, NP
	        PHI	= UPHI(I,J,K)
	        CALL	UPHOTON	(ENER, THETA, PHI, PHOT, POL)
	        RN0(I,J,K)	= PHOT
	        POL_DEG(I,J,K)	= POL
C Status report.
     	        KCHECK = KCHECK + 1
     	        IPOINTS = IPOINTS + 1
	        IF (KCHECK.EQ.NCHECK) THEN
     	          TTIME = CPUTIM() - TIME0
                  PERC = IPOINTS/TOTPOINTS*100
     	          CALL	REPORT ( ENER, THETA, PHI, TTIME, PERC, 1)
                  KCHECK = 0
     	        END IF
C
39	     CONTINUE
29	   CONTINUE
19	  CONTINUE
C
	IF (IPASS.EQ.0) THEN
	  write(6,*) ' '
     	  write(6,*) '----------------------------',
     $'-----------------------------------------------'
     	  write(6,*) ' '
     	  write(6,*) 'Spectra Computations completed.'
     	  write(6,*) ' '
#ifdef vms
     	  ttime = cputim() - time0
     	  write(6,*) 'Total CPU time used so far: ',TTIME
     	  write(6,*) 'CPU time per point: ',TTIME/TOTPOINTS
#endif
     	  write(6,*) ' '
     	  write(6,*) '----------------------------',
     $'-----------------------------------------------'
     	  write(6,*) ' '
	END IF
C
C Write out all arrays.
C
D	WRITE	(40)	(((RN0(I,J,K), I = 1, NP), J = 1, NT), K = 1, NE)
D	WRITE	(40)	(((POL_DEG(I,J,K), I = 1, NP), J = 1, NT), K = 1, NE)

	DO 399 K = 1, NE
	    DO 399 J = 1, NT
		DO 399 I = 1, NP
 399		    WRITE (40) RN0(I,J,K)

	DO 499 K = 1, NE
	    DO 499 J = 1, NT
		DO 499 I = 1, NP
 499		    WRITE (40) POL_DEG(I,J,K)

	CLOSE	(40)
	END
