C +++
C
C Source: src/lib/intspl.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: intspl.F
C Revision 1.6  1991/07/06  19:56:48  khan
C Grenoble and after. Minor changes
C
C Revision 1.5  91/04/05  13:54:23  cwelnak
C changed quotes on #include
C 
C Revision 1.4  91/03/22  12:20:41  cwelnak
C SUN version -- INC to #inc
C 
C Revision 1.3  90/11/13  14:04:53  khan
C Cleanup and SAVE statements
C 
C Revision 1.2  90/07/20  22:05:08  khan
C put #if unix ... to make it work also on vms
C 
C Revision 1.1  90/07/10  14:56:20  khan
C Initial revision
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C+++
C     PROGRAM    INTSPL
C
C     PURPOSE    TO INTERPOLATE THE VALUE Y FOR A POINT X, USING THE ARRAY
C                G(5,N) FROM THE PROGRAM CUBSPL.
C
C     INPUT      G(5,N) AS FROM CUBSPL.
C                N, THE # OF DATA POINTS IN G(5,N).
C                X, THE POINT WHERE YOU WANT THE INTERPOLATION TO BE MADE.   
C 
C     OUTPUT     Y, THE INTERPOLATED VALUE.
C                IER =1 FOR ERROR, =0 OTHERWISE.
C
C---              
      SUBROUTINE SPL_INT(G,N,X,Y,IER)
      IMPLICIT	REAL*8	(A-H,O-Z)
      REAL*8   G(5,N), X, Y, Z
      INTEGER  I, IER, N
      GMAX	= MAX(G(1,1),G(1,N))
      GMIN	= MIN(G(1,1),G(1,N))
      IF ((X .LT. GMIN) .OR. (X .GT. GMAX)) THEN
        WRITE(6,*) 'SPL_INT: x is outside the interpolation range.'
        IER = 1
        RETURN
      ELSE IF (X .EQ. G(1,N)) THEN
        I = N-1 
        GO TO 10
      END IF  
      I = 0
21    IF (G(1,I+1) .LE. X) THEN
        I = I + 1
      GOTO 21
	  END IF
10    Z = X - G(1,I)
      Y = G(2,I) + Z*(G(3,I) + Z*(G(4,I) + Z*G(5,I)))
      IER = 0
      RETURN
      END
