C +++
C
C $Source: /home/cvsroot/shadow/src/utils/post/sector.F,v $
C
C $Date: 2001/11/14 16:54:15 $
C 
C $Locker:  $
C 
C $Revision: 1.1 $
C 
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C $Log: sector.F,v $
C Revision 1.1  2001/11/14 16:54:15  khan
C 2001-11-14  Mumit Khan  <khan@nanotech.wisc.edu>
C
C 	* sector.F: Added back old file from VMS days.
C 	* Makefile.in: Update.
C
C Revision 1.5  1991/07/06  19:43:52  khan
C Grenoble Changes ...
C
C Revision 1.4  91/04/05  15:50:55  cwelnak
C changed quotes in #includes
C 
C Revision 1.3  91/03/25  15:56:31  khan
C SUN port -- INCLUDE -> #include
C 
C Revision 1.2  91/01/25  16:47:56  khan
C Ported to Ultrix
C 
C Revision 1.1  90/10/08  17:03:49  khan
C Initial revision
C 
C 
C ---

#if unix
#include		"./../../include/header.txt"
#elif vms
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif
C+++
C
C	PROGRAM		SECTOR
C
C	PURPOSE		To combine several tracings from SHADOW in
C			a single sectored ourtput
C
C	ALGORITHM	a) reads in source file
C			b) reads in M mirror files
C			c) computes OP to mirror
C			d) puts intercepts associated with shorter OP in
C			   a single continuation file
C
C	INPUT		a   BEGIN/STAR file
C			several MIRRS files
C
C	OUTPUT		a STAR file
C
C---
     	PROGRAM		SECTOR

#if unix
     	INCLUDE		'./../../include/common.blk'
    	INCLUDE		'./../../include/data.blk'
     	INCLUDE		'./../../include/namelist.blk'
#elif vms
    	INCLUDE		'SHADOW$INC:COMMON.BLK/LIST'
    	INCLUDE		'SHADOW$INC:DATA.BLK/LIST'
    	INCLUDE		'SHADOW$INC:NAMELIST.BLK/LIST'
#endif

     	CHARACTER*80	RSTRING, INFIL(4), FILSOUR, FILPAR
     	DIMENSION	RSOUR(12,N_DIM),RMIR(4,12,N_DIM),RTEMP(12,N_DIM)
     	DIMENSION	PHTEMP(3,N_DIM), PHMIR(4,3,N_DIM)
	DIMENSION	APTEMP(3,N_DIM), APMIR(4,3,N_DIM)
     	FILSOUR	=   RSTRING ('Source file ? ')
     	FILPAR	=   RSTRING ('Parameter file [ START.xx ] ? ')
     	NSEC	=   IRINT ('How many sectors [ max 4 ] ? ')
     	IF (NSEC.GT.4) STOP 'Too many. Please retry.'
     	CALL	RWNAME (FILPAR, 'R_OE', IERR)
     	IF (IERR.NE.0) STOP 'NAMELIST ERROR'
     	IPAR = 0

     	CALL	SETSOUR
     	CALL	IMREF
     	CALL	OPTAXIS (IPAR)
C
C Reads in source file
C
     	CALL	RBEAM	
     $	(FILSOUR,RSOUR,PHTEMP,APTEMP,NCOL,NPOINT,IFLAG,IERR) 
	IF (IERR.NE.0)	STOP	'Error in reading source ray file !'
     	WRITE(6,*)'Read ', NPOINT, ' from ',FILSOUR
C
C Reads in mirror files
C
     	DO 10 I=1,NSEC
     	  WRITE(6,*)'Sector # ',I
     	  INFIL(I) = RSTRING ('File name ? ')
     	  CALL RBEAM (INFIL(I),RTEMP,PHTEMP,APTEMP,NCOL,NP,IFLAG,IERR)
     	 DO 20 J=1,NPOINT
     	  DO 15 K=1,12
     	    RMIR(I,K,J) = RTEMP(K,J)
15     	  CONTINUE
20     	 CONTINUE
	 IF (NCOL.GT.12) THEN
     	  DO 30 J=1,NPOINT
     	   DO 25 K=1,3
     	     PHMIR(I,K,J) = PHTEMP(K,J)
25     	   CONTINUE
30     	  CONTINUE
	 END IF
	 IF (NCOL.EQ.18) THEN
     	  DO 40 J=1,NPOINT
     	   DO 35 K=1,3
     	     APMIR(I,K,J) = APTEMP(K,J)
35     	   CONTINUE
40     	  CONTINUE
	 END IF
10     	CONTINUE
C
C Rotates source in mirror reference frame
C
     	CALL	RESTART	(RSOUR,PHTEMP,APTEMP)
C
C Start calculations
C
     	DO 50 I=1,NPOINT
     	  KEEP = 1
     	 DO 45 KSEC=1,NSEC
C
C Computes distances
C
     	   DIST =        (RSOUR(1,I)-RMIR(KSEC,1,I))**2
     	   DIST = DIST + (RSOUR(2,I)-RMIR(KSEC,2,I))**2
     	   DIST	= DIST + (RSOUR(3,I)-RMIR(KSEC,3,I))**2
	  IF (KSEC.NE.1) THEN
           IF (DIST.LT.DIST0) THEN
     	    KEEP = KSEC
     	    DIST0 = DIST
     	   END IF
	  ELSE
	    DIST0 = DIST
	  END IF
45        CONTINUE
     	 DO 60 KOORD=1,12
     	   RTEMP (KOORD,I) = RMIR (KEEP,KOORD,I)
60     	 CONTINUE
	 IF (NCOL.GT.12) THEN
	   DO 70 KOORD = 1,3
	     PHTEMP(KOORD,I) = PHMIR (KEEP,KOORD,I)
70	   CONTINUE
	 END IF
	 IF (NCOL.EQ.18) THEN
	   DO 80 KOORD = 1,3
	     APTEMP(KOORD,I) = APMIR (KEEP,KOORD,I)
80	   CONTINUE
	 END IF
50       CONTINUE
C
C Store mirror
C
        IFORM = 0
     	CALL	WRITE_OFF 
     $('MIRRS.00',RTEMP,PHTEMP,APTEMP,NCOL,NPOINT,IFLAG,IFORM,IERR) 
     	IF (IERR.NE.0) STOP 'Error creating output ray file'
C
C Array is ready; compute image
C
C    	CALL	IMAGE	(RTEMP,APTEMP,PHTEMP,IK)
C
C All done.
C
     	STOP
     	END
