C +++
C
C Source: src/trace/diffrac.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log:	diffrac.F
C Revision 1.7  91/04/05  15:05:44  cwelnak
C changed quotes on #includes
C 
C Revision 1.6  91/03/21  16:14:38  cwelnak
C SUN version -- INCLUDE to #include
C 
C Revision 1.5  90/11/13  14:01:46  khan
C Cleanup and SAVE statements
C 
C Revision 1.4  90/07/19  21:37:46  khan
C Put #ifdef's to make it work on BOTH VMS and Ultrix
C 
C Revision 1.3  90/07/14  22:51:05  khan
C All public include files (common.blk, etc) are now in ./../include/ dir.
C 
C Revision 1.2  90/07/14  12:15:19  khan
C All files opened with STATUS=UNKNOWN (as opposed to NEW as in VMS).
C 
C Revision 1.1  90/07/10  14:56:05  khan
C Initial revision
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C+++
C
C	SUBROUTINE	DIFFRAC
C
C	PURPOSE		to compute the rotation angle to be given to a
C			grating at a given wavelength, for the case of 
C			a constant included angle (TGM, SEYA)
C
C	OUTPUTS 	X_ROT rotation angle in degrees
C--
     	SUBROUTINE	DIFFRAC
#if defined(unix) || HAVE_F77_CPP
c
c This causes problems with F77 drivers, since can't use -I directive.
c so I'll use the standard cpp directive instead.
c
c	INCLUDE         './../include/common.blk'
c
c
#	include		<common.blk>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:COMMON.BLK/LIST'
#endif

     	DEFLEC	=   ( T_INCIDENCE + T_REFLECTION )
     	THETA0	=   DEFLEC/2*TORAD

     	SIN_X_ROT =  - ORDER*R_LAMBDA*1.0D-7*RULING/2/COS(THETA0)/10
     	IF (ABS(SIN_X_ROT).GE.1.0D0)	THEN
		WRITE(6,*)
     $'**************************************************************'
     $,'*********************     WARNING   **************************'
     $,'**************************************************************'
     $,'            DIFFRACTION    ANGLE  IS  COMPLEX	              '
     $,'**************************************************************'
		CALL LEAVE ('DIFFRAC','Check program inputs.',0)
     	ELSE
     	END IF
     	X_ROT	=   ASIN(SIN_X_ROT)
     	X_ROT	=   X_ROT*TODEG
     	RETURN
      END
C
C+++
C	subroutine	HOLO_SET
C
C	this subroutine will compute the ruling density at the origin for
C	the case of an holographic grating. This will ensure accuracy in
C	the optical axis position. It will also compute some vectors
C	used later.
C
C--
     	SUBROUTINE	HOLO_SET
#if defined(unix) || HAVE_F77_CPP
c
c This causes problems with F77 drivers, since can't use -I directive.
c so I'll use the standard cpp directive instead.
c
c	INCLUDE         './../include/common.blk'
c
c
#	include		<common.blk>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:COMMON.BLK/LIST'
#endif
    	REAL*8	HYPER(3),HYPER1(3),PPOUT(3),VNOR(3),VTAN(3)
   	REAL*8	DIS1(3),DIS2(3)
	REAL*8	VTEMP(3)
     	DATA	PPOUT	/3*0.0D0/
     	DATA	VNOR	/2*0.0D0,1.0D0/
C
C Establishes the reference vectors used to compute the grooves.
C The azimuthal rotation angles are defined as CCW
C
     	ALPHA_1	=   HOLO_RT1*TORAD
     	ALPHA_2 =   HOLO_RT2*TORAD
		IF (F_RULING.EQ.2) THEN
     	 IF (F_PW.EQ.0) THEN
	      HOLO1(1) =   HOLO_R1*SIN(HOLO_DEL*TORAD)*SIN(ALPHA_1)
	      HOLO1(2) =   HOLO_R1*SIN(HOLO_DEL*TORAD)*COS(ALPHA_1)
	      HOLO1(3) =   HOLO_R1*COS(HOLO_DEL*TORAD)
	      HOLO2(1) =   HOLO_R2*SIN(HOLO_GAM*TORAD)*SIN(ALPHA_2)
	      HOLO2(2) =   HOLO_R2*SIN(HOLO_GAM*TORAD)*COS(ALPHA_2)
	      HOLO2(3) =   HOLO_R2*COS(HOLO_GAM*TORAD)
     	 ELSE IF (F_PW.EQ.1) THEN
	      HOLO1(1) =   SIN(HOLO_DEL*TORAD)*SIN(ALPHA_1)
	      HOLO1(2) = - SIN(HOLO_DEL*TORAD)*COS(ALPHA_1)
	      HOLO1(3) = - COS(HOLO_DEL*TORAD)
	      HOLO2(1) =   HOLO_R2*SIN(HOLO_GAM*TORAD)*SIN(ALPHA_2)
	      HOLO2(2) =   HOLO_R2*SIN(HOLO_GAM*TORAD)*COS(ALPHA_2)
	      HOLO2(3) =   HOLO_R2*COS(HOLO_GAM*TORAD)
     	 ELSE IF (F_PW.EQ.2) THEN
	      HOLO1(1) =   HOLO_R1*SIN(HOLO_DEL*TORAD)*SIN(ALPHA_1)
	      HOLO1(2) =   HOLO_R1*SIN(HOLO_DEL*TORAD)*COS(ALPHA_1)
	      HOLO1(3) =   HOLO_R1*COS(HOLO_DEL*TORAD)
	      HOLO2(1) =   SIN(HOLO_GAM*TORAD)*SIN(ALPHA_2)
	      HOLO2(2) = - SIN(HOLO_GAM*TORAD)*COS(ALPHA_2)
	      HOLO2(3) = - COS(HOLO_GAM*TORAD)
     	 ELSE IF (F_PW.EQ.3) THEN
	      HOLO1(1) =   SIN(HOLO_DEL*TORAD)*SIN(ALPHA_1)
	      HOLO1(2) = - SIN(HOLO_DEL*TORAD)*COS(ALPHA_1)
	      HOLO1(3) = - COS(HOLO_DEL*TORAD)
	      HOLO2(1) =   SIN(HOLO_GAM*TORAD)*SIN(ALPHA_2)
	      HOLO2(2) = - SIN(HOLO_GAM*TORAD)*COS(ALPHA_2)
	      HOLO2(3) = - COS(HOLO_GAM*TORAD)
     	 ELSE
     	 END IF
		ELSE
		END IF
C
C HOLO1,HOLO2 are the laser sources positions in the case of spherical
C waves, direction cosines for plane waves.
C
     	DO 11 I=1,3
     	 DIS1(I) = HOLO1(I)
     	 DIS2(I) = HOLO2(I)
11   	CONTINUE
C
C DIS1,DIS2 are the direction cosines from laser sources to intercepts
C
     	 IF (F_PW.EQ.0) THEN		! Both spherical sources
     		CALL	VECTOR	(HOLO1,PPOUT,DIS1)
     		CALL	VECTOR	(HOLO2,PPOUT,DIS2)
     		CALL	NORM	(DIS1,DIS1)
     		CALL	NORM	(DIS2,DIS2)
     	 ELSE IF (F_PW.EQ.1) THEN	! plane/spherical
     		CALL	VECTOR	(HOLO2,PPOUT,DIS2)
     		CALL	NORM	(DIS2,DIS2)
     	 ELSE IF (F_PW.EQ.2) THEN	! spherical/plane
     		CALL	VECTOR	(HOLO1,PPOUT,DIS1)
     		CALL	NORM	(DIS1,DIS1)
     	 ELSE IF (F_PW.EQ.3) THEN	! plane/plane
C  Nothing to do. DIS1,DIS2 are already normalized.
     	 ELSE
     	 END IF
C
C If one of the source is a virtual one, we have to change the direction
C of one of the two versors.
C
     	IF (F_VIRTUAL.EQ.1) THEN		! real /virtual
     	  CALL SCALAR (DIS2,-1.0D0,DIS2)
     	ELSE IF (F_VIRTUAL.EQ.2) THEN		! virtual /real
     	  CALL SCALAR (DIS1,-1.0D0,DIS1)
     	ELSE IF (F_VIRTUAL.EQ.3) THEN		! virtual /virtual
     	  CALL SCALAR (DIS1,-1.0D0,DIS1)
     	  CALL SCALAR (DIS2,-1.0D0,DIS2)
     	END IF
C
     		CALL	VECTOR	(DIS2,DIS1,HYPER)
     		CALL	NORM	(HYPER,HYPER)
C
C  HYPER is the normal to the hyperboloid in PPOUT. Its direction will
C  be in the y-z plane, if ALPHA_1,ALPHA_2 are zero.
C
     		CALL	CROSS	(HYPER,VNOR,VTEMP)
     		CALL	NORM	(VTEMP,VTEMP)
     		CALL	CROSS	(VNOR,VTEMP,VTAN)
     		CALL	NORM	(VTAN,VTAN)
C
C  VTAN is now a vector tangent to the grating surface and orthogonal
C  to the groove. It MUST be (0,1,0) if the ALPHA_1, ALPHA_2 are zero.
C  We compute now the ruling density at that point.
C
     		CALL	VECTOR	(DIS2,DIS1,HYPER1)
     		CALL	DOT	(VTAN,HYPER1,ADJUST)
     		RULING	=   ADJUST*1.0D8/HOLO_W
#ifdef vms
     	OPEN  (24,FILE='RULING',STATUS='NEW')
#else
     	OPEN  (24,FILE='RULING',STATUS='UNKNOWN')
	REWIND (24)
#endif
     	IF (F_VIRTUAL.EQ.0) THEN
     	  WRITE (24,*) 'Source:	REAL,		Exit:	REAL'
     	ELSE IF (F_VIRTUAL.EQ.1) THEN
     	  WRITE (24,*) 'Source:	REAL,		Exit:	VIRTUAL'
     	ELSE IF (F_VIRTUAL.EQ.2) THEN
     	  WRITE (24,*) 'Source:	VIRTUAL,	Exit:	REAL'
     	ELSE IF (F_VIRTUAL.EQ.3) THEN
     	  WRITE (24,*) 'Source:	VIRTUAL,	Exit:	VIRTUAL'
     	END IF
     	WRITE (24,1010) HOLO_DEL
     	WRITE (24,1020) HOLO_R1
     	WRITE (24,1030) HOLO_GAM
     	WRITE (24,1040) HOLO_R2
 		WRITE (24,1200) HOLO1(1),HOLO1(2),HOLO1(3)
 		WRITE (24,1210) HOLO2(1),HOLO2(2),HOLO2(3)
 	 	WRITE (24,1220) VTAN(1),VTAN(2),VTAN(3)
    	WRITE (24,1000)
     	WRITE (24,*)	RULING
     	WRITE (24,1100)
     	CLOSE (24)
     	RETURN
1000	FORMAT (1X,'The ruling density at the origin is : ')
1010	FORMAT (1X,'Entrance slit side incidence angle : ',G19.12)
1015	FORMAT (1X,'Source is: ',A20)
1020	FORMAT (1X,'Entrance slit side distance        : ',G19.12)
1025	FORMAT (1X,'Exits is : ',A20)
1030	FORMAT (1X,'Exit slit side incidence angle : ',G19.12)
1040	FORMAT (1X,'Exit slit side distance        : ',G19.12)
1100	FORMAT (1X,'Lines/cm.')
1200	FORMAT (1X,'Position of Entrance Slit Source : ',/,
     $		1x,3(5X,G19.12))
1210	FORMAT (1X,'Position of Exit     Slit Source : ',/,
     $		1x,3(5X,G19.12))
1220	FORMAT (1X,'Vector orthogonal to grooves at (0,0,0) : ',/,
     $		1x,3(5X,G19.12))
     	END
