C +++
C
C Source: src/tools/math/rcdf.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log:	rcdf.F
C Revision 1.2  90/11/13  14:03:15  khan
C Cleanup and SAVE statements
C 
C Revision 1.1  90/07/17  13:55:06  khan
C Initial revision
C 
C 
C ---

C+++
C	SUBROUTINE	RCDF
C
C	PURPOSE		To read the unformatted CDF for SR radiation
C
C---
     	SUBROUTINE	RCDF	( ARG, VALUE, ENERGY, ISEED, IER)
#if defined(unix) || HAVE_F77_CPP
c
c This causes problems with F77 drivers, since can't use -I directive.
c so I'll use the standard cpp directive instead.
c
c	INCLUDE         './../include/common.blk'
c
c
#	include		<common.blk>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:COMMON.BLK/LIST'
#endif
     	REAL*4		CDFG0  (2,1010)
     	REAL*4		CDF	(4,21,250),XPHOT(1000),XANG(1000)
     	REAL*4		CPHOT(10)
     	EXTERNAL	CPHOT,CANG
     	IF (IER.EQ.-1) THEN
C
C Reads in the total flux distribution
C
     	OPEN	(20, FILE='srdistr.cdf', STATUS='OLD', READONLY,
     $		 FORM='UNFORMATTED')
     	READ	(20)	ICOL,NP
     	DO 10 I=1,NP
     	  READ	(20)	CDFG0(1,I),CDFG0(2,I)
10      CONTINUE 
     	CLOSE	(20)
C
C Reads in now the angle data
C
     	OPEN	(20, FILE='SRSPEC', STATUS='OLD', READONLY,
     $		 FORM='UNFORMATTED')
     	READ	(20)	NPHOT,ICOL,IST
     	DO 20 I=1,NPHOT
     	  READ (20)	XPHOT(I),XANG(I)
     	 DO 15 J=1,21
     	   READ (20)	CDF(1,J,I), CDF(2,J,I), CDF(3,J,I), CDF(4,J,I)
15       CONTINUE 
20      CONTINUE 
C
C Rescale sthe photon energy   ------->>>>> This must be checked
C
     	DO 30 I=1,10
     	  CPHOT(I) = 1957.0/BENER*PHOTON(I)
30      CONTINUE 
C
C Define the limits of interest of the SR. This is done by fitting
C a spline to the data and inverting the spline.
C
     	RETURN
C-----------------------------------------------------------------
C Finds the distribution
C
     	ELSE IF (IER.EQ.0) THEN
C
C First the photon energy
C
     	VALUE	=   CPHOT	(ARG)
     	ARG	=   RAN 	(ISEED)
     	ANGLE	=   CANG	(ARG)
     	RETURN
     	END
C+++
C	FUNCTION	CPHOT
C
C	PURPOSE		Returns a value of photon energy from the CDF
C
C---
     	FUNCTION	CPHOT	(XIN)
     	
