C +++
C
C Source: src/source/id/ucdf.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log:	ucdf.F
C Revision 1.6  91/07/06  20:03:58  khan
C Grenoble and after. Minor changes
C 
C Revision 1.5  91/04/05  14:47:39  cwelnak
C changed quotes on #includes
C 
C Revision 1.4  91/03/21  15:38:41  cwelnak
C SUN version -- INCLUDE to #include
C 
C Revision 1.3  90/10/30  00:01:42  khan
C Fix Ultrix -> VMS things that got screwed up in VMS -> Ultrix.
C 
C Revision 1.2  90/07/17  23:04:53  khan
C Fixed STATUS=NEW in OPEN statements to UNKNOWN for Unix.
C Substitue pre_rad.blk for PRE_RAD.BLK
C 
C Revision 1.1  90/07/17  15:36:36  khan
C Initial revision
C 
C 
C ---


C+++
C	
C	SUBROUTINE		UCDF
C
C	PURPOSE			To compute the CDF's from the RN's
C
C	INPUT:			RN0(phi, theta, ener)
C				RN1(     theta, ener)
C				RN2(            ener)
C
C	OUTPUT:			CDF0(phi, theta, ener)
C				CDF1(     theta, ener)
C				CDF2(            ener)
C---
	SUBROUTINE		UCDF(RN0,RN1,RN2,CDF0,CDF1,CDF2,
     $					UPHI,UTHETA,UENER)

	IMPLICIT		REAL*8	(A-H,O-Z)

#if defined(unix) || HAVE_F77_CPP
#	include			"pre_rad.blk"
#elif defined(vms)
	INCLUDE			'PRE_RAD.BLK/LIST'
#endif

	DIMENSION		UPHI(31,31,51),UTHETA(31,51),UENER(51) 
	DIMENSION		RN0(31,31,51),RN1(31,51),RN2(51) 
	DIMENSION		CDF0(31,31,51),CDF1(31,51),CDF2(51)

	DIMENSION		YRN0(1001),YRNN0(1001)
	DIMENSION		YRN1(1001),YRNN1(1001)
	DIMENSION		YRN2(1001),YRNN2(1001)

C 
C  HERE WE CALCULATE THE CDF's.  
C
	 DO 15 K = 1,NE
	   DO 25 J = 1,NT
	      DO 35 I = 1,NP
		 YRN0(I) = RN0(I,J,K)
35	      CONTINUE
C  Use trapezoidal integration
		 YRNN0(1) = 0.0D0		
		 DO 45 I=2,NP
		   YRNN0(I) = YRNN0(I-1) + (UPHI(I,J,K)-UPHI(I-1,J,K))*
     $					0.5D0*( YRN0(I-1) + YRN0(I) )
45 		 CONTINUE
C						! integrate over phi
	      DO 55 I = 1,NP			! Note, just integration,
		 CDF0(I,J,K) = YRNN0(I)	! variable not eliminated.
55	      CONTINUE
25	   CONTINUE
15	 CONTINUE
C 
	 DO 65 K = 1,NE
	   DO 75 J = 1,NT
	      YRN1(J) = RN1(J,K)
75	   CONTINUE
C  Use trapezoidal integration
		 YRNN1(1) = 0.0D0
		 DO 85 J=2,NT
		   YRNN1(J) = YRNN1(J-1) + (UTHETA(J,K)-UTHETA(J-1,K))*
     $					0.5D0*( YRN1(J-1) + YRN1(J) )
85		 CONTINUE
C						! integrate over theta
	   DO 95 J = 1,NT
	      CDF1(J,K) = YRNN1(J)
95 	   CONTINUE
65	 CONTINUE
C
	 DO 115 K=1,NE
	   YRN2(K) = RN2(K)
115 	 CONTINUE
C  Use trapezoidal integration
	 YRNN2(1) = 0.0D0
	 DO 125 K=2,NE
	   YRNN2(K) = YRNN2(K-1) + (UENER(K)-UENER(K-1))*
     $				0.5D0*( YRN2(K-1) + YRN2(K) )
125	 CONTINUE
C
	 DO 135 K=1,NE
	   CDF2(K) = YRNN2(K)
135 	 CONTINUE
C	
	RETURN
	END

