C+++
C
C Source: src/utils/post/graphics/plotxy.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log:	plotxy.F
C Revision 1.4  91/03/11  13:08:28  v_white
C *** empty log message ***
C 
C Revision 1.3  90/11/28  14:07:04  khan
C changed some ifdefs
C 
C Revision 1.1  90/10/08  17:03:45  khan
C Initial revision
C 
C 
C ---
C++++
C
C	PROGRAM		PLOT_XY
C
C	PURPOSE		To generate an x-y plot of any two columns of
C			SHADOW output.
C
C	INPUT		A "ray" file.
C
C	OUTPUT		A file suitable for TOPDRAWER
C			A file suitable for Primvs
C
C	Link using GRA:GRALIB.LNK or GRA:TDSHARE.LNK
C----
     	PROGRAM		PLOTXY
	IMPLICIT        REAL*8          (A-E,G-H,O-Z)
#if defined(unix) || HAVE_F77_CPP
#       include	        <dim.par>
#elif defined(vms)
	INCLUDE		'SHADOW$INC:DIM.PAR/LIST'
	REAL		XPLOT, YPLOT
#endif
	PARAMETER	(MAXGS = 101)
     	REAL*8		RAY(18,N_DIM),RAY2(18,N_DIM)
	REAL*8		A_SQUARE(N_DIM),A2_SQUARE(N_DIM)
C
C Save the large arrays so as not to overflow stack (eg., on DEC ALPHA)
C
	SAVE		RAY, RAY2, A_SQUARE, A2_SQUARE
     	DATA	TWOPI 	/  6.2831 85307 17958 64679 25287 D0 /
	DATA	TOCM	/  1.239 852	D-4		     /
	DATA	TOANGS 	/  1.239 852    D+4		     /
	DATA    TORAD   /  0.0174 53292 51994 32957 69237 D0 /
     	CHARACTER * 80 	FILE_IN
     	CHARACTER * 60	FILETEXT
     	CHARACTER * 17	DATETEXT
	CHARACTER * 80	COMMENT
     	CHARACTER * 80	TEXT,TEXT1,TEXT2,TEXT3,TEXT4,TEXT5
     	CHARACTER * 80	RSTRING,FILE_I0,TEXT6,TEXT7,TEXT8
     	CHARACTER * 20	TODAY
     	DATA	COMMENT	/'   '/
     	DATA	TODAY	/'                    '/
	data	i_td / 0 /
     	DIMENSION	TEST(30),R_LOW(30),R_UPP(30)
     	DIMENSION	X_ARRAY(100),Y_ARRAY(100),XYLIM(4)
     	DIMENSION	XMEAN(30),STDEV(30),VAR(30)
	DIMENSION	XPLOT(N_DIM),YPLOT(N_DIM)
	DIMENSION	XLOSS(N_DIM),YLOSS(N_DIM)
	DIMENSION	PIXEL(MAXGS,MAXGS),XSID(MAXGS)
     	DIMENSION	YSID(MAXGS), PIXNEW(MAXGS,MAXGS)
     	DIMENSION	ZDATA(MAXGS*MAXGS),CVALUE(20)
	INTEGER		ICONT(10),IPLT(10)
#ifndef vms
	CHARACTER*1024	PRIMVS
	CHARACTER*1024	PRIMVSPATH
#endif

1     	CALL	ALINE	('PLOT> Input file? ',FILE_IN)
     	CALL	RBEAM18	(FILE_IN,RAY,NCOL,NPOINT,IFLAG,IERR)
	IF (IERR.NE.0)	STOP	'Error in reading ray file.'
C
    	CALL	FILEINFO  (FILE_IN)
    	CALL	NEXTFILE  (FILETEXT,DATETEXT)
	WRITE(6,*) 'PLOT> Options --- Enter'
     	WRITE(6,*) 'PLOT>   0   for excluding the losses'
     	WRITE(6,*) 'PLOT>   1   for including only the losses'
     	WRITE(6,*) 'PLOT>   2   for including all the rays.'
     	ILOST = IRINT ('PLOT> Then ? ')
	WRITE(6,*) 'PLOT> Comment for plot [ 80 char ] ?'
	WRITE(6,*) '*******************/*******************/',
     $'*******************/*******************/'
     	READ (5,1000)	COMMENT
C1000	FORMAT (Q,A)
1000	FORMAT (A)
	NLOSS	=   0
     	DO 11 I=1,NPOINT
     	IF (RAY(10,I).LT.0.0) NLOSS = NLOSS + 1
11      CONTINUE
100     CONTINUE
C     	CALL	LIB$ERASE_PAGE(1,1)
     	WRITE(6,*) 'PLOT> File read OK. Full specifications:'
     	WRITE(6,*) '     ',FILETEXT
     	WRITE(6,*) '     ','Was created : ',DATETEXT
     	WRITE(6,*) ' '
     	NGOOD = NPOINT - NLOSS
	WRITE(6,*) 'PLOT>  Found ',NGOOD,
     $		' good points out of',NPOINT
C********1*********2*********3*********4*********5*********6*********7**
	WRITE(6,*) 'PLOT>  The following columns are defined for each ',
     $	'ray :'
	IF (NCOL.GE.12) THEN
	  WRITE(6,*) '       1)  the regular columns [1-12]'
	  IF (NCOL.GE.13) THEN
	    WRITE(6,*) '       2)  optical path [13]'
	    IF (NCOL.EQ.18) THEN
	      WRITE(6,*) '       3)  phase angle of As[14], Ap[15], and'
     $,' the Ap vector [16-18]'
	    END IF
	  END IF
	END IF
C
     	R_LOW(1) =   1.0D+20
     	R_UPP(1) = - 1.0D+20
     	R_LOW(2) =   1.0D+20
     	R_UPP(2) = - 1.0D+20
     	R_LOW(3) =   1.0D+20
     	R_UPP(3) = - 1.0D+20

     	R_LOW(4) =   1.0D+20
     	R_UPP(4) = - 1.0D+20
     	R_LOW(5) =   1.0D+20
     	R_UPP(5) = - 1.0D+20
     	R_LOW(6) =   1.0D+20
     	R_UPP(6) = - 1.0D+20

     	R_LOW(11) =   1.0D+20
     	R_UPP(11) = - 1.0D+20

     	R_LOW(13) =   1.0D+20
     	R_UPP(13) = - 1.0D+20

     	R_LOW(20) =   1.0D+20
     	R_UPP(20) = - 1.0D+20

     	DO 300 I=1,NPOINT
	 IF (ILOST.EQ.0) THEN
	   IF (RAY(10,I).LT.0.0D0)   GO TO 300
	 ELSE IF (ILOST.EQ.1) THEN
     	   IF (RAY(10,I).GE.0.0D0)   GO TO 300
     	 ELSE
     	 END IF
     	TEST(1)	=   RAY(1,I)
     	TEST(2)	=   RAY(2,I)
     	TEST(3)	=   RAY(3,I)
     	TEST(4)	=   RAY(4,I)
     	TEST(5)	=   RAY(5,I)
     	TEST(6)	=   RAY(6,I)
     	TEST(11) =   RAY(11,I)
     	TEST(13) =   RAY(13,I)
     	TEST(20) =   RAY(4,I)**2 + RAY(6,I)**2
     	TEST(20) =   ABS( SQRT(TEST(20))/RAY(5,I) )
     	R_LOW(1)= MIN(R_LOW(1),TEST(1))
     	R_UPP(1)= MAX(R_UPP(1),TEST(1))
     	R_LOW(2)= MIN(R_LOW(2),TEST(2))
     	R_UPP(2)= MAX(R_UPP(2),TEST(2))
     	R_LOW(3)= MIN(R_LOW(3),TEST(3))
        R_UPP(3)= MAX(R_UPP(3),TEST(3))

     	R_LOW(4)= MIN(R_LOW(4),TEST(4))
     	R_UPP(4)= MAX(R_UPP(4),TEST(4))
     	R_LOW(5)= MIN(R_LOW(5),TEST(5))
     	R_UPP(5)= MAX(R_UPP(5),TEST(5))
     	R_LOW(6)= MIN(R_LOW(6),TEST(6))
     	R_UPP(6)= MAX(R_UPP(6),TEST(6))

     	R_LOW(11)= MIN(R_LOW(11),TEST(11))
	R_UPP(11)= MAX(R_UPP(11),TEST(11))

     	R_LOW(13)= MIN(R_LOW(13),TEST(13))
	R_UPP(13)= MAX(R_UPP(13),TEST(13))

     	R_LOW(20)= MIN(R_LOW(20),TEST(20))
	R_UPP(20)= MAX(R_UPP(20),TEST(20))
300	CONTINUE
C
C computes centers and variance
C
     	DO 12 JCOL=1,6
     	  XMEAN(JCOL)	= 0.0D0
     	  VAR(JCOL)	= 0.0D0
     	  NPCOL		= 0
     	 DO 13 I=1,NPOINT
     	  IDOIT = 1
     	  IF (ILOST.EQ.0.AND.RAY(10,I).LT.0.0) IDOIT = 0
     	  IF (ILOST.EQ.1.AND.RAY(10,I).GE.0.0) IDOIT = 0
     	  IF (IDOIT.EQ.1) THEN
     	    XMEAN(JCOL) 	= XMEAN(JCOL) + RAY(JCOL,I)
     	    VAR(JCOL)	= VAR(JCOL) + RAY(JCOL,I)**2
     	    NPCOL	=   NPCOL + 1
     	  END IF
13	 CONTINUE
     	  IF (NPCOL.EQ.0) THEN
     	    WRITE (6,*) 'NPCOL zero for column ',JCOL
	    GO TO 12
     	  END IF
     	  XMEAN(JCOL) = XMEAN(JCOL)/NPCOL
     	  VAR(JCOL)   = VAR(JCOL)/NPCOL - XMEAN(JCOL)**2
     	 IF (VAR(JCOL).GE.0.0D0) THEN
     	   STDEV(JCOL) = SQRT(VAR(JCOL))
     	 ELSE
     	   STDEV(JCOL) = 0.0D0
     	 END IF
12     	CONTINUE
     	WRITE (6,*)
     	WRITE (6,2000)
     	WRITE (6,*)
     	WRITE (6,2010) 1,'X ',R_LOW(1),R_UPP(1),XMEAN(1),STDEV(1)
     	WRITE (6,2010) 2,'Y ',R_LOW(2),R_UPP(2),XMEAN(2),STDEV(2)
     	WRITE (6,2010) 3,'Z ',R_LOW(3),R_UPP(3),XMEAN(3),STDEV(3)
     	WRITE (6,2010) 4,'X''',R_LOW(4),R_UPP(4),XMEAN(4),STDEV(4)
     	WRITE (6,2010) 5,'Y''',R_LOW(5),R_UPP(5),XMEAN(5),STDEV(5)
     	WRITE (6,2010) 6,'Z''',R_LOW(6),R_UPP(6),XMEAN(6),STDEV(6)
        WRITE (6,2020) 11,'Photon Energy  (eV)',TOCM*R_LOW(11)/TWOPI
     $,R_UPP(11)*TOCM/TWOPI
     	WRITE (6,2020) 20,'Numerical Aperture',R_LOW(20),R_UPP(20)
#if defined (vms)
2000	FORMAT (//,T2,'Column',T5,' Par',T10,'Minimum:',T25,'Maximum:',
     $		T40,'Center:',T55,'St. Dev.:')
#else
2000    FORMAT (//,T2,'Col',T5,' Par',T10,'Minimum:',T25,'Maximum:',
     $          T40,'Center:',T55,'St. Dev.:')
#endif

2010	FORMAT (1X,T2,I2,T5,A3,T10,G12.5,T25,G12.5,T40,G12.5,T55,G12.5)
2020	FORMAT (1X,T2,I2,T7,A,T30,G12.5,T45,G12.5)

     	WRITE(6,*) ' '
     	WRITE(6,*) 'PLOT> Options. You may plot any two rows from '
	WRITE(6,*) '      the above list versus each other. '
	WRITE(6,*) '      You may also plot any of them versus the '
	WRITE(6,*) '      ray Numerical Aperture. N.A. -- enter 20.'
     	WRITE(6,*) ' '
     	WRITE(6,*) 'PLOT> Rows to use for plot :'
     	IX	=   IRINT ('PLOT>   for horizontal axis ? ')
     	IY	=   IRINT ('PLOT>   for vertical axis   ? ')
     	IF (IX.EQ.11.OR.IY.EQ.11) THEN
     	  WRITE(6,*) 'PLOT> Units for plot: '
     	  WRITE(6,*) '      0   For  cm-1'
     	  WRITE(6,*) '      1   For  eV'
     	  WRITE(6,*) '      2   For  Angs'
     	  IUNIT = IRINT ('PLOT> Then ? ')
     	ENDIF
     	WRITE(6,*) ' '
     	WRITE(6,*) 'PLOT> Scaling options. Enter '
     	WRITE(6,*) ' '
     	WRITE(6,*) '       0   For automatic scaling'
     	WRITE(6,*) '       1   For cartesian scaling'
     	WRITE(6,*) '       2   For external limits'
     	IPLOT = IRINT ('PLOT> Then ? ')
c
c takes care of the Optical Path Case -- since the variation is small
c we must avoid precision problems in the plotting, so that we will be
c plotting the OPD.
c 
     	  IF (IX.EQ.13.OR.IY.EQ.13) THEN
     	    P_CENT = (R_LOW(13)+R_UPP(13))/2.0D0
     	    P_DEL  = R_UPP(13) - R_LOW(13)
     	    R_LOW(13) = - 0.5D0*P_DEL
     	    R_UPP(13) = + 0.5D0*P_DEL
     	  END IF
     	  X_LOW = R_LOW(IX)
     	  Y_LOW = R_LOW(IY)
     	  X_UPP = R_UPP(IX)
     	  Y_UPP = R_UPP(IY)
     	  IF (IUNIT.EQ.1) THEN
     	   IF (IX.EQ.11) THEN
     	     X_LOW = TOCM*X_LOW/TWOPI
     	     X_UPP = TOCM*X_UPP/TWOPI
     	   ELSE IF (IY.EQ.11) THEN
     	     Y_LOW = TOCM*Y_LOW/TWOPI
     	     Y_UPP = TOCM*Y_UPP/TWOPI
     	   END IF
     	  ELSE IF (IUNIT.EQ.2) THEN
     	   IF (IX.EQ.11) THEN
     	     X_TMP = X_LOW
     	     X_LOW = TWOPI/X_UPP*1.0D8
     	     X_UPP = TWOPI/X_TMP*1.0D8
     	   ELSE IF (IY.EQ.11) THEN
     	     Y_TMP = Y_LOW
     	     Y_LOW = TWOPI/Y_UPP*1.0D8
     	     Y_UPP = TWOPI/Y_TMP*1.0D8
     	   END IF
     	  END IF
     	IF (IPLOT.EQ.0) THEN
     	  CALL	ROUNDOUT (X_LOW,X_UPP,Y_LOW,Y_UPP)
     	ELSE IF (IPLOT.EQ.1) THEN
     	  X_CEN = 0.5D0*(X_LOW+X_UPP)
     	  Y_CEN = 0.5D0*(Y_LOW+Y_UPP)
     	  X_DEL = X_UPP - X_LOW
     	  Y_DEL = Y_UPP - Y_LOW
     	  DEL	= MAX(X_DEL,Y_DEL)
     	  X_LOW = X_CEN - 0.5D0*DEL
     	  X_UPP = X_CEN + 0.5D0*DEL
     	  Y_LOW = Y_CEN - 0.5D0*DEL
     	  Y_UPP = Y_CEN + 0.5D0*DEL
     	  CALL	ROUNDOUT (X_LOW,X_UPP,Y_LOW,Y_UPP)
     	ELSE
     	  WRITE(6,*) 'PLOT> Enter limits. '
     	  WRITE(6,*) 'PLOT> Horizontal min.: '
	  READ(5,*)  X_LOW
C     	  X_LOW	= RNUMBER ('PLOT> Horizontal min.: ')
     	  WRITE(6,*) 'PLOT> Horizontal max.: '
	  READ(5,*)  X_UPP
C     	  X_UPP = RNUMBER ('PLOT> Horizontal max.: ')
     	  WRITE(6,*) 'PLOT> Vertical min.: '
	  READ(5,*)  Y_LOW
C     	  Y_LOW = RNUMBER ('PLOT> Vertical min.  : ')
     	  WRITE(6,*) 'PLOT> Vertical max.: '
	  READ(5,*)  Y_UPP
C     	  Y_UPP = RNUMBER ('PLOT> Vertical max.  : ')
     	END IF
C
     	IGRID = 0
     	WRITE(6,*) 'PLOT> Plotting options : '
	WRITE(6,*) '       0   For scattered plot'
	WRITE(6,*) '       1   For connected plot'
	WRITE(6,*) '       2   For contour plot'
     	IGRID = IRINT ('PLOT> Then ? ' )
     	IF (IGRID.EQ.1) THEN
     	 WRITE(6,*) 'PLOT> Grid size [ Nx by Ny ].'
     	 NGX	=   IRINT ('PLOT> Nx : ')
     	 NGY	=   IRINT ('PLOT> Ny : ')
	ELSE IF (IGRID.EQ.2) THEN
     	 WRITE(6,*) 
     $'PLOT> Number of bins [Nx by Ny] to prepare the contours.'
     	 NGX	=   IRINT ('PLOT> Nx : ')
     	 NGY	=   IRINT ('PLOT> Ny : ')
	 NCONT	=   IRINT ('PLOT> Number of contours : ')
	 IPLT(2) =  IRINT 
     $	 ('PLOT> Degree of polynomial used for joining [0=default] : ')
	 K_REFL	=   IRINT ('PLOT> Included reflectivity ? ')
	 IF (K_REFL.EQ.1) THEN
C
C We need A**2 later on then.
C
	   IF (NCOL.EQ.18) THEN
	     DO 14 I = 1, NPOINT
	       A_SQUARE(I)= RAY(7,I)**2 + RAY(8,I)**2 + RAY(9,I)**2
     $			+ RAY(16,I)**2 + RAY(17,I)**2 + RAY(18,I)**2
14	     CONTINUE
	   ELSE
	     DO 16 I = 1, NPOINT
	       A_SQUARE(I)= RAY(7,I)**2 + RAY(8,I)**2 + RAY(9,I)**2
16	     CONTINUE
	   END IF
	   NORMAL 	= 0
	   WRITE(6,*) 'PLOT> Options : '
	   WRITE(6,*) '  0   Power density [J/area] reflected/' //
     $		'transmitted'
	   WRITE(6,*) '  1   Power density [J/area] absorbed'
	   WRITE(6,*) '  2   Local reflectivity/transmission'
	   K_ACT = IRINT('PLOT> Then ? ')
	   IF (K_ACT.EQ.1.OR.K_ACT.EQ.2) THEN
	     FILE_I0 	= RSTRING ('PLOT> File to use for Io : ')
	     CALL	RBEAM18
     $		(FILE_I0,RAY2,NCOL2,NPOINT2,IFLAG,IERR)
	     IF (IERR.NE.0)	STOP 'Error in reading Io file.'
	     IF (NPOINT2.NE.NPOINT) STOP
     $'Io file does not have the same number of rays as the input file.'
	    IF (NCOL2.EQ.18) THEN
	      DO 17 I = 1, NPOINT2
	       A2_SQUARE(I)= RAY2(7,I)**2 + RAY2(8,I)**2 + RAY2(9,I)**2
     $			+ RAY2(16,I)**2 + RAY2(17,I)**2 + RAY2(18,I)**2
17	      CONTINUE
	    ELSE
	      DO 18 I = 1, NPOINT2
	       A2_SQUARE(I)= RAY2(7,I)**2 + RAY2(8,I)**2 + RAY2(9,I)**2
18	      CONTINUE
	    END IF
	   END IF
	   IF (K_ACT.EQ.0.OR.K_ACT.EQ.1) THEN
     	     WRITE(6,*) 'Scaling options: '
     	     WRITE(6,*) 'No scaling                           [ 0 ] '
     	     WRITE(6,*) 'Scaling with user-supplied number    [ 1 ] '
     	     WRITE(6,*) 'Auto-scaling for SR source           [ 2 ] '
     		ISCALE = 
     $		IRINT ('PLOT> Then ? ')
     	   END IF
	   IF (ISCALE.EQ.1) THEN
C     	     TPOWER	= RNUMBER ('PLOT> Scaling factor : ')
	     WRITE(6,*) 'PLOT> Scaling factor: '
	     READ(5,*) TPOWER
     	     WRITE(6,*) 
     $'We need the conversion factor from the units used in the ',
     $'calculations to CM. e.g., if mm were used, enter .1'
	     WRITE(6,*) 'Conversion factor: '
	     READ(5,*) PUNITS
C     	     PUNITS	= RNUMBER ('Then ? ')
C
C compute beam energy
C
     	     TENER = 0.0
     	    DO 19 I=1,NPOINT
     	      TENER = TENER + RAY(11,I)/TWOPI*TOCM*1.602D-19
19	    CONTINUE
     	     FACTOR = TPOWER/TENER
     	   ELSE IF (ISCALE.EQ.2) THEN
C     	     ORBIT = RNUMBER ('Machine radius [ m ] ? ')
C     	     ENER  = RNUMBER ('Machine energy [ GeV ] ? ')
C     	     CURR  = RNUMBER ('Machine current[ A ] ? ')
C     	     ACCEPTANCE = RNUMBER ('milliradians of orbit ? ')
	     WRITE(6,*) 'Machine radius [ m ] ?'
	     READ(5,*) ORBIT
	     WRITE(6,*) 'Machine energy [ GeV ] ? '
	     READ(5,*) ENER
	     WRITE(6,*) 'Machine current[ A ] ? '
	     READ(5,*) CURR
	     WRITE(6,*) 'Milliradians of orbit ? '
	     READ(5,*) ACCEPTANCE
     	     WRITE(6,*) 
     $'We need the conversion factor from the units used in the ',
     $'calculations to CM. e.g., if mm were used, enter .1'
	     WRITE(6,*) 'Conversion factor: '
	     READ(5,*) PUNITS
C     	     PUNITS	= RNUMBER ('Then ? ')
C
C Following power is in KWH. It is the total power incoming on the
C beamline. Notice that the power is given in Watts.
C
     	     TPOWER = ENER**4/ORBIT*88.5*CURR*ACCEPTANCE/TWOPI
     	     WRITE(6,*) 'Total power accepted: ',TPOWER
C
C Each ray carries hv energy. The scaling factor is obtained 
C by computing the total energy carried by the beam.
C
C compute beam energy
C
     	     TENER = 0.0
     	    DO 3037 I=1,NPOINT
     	      TENER = TENER + RAY(11,I)/TWOPI*TOCM*1.602D-19
3037	    CONTINUE
     	     FACTOR = TPOWER/TENER
     	   END IF
	 ELSE
	   WRITE(6,*) 'PLOT> Data normalization : '
	   WRITE(6,*) '        0   For no normalization'
	   WRITE(6,*) '        1   For normalized to 1'
	   WRITE(6,*) '        2   For normalized to total counts'
	   NORMAL = IRINT ('PLOT> Then ? ')
	 END IF
     	 ISMOOTH = IYES ('Smoothing [ Y/N ] ? ')
     	 ISAVE	= IYES ('Save grid file [ Y/N ] ? ')
	   OPEN(22,FILE='test',STATUS='UNKNOWN')
     	END IF
C
     	ICROSS = IRINT ('PLOT> Hairline at [ 0,0 ] ? ')
     	IF (ICROSS.EQ.1) THEN
	 EXT	= 0.4
	ELSE
	 EXT	= 0.8
     	END IF
     	Y_C = (Y_LOW + Y_UPP)/2
     	YU_C = Y_C + EXT*(Y_UPP-Y_C)
     	YL_C = Y_C - EXT*(Y_C-Y_LOW)
     	X_C = (X_LOW + X_UPP)/2
     	XU_C = X_C + EXT*(X_UPP-X_C)
     	XL_C = X_C - EXT*(X_C-X_LOW)
C
     	IMIRR = IRINT ('PLOT> Overlay a mirror/slit ? ')
     	IF (IMIRR.EQ.1) THEN
     	 WRITE(6,*) 'PLOT> Mirror/Slit type: '
     	 WRITE(6,*) '      0 .... rectangular '
     	 WRITE(6,*) '      1 .... elliptical '
     	 ISLIT	=   IRINT ('Then ? ')
     	  IF (ISLIT.EQ.0) THEN
C     	   XS_MIN =  RNUMBER ('PLOT > X min : ')
     	   WRITE(6,*) 'PLOT > X min : '
	   READ(5,*) XS_MIN
C     	   XS_MAX =  RNUMBER ('PLOT >   max : ')
     	   WRITE(6,*) 'PLOT >   max : '
	   READ(5,*) XS_MAX
C     	   YS_MIN =  RNUMBER ('PLOT > Y min : ')
     	   WRITE(6,*) 'PLOT > Y min : '
	   READ(5,*) YS_MIN
C     	   YS_MAX =  RNUMBER ('PLOT >   max : ')
     	   WRITE(6,*) 'PLOT >   max : '
	   READ(5,*) YS_MAX
     	  ELSE
C     	   AMAJ =  RNUMBER ('PLOT > Semi-axis along [ x ] : ')
     	   WRITE(6,*) 'PLOT > Semi-axis along [ x ] : '
	   READ(5,*) AMAJ
C     	   AMIN =  RNUMBER ('PLOT >                 [ y ] : ')
     	   WRITE(6,*) 'PLOT >                 [ y ] : '
	   READ(5,*) AMIN
C     	   ELLX	=  RNUMBER ('PLOT > center [ x ] : ')
     	   WRITE(6,*) 'PLOT > center [ x ] : '
	   READ(5,*) ELLX
C     	   ELLY	=  RNUMBER ('PLOT >        [ y ] : ')
     	   WRITE(6,*) 'PLOT >        [ y ] : '
	   READ(5,*) ELLY
     	  END IF
     	END IF
C
C starts computing the histograms
C
     	WRITE(6,*) 'PLOT> Ready for histograms. Enter:'
     	WRITE(6,*) '     -1         to skip '
     	WRITE(6,*) '      0     for same limits as plot'
     	WRITE(6,*) '      1                     3*stdev'
     	WRITE(6,*) '      2                     external'
     	IANSW	=   IRINT ('PLOT> ? ')
     	IF (IANSW.EQ.0) THEN
     	  X_CENT = 0.5*(X_LOW + X_UPP)
     	  XWIDTH = X_UPP - X_LOW
     	  Y_CENT = 0.5*(Y_LOW + Y_UPP)
     	  YWIDTH = Y_UPP - Y_LOW
     	ELSE IF (IANSW.EQ.1) THEN
     	  X_CENT = XMEAN(IX)
     	  Y_CENT = XMEAN(IY)
     	  XWIDTH = 6*STDEV(IX)
     	  YWIDTH = 6*STDEV(IY)
     	ELSE IF (IANSW.EQ.2) THEN
C     	  X_CENT =  RNUMBER ('PLOT> Center for [ X ] axis: ')
     	  WRITE(6,*) 'PLOT> Center for [ X ] axis: '
	  READ(5,*) X_CENT
C     	  XWIDTH =  RNUMBER ('PLOT> Width            : ')
     	  WRITE(6,*) 'PLOT> Width            : '
	  READ(5,*) XWIDTH
C     	  Y_CENT =  RNUMBER ('PLOT> Center for [ Y ] axis: ')
     	  WRITE(6,*) 'PLOT> Center for [ Y ] axis: '
	  READ(5,*) Y_CENT
C     	  YWIDTH =  RNUMBER ('PLOT> Width            : ')
     	  WRITE(6,*) 'PLOT> Width            : '
	  READ(5,*) YWIDTH
     	END IF
	IF (IANSW.NE.-1) THEN
	  IF (IGRID.NE.2) THEN
	    N_BINX =  IRINT  
     $		('PLOT> Number of bins for X axis [default = 25] : ')
	    IF (N_BINX.LT.1)	N_BINX	= 25
	    N_BINY =  IRINT  
     $		('PLOT> Number of bins for Y axis [default = 25] : ')
	    IF (N_BINY.LT.1)	N_BINY	= 25
	  ELSE
	    N_BINX	= NGX
	    N_BINY	= NGY
	  END IF
	END IF
C
C User can save the TD.FIL to regenerate the plot at a later time.
C
#if defined(vms)
	I_TD  = IRINT 
     $		('PLOT> Do you want to save the TD command file ? ')
	IF (I_TD.EQ.1) OPEN (27,FILE='TD.FIL',STATUS='NEW')
C
C Set up the terminal for plotting.
C  
	CALL	SET_SCREEN	('PLOT>',0,ITERM)
	CALL 	TDNEWP
	TEXT	= 'MODE NOECHO ;'
     	CALL 	TDSET	(%REF(TEXT))
	TEXT	= 'TICKS SIZE 0.05 ;'
     	CALL	TDSET	(%REF(TEXT))
	TEXT	= 'LABELS ALL OFF ;'
     	CALL	TDSET	(%REF(TEXT))
#else
C
C Check unix display and start creating primvs command file
C
	ITD = 0
C	WRITE(6,*)'This will create PRIMVS input files'
	WRITE(6,*) 'Display type:'
#if HAVE_XWINDOWS
	WRITE(6,*) '  [ 0 ] Xwindow'
#endif
	WRITE(6,*) '  [ 1 ] Tektronix'
	WRITE(6,*) '  [ 2 ] Postscript file'
	ITERM = IRINT ('Terminal type:  ')
C now write out primvs command file
	OPEN (35,FILE='plotxy.prm',STATUS='UNKNOWN', FORM='FORMATTED')
	WRITE(35,*) '#Primvs command file for PLOTXY'
#endif
#if !HAVE_XWINDOWS
	IF (ITERM.EQ.0) THEN
	    WRITE (*,*) 'No X Windows support. Using Postscript file'
	    ITERM=2
	ENDIF
#endif
	IF (ITERM.LT.0 .OR. ITERM.GT.2) THEN
	    WRITE (*,*) 'Invalid device Id. Using Postscript file'
	    ITERM=2
	ENDIF
	IF (IANSW.EQ.-1) THEN
#if !defined(vms)
	  IF      (ITERM.EQ.0) THEN
	     WRITE (35,*) '# Initialize Xwindow display'
	     WRITE (35,*) '#'
	     WRITE (35,*) 'initpage(xwin)'
	    ELSE IF (ITERM.EQ.1) THEN
	     WRITE (35,*) '# Initialize Tektronix display'
	     WRITE (35,*) '#'
	     WRITE (35,*) 'initpage(tekt)'
	  ELSE IF (ITERM.EQ.2) THEN
	     WRITE (35,*) '# Initialize Postscript file (plotxy.ps)'
	     WRITE (35,*) '#'
	     WRITE (35,*) 'setcolor(0)'
	     WRITE (35,*) 'initpage(ps,"plotxy.ps")'
	  END IF
#endif
	  TEXT	= 'WINDOW X 0 9.2 Y 0 9.2 ;'
	ELSE
#if !defined(vms)
	  IF      (ITERM.EQ.0) THEN
	     WRITE (35,*) '# Initialize Xwindow display'
	     WRITE (35,*) '#'
	     WRITE (35,*) 'initpage(xwin)'
	  ELSE IF (ITERM.EQ.1) THEN
	     WRITE (35,*) '# Initialize Tektronix display'
	     WRITE (35,*) '#'
	     WRITE (35,*) 'initpage(tekt)'
	  ELSE IF (ITERM.EQ.2) THEN
	     WRITE (35,*) '# Initialize Postscript file'
	     WRITE (35,*) '#'
	     WRITE (35,*) 'setcolor(0)'
	     WRITE (35,*) 'initpage(ps,"plotxy.ps")'
	  END IF
#endif
	  TEXT	= 'WINDOW X 0 7 Y 0 7 ;'
	END IF
#if defined(vms)
     	CALL	TDSET	(%REF(TEXT))
	WRITE	(TEXT,1010) 	X_LOW,X_UPP,Y_LOW,Y_UPP
1010	FORMAT	('LIMITS X ',G13.6,' ',G13.6,' Y ',G13.6,' ',G13.6,' ;')
     	CALL 	TDSET	(%REF(TEXT))
	IF (I_TD.EQ.1) THEN
	  WRITE (27,*)	'MODE NOECHO'
	  WRITE (27,*)	'TICKS SIZE 0.05'
	  WRITE (27,*)	'LABELS ALL OFF'
	  IF (IANSW.EQ.-1) THEN
	    WRITE (27,*) 'WINDOW X 0 9.2 Y 0 9.2'
	  ELSE
	    WRITE (27,*) 'WINDOW X 0 7 Y 0 7'
	  END IF
	  WRITE (27,*)	TEXT(1:66)
	END IF
#else
	IF (IANSW.EQ.-1) THEN
	  WRITE (35,*) ' '
	  WRITE (35,*) '# Set page and plot limits'
	  WRITE (35,*) 'regionr(0.05,0.05,0.727,0.857,1.0)'
	  WRITE(35,3030) X_LOW,X_UPP,Y_LOW,Y_UPP
	  WRITE (35,*) 'scalechr(0.5)'
	  WRITE(35,*) 'color(green)'
	ELSE
	  WRITE (35,*) ' '
	  WRITE (35,*) '# Set page and plot limits'
	  WRITE(35,*) 'regionr(0.05,0.05,0.55,0.7,1.0)'
	  WRITE(35,3030) X_LOW,X_UPP,Y_LOW,Y_UPP
	  WRITE (35,*) 'scalechr(0.5)'
	  WRITE(35,*) 'color(green)'
	ENDIF
3030    FORMAT ('xyrange(',SP,G15.8,',',G15.8,',',G15.8,',',G15.8,')')
#endif

C
C Mark the origin.
C
	  XPLOT (1)	= 0.0
	  XPLOT (2)	= 0.0
	  YPLOT (1)	= Y_UPP
	  YPLOT (2)	= YU_C
#if defined(vms)
	  CALL	JOIN	(2,XPLOT,YPLOT,I_TD,1)
#else
	  WRITE(35,*) ' '
	  WRITE(35,*) '# Mark the origin '
	  WRITE(35,4040) XPLOT(1),YPLOT(1),XPLOT(2),YPLOT(2)
4040	  FORMAT ('line(',G15.8,',',G15.8,',',G15.8,',',G15.8,')')
#endif
	  XPLOT (1)	= 0.0
	  XPLOT (2)	= 0.0
	  YPLOT (1)	= YL_C
	  YPLOT (2)	= Y_LOW
#if defined(vms)
	  CALL  JOIN	(2,XPLOT,YPLOT,I_TD,1)
#else
	  WRITE(35,4040) XPLOT(1),YPLOT(1),XPLOT(2),YPLOT(2)
#endif
	  XPLOT (1)	= X_LOW
	  XPLOT (2)	= XL_C
	  YPLOT (1)	= 0.0
	  YPLOT (2)	= 0.0
#if defined(vms)
	  CALL  JOIN	(2,XPLOT,YPLOT,I_TD,1)
#else
	  WRITE(35,4040) XPLOT(1),YPLOT(1),XPLOT(2),YPLOT(2)
#endif
	  XPLOT (1)	= XU_C
	  XPLOT (2)	= X_UPP
	  YPLOT (1)	= 0.0
	  YPLOT (2)	= 0.0
#if defined(vms)
	  CALL  JOIN	(2,XPLOT,YPLOT,I_TD,1)
#else
	  WRITE(35,4040) XPLOT(1),YPLOT(1),XPLOT(2),YPLOT(2)
#endif
C
C Before plotting, set up the contour first.
C
	IF (IGRID.EQ.2) THEN
C
C Prepare the side of the grid.
C
	  X_STEP = (X_UPP - X_LOW)/NGX
	  Y_STEP = (Y_UPP - Y_LOW)/NGY
	  AREA	 = X_STEP*Y_STEP
C
C Scale power or # of rays to area
C
	  IF (ISCALE.NE.0) THEN
   	    FACTOR = FACTOR/(PUNITS**2*AREA)
	  ELSE
	    FACTOR = 1.0D0
	  END IF
C
	  DO 21 I = 1,NGX
	    XSID(I)	= X_LOW + X_STEP*(I-1) + X_STEP/2
21	  CONTINUE
	  DO 22 J = 1,NGY
	    YSID(J)	= Y_LOW + Y_STEP*(J-1) + Y_STEP/2
22	  CONTINUE
#if defined(vms)
	  TEXT	= 'SET ORDER X Y DUMM ;'
	  CALL	TDSET	(%REF(TEXT))
	  IF (I_TD.EQ.1)	WRITE (27,*) 'SET ORDER X Y DUMM'
#else
	  WRITE(35,*) 'format(x:1,y:2)'

#endif
	END IF
C
C Loop thru all the rays.
C
	IF (IGRID.EQ.1) THEN
	  OPEN(36,FILE='scatter.dat',STATUS='UNKNOWN')
	ENDIF
     	IPASS = 0
9999	KX = 0
     	KY = 0
	KPLOT = 0
	KLOSS = 0
     	IPASS = IPASS + 1
     	DO 8989 I=1,NPOINT
     	  IF (IX.NE.20) XWRI	=  RAY(IX,I)
     	  IF (IY.NE.20) YWRI  	=  RAY(IY,I)
     	  IF (IX.EQ.11) THEN
           IF (XWRI.LT.1D-8) GO TO 8989
     	   IF (IUNIT.EQ.1) THEN
     	     XWRI = XWRI*TOCM/TWOPI
     	   ELSE IF (IUNIT.EQ.2) THEN
     	     XWRI = TWOPI/XWRI*1.0E8
     	   END IF
     	  END IF
     	  IF (IY.EQ.11) THEN
          IF (YWRI.LT.1D-8) GO TO 8989
     	   IF (IUNIT.EQ.1) THEN
     	     YWRI = YWRI*TOCM/TWOPI
     	   ELSE IF (IUNIT.EQ.2) THEN
     	     YWRI = TWOPI/YWRI*1.0E8
     	   END IF
     	  END IF
     	  IF (IX.EQ.20) THEN
     	    XWRI = ABS( SQRT( RAY(4,I)**2 + RAY(6,I)**2 )/RAY(5,I) )
     	  ELSE IF (IY.EQ.20) THEN
     	    YWRI = ABS( SQRT( RAY(4,I)**2 + RAY(6,I)**2 )/RAY(5,I) )
     	  END IF
     	  IF (IX.EQ.13) THEN
     	    XWRI = XWRI - P_CENT
     	  ELSE IF (IY.EQ.13) THEN
     	    YWRI = YWRI - P_CENT
     	  END IF
C
C Scattered plot :
C
     	 IF (IGRID.EQ.0) THEN
          IF (ILOST.EQ.0) THEN
           IF (RAY(10,I).GE.0.0D0) THEN
		KPLOT		= KPLOT + 1
		XPLOT (KPLOT)	= XWRI
		YPLOT (KPLOT)	= YWRI
	   END IF
     	  ELSE IF (ILOST.EQ.1) THEN
    	   IF (RAY(10,I).LT.0.0D0) THEN
		KPLOT		= KPLOT + 1
		XPLOT (KPLOT)	= XWRI
		YPLOT (KPLOT)	= YWRI
	   END IF
     	  ELSE IF (ILOST.EQ.2) THEN
    	   IF (RAY(10,I).GE.0.0D0) THEN
		KPLOT		= KPLOT + 1
		XPLOT (KPLOT)	= XWRI
		YPLOT (KPLOT)	= YWRI
	   ELSE
		KLOSS		= KLOSS + 1
		XLOSS (KLOSS)	= XWRI
		YLOSS (KLOSS)	= YWRI
	   END IF
     	  END IF
C
C Contour plot :
C
         ELSE IF (IGRID.EQ.2) THEN
	   IF (ILOST.EQ.0.AND.RAY(10,I).LT.0.0D0) GO TO 8989
	   IF (ILOST.EQ.1.AND.RAY(10,I).GE.0.0D0) GO TO 8989
	   KPLOT	= KPLOT + 1
	   ARG_X	= (XWRI - X_LOW)/X_STEP
	   ARG_Y	= (YWRI - Y_LOW)/Y_STEP
	   I_BIN	= INT(ARG_X) + 1
	   J_BIN	= INT(ARG_Y) + 1
	   IF (I_BIN.GT.MAXGS.OR.I_BIN.LT.1) GO TO 8989
	   IF (J_BIN.GT.MAXGS.OR.J_BIN.LT.1) GO TO 8989
	   IF (K_REFL.EQ.1) THEN
	     IF (K_ACT.EQ.0) THEN
	       ARG	= A_SQUARE(I)
	       ARG	= ARG*FACTOR*TOCM/TWOPI*1.602D-19*RAY(11,I)
	     ELSE
	       ARG1	= A_SQUARE(I)
	       ARG2	= A2_SQUARE(I)
	       IF (K_ACT.EQ.1) THEN
	         ARG	= ARG2 - ARG1
C
C the following, r_ener, is the energy carried by each ray
C
     		 R_ENER = TOCM/TWOPI*1.602D-19*RAY(11,I)
C
C after scaling and taking in account the decrease in |A|, we obtain
C
	         ARG	= ARG*FACTOR*R_ENER
	       ELSE IF (K_ACT.EQ.2) THEN
	         ARG	= ARG1/ARG2
	       END IF
	     END IF
           ELSE
	     ARG	= 1.0D0
	   END IF
	   PIXEL(I_BIN,J_BIN)	= PIXEL(I_BIN,J_BIN) + ARG
	   WRITE(22,*) XWRI,YWRI,ARG
C	
C Connected plot :
C
     	 ELSE IF (IGRID.EQ.1.AND.IPASS.EQ.1) THEN
     	  KX = KX + 1
     	  IF (IX.NE.20) XWRI	=  RAY(IX,I)
     	  IF (IY.NE.20) YWRI	=  RAY(IY,I)
     	  IF (IX.EQ.20) THEN
     	    XWRI = ABS( SQRT( RAY(4,I)**2 + RAY(6,I)**2 )/RAY(5,I) )
     	  ELSE IF (IY.EQ.20) THEN
     	    YWRI = ABS( SQRT( RAY(4,I)**2 + RAY(6,I)**2 )/RAY(5,I) )
     	  END IF
     	  IF (IX.EQ.13) THEN
     	    XWRI = XWRI - P_CENT
     	  ELSE IF (IY.EQ.13) THEN
     	    YWRI = YWRI - P_CENT
     	  END IF
          IF (ILOST.EQ.0) THEN
           IF (RAY(10,I).GE.0.0D0) THEN
	     KPLOT		= KPLOT + 1
	     XPLOT (KPLOT)	= XWRI
	     YPLOT (KPLOT)	= YWRI	
     	     ITST = 0
     	   ELSE IF (RAY(10,I).LT.0.0D0.AND.ITST.EQ.0) THEN
	     IF (KPLOT.NE.0) THEN
#if defined(vms)
	       CALL JOIN	(KPLOT,XPLOT,YPLOT,I_TD,0)
#else
	       WRITE(36,*) XPLOT,YPLOT
#endif
 	       KPLOT	= 0
     	       ITST = 1
	     END IF
     	   END IF
     	  ELSE IF (ILOST.EQ.1) THEN
    	   IF (RAY(10,I).LT.0.0D0) THEN
	     KPLOT		= KPLOT + 1
	     XPLOT (KPLOT)	= XWRI
	     YPLOT (KPLOT)	= YWRI	
     	     ITST = 0
     	   ELSE IF (RAY(10,I).GE.0.0D0.AND.ITST.EQ.0) THEN
	     IF (KPLOT.NE.0) THEN
#if defined(vms)
	       CALL JOIN	(KPLOT,XPLOT,YPLOT,I_TD,0)
#else
	       WRITE(36,*) XPLOT,YPLOT
#endif
 	       KPLOT	= 0
     	       ITST = 1
	     END IF
     	   END IF
     	  ELSE IF (ILOST.EQ.2) THEN
	     KPLOT		= KPLOT + 1
	     XPLOT (KPLOT)	= XWRI
	     YPLOT (KPLOT)	= YWRI	
     	  END IF
     	  IF (KX.EQ.NGX) THEN
	     IF (KPLOT.NE.0) THEN
#if defined(vms)
	       CALL JOIN	(KPLOT,XPLOT,YPLOT,I_TD,0)
#else
	       WRITE(36,*) XPLOT,YPLOT
#endif
 	       KPLOT	= 0
	     END IF
	     KX	= 0
     	  END IF
     	 ELSE IF (IGRID.EQ.1.AND.IPASS.EQ.2) THEN
     	  KY = KY + 1
     	  INDEX = NGX*(KY-1)+KX+1
     	  IF (IX.NE.20) XWRI	=  RAY(IX,INDEX)
     	  IF (IY.NE.20) YWRI	=  RAY(IY,INDEX)
     	  IF (IX.EQ.20) THEN
     	    XWRI = ABS( SQRT( RAY(4,I)**2 + RAY(6,I)**2 )/RAY(5,I) )
     	  ELSE IF (IY.EQ.20) THEN
     	    YWRI = ABS( SQRT( RAY(4,I)**2 + RAY(6,I)**2 )/RAY(5,I) )
     	  END IF
     	  IF (IX.EQ.13) THEN
     	    XWRI = XWRI - P_CENT
     	  ELSE IF (IY.EQ.13) THEN
     	    YWRI = YWRI - P_CENT
     	  END IF
          IF (ILOST.EQ.0) THEN
           IF (RAY(10,INDEX).GE.0.0D0) THEN
	     KPLOT		= KPLOT + 1
	     XPLOT (KPLOT)	= XWRI
	     YPLOT (KPLOT)	= YWRI	
     	     ITST = 0
     	   ELSE IF (RAY(10,INDEX).LT.0.0D0.AND.ITST.EQ.0) THEN
	     IF (KPLOT.NE.0) THEN
#if defined(vms)
	       CALL JOIN	(KPLOT,XPLOT,YPLOT,I_TD,0)
#else
	       WRITE(36,*) XPLOT,YPLOT
#endif
 	       KPLOT	= 0
     	       ITST = 1
	     END IF
     	   END IF
     	  ELSE IF (ILOST.EQ.1) THEN
    	   IF (RAY(10,INDEX).LT.0.0D0) THEN
	     KPLOT		= KPLOT + 1
	     XPLOT (KPLOT)	= XWRI
	     YPLOT (KPLOT)	= YWRI	
     	     ITST = 0
     	   ELSE IF (RAY(10,INDEX).GE.0.0D0.AND.ITST.EQ.0) THEN
	     IF (KPLOT.NE.0) THEN
#if defined(vms)
	       CALL JOIN	(KPLOT,XPLOT,YPLOT,I_TD,0)
#else
	       WRITE(36,*) XPLOT,YPLOT
#endif
 	       KPLOT	= 0
     	       ITST = 1
	     END IF
     	   END IF
     	  ELSE IF (ILOST.EQ.2) THEN
	     KPLOT		= KPLOT + 1
	     XPLOT (KPLOT)	= XWRI
	     YPLOT (KPLOT)	= YWRI	
     	  END IF
     	  IF (KY.EQ.NGY) THEN
     	     KX = KX + 1
	     IF (KPLOT.NE.0) THEN
#if defined(vms)
	       CALL JOIN	(KPLOT,XPLOT,YPLOT,I_TD,0)
#else
	       WRITE(36,*) XPLOT,YPLOT
#endif
 	       KPLOT	= 0
	     END IF
   	     KY = 0
     	  END IF
     	 END IF
8989   	CONTINUE
     	IF (IGRID.EQ.1.AND.IPASS.EQ.1) GO TO 9999
	IF (IGRID.EQ.0)	THEN
#if defined(vms)
	  IF (ITERM.EQ.3) 	CALL SET_COLOR (9)
	  IF (KPLOT.NE.0) CALL TDPLOT (KPLOT,XPLOT,YPLOT)
#else
	  WRITE(35,*) ' '
	  WRITE(35,*) '# Draw axes and plot scatter plot '
	  WRITE(35,*) 'symbol(1)'
	  WRITE(35,*) 'box("bcnst",0,0,"bcnstv",0,0)'
	  WRITE(35,*) '# Good rays are shown in green'
	  WRITE(35,*) 'color(green)'
	  WRITE(35,*) 'plotp("scatter.dat")'
	  WRITE(35,*) 'color(green)'
	  OPEN(36,FILE='scatter.dat',STATUS='UNKNOWN')
	  IF (KPLOT.NE.0) THEN
	    DO 3031 I = 1,KPLOT
	      WRITE(36,*) XPLOT(I),YPLOT(I)
3031	    CONTINUE
	  END IF
#endif
	  IF (I_TD.EQ.1) THEN
	    DO I = 1, KPLOT
	      IF (MOD(I,1000).EQ.0)	WRITE	(27,*)	'PLOT'
	      WRITE 	(27,*)	XPLOT(I),YPLOT(I)
	    END DO
	    WRITE	(27,*)	'PLOT'
	  END IF
	  IF (ILOST.EQ.2) THEN
#if defined(vms)
	   IF (ITERM.EQ.3) 	CALL SET_COLOR (6)
	   IF (KLOSS.GT.0)	CALL TDPLOT (KLOSS,XLOSS,YLOSS)
#else
	   IF (KLOSS.GT.0) THEN
	     OPEN(40,FILE='lost.dat',STATUS='UNKNOWN')
	     WRITE(35,*) '# Lost rays are shown in red'
	     WRITE(35,*) 'color(red)'
	     WRITE(35,*) 'plotp("lost.dat")'
	     WRITE(35,*) 'color(green)'
	     DO 3032 I = 1,KLOSS
	       WRITE(40,*) XLOSS(I),YLOSS(I)
3032	     CONTINUE
	   END IF
#endif
	   IF (I_TD.EQ.1) THEN
	    DO I = 1, KLOSS
	      IF (MOD(I,1000).EQ.0)	WRITE	(27,*)	'PLOT'
	      WRITE 	(27,*)	XLOSS(I),YLOSS(I)
	    END DO
	    WRITE	(27,*)	'PLOT'
	   END IF
	  END IF
#if defined(vms)
	  IF (ITERM.EQ.3) 	CALL SET_COLOR (1)
#endif
	ELSE IF (IGRID.EQ.2) THEN
C
C Smooths the picture for contour plots
C
     	  IF (ISMOOTH.EQ.1) THEN
     	   DO 26 L=2,NGX-1
     	    DO 27 J=2,NGY-1
     	      PIXNEW (L,J) = 4*PIXEL(L,J) + 
     $			2*PIXEL(L,J-1) + 2*PIXEL(L,J+1) +
     $			2*PIXEL(L+1,J) + 2*PIXEL(L-1,J) +
     $			PIXEL(L+1,J+1) + PIXEL(L+1,J-1) +
     $			PIXEL(L-1,J+1) + PIXEL(L-1,J-1)
     	      PIXNEW (L,J) = PIXNEW (L,J)/16
27	    CONTINUE
26	   CONTINUE
C
C Sides
C
     	   DO 28 L=2,NGX-1
     	     PIXNEW (L,1) = 4*PIXEL(L,1) + 
     $			2*PIXEL(L-1,1) + 2*PIXEL(L,2) + 2*PIXEL(L+1,1) +
     $			PIXEL(L-1,2) + PIXEL(L+1,2)
     	     PIXNEW (L,NGY) = 4*PIXEL(L,NGY) + 
     $			2*PIXEL(L-1,NGY) + 2*PIXEL(L,NGY-1) + 
     $			2*PIXEL(L+1,NGY) +
     $			PIXEL(L-1,NGY-1) + PIXEL(L+1,NGY-1)
     	     PIXNEW (L,1) = PIXNEW(L,1)/12
     	     PIXNEW (L,NGY) = PIXNEW (L,NGY)/12
28	   CONTINUE
     	   DO 29 J=2,NGY-1
     	     PIXNEW (1,J) = 4*PIXEL(1,J) + 
     $			2*PIXEL(1,J-1) + 2*PIXEL(2,J) + 2*PIXEL(1,J+1) +
     $			PIXEL(2,J-1) + PIXEL(2,J+1)
     	     PIXNEW (NGX,J) = 4*PIXEL(NGX,J) + 
     $			2*PIXEL(NGX,J-1) + 2*PIXEL(NGX-1,J) + 
     $			2*PIXEL(NGX,J+1) +
     $			PIXEL(NGX-1,J-1) + PIXEL(NGX-1,J+1)
     	     PIXNEW (1,J) = PIXNEW(1,J)/12
     	     PIXNEW (NGX,J) = PIXNEW(NGX,J)/12
29	   CONTINUE
C
C Corners
C
     	    PIXNEW (1,1) = 4*PIXEL(1,1) + 2*PIXEL(1,2) + 2*PIXEL(2,1) +
     $ 			PIXEL(2,2)
      	    PIXNEW (1,NGY) = 4*PIXEL(1,NGY) + 2*PIXEL(1,NGY-1) + 
     $			2*PIXEL(2,NGY) + PIXEL(2,NGY-1)
     	    PIXNEW (NGX,1) = 4*PIXEL(NGX,1) + 2*PIXEL(NGX,2) + 
     $			2*PIXEL(NGX-1,1) + PIXEL(NGX-1,2)
     	    PIXNEW (NGX,NGY) = 4*PIXEL(NGX,NGY) + 2*PIXEL(NGX,NGY-1) + 
     $			2*PIXEL(NGX-1,NGY) + PIXEL(NGX-1,NGY-2)
     	    PIXNEW (1,1) = PIXNEW(1,1)/9
     	    PIXNEW (1,NGY) = PIXNEW(1,NGY)/9
     	    PIXNEW (1,NGX) = PIXNEW(1,NGX)/9
     	    PIXNEW (NGX,NGY) = PIXNEW(NGX,NGY)/9
     	   DO 31 L=1,NGX
     	    DO 32 J=1,NGY
     	      PIXEL(L,J) = PIXNEW(L,J)
32	    CONTINUE
31	   CONTINUE 
	  END IF
C
C save grid file
C
     	IF (ISAVE.EQ.1) THEN
     	  OPEN (21, FILE='GRID', STATUS='NEW')
     	  WRITE (21,*) NGX,NGY
     	 DO 33 L=1,NGX
     	  DO 34 J=1,NGY
     	    WRITE (21,*) XSID(L),YSID(J),PIXEL(L,J)
34	  CONTINUE
33	 CONTINUE
     	  CLOSE(21)
     	END IF
C
C prepare for plotting
C
	  ZMAX	= -1.0D20
	  ZMIN	=  1.0D20
	  DO 35 I = 1,NGX
	    DO 36 J = 1,NGY
	      ZMAX	= MAX(ZMAX,PIXEL(I,J))
	      ZMIN	= MIN(ZMIN,PIXEL(I,J))
36	    CONTINUE
35	  CONTINUE
	  IF (NORMAL.EQ.1) THEN
	    DO 37 I = 1,NGX
	      DO 38 J = 1,NGY
	        PIXEL(I,J)	= PIXEL(I,J)/ZMAX
38	      CONTINUE
37	    CONTINUE
	    ZMIN	= ZMIN/ZMAX
	    ZMAX	= 1.0D0
	  ELSE IF (NORMAL.EQ.2) THEN
	    DO 39 I = 1,NGX
	      DO 41 J = 1,NGY
	        PIXEL(I,J)	= PIXEL(I,J)/KPLOT
41	      CONTINUE
39	    CONTINUE
	    ZMAX	= ZMAX/KPLOT
	    ZMIN	= ZMIN/KPLOT
	  END IF
	  DO 42 I = 1,NCONT
	    CVALUE(I)	= ZMIN + I*(ZMAX-ZMIN)/(NCONT+1)
42	  CONTINUE
	  K = 0
	  DO 43 J = 1,NGY
	    DO 44 I = 1,NGX
	      K		= K + 1
	      ZDATA(K)	= PIXEL(I,J)
44	    CONTINUE
43	  CONTINUE
	  ICONT(1)	= NCONT
	  ICONT(2)	= 1
	  ICONT(3)	= 27
	  ICONT(4)	= ITERM
	  IPLT(1)	= I_TD
	  IPLT(3)	= 0
	  XYLIM(1)      = X_LOW
	  XYLIM(2)	= X_UPP
	  XYLIM(3)  	= Y_LOW
	  XYLIM(4)	= Y_UPP
	  CALL	CONTOUR(XSID,YSID,ZDATA,XYLIM,NGX,NGY,ICONT,CVALUE,IPLT)
#ifndef vms
	  WRITE(35,*) 'color(green)'

	ELSE IF (IGRID.EQ.1) THEN
	  WRITE(35,*) ' '
	  WRITE(35,*) '# Draw axes and connected plot '
          WRITE(35,*) 'symbol(1)'
	  WRITE(35,*) 'box("bcnst",0,0,"bcnstv",0,0)'
	  WRITE(35,*) 'plotl("scatter.dat")'
#endif
	END IF
C
C Overlay the slit or mirror.
C
	IF (IMIRR.EQ.1) THEN
     	  IF (ISLIT.EQ.0) THEN
	   XPLOT(1)	= XS_MIN
	   YPLOT(1)	= YS_MIN
	   XPLOT(2)	= XS_MIN
	   YPLOT(2)	= YS_MAX
	   XPLOT(3)	= XS_MAX
	   YPLOT(3)	= YS_MAX
	   XPLOT(4)	= XS_MAX
	   YPLOT(4)	= YS_MIN
	   XPLOT(5)	= XS_MIN
	   YPLOT(5)	= YS_MIN
#if defined(vms)
	   CALL		JOIN	(5,XPLOT,YPLOT,I_TD,1)
#else
	   WRITE(35,*) ' '
	   WRITE(35,*) '# Overlay the slit or mirror.'
	   WRITE(35,4040) XS_MIN,YS_MIN,XS_MIN,YS_MAX
	   WRITE(35,4040) XS_MIN,YS_MAX,XS_MAX,YS_MAX
	   WRITE(35,4040) XS_MAX,YS_MAX,XS_MAX,YS_MIN
	   WRITE(35,4040) XS_MAX,YS_MIN,XS_MIN,YS_MIN
#endif
     	  ELSE
#if !defined(vms)
	    OPEN(39,FILE='ellipse',STATUS='UNKNOWN')
	    WRITE(35,*) ' '
	    WRITE(35,*) '# Overlay the slit or mirror.'
	    WRITE(35,*) 'plotl("ellipse")'
#endif
     	    DO 46 I=1,61
     	    ARG = 6*(I-1)
     	    XPLOT(I) = ELLX + AMAJ*COS(TORAD*ARG)
     	    YPLOT(I) = ELLY + AMIN*SIN(TORAD*ARG)
#if !defined(vms)
	    WRITE(39,*) XPLOT(I),YPLOT(I)
#endif
46	    CONTINUE
#if defined(vms)
	   CALL	JOIN	(61,XPLOT,YPLOT,I_TD,0)
#endif
     	  END IF
     	END IF
C
C Now the histogram.
C
     	IF (IANSW.EQ.-1) GO TO 5001
     	NORM = 0
     	IREFL	=   0
     	DO 47 KKK=1,2
     	 IF (KKK.EQ.1) THEN
     	   N_COL = IX
	   N_BIN = N_BINX
     	   STEP	=   XWIDTH/(N_BINX - 1)
     	   X_START	=   X_CENT - XWIDTH/2 - STEP/2
     	  DO 48 I=1,N_BIN
     	    X_ARRAY(I) =   (I-1)*STEP + X_START + STEP/2
	    Y_ARRAY(I) =   0.0D0
48	  CONTINUE
     	 ELSE
     	   N_COL = IY
	   N_BIN = N_BINY
     	   STEP	=   YWIDTH/(N_BINY - 1)
     	   X_START	=   Y_CENT- YWIDTH/2  - STEP/2
     	  DO 49 I=1,N_BIN
     	    X_ARRAY(I) =   (I-1)*STEP + X_START + STEP/2
	    Y_ARRAY(I) =   0.0D0
49	  CONTINUE
     	 END IF
C
C If plotting contours, then the histogram values are obtained by just 
C integrating the grid (PIXEL) on each side.
C
	IF (IGRID.EQ.2) THEN
	  IF (KKK.EQ.1) THEN
	    DO 51 I = 1, NGX
	      DO 52 J = 1, NGY
	        Y_ARRAY(I) = Y_ARRAY(I) + PIXEL(I,J)
52	      CONTINUE
51	    CONTINUE
	  ELSE
	    DO 53 J = 1, NGY
	      DO 54 I = 1, NGX
	        Y_ARRAY(J) = Y_ARRAY(J) + PIXEL(I,J)
54	      CONTINUE
53	      CONTINUE
	  END IF
	  GO TO 998
	END IF
     	DO 999 I=1,NPOINT
         IF (N_COL.EQ.11) THEN
	   IF (RAY(11,I).LT.1D-8) GO TO 999
           IF (IUNIT.EQ.1) THEN
     	     RAYTEST = TOCM*RAY(11,I)/TWOPI
     	   ELSE IF (IUNIT.EQ.2) THEN
     	     RAYTEST = TWOPI/RAY(11,I)*1.0E8
           END IF
         ELSE
           RAYTEST   = RAY(N_COL,I)
         END IF	 
     	 IF (ILOST.EQ.0) THEN
     	  IF (RAY(10,I).LT.0.0D0) GO TO 999
     	 ELSE	IF (ILOST.EQ.1) THEN
     	  IF (RAY(10,I).GT.0.0D0) GO TO 999
     	 ELSE	IF (ILOST.EQ.2) THEN
	 END IF
      	 ARG	=   (RAYTEST - X_START)/STEP
     	 J_BIN	=   INT (ARG) + 1
      	 IF (J_BIN.LT.1.OR.J_BIN.GT.N_BIN) GO TO 999
	 IF (IREFL.EQ.1) THEN
	       VAL  =   A_SQUARE(I)
	 ELSE
		VAL = 1.0
	 END IF
    	 Y_ARRAY(J_BIN) = Y_ARRAY(J_BIN) + VAL
998	CONTINUE
999	CONTINUE
     	IF (KKK.EQ.1) THEN
#if defined(vms)
     	  CALL TDSET	(%REF('WINDOW X 0 7 Y 7.2 9.2; '))
	  WRITE	(TEXT,1020)	X_LOW,X_UPP
1020	  FORMAT ('LIMITS X ',G13.6,' ',G13.6,'; ')
	  CALL TDSET	(%REF(TEXT))
#else
	  WRITE(35,*) ' '
	  WRITE(35,*) '# Define plotting area for top histogram '
	  WRITE(35,*) 'regionr(0.05,0.70,0.55,0.927,0.3077)'
	  OPEN(37,FILE='histtop.dat',STATUS='UNKNOWN')
#endif
	X1UPP = -1.0D20
     	DO 56 I=1,N_BIN
     	  XPLOT(I) = X_ARRAY(I)
     	  YPLOT(I) = Y_ARRAY(I)
	  X1UPP = MAX(X1UPP,Y_ARRAY(I))
56	CONTINUE
	X1UPP = X1UPP*1.1
#if defined(vms)
	  CALL	TDHIST  (N_BIN,XPLOT,YPLOT)
#else
	  X1LOW = 0.0D0
	  WRITE(35,3030) X_LOW,X_UPP,X1LOW,X1UPP
	  WRITE(35,*) 'plotl("histtop.dat")'
	  WRITE(35,*) 'box("bcst",0,0,"bcnstv",0,0)'
	  WRITE(35,*) 'label("","","',FILETEXT,'")'
	  WRITE(37,*) XSTART,0.0
	  DO 3035 I = 1,N_BIN
	    WRITE(37,*) X_ARRAY(I)-STEP/2, Y_ARRAY(I)
	    WRITE(37,*) X_ARRAY(I)+STEP/2, Y_ARRAY(I)
3035	  CONTINUE
	  WRITE(37,*) X_ARRAY(N_BIN)+STEP/2, 0.0
#endif
	  IF (I_TD.EQ.1) THEN
	    WRITE	(27,*)	'WINDOW X 0 7 Y 7.2 9.2'
	    WRITE	(27,*)	TEXT(1:36)
	      DO 3042 I = 1, N_BIN
		WRITE	(27,*)	XPLOT(I),YPLOT(I)
3042	      CONTINUE
	    WRITE	(27,*)	'HIST'
	  END IF
     	ELSE
#if defined(vms)
     	  CALL TDSET	(%REF('WINDOW X 7.2 9.2 Y 0 7; '))
	  WRITE	(TEXT,1030)	Y_LOW,Y_UPP
1030	  FORMAT ('LIMITS Y ',G13.6,' ',G13.6,'; ')
	  CALL TDSET	(%REF(TEXT))
#else
	  WRITE(35,*) ' '
	  WRITE(35,*) '# Define plotting area for side histogram'
	  WRITE(35,*) 'regionr(0.55,0.05,0.727,0.7,3.25)'
#endif
	XMAX	= 0
	DO 3041 I=1,N_BIN
	  XMAX	= MAX(XMAX,Y_ARRAY(I))
3041	CONTINUE
#if defined(vms)
	WRITE	(TEXT1,1031)	XMAX*1.1
1031	FORMAT	('LIMIT X 0 ',G13.6,'; ')
	CALL TDSET	(%REF(TEXT1))
#else
	Y1LOW = 0.0
	Y1UPP = XMAX*1.1
	WRITE(35,3030) Y1LOW,Y1UPP,Y_LOW,Y_UPP
	WRITE(35,*) 'plotl("histside.dat")'
	WRITE(35,*) 'box("bcnst",0,0,"bcst",0,0)'
	OPEN(38,FILE='histside.dat',STATUS='UNKNOWN')
#endif
	IF (I_TD.EQ.1)	THEN
	  WRITE	(27,*)	'WINDOW X 7.2 9.2 Y 0 7'
	  WRITE (27,*)	TEXT(1:36)
	  WRITE (27,*)	TEXT1(1:23)
	END IF
	XPLOT(1)	= X_ARRAY(1) - STEP/2
	YPLOT(1)	= 0.0
	XPLOT(2)	= X_ARRAY(1) - STEP/2
	YPLOT(2)	= Y_ARRAY(1)
#if defined(vms)
	CALL JOIN	(2,YPLOT,XPLOT,I_TD,1)
#else
	WRITE(38,*) YPLOT(1),XPLOT(1)
	WRITE(38,*) YPLOT(2),XPLOT(2)
#endif
	Y_ARRAY(N_BIN+1)	= 0.0
     	DO 59 I=1,N_BIN
     	  XWRI_L = X_ARRAY(I)-STEP/2
     	  XWRI_U = X_ARRAY(I)+STEP/2
     	 IF (IY.EQ.11) THEN
     	  IF (IUNIT.EQ.1) THEN
     	    XWRI_L = TOCM*XWRI_L/TWOPI
     	    XWRI_U = TOCM*XWRI_U/TWOPI
     	  ELSE IF (IUNIT.EQ.2) THEN
     	    XWRI_L = TWOPI/XWRI_L*1.0E8
     	    XWRI_U = TWOPI/XWRI_U*1.0E8
     	  END IF
     	 END IF
	 XPLOT (1)	= XWRI_L
	 YPLOT (1)	= Y_ARRAY(I)
	 XPLOT (2)	= XWRI_U
	 YPLOT (2)	= Y_ARRAY(I)
	 XPLOT (3)	= XWRI_U
	 YPLOT (3)	= Y_ARRAY(I+1)
#if defined(vms)
	 CALL	JOIN	(3,YPLOT,XPLOT,I_TD,1)
#else
	 WRITE(38,*) YPLOT(1),XPLOT(1)
	 WRITE(38,*) YPLOT(2),XPLOT(2)
	 WRITE(38,*) YPLOT(3),XPLOT(3)
#endif
59	CONTINUE
     	END IF
47	CONTINUE

5001	CONTINUE
#if defined(vms)
	CALL TDSET	(%REF('WINDOW X 0 13 Y 0 10; '))
	TEXT	= FILETEXT//'; '
	CALL TDTSET	(2.0,0,0,0)
     	CALL TDTITL	(%REF(TEXT),0.2,9.6)
	TEXT	= DATETEXT//'; '
	CALL TDTSET	(2.0,0,0,0)
	CALL TDTITL	(%REF(TEXT),9.5,9.6)
	TEXT	= COMMENT(1:20)//'; '
	CALL TDTSET	(2.0,0,0,0)
	CALL TDTITL	(%REF(TEXT),9.5,8.9)
     	IF (LCOMM.GT.20) THEN
	  TEXT	= COMMENT(21:40)//'; '
	  CALL TDTSET	(2.0,0,0,0)
	  CALL TDTITL	(%REF(TEXT),9.5,8.4)
	  IF (LCOMM.GT.40) THEN
	    TEXT	= COMMENT(41:60)//'; '
	    CALL TDTSET	(2.0,0,0,0)
	    CALL TDTITL	(%REF(TEXT),9.5,7.9)
	    IF (LCOMM.GT.60) THEN
	      TEXT	= COMMENT(61:80)//'; '
	      CALL TDTSET	(2.0,0,0,0)
	      CALL TDTITL (%REF(TEXT),9.5,7.4)
	    END IF
	  END IF
     	END IF
     	CALL	DATE	(TODAY(1:9))
     	CALL	TIME	(TODAY(12:20))
	CALL TDSET	(%REF('ORDER X Y ; '))
	CALL TDSET	(%REF('AXES ALL OFF; '))
     	CALL TDSET	(%REF('LIMITS X 0 13 Y 0 10; '))
	IF (I_TD.EQ.1) THEN
	  WRITE	(27,*)  'WINDOW X 0 13 Y 0 10'
	  WRITE	(27,*)  'SET TITLE SIZE -2'
	  WRITE	(27,*)  'TITLE 0.2 9.6 '''//FILETEXT//''''
	  WRITE	(27,*)  'TITLE 9.5 9.6 '''//DATETEXT//''''
	  WRITE	(27,*)  'TITLE 9.5 8.9 '''//COMMENT(1:20)//''''
	  IF (LCOMM.GT.20) THEN
	    WRITE	(27,*)  'TITLE 9.5 8.4 '''//COMMENT(21:40)//''''
	    IF (LCOMM.GT.40)
     $	    WRITE	(27,*)  'TITLE 9.5 7.9 '''//COMMENT(41:60)//''''
	    IF (LCOMM.GT.60)
     $	    WRITE	(27,*)  'TITLE 9.5 7.4 '''//COMMENT(61:80)//''''
	  END IF
	  WRITE	(27,*)  'ORDER X Y'
	  WRITE	(27,*)  'AXIS ALL OFF'
	  WRITE	(27,*)  'LIMITS X 0 13 Y 0 10'
	END IF
     	XPLOT(1)	= 9.3
	YPLOT(1)	= 0
     	XPLOT(2)	= 9.3
	YPLOT(2)	= 7
     	XPLOT(3)	= 13
	YPLOT(3)	= 7
     	XPLOT(4)	= 13
	YPLOT(4)	= 0
     	XPLOT(5)	= 9.3
	YPLOT(5)	= 0
	CALL JOIN	(5,XPLOT,YPLOT,I_TD,1)
     	XPLOT(1)	= 9.3
	YPLOT(1)	= 6.4
     	XPLOT(2)	= 13
	YPLOT(2)	= 6.4
	CALL JOIN	(2,XPLOT,YPLOT,I_TD,1)
	TEXT		= TODAY//'; '
	CALL TDTSET	(2.0,0,0,0)
	CALL TDTITL	(%REF(TEXT),9.5,6.7)
     	WHAT	=   X_UPP-X_LOW
	WRITE (TEXT,1050) WHAT
1050	FORMAT	('H Length ',G12.5,'; ')
	CALL TDTSET	(2.0,0,0,0)
	CALL TDTITL	(%REF(TEXT),9.5,6.1)
     	WHAT	=   (X_UPP+X_LOW)/2
	WRITE (TEXT1,1060) WHAT
1060	FORMAT	('H center ',G12.5,'; ')
	CALL TDTSET	(2.0,0,0,0)
	CALL TDTITL	(%REF(TEXT1),9.5,5.7)
     	WHAT	=   (Y_UPP-Y_LOW)
	WRITE (TEXT2,1070) WHAT
1070	FORMAT	('V Length ',G12.5,'; ')
	CALL TDTSET	(2.0,0,0,0)
	CALL TDTITL	(%REF(TEXT2),9.5,5.3)
     	WHAT	=   (Y_UPP+Y_LOW)/2
	WRITE (TEXT3,1080) WHAT
1080	FORMAT	('V center ',G12.5,'; ')
	CALL TDTSET	(2.0,0,0,0)
	CALL TDTITL	(%REF(TEXT3),9.5,4.9)
	IF (I_TD.EQ.1) THEN
	  WRITE	(27,*)	'TITLE 9.5 6.7 '''//TODAY//''''
	  WRITE (27,*)	'SET TITLE SIZE 2'
	  WRITE (27,*)	'TITLE 9.5 6.1 '''//TEXT(1:21)//''''
	  WRITE (27,*)	'TITLE 9.5 5.7 '''//TEXT1(1:21)//''''
	  WRITE (27,*)	'TITLE 9.5 5.3 '''//TEXT2(1:21)//''''
	  WRITE (27,*)	'TITLE 9.5 4.9 '''//TEXT3(1:21)//''''
	END IF
	XPLOT(1)	= 9.3
	YPLOT(1)	= 4.5
	XPLOT(2)	= 13
	YPLOT(2)	= 4.5
	CALL JOIN	(2,XPLOT,YPLOT,I_TD,1)
     	IF (IPLOT.EQ.0) THEN
	  TEXT(1:14)	= 'AUTOSCALING ; '
     	ELSE IF (IPLOT.EQ.1) THEN
	  TEXT(1:14)	= 'CARTESIAN   ; '
     	ELSE
	  TEXT(1:14)	= 'EXTERNAL    ; '
     	END IF
	CALL TDTSET	(2.0,0,0,0)
	CALL TDTITL	(%REF(TEXT),9.5,4.2)
	XPLOT(1)	= 9.3
	YPLOT(1)	= 3.9
	XPLOT(2)	= 13
	YPLOT(2)	= 3.9
	CALL JOIN	(2,XPLOT,YPLOT,I_TD,1)
     	IF (ILOST.EQ.0) THEN
	  TEXT1(1:14)	= '--GOOD ONLY ; '
     	ELSE IF (ILOST.EQ.1) THEN
	  TEXT1(1:14)	= '--LOST ONLY ; '
     	ELSE
	  TEXT1(1:14)	= '--ALL RAYS  ; '
     	END IF
	CALL TDTSET	(2.0,0,0,0)
	CALL TDTITL	(%REF(TEXT1),9.5,3.6)
	XPLOT(1)	= 9.3
	YPLOT(1)	= 3.3
	XPLOT(2)	= 13
	YPLOT(2)	= 3.3
	CALL JOIN	(2,XPLOT,YPLOT,I_TD,1)
	WRITE (TEXT2,1100)	NPOINT
1100	FORMAT	('TOT  = ',I7.1,'; ')
	CALL TDTSET	(2.0,0,0,0)
     	CALL TDTITL	(%REF(TEXT2),9.5,3.0)
	WRITE (TEXT3,1110)	NLOSS
1110	FORMAT	('LOST = ',I7.1,'; ')
	CALL TDTSET	(2.0,0,0,0)
     	CALL TDTITL	(%REF(TEXT3),9.5,2.6)
	XPLOT(1)	= 9.3
	YPLOT(1)	= 2.3
	XPLOT(2)	= 13
	YPLOT(2)	= 2.3
	CALL JOIN	(2,XPLOT,YPLOT,I_TD,1)
	WRITE (TEXT4,1120)	IX
1120	FORMAT	('Horizontal: ',I7.1,'; ')
	CALL TDTSET	(2.0,0,0,0)
     	CALL TDTITL	(%REF(TEXT4),9.5,2.0)
	WRITE (TEXT5,1130)	IY
1130	FORMAT	('Vertical:   ',I7.1,'; ')
	CALL TDTSET	(2.0,0,0,0)
     	CALL TDTITL	(%REF(TEXT5),9.5,1.6)
	XPLOT(1)	= 9.3
	YPLOT(1)	= 1.3
	XPLOT(2)	= 13
	YPLOT(2)	= 1.3
	CALL JOIN	(2,XPLOT,YPLOT,I_TD,1)
	IF (IGRID.EQ.2) THEN
	  TEXT6	= 'Contour Values : ; '
	  CALL	TDTSET	(2.0,0,0,0)
	  CALL	TDTITL	(%REF(TEXT6),9.5,1.0)
	  WRITE	(TEXT7,1140)	NCONT,CVALUE(NCONT)
1140	  FORMAT	('  ',I2,' -- ',G12.5,'; ')
	  CALL	TDTSET	(2.0,0,0,0)
	  CALL	TDTITL	(%REF(TEXT7),9.5,0.65)
	  WRITE	(TEXT8,1140)	1,CVALUE(1)
	  CALL	TDTSET	(2.0,0,0,0)
	  CALL	TDTITL	(%REF(TEXT8),9.5,0.3)
	END IF
	CALL TDEND
	CALL	SET_SCREEN	(' ',1,ITERM)
	IF (I_TD.EQ.1) THEN
	  WRITE (27,*)	'TITLE 9.5 4.2 '''//TEXT(1:11)//''''
	  WRITE (27,*)	'TITLE 9.5 3.6 '''//TEXT1(1:11)//''''
	  WRITE (27,*)	'TITLE 9.5 3.0 '''//TEXT2(1:14)//''''
	  WRITE (27,*)	'TITLE 9.5 2.6 '''//TEXT3(1:14)//''''
	  WRITE (27,*)	'TITLE 9.5 2.0 '''//TEXT4(1:19)//''''
	  WRITE (27,*)	'TITLE 9.5 1.6 '''//TEXT5(1:19)//''''
	  IF (IGRID.EQ.2) THEN
	    WRITE (27,*)	'TITLE 9.5 1.0 '''//TEXT6(1:15)//''''
	    WRITE (27,*)	'TITLE 9.5 0.65 '''//TEXT7(1:20)//''''
	    WRITE (27,*)	'TITLE 9.5 0.3 '''//TEXT8(1:20)//''''
	  END IF
	  WRITE (27,*)  'END'
	END IF
#else
	WRITE(35,*) ' '
	WRITE(35,*) '# Fill in some useful information '
	WRITE(35,*) 'regionp(0.73,0.05,1.0,0.7)'
	WRITE(35,*) 'xyrange(0.6,1.0,0.1,1.0)'
	WRITE(35,*) 'scalechr(0.7)'
	WRITE(35,*) 'box("bc",0,0,"bc",0,0)'
	WRITE(35,*) 'line(0.6,0.93,1.0,0.93)'
	WRITE(35,*) 'line(0.6,0.72,1.0,0.72)'
	WRITE(35,*) 'line(0.6,0.65,1.0,0.65)'
	WRITE(35,*) 'line(0.6,0.55,1.0,0.55)'
	WRITE(35,*) 'line(0.6,0.40,1.0,0.40)'
	WRITE(35,*) 'line(0.6,0.28,1.0,0.28)'
#if !defined rs6000 && !defined(F2C) && !defined(G77)
	CALL DATE(TODAY(1:9))
#endif
#if !defined(F2C) && !defined(G77)
	CALL TIME(TODAY(12:20))
#endif
	WRITE(35,*) 'text("t",-1.5,0.05,0,"',TODAY(1:16),'")'
	WRITE(35,3050) X_UPP-X_LOW
3050	FORMAT	('gtext(0.61,0.90,0,0,0,"H Length ',G10.5,'")')
	WRITE(35,3060) (X_UPP+X_LOW)/2
3060	FORMAT	('gtext(0.61,0.85,0,0,0,"H Center ',G10.5,'")')
	WRITE(35,3070) Y_UPP-Y_LOW
3070	FORMAT	('gtext(0.61,0.80,0,0,0,"V Length ',G10.5,'")')
	WRITE(35,3080) (Y_UPP+Y_LOW)/2
3080	FORMAT	('gtext(0.61,0.75,0,0,0,"V Center ',G10.5,'")')
	IF (IPLOT.EQ.0) THEN
	  TEXT(1:19) = 'AUTOSCALING         '
	ELSE IF (IPLOT.EQ.1) THEN
	  TEXT(1:19) = 'CARTESIAN           '
	ELSE
	  TEXT(1:19) = 'EXTERNAL            '
	END IF
	WRITE(35,*) 'gtext(0.61,0.68,0,0,0,"',TEXT(1:19),'")'
	IF (ILOST.EQ.0) THEN
	  TEXT(1:19) = '- good only         '
	ELSE IF (ILOST.EQ.1) THEN
	  TEXT(1:19) = '- lost only         '
	ELSE
	  TEXT(1:19) = '- all rays          '
	END IF
	WRITE(35,*) 'gtext(0.61,0.58,0,0,0,"',TEXT(1:19),'")'
	WRITE(35,3090) NPOINT
3090	FORMAT ('gtext(0.61,0.48,0,0,0,"Total = ',I7.1,'")')
	IF (ILOST.EQ.2) WRITE(35,*) 'color(red)'
	WRITE(35,3110) NLOSS
3110	FORMAT ('gtext(0.61,0.43,0,0,0,"Lost = ',I7.1,'")')
	IF (ILOST.EQ.2) WRITE(35,*) 'color(green)'
	WRITE(35,3120) IX
3120	FORMAT ('gtext(0.61,0.35,0,0,0,"Horizontal = ',I7.1,'")')
	WRITE(35,3130) IY
3130	FORMAT ('gtext(0.61,0.30,0,0,0,"Vertical = ',I7.1,'")')
	IF (IGRID.EQ.2) THEN
	  WRITE(35,*) 'gtext(0.61,0.25,0,0,0,"Contour Values :")'
	  WRITE(35,3140) NCONT,CVALUE(NCONT)
3140	  FORMAT ('gtext(0.61,0.20,0,0,0,"',I2,' -- ',G15.8,'")')
	  WRITE(35,3150) 1,CVALUE(1)
3150	  FORMAT ('gtext(0.61,0.15,0,0,0,"',I2,' -- ',G15.8,'")')
	END IF
C       IF (IANSW.EQ.-1) THEN
	  WRITE(35,*) 'regionp(0.727,0.7,1,1)'
	  WRITE(35,*) 'text("t",-4,0,0,"',COMMENT(1:20),'")'
	  WRITE(35,*) 'text("t",-6,0,0,"',COMMENT(21:40),'")'
	  WRITE(35,*) 'text("t",-8,0,0,"',COMMENT(41:60),'")'
	  WRITE(35,*) 'text("t",-10,0,0,"',COMMENT(61:80),'")'
	  WRITE(35,*) 'text("b",-1.0,0,0,"Prepared:")'
C  WRITE(35,*) 'regionp(0.11,0.72,0.65,1)'
C  WRITE(35,*) 'text("t",-1,0,0,"',FILETEXT,'")'
CELSE
C  WRITE(35,*) 'subpage(2)'
C  WRITE(35,*) 'regionp(0.55,0,1,0.5)'
C  WRITE(35,*) 'text("t",-1,0,0,"',COMMENT(1:20),'")'
C  WRITE(35,*) 'text("t",-3,0,0,"',COMMENT(21:40),'")'
C  WRITE(35,*) 'text("t",-5,0,0,"',COMMENT(41:60),'")'
C  WRITE(35,*) 'text("t",-7,0,0,"',COMMENT(61:80),'")'
C  WRITE(35,*) 'text("b",-1.0,0,0,"Prepared:")'
CEND IF


	IF (IANSW.EQ.-1) THEN
	  WRITE(35,*) 'regionp(0.11,0.72,0.65,1)'
	  WRITE(35,*) 'text("t",-2,0,0,"',FILETEXT,'")'
	END IF
	WRITE(35,*) 'closepage'
	WRITE(35,*) 'exit'
	CLOSE(35)
	CLOSE(36)
	CLOSE(37)
	CLOSE(38)
	CLOSE(39)
	CLOSE(40)
C
C Get the program name relative to SHADOW_ROOT/bin.
C
	IFLAG = 0
	CALL PROGPATH ('primvs', PRIMVS, IFLAG)
	PRIMVSPATH = PRIMVS(1:IBLANK(PRIMVS)) // ' -i plotxy.prm'
	WRITE(*,*) 'Executing program: ' // 
     $		PRIMVSPATH(1:IBLANK(PRIMVSPATH))
#if !defined(_WIN32)
	CALL SYSTEM (PRIMVSPATH)
#else
	IFLAG = 0
	CALL RUNPRIMVS (PRIMVS(1:IBLANK(PRIMVS)),'plotxy.prm',iflag)
#endif
	CLOSE(22)
#endif
     	END
C+++
C	SUBROUTINE	ROUNDOUT
C
C	PURPOSE		To find 'nice' scale for plots
C
C	ALGORITHM	Direct calculation
C
C---
     	SUBROUTINE	ROUNDOUT (X1,X2,X3,X4)
	IMPLICIT        REAL*8          (A-E,G-H,O-Z)
     	CALL	ROUND	(X1,X2)
     	CALL	ROUND	(X3,X4)
     	RETURN
     	END
C+++
C	SUBROUTINE	ROUND
C
C---
     	SUBROUTINE	ROUND	(XMIN,XMAX)
	IMPLICIT        REAL*8          (A-E,G-H,O-Z)
	XDEL	= ABS(XMAX-XMIN)
     	IF (XDEL.LT.1.0D-15)	RETURN
C
C Computes the exponent of the difference
C
     	I0	=   LOG10 (XDEL/2.0D0)
     	IF (I0.LT.1.0) I0 = I0 - 1
	XRANGE	= 10.0D0**(I0)
	IMAX	= XMAX/XRANGE + 1
	IMIN	= XMIN/XRANGE - 1
	IF (IMAX.LT.0.0) THEN
	  IMAX	= IMAX/5.0D0
	ELSE
	  IMAX	= IMAX/5.0D0 + 1
	END IF
	IF (IMIN.LE.0.0) THEN
	  IMIN	= IMIN/5.0D0 - 1
	ELSE
	  IMIN 	= IMIN/5.0D0
	END IF
	IMAX	= IMAX*5.0D0
	IMIN	= IMIN*5.0D0
	XMAX	= DBLE(IMAX)*XRANGE
	XMIN	= DBLE(IMIN)*XRANGE
     	RETURN
     	END
#if defined(vms)
C+++
C	SUBROUTINE 	JOIN
C---
	SUBROUTINE	JOIN (NPLOT,XPLOT,YPLOT,I_TD,I_FLAG)
	IMPLICIT        REAL*8          (A-E,G-H,O-Z)
#if defined(unix) || HAVE_F77_CPP
#       include	        <dim.par>
#elif defined(vms)
	INCLUDE		'SHADOW$INC:DIM.PAR/LIST'
#endif
	DIMENSION	XPLOT(N_DIM),YPLOT(N_DIM)
	IF (I_TD.EQ.1)	THEN
	  DO I = 1, NPLOT
	    WRITE	(27,*)	XPLOT(I),YPLOT(I)
	  END DO
	END IF
	IF (I_FLAG.EQ.1) THEN
	  CALL 	TDJOIN (NPLOT,XPLOT,YPLOT,0,0,1)
	  IF (I_TD.EQ.1)  WRITE	(27,*)	'JOIN 1'
	ELSE
	  CALL	TDJOIN (NPLOT,XPLOT,YPLOT)
	  IF (I_TD.EQ.1)  WRITE (27,*)	'JOIN'
	END IF
	RETURN
	END
#endif
