C+++
C	SUBROUTINE	MSSG	(TEXT1,TEXT2,IFLAG)
C
C	PURPOSE		Outputs an error message to the screen and
C			to a file
C
C	ARGUEMNTS	TEXT1 : Tipically, the calling routine name
C			TEXT2 : A file name, or a message
C			TEXT3 : A flag or an IOSTAT value.
C
C---
     	SUBROUTINE	MSSG (T1, T2, IFLAG)
     	CHARACTER *(*)	T1, T2
#if defined(unix) || HAVE_F77_CPP
#	include		"parms.inc"
#elif defined(vms)
	INCLUDE		'parms.inc'
#endif
#ifdef vms
     	WRITE (*,*)'SHADOW-E-Error: '
     	WRITE (*,*)'Module     : ',T1
     	WRITE (*,*)'Message    : ',T2
     	WRITE (*,*)'Error flag : ',IFLAG
     	WRITE (33, 100) T1
     	WRITE (33, 100) T2
     	WRITE (33, 110) IFLAG
100	FORMAT (1X,'>',A)
110	FORMAT (1X,I5)
#else
	MESSAGE = 'SHADOW-E-Error: '
	CALL SIMPLEMESSAGE
     	WRITE (MESSAGE, *)'Module     : ',T1
	CALL SIMPLEMESSAGE
     	WRITE (MESSAGE, *)'Message    : ',T2
	CALL SIMPLEMESSAGE
     	WRITE (MESSAGE,*)'Error flag : ',IFLAG
	CALL SIMPLEMESSAGE
#endif
	
     	RETURN
     	END
