C +++
C
C Source: src/utils/post/sysinfo.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: sysinfo.F
C Revision 1.8  1992/01/17  11:34:12  cwelnak
C 6000 changes
C
C Revision 1.7  92/01/16  11:24:03  cwelnak
C 6000 changes
C 
C Revision 1.6  91/09/06  09:03:55  cwelnak
C upper to lower case for
C default filenames.
C 
C Revision 1.5  91/07/06  19:43:52  khan
C Grenoble Changes ...
C 
C Revision 1.4  91/04/05  15:50:59  cwelnak
C changed quotes in #includes
C 
C Revision 1.3  91/03/25  15:56:40  khan
C SUN port -- INCLUDE -> #include
C 
C Revision 1.2  91/01/25  16:48:03  khan
C Ported to Ultrix
C 
C Revision 1.1  90/10/08  17:03:50  khan
C Initial revision
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C+++
C	PROGRAM		SYS_INFO
C
C	PURPOSE		Returns a readable file of a mirror definition
C			in shadow.
C
C---
     	PROGRAM		SYS_INFO
#if defined(unix) || HAVE_F77_CPP
c
c This causes problems with F77 drivers, since can't use -I directive.
c so I'll use the standard cpp directive instead.
c
c	INCLUDE         './../../include/common.blk'
c	INCLUDE         './../../include/namelist.blk'
c
c
#	include		<common.blk>
#	include		<namelist.blk>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:COMMON.BLK/LIST'
     	INCLUDE		'SHADOW$INC:NAMELIST.BLK/LIST'
#endif
     	CHARACTER *40	MIRFIL
     	CHARACTER *80	COMMENT,TITLE
     	CHARACTER *71	TOPLIN
     	DATA	TOPLIN	/
     $'+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'/
     	CHARACTER * 32 		FILE_OUT
     	CHARACTER * 60		FILETEXT
     	CHARACTER * 17		DATETEXT
     	CHARACTER *20		TYPE (12),BREAK, TSLIT(5) *11
     	CHARACTER *21		TSCR (2)
     	CHARACTER *80		FILE_IN(20),OPTFILE,TEXT,RSTRING
	SAVE OPTFILE
     	DATA	TSLIT(1)/'SLIT       '/
     	DATA	TSLIT(2)/'STOP       '/
     	DATA	TSLIT(3)/'RECTANGULAR'/
     	DATA	TSLIT(4)/'ELLIPTICAL '/
     	DATA	TSLIT(5)/'EXTERNAL   '/
     	DATA	TSCR(1)	/'AFTER Mirror'/
     	DATA	TSCR(2) /'BEFORE  Mirror'/
     	DATA	TYPE(1)	/'SPHERICAL   '/
     	DATA	TYPE(2)	/'ELLIPTICAL  '/
     	DATA	TYPE(3) /'TOROIDAL    '/
     	DATA	TYPE(4) /'PARABOLICAL '/
     	DATA	TYPE(5)	/'PLANE       '/
     	DATA	TYPE(6) /'CODLING SLIT'/
     	DATA	TYPE(7)	/'HYPERBOLICAL'/
     	DATA	TYPE(8)	/'CONICAL     '/
     	DATA	BREAK	/'    ----------------'/
	CALL CLSCREEN
     	WRITE(6,*) 
     $  '-------------------- S Y S I N F O ----------------------'
     	WRITE(6,*) 
     $  '                  vs. 2.02  June 1989'
     	WRITE(6,*) ' '
     	GO TO 1
20	WRITE(6,*) 'Error reading the NAMELIST.'
     	STOP
10     	WRITE(6,*) 'Error opening: ',MIRFIL
1     	IDEF = IYES ('Default filenames [ Y/N ] ?')
     	IF (IDEF.EQ.1) THEN
     	  NF	=   IRINT ('How many OE''s ? ')
     	  IF (NF.EQ.0) NF = 1
     	 DO 11 J=1,NF
     	   WRITE (FILE_IN(J),999) 'end.',J
D	   write(6,*) file_in(j)
11       CONTINUE
     	  WRITE (OPTFILE,998)	'optax.',NF
D	write(6,*) opt_fil
998	  FORMAT (A6,I2.2)
999	  FORMAT (A4,I2.2)
     	ELSE
     	  WRITE(6,*) 'List of files describing the system. Use TT: ',
     $'for keyboard input (VMS only).'
	  MIRFIL = RSTRING ('INPUT> File containing ERFs ? ')
     	 IF (MIRFIL(1:3).EQ.'TT:') WRITE(6,*) 
     $'INPUT> Please enter filenames: ?'
#ifdef vms
     	  OPEN (20, FILE=MIRFIL, STATUS='OLD', READONLY, ERR=10)
#else
     	  OPEN (20, FILE=MIRFIL, STATUS='OLD', ERR=10)
#endif
	  I=1
30     	  WRITE(6,*) 'File # ',I,' = '
     	  READ (20,1000,ERR=40,END=40)  FILE_IN(I)
     	  I=I+1
     	  GO TO 30
40	  CLOSE (20)
     	
     	  WRITE(6,*) 'SYSINF> Will use ',I-1,' ERF files.'
     	  NF	= I - 1
     	  CALL	ALINE ('INPUT> Optaxis file-name : ',OPTFILE)
1000	  FORMAT	(A)
     	END IF
     	CALL	ALINE ('INPUT> Title ? ',TITLE)
     	CALL	ALINE ('INPUT> Comment ? ',COMMENT)
     	CALL	ALINE ('INPUT> Output file-name ? ',FILE_OUT)
     	WRITE(6,*) 'SYSINF> Prepare output to file : ',FILE_OUT
#ifdef vms
     	OPEN (30,FILE=FILE_OUT,STATUS='NEW',CARRIAGECONTROL='LIST')
#else
     	OPEN (30,FILE=FILE_OUT,STATUS='UNKNOWN')
	REWIND (30)
#endif
     	WRITE (30,*)
     	WRITE (30,*) TOPLIN
     	WRITE (30,*)
     $'**************  S Y S T E M      ',
     $'D E S C R I P T I O N  **************'
     	WRITE (30,*) TOPLIN
     	WRITE (30,*) TITLE
     	WRITE (30,*) COMMENT
     	WRITE (30,*) TOPLIN
     	WRITE (30,*) 'Input file specified:',MIRFIL
     	IF (MIRFIL(1:3).NE.'TT:'.AND.IDEF.NE.1) THEN
     	  CALL	FILEINFO  (MIRFIL)
     	  CALL	NEXTFILE  (FILETEXT,DATETEXT)
	  WRITE (30,1500)	FILETEXT
1500	FORMAT (1X,'Full file Specification :',A)
     	  WRITE (30,1501)	DATETEXT
1501	FORMAT (1X,'Creation Date           :',A)
     	END IF
     	  WRITE (30,*)	TOPLIN
     	  WRITE (30,1502)
1502	FORMAT (1X,' #    Optical Element: ',T62,'Creation Time:')
     	DO 12 J=1,NF
     	  TEXT(1:80) = FILE_IN(J)(1:80)
     	  CALL DESPACE (TEXT,TEXT,ILEN)
     	  CALL	FILEINFO  (TEXT(1:ILEN))
     	  CALL	NEXTFILE  (FILETEXT,DATETEXT)
	  WRITE (30,1503)	J,FILETEXT,DATETEXT
12      CONTINUE
1503	FORMAT (1X,I4,3X,A59,T63,A)
     	WRITE (30,*)	TOPLIN
     	
     	DO 13 J=1,NF
     	IDUMM = 0
     	CALL	RWNAME ( FILE_IN(J),'R_OE', IDUMM)
	WRITE(6,*) N_SCREEN
     	IF (IDUMM.EQ.-1) GO TO 20
     	IF (IDUMM.EQ.-2) GO TO 10
     	IF (IDUMM.NE. 0) STOP 'Fatal Error.'
     	WRITE(6,*) 'SYSINF> File ',FILE_IN(J),' read correctly.'
     	WRITE (30,*) ' '
     	WRITE (30,*)	'Optical Element # ',J,'      System Number: '
     	DO 14 I=1,80
     	TEXT(I:I)=' '
14      CONTINUE
     	IF (F_CRYSTAL.EQ.1) THEN
     		TEXT(1:5) = 'BRAGG'
     	ELSE IF (F_GRATING.EQ.1) THEN
     		TEXT(1:7) = 'GRATING'
     	ELSE
     		TEXT(1:6) = 'MIRROR'
     	END IF
     	DO 16 JJ=1,14
     	TEXT (9+JJ:9+JJ) = TYPE(FMIRR)(JJ:JJ)
16      CONTINUE
     	IF (FHIT_C.EQ.1) THEN
     		TEXT(30:39)  =  'DIM CHECK'
     	ELSE
     		TEXT(30:39)  =  'UNLIMITED'
     	END IF
     	IF (F_EXT.EQ.1) THEN
     		TEXT(45:53)  =  'EXTERNAL'
     	ELSE
     		TEXT(45:53)  =  'COMPUTED'
     	END IF
     	IF (F_REFLEC.EQ.0) THEN
     		TEXT(60:71)	=  'REFLEC. OFF'
     	ELSE
     		TEXT(60:71)	=  'REFLEC. ON '
     	END IF
     	WRITE (30,*) ' '
     	WRITE (30,*) TEXT(1:71)
     	WRITE (30,*) ' '
     	WRITE (30,*) '  Orientation        ',ALPHA*TODEG,' deg.'
     	WRITE (30,*) '  Source Plane       ',T_SOURCE
     	WRITE (30,*) '  Incidence Ang.     ',T_INCIDENCE*TODEG,' deg.'
     	WRITE (30,*) '  Reflection Ang.    ',T_REFLECTION*TODEG,' deg.'
     	WRITE (30,*) '  Image Plane        ',T_IMAGE
     	  WRITE (30,*)	BREAK
     	IF (F_SCREEN.EQ.1) THEN
	WRITE(6,*) N_SCREEN,I_SCREEN,SL_DIS
     	  WRITE (30,*)	'  SCREENS: ',N_SCREEN,' defined.'
     	 DO 17 I=1,N_SCREEN
     	   IJ = I_SCREEN(I) + 1
     	   WRITE (30,*)	TSCR(IJ),' at ',SL_DIS(I)
     	  IF (I_SLIT(I).NE.0) THEN
     	    IND1 =  I_STOP(I) + 1
     	    IND2  =  K_SLIT(I) + 3
     	    WRITE (30,*)	'  Type :',TSLIT(IND1),'  ',TSLIT(IND2)
     	  END IF
17      CONTINUE
     	  WRITE (30,*)	BREAK
     	END IF
13     	CONTINUE
#ifdef vms
     	OPEN (20, FILE=OPTFILE, STATUS='OLD', READONLY)
#else
     	OPEN (20, FILE=OPTFILE, STATUS='OLD')
#endif
     	WRITE (30,3005)
3005	FORMAT (1X,/,1X,T26,'OPTICAL SYSTEM CONFIGURATION')
     	WRITE (30,3000)
3000	FORMAT (1x,T27,'Laboratory Reference Frame.',/)
     	WRITE (30,3010)
3010	FORMAT (1X,'OPT. Elem # ',T20,'X = ',T40,'Y =',T60,'Z =',/)
     	KK = 0
110	READ (20,*,ERR=100,END=100) IELEM
     	READ (20,*)	X,Y,Z				!Source
     	IF (KK.EQ.0)	WRITE (30,3020) 0,X,Y,Z
     	READ (20,*)	X,Y,Z				!Mirror
     	WRITE (30,3020) IELEM,X,Y,Z
     	READ (20,*)	X,Y,Z				!Image
     	WRITE (30,3030) IELEM,X,Y,Z
     	WRITE (30,*)	' '
     	READ (20,*)
     	READ (20,*)
     	READ (20,*)
     	READ (20,*)
     	READ (20,*)
     	KK = KK + 1
     	GO TO 110
3020	FORMAT (1X,T5,I4,T18,G18.11,T38,G18.11,T58,G18.11)
3030	FORMAT (1X,T8,I4,'''',T21,G18.11,T41,G18.11,T61,G18.11)
100	CONTINUE
     	WRITE (30,*)	TOPLIN
     	WRITE (30,*)
     $'***************                 E N',
     $' D                  ***************'
     	WRITE (30,*)	TOPLIN
     	CLOSE (30)
     	END


	BLOCK DATA
	IMPLICIT 	REAL*8		(A-E,G-H,O-Z)
	IMPLICIT 	INTEGER*4	(F,I-N)
	COMMON	/MATHBLK/ PI,TWOPI,PIHALF,TODEG,TORAD,ORIGIN(3),
     $			X_VRS(3),Y_VRS(3),Z_VRS(3),TOCM,TOANGS

     	DATA	PI     	/  3.1415 92653 58979 32384 62643 D0 /
     	DATA	PIHALF 	/  1.5707 96326 79489 66192 31322 D0 /
     	DATA	TWOPI 	/  6.2831 85307 17958 64679 25287 D0 /
     	DATA	TODEG 	/ 57.2957 79513 08232 08767 98155 D0 /
     	DATA	TORAD	/  0.0174 53292 51994 32957 69237 D0 /
	DATA	TOCM	/  1.239 852	D-4		     /
	DATA	TOANGS 	/  1.239 852    D+4		     /

	END

