	SUBROUTINE	tt_writeTrim (string)
	implicit integer (a-z)
c++
c	SUBROUTINE	tt_writeTrim (string)
c
c	string		- input/string
c			  string to be written
c--
	character*(*) string
c
	lstring=ltrim(string)
	call tt_write (string(:lstring))
C	tt_writeTrim=1
	return
	end

	SUBROUTINE	tt_write (string)
	implicit integer (a-z)
c++
c	SUBROUTINE	tt_write (string)
c
c	string		- input/string
c			  string to be written
c--
	character*(*) string
c
#ifdef vms
	include	'io.inc'
c

	code=smg$put_chars (displayID,string)
#else
	call curses_put_chars(string)
#endif
C	tt_write=1
	return
	end

	subroutine tt_read (string,lstring,code)
	implicit integer*4 (a-z)
c++
c	subroutine tt_read (string,lstring,code)
c
c  Call SMG$ routine to read user input from terminal
c    with non-default handling of terminators
c
c  Recognizes as special cases the following:
c	escape sequences of arrow keys (VT100 and VT52)
c	Tab / Backspace / GT Sign / LT Sign / Question Mark
c
c  string	- output/string
c		  data read from terminal
c		  length determines maximum data read
c  lstring	- output/integer
c		  number of bytes of data (excluding terminators)
c  code		- output/integer
c		  way read was terminated
c		    0 => cr/lf/ff/ and other non-printing character
c		    1 => up arrow or backspace
c		    2 => right arrow or '>'
c	 	    3 => down arrow or tab
c		    4 => left arrow or '<' or control/z
c		    5 => control/c  or control/y
c		    6 => control/w
c--
	character*(*) string
c
#ifdef vms
	include 'parms.inc'
	include 'io.inc'
	include	'($smgdef)'
	include	'($ssdef)'
	include	'($trmdef)'
c
	character*1	ignore
	integer*4	lIgnore
	integer*4	ignore_code
c
c  bit mask of characters that terminate read
c	bs=10	tab=11	'<'=74	'>'=76  cntl/w=27  cntl/z=32	(octal)
c	    8        9  60      62	  23		26      (decimal)
c
	integer stop_mask (4)
	data stop_mask /'ffffffff'x,'50000000'x,
     *			'00000000'x,'00000000'x/
c
c  list of special stop characters and their return codes
c
	integer stop_char (10),stop_code(10)
	data stop_char / 9, 8,62,60,23,26,
     *					  smg$k_trm_up,
     *					  smg$k_trm_down,
     *					  smg$k_trm_right,
     *					  smg$k_trm_left/
	data stop_code / 3, 1, 2, 4, 6, 4,
     *					  1,3,2,4/
c
c  stop mask descriptor gives the number of bytes in the stop_mask
c    and its address
c  address can't be determined until execution time
c
	integer stop_mask_desc (2)
	data stop_mask_desc /16,0/
c
	string=' '
	lstring=0
c
c  Have valid channel and know we are working with a terminal
c  We'll assume that the user is working from a supported terminal
c
	stop_mask_desc(2)=%loc(stop_mask)
c
c  ignore EOF since it is reported twice: once as control/Z and once
c    as smg$_EOF
c
	call put_buffer
 	return_code=smg$read_string (keyboardID,string, , ,
     *				trm$m_tm_trmNoEcho+trm$m_tm_noRecall, ,
     *				stop_mask_desc,
     *				lString,term_code,displayID, , , )
c
	if (return_code .eq. smg$_eof) then
	    lString=0
	    code=4
	    goto 999
	else if (return_code .eq. ss$_badEscape .or.
     *	    return_code .eq. ss$_dataOverRun) then
	    lString=0
	    code=0
	    goto 999
	else
	  call check (return_code)
	endif
c
c  control/z with data in buffer is special case
c  must consume the smg$_EOF 
c
	if (term_code .eq. smg$k_trm_ctrlz) then
	  return_code=smg$read_string (keyboardID,ignore, , ,
     *				trm$m_tm_trmNoEcho+trm$m_tm_noRecall, ,
     *				stop_mask_desc,
     *				lIgnore,ignore_code,displayID, , , )
	  if (return_code .ne. smg$_eof) then
	     pause 'TT_READ: Control/Z and SMG$_EOF problems'
	  endif
	endif
c
	if (term_code .eq. smg$k_trm_ctrlc .or.
     *	    term_code .eq. smg$k_trm_ctrly) then
	    lString=0
	    code=5
	    goto 999
	else if (term_code .eq. smg$k_trm_unknown) then
	    lString=0
            code=5
	    goto 999
	else
	    do i=1,10
	        if (term_code .eq. stop_char(i)) then
		    code=stop_code(i)
		    goto 999
		endif
	    end do
	endif
c
c  Normal termination
c
	code=0
c
 999	return
c
#else 
	call curses_read (string,lstring,code)
	return
#endif
 	end

	subroutine tt_return (string,lstring,code)
	implicit integer*4 (a-z)
c++
c	subroutine tt_return (string,lstring,code)
c
c  Call SMG$ routine to wait for user to type carriage return
c    with non-default handling of terminators
c
c  Recognizes as special cases the following:
c	escape sequences of arrow keys (VT100 and VT52)
c	Tab / Backspace / GT Sign / LT Sign / Question Mark
c
c  string	- output/string
c		  data read from terminal
c		  length determines maximum data read
c  lstring	- output/integer
c		  number of bytes of data (excluding terminators)
c  code		- output/integer
c		  way read was terminated
c		    0 => cr/lf/ff/ and other printing or non-printing character
c		    1 => up arrow or backspace
c		    2 => right arrow or '>'
c	 	    3 => down arrow or tab
c		    4 => left arrow or '<'
c		    5 => control/c  or control/y
c		    6 => control/w
c--
	character*(*) string
c
#ifdef vms
	include 'parms.inc'
	include 'io.inc'
	include	'($smgdef)'
	include	'($ssdef)'
	include	'($trmdef)'
c
c  bit mask of characters that terminate read
c	bs=10	tab=11	'<'=74	'>'=76   cntl/w=27 	(octal)
c	    8        9  60      62          23	 	(decimal)
c
	integer stop_mask (4)
	data stop_mask /'f7ffffff'x,'ffffffff'x,
     *			'ffffffff'x,'ffffffff'x/
c
c  list of special stop characters and their return codes
c
	integer stop_char (9),stop_code(9)
	data stop_char / 9, 8,62,60,23,
     *					  smg$k_trm_up,
     *					  smg$k_trm_down,
     *					  smg$k_trm_right,
     *					  smg$k_trm_left/
	data stop_code / 3, 1, 2, 4, 6,
     *					  1,3,2,4/
c
c  stop mask descriptor gives the number of bytes in the stop_mask
c    and its address
c  address can't be determined until execution time
c
	integer stop_mask_desc (2)
	data stop_mask_desc /16,0/
c
	string=' '
	lstring=0
c
	stop_mask_desc(2)=%loc(stop_mask)
c
c  ignore EOF since it is reported twice: once as control/Z and once
c    as smg$_EOF
c
	call put_buffer
 	return_code=smg$read_string (keyboardID,string, , ,
     *				trm$m_tm_trmNoEcho+trm$m_tm_noRecall, ,
     *				stop_mask_desc,
     *				lString,term_code,displayID, , , )
	if (return_code .eq. smg$_eof) then
	    lString=0
	    code=0
	    goto 999
	else if (return_code .eq. ss$_badEscape .or.
     *	    return_code .eq. ss$_dataOverRun) then
	    lString=0
	    code=0
	    goto 999
	else
	  call check (return_code)
	endif
c
	if (term_code .eq. smg$k_trm_ctrlc .or.
     *	    term_code .eq. smg$k_trm_ctrly) then
	    lString=0
	    code=5
	    goto 999
	else if (term_code .eq. smg$k_trm_unknown) then
	    lString=0
            code=5
	    goto 999
	else
	    do i=1,9
	        if (term_code .eq. stop_char(i)) then
		    code=stop_code(i)
		    goto 999
		endif
	    end do
	endif
c
c  Normal termination
c
	code=0
c
 999	return
c
#else
	call curses_return (string, lstring, code)
	return
#endif
 	end

	subroutine tt_prompt (prompt,string,lstring,code)
	implicit integer*4 (a-z)
c++
c	subroutine tt_prompt (prompt,string,lstring,code)
c
c  prompt	- input/string
c		  prompt string
c  string	- output/string
c		  data read from terminal
c		  length determines maximum data read
c  lstring	- output/integer
c		  number of bytes of data (excluding terminators)
c  code		- output/integer
c		  way read was terminated
c		    0 => cr/lf/ff/ and other non-printing character
c		    1 => control/c  or control/y or control/z
c--
	character*(*) prompt,string
c
#ifdef vms
	include 'parms.inc'
	include 'io.inc'
	include '($iodef)'
	include '($ssdef)'
c
	parameter (controlz=26)
c
c  I/O status block
c    word 0	- I/O status code
c    word 1	- offset to terminator
c    word 2	- termination character
c    word 3	- terminator size
c
	integer   iosb4(2)
	integer*2 iosb2(4)
	equivalence (iosb4,iosb2)
c
c  Qio function codes: accept escape sequences, don't echo terminating chars
c
	parameter (read=io$_readprompt)
c
	lstring=0
c
c  Have valid channel and know we are working with a terminal
c  We'll assume that the user is working from a supported terminal
c    either a VT100 or VT52 compatible terminal
c
	l=len(string)
	lp=len(prompt)
c
	return_code=sys$qiow ( ,%val(TT_channel),%val(read), 
     *				iosb4, , ,%ref(string),%val(l), ,
     *				,%ref(prompt),%val(lp))
c
	call check (return_code)
c
c  Look at I/O return code
c
	return_code=iosb2(1)
	if (return_code .eq. ss$_controlc .or.
     *	    return_code .eq. ss$_controly ) then
	      code=1
	      goto 999
	endif
c
c  Normal termination
c  Get length of input from IOSB
c
 50	lstring=iosb2 (2)
	if (iosb2(3) .eq. controlz) then
	  code=1
	else
	  code=0
	endif
c
 999	return
c
#else
	call curses_prompt (prompt, string, lstring, code)
	return
#endif
 	end

	subroutine tt_init
	implicit integer*4 (a-z)
c++
c	subroutine tt_init
c
c  Opens channel to terminal 
c  initializes device independent screen management routines
c
c--
#ifdef vms
	include 'io.inc'
	include	'($IODEF)'
	include	'($TTDEF)'
	include	'($TT2DEF)'
	include	'($SSDEF)'
	include 'parms.inc'
	include 'buffer.inc'
	include 'exitblock.inc'
c
	integer*4	sys$qiow
c
c  subroutine to be called when program exits
c
	external exit_subroutine
c
c  VMS Standard definitions
c    Get Device/Volume information item codes
c    Device Class definitons
c
	external dvi$_devclass
	include '($dcdef)'
c
	integer*4 item_list (4)
	integer*2 item_list2 (8)
	equivalence (item_list,item_list2)
c
	open (unit=6,name='TT',status='new')
	open (unit=5,name='TT',status='old',readonly)
c
c  Open channel if not already open
c
	return_code=sys$assign ('TT',TT_channel, , )
	call check (return_code)
c
c  Check that it is a terminal class device
c  Build VMS item list: Item Code/Buffer Lengths/Data Addresses
c
	item_list2(1) = 8
	item_list2(2) = %loc (dvi$_devclass)
	item_list (2) = %loc (return_data)
	item_list (3) = %loc (return_length)
	item_list (4) = 0
c
	return_code=sys$getdvi ( ,%val(TT_channel), ,item_list
     *				, , , , )
	call check (return_code)
	if (return_data .ne. dc$_term) then
	  message='Logical name "TT:" must be assigned a terminal'
	  call fatal
	endif
c
c  save current attributes
c  then turn off line edit and recognize escape sequences
c
	return_code=sys$qiow (,%val(TT_channel),
     *		%val(io$_sensemode), , , ,
     *		originalSenseData,%val(12), , , , )
	call check (return_code)
	do i=1,3
	  senseData(i)=originalSenseData(i)
	end do
	senseData(2)=iand (senseData(2),
     *			not(0))
	senseData(2)=ior (senseData(2),
     *			tt$m_escape)
	senseData(3)=iand (senseData(3),
     *			not (tt2$m_editing))
	senseData(3)=ior (senseData(3),
     *			0)
ccccc	call setMenuMode (1)
c
c  this gets called after SMG exit handler
c
ccc	exit_block (2)=%loc(exit_subroutine)
ccc	exit_block (3)=1
ccc	exit_block (4)=%loc(exit_sscode)
ccc	return_code=sys$dclexh (exit_block)
ccc	call check (return_code)
c
c  Initialize terminal independent screen routines
c
	return_code=smg$create_pasteBoard (pasteID,'TT')
	call check (return_code)
	return_code=smg$create_virtual_display (24,80,displayID)
	call check (return_code)
	return_code=smg$paste_virtual_display (displayID,pasteID,1,1)
	call check (return_code)
	return_code=smg$create_virtual_keyboard (keyboardID,'TT')
	call check (return_code)
c
c  this gets called before SMG exit handler
c  reset CRT modes when program exits
c
	exit_block (2)=%loc(exit_subroutine)
	exit_block (3)=1
	exit_block (4)=%loc(exit_sscode)
	return_code=sys$dclexh (exit_block)
	call check (return_code)
c
	return
#else
	call curses_init
	return
#endif
	end

	subroutine setMenuMode (flag)
	implicit none
c++
c  subroutine setMenuMode (flag)
c
c  flag		- input/integer*4
c		    0 => restore original terminal characteristics
c		    1 => turn on menu mode
c			  enable escape sequence recognition
c			  turn off line editing
c--
	integer*4	flag
#ifdef vms
c
	include		'io.inc'
	include		'($IODEF)'
c
	integer*4	currentMode
	data		currentMode /-1/
	integer*4	return_code
	integer*4	sys$qiow
c
	if (flag .eq. currentMode) goto 99
	if (flag .eq. 0) then
	  return_code=sys$qiow ( ,%val(TT_channel),%val(io$_setmode), , , ,
     *		originalSenseData,%val(12), , , , )
	else
	  return_code=sys$qiow ( ,%val(TT_channel),%val(io$_setmode), , , ,
     *		senseData,%val(12), , , , )
	endif
	call check (return_code)
	currentMode=flag
#endif
 99	return
	end
