C +++
C
C Source: src/source/bm/t_phot.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log:	t_phot.F
C Revision 1.1  90/07/11  10:45:14  khan
C Initial revision
C 
C 
C ---

	IMPLICIT	REAL*8	(A-H,O-Z)
	DATA	PI	/3.141592653589793238D0/
	RAD	= RNUMBER ('Machine radius [ m ] : ')
	BENER	= RNUMBER ('        energy [ GeV ] : ')
	PHOT	= RNUMBER ('Photon energy : ')
	THEMAX	= rnumber ('Maximum vertical angle [ mrad ] : ')
	np	= IRINT ('No. of points : ')
	IPOL	= IRINT ('Polarization [1,2,3] : ')
	THEMAX	= THEMAX * 1.0D-3
	THESTEP	= THEMAX/(NP-1)
	GAMMA	= 1957.0D0*BENER
	R_LAM	= 4*PI*RAD/3.D0/GAMMA**3*1.0D10
	C_PHOT	= 12398.52D0/R_LAM
	IFLAG	= -1
	CALL	BEND_PHOT(RN,THETA,PHOT,GAMMA,C_PHOT,IPOL,IFLAG)
	do i = 1, np
	  IFLAG	= 1
	  THETA	= THESTEP*(I-1)
	  CALL	BEND_PHOT(RN,THETA,PHOT,GAMMA,C_PHOT,IPOL,IFLAG)
	  WRITE	(25,*)	THETA*1.0D3, RN
	CONTINUE
	END
