C +++
C
C Source: src/utils/pre/reflag.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log:	reflag.F
C Revision 1.7  92/01/16  15:38:22  cwelnak
C 6000 changes and array def'n
C 
C Revision 1.6  1991/07/31  14:31:06  cwelnak
C for 18 columns to work, need to dimension
C phase1, phase2, ap1, ap2
C
C Revision 1.5  91/07/06  19:20:42  khan
C Grenoble Changes ...
C 
C Revision 1.4  91/04/05  15:57:25  cwelnak
C changed quotes on #includes
C 
C Revision 1.3  91/03/25  16:25:04  khan
C SUN port -- INCLUDE -> #include
C 
C Revision 1.2  91/01/25  16:50:41  khan
C Ported to Ultrix
C 
C Revision 1.1  90/10/10  13:12:58  khan
C Added Pre-processor directives for Unix/VMS compilations
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C+++
C	PROGRAM		REFLAG
C
C	PURPOSE		To modify the good/lost flag in a given ray file
C			accordingly to those of another one. Typically
C			used to study the rays that will be lost from a
C			given source.
C
C	ALGORITHM	None
C
C	INPUTS		Two RAY  files
C
C	OUTPUT		Another ray file
C
C+++
     	PROGRAM		REFLAG
    	IMPLICIT	REAL*8		(A-H,O-Z)
#if defined(unix) || HAVE_F77_CPP
#   	include		<dim.par>
#elif defined(vms)
    	INCLUDE		'SHADOW$INC:DIM.PAR/LIST'
#endif
C    	IMPLICIT	REAL*8		(A-H,O-Z)
     	DIMENSION	PHASE1 (3,N_DIM), PHASE2 (3,N_DIM)
	DIMENSION	AP1 (3,N_DIM), AP2 (3,N_DIM)
     	DIMENSION	RAY1 (12,N_DIM),RAY2 (12,N_DIM)
     	CHARACTER*80	INFILE1, INFILE2, OUTFILE, RSTRING

     	INFILE1	  =   RSTRING  
     $('File to be modified [ e.g. BEGIN.DAT ] ? ')
     	INFILE2   =   RSTRING  
     $('File to use as modifier [ e.g. SCREEN.0503 ] ? ')
     	OUTFILE	  =   RSTRING  ('Output file ? ')

     	IFLAG = 1

     	CALL	RBEAM  (INFILE1,RAY1,PHASE1,AP1,NC1,NP1,IFLAG,IERR)
     	CALL	RBEAM  (INFILE2,RAY2,PHASE2,AP2,NC2,NP2,IFLAG,IERR)

     	IF (NP1.NE.NP2) THEN
     	  WRITE(6,*) 'Sorry, different number of rays.'
     	  WRITE(6,*)'You most likely have used wrong files. Please ',
     $ 'try again.'
     	END IF
     	IF (NC1.NE.NC2) THEN
     	  WRITE(6,*)'Sorry, different number of columns.'
     	  WRITE(6,*)'You most likely have used wrong files. Please ',
     $ 'try again.'
     	END IF

     	DO 10 I=1,NP1
     	  RAY1 (10,I) = RAY2 (10,I)
10     	CONTINUE

     	CALL	WRITE_OFF  (OUTFILE,RAY1,PHASE1,AP1,NC1,NP1,IFLAG,
     $		0, IERR)

     	END
