C +++
C
C Source: src/utils/pre/ergset.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log:	ergset.F
C Revision 1.6  92/01/16  14:48:39  cwelnak
C 6000 changes
C 
C Revision 1.5  91/07/06  19:20:42  khan
C Grenoble Changes ...
C 
C Revision 1.4  91/04/05  15:57:19  cwelnak
C changed quotes on #includes
C 
C Revision 1.3  91/03/25  16:24:48  khan
C SUN port -- INCLUDE -> #include
C 
C Revision 1.2  91/01/25  16:50:18  khan
C Ported to Ultrix
C 
C Revision 1.1  90/10/10  13:12:54  khan
C Added Pre-processor directives for Unix/VMS compilations
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C+++
C	PROGRAM		ERGSET
C
C	PURPOSE		To set up teh ERG/Grasshopper at a given
C			photon energy.
C
C	INPUT		a set of STARTxx files describing the system
C			at zero order.
C
C	OUTPUT		A set of STARTxx files describing the system
C			at a given photon energy.
C
C---
      	PROGRAM		ERGSET
#if defined(unix) || HAVE_F77_CPP
c
c This causes problems with F77 drivers, since can't use -I directive.
c so I'll use the standard cpp directive instead.
c
c	INCLUDE         './../../include/common.blk'
c	INCLUDE         './../../include/namelist.blk'
c
c
#	include		<common.blk>
#	include		<namelist.blk>
#elif defined(vms)
    	INCLUDE		'SHADOW$INC:COMMON.BLK'
    	INCLUDE		'SHADOW$INC:NAMELIST.BLK'
#endif
      	CHARACTER*80	INFIL(20),OUTFIL(20),RSTRING,NAME
C
C Inquire about the ZERO ORDER values
C
      	WRITE(6,*)'Definition of ERG at ZERO Order Position.'
      	TLENGTH = RNUMBER ('Distance M0-exit slit ? ')
      	CODDIS  = RNUMBER ('M1-Codling slit distance ? ')
      	CINC	   = RNUMBER ('Codling Slit Incidence Angle ? ')
      	GRAD	   = RNUMBER ('Grating Radius ? ')
      	GINC	   = RNUMBER ('Grating Incidence Angle ? ')
      	RRULING	=  RNUMBER ('Lines per CM ? ')
      	IWHAT	=  IRINT   ('Enter [ 0 ] to use eV, [ 1 ] Angs. ')
      	XPHOT	=  RNUMBER ('Then ? ')
      	ORDERH	=  RNUMBER ('Order to be used ? ')
	RL0MAX	=  RNUMBER ('Maximum slit-to-slit distance : ')
      	ISAVE	   = IYES ('Do you want to save the inputs [ Y/N ] ? ')
      	IF (IWHAT.EQ.0) THEN
      	  XPHOT = TOCM/XPHOT
      	ELSE
      	  XPHOT = XPHOT*1.0D-8
      	END IF
C
C Reads in old NAMELIST files; they may not be at ZERO order.
C
      	
1      	INFIL(1) = RSTRING ('File describing M1 ?           ')
2      	INFIL(2) = RSTRING ('                Codling Slit ? ')
3      	INFIL(3) = RSTRING ('                Grating ?      ')
      	IDUMM	=  0
C
C First the grating
C
      	DTOTAL  = 0.0D0
      	CALL	RWNAME (INFIL(3),'R_OE',IDUMM)
      	IF (IDUMM.NE.0) THEN
      	  WRITE(6,*)'Error looking up ',INFIL(3)
      	  GO TO 3
      	END IF
      	WRITE(6,*)INFIL(3),' read OK.'
      	RMIRR	=  GRAD
      	XTEMP = GRAD*COS(TORAD*GINC)/2
      	T_SOURCE = XTEMP
      	T_INCIDENCE = GINC
      	ORDER   =  ORDERH
      	RULING	=  RRULING
      	SINBE	=  SIN(TORAD*GINC) + ORDER*RULING*XPHOT
      	IF (ABS(SINBE).GT.1.0D0) THEN
      	  WRITE(6,*)'WARNING: wavelength too long for this grating.'
      	  STOP
      	END IF
      	T_REFLECTION = TODEG*(ASIN(SINBE))
      	TILT	=  GINC - T_REFLECTION
      	T_IMAGE	=  GRAD*COS(TORAD*T_REFLECTION)
      	ZEROL  =  GRAD*COS(TORAD*GINC)*2
	F_PHOT_CENT	= IWHAT
      	PHOT_CENT = TOCM/XPHOT
	R_LAMBDA  = XPHOT*1.0D8
C
C The grating is fully specified. Write out the modified parameters
C
      	IDUMM	= 1
      	WRITE(6,*)'Enter new file name for grating. To use the same, ',
     $'just type <ret>'
      	NAME	= RSTRING ('Then ? ')
      	IF (NAME(1:5).EQ.'    ') NAME=INFIL(3)
      	CALL	RWNAME ( NAME,'W_OE', IDUMM)
C
C This is the slit-slit distance
C
      	RL0	=  T_IMAGE**2 + (2*T_SOURCE)**2 -
     $		4*T_IMAGE*T_SOURCE*COS(TORAD*T_INCIDENCE+T_REFLECTION)
      	RL0	=  SQRT(RL0)
	IF (RL0.GT.RL0MAX)	
     $	  WRITE(6,*)'Warning!!  Carriage doesn''t have enough travel.'
      	DELTAR	=  RL0 - ZEROL 
      	DTOTAL  =  DTOTAL + RL0
C
C Computes now the codling slit tilt angle
C
      	IDUMM	=  0
      	CALL	RWNAME (INFIL(2),'R_OE', IDUMM)
      	IF (IDUMM.NE.0) THEN
      	  WRITE(6,*)'Error looking up ',INFIL(2)
      	  GO TO 2
      	END IF
      	WRITE(6,*)INFIL(2),' read OK.'
      	TILT	=  TILT/2	! TILT was the grating diffraction
      				! angle
      	T_INCIDENCE = CINC - TILT
      	T_REFLECTION = CINC - TILT
      	T_SOURCE = 20
      	T_IMAGE = XTEMP
      	IDUMM	= 1
      	WRITE(6,*)'Enter new file name for Codling Slit. To use the ',
     $'same just type <ret>'
      	NAME	= RSTRING ('Then ? ')
      	IF (NAME(1:5).EQ.'    ') NAME=INFIL(2)
      	CALL	RWNAME ( NAME,'W_OE', IDUMM)
C
C Finally, M1 is located
C
      	IDUMM	=  0
      	CALL	RWNAME (INFIL(1),'R_OE', IDUMM)
      	IF (IDUMM.NE.0) THEN
      	  WRITE(6,*)'Error looking up ',INFIL(1)
      	  GO TO 1
      	END IF
    	T_SOURCE = T_SOURCE - DELTAR
      	T_IMAGE = CODDIS - 20.0D0 
      	IDUMM	= 1
      	WRITE(6,*)'Enter new file name for M1. To use the same, ',
     $'just type <ret>'
      	NAME	= RSTRING ('Then ? ')
      	IF (NAME(1:5).EQ.'    ') NAME=INFIL(1)
      	CALL	RWNAME ( NAME,'W_OE', IDUMM)
C
C save input set
C
      	 IF (ISAVE.EQ.1) THEN
           NAME	= RSTRING ('File name ? ')
      	   OPEN (20, FILE=NAME, STATUS = 'UNKNOWN')
	   REWIND (20)
      	   WRITE (20,*) TLENGTH,' ! Distance M0-exit slit'
      	   WRITE (20,*) CODDIS, ' ! Codling slit distance'
      	   WRITE (20,*)	CINC,	 ' ! Codling Slit Incidence Angle'
      	   WRITE (20,*) GRAD,   ' ! Grating Radius'
      	   WRITE (20,*) GINC,   ' ! Grating Incidence Angle'
      	   WRITE (20,*) ZEROL,	 ' ! Zero order slit distance'
      	   WRITE (20,*) DELTAR, ' ! Carriage movement '
      	   WRITE (20,*) TILT,    ' ! Codling slit tilt '
      	   WRITE (20,*)	INFIL(1),' ! M1 file'
      	   WRITE (20,*) INFIL(2),' ! Codling Slit file'
      	   WRITE (20,*) INFIL(3),' ! Grating file'
      	   CLOSE (20)
      	 END IF

      	END

	BLOCK DATA
	IMPLICIT        REAL*8          (A-E,G-H,O-Z)
	IMPLICIT        INTEGER*4       (F,I-N)
	COMMON  /MATHBLK/ PI,TWOPI,PIHALF,TODEG,TORAD,ORIGIN(3),
     $			 X_VRS(3),Y_VRS(3),Z_VRS(3),TOCM,TOANGS

	DATA    PI      /  3.1415 92653 58979 32384 62643 D0 /
	DATA    PIHALF  /  1.5707 96326 79489 66192 31322 D0 /
	DATA    TWOPI   /  6.2831 85307 17958 64679 25287 D0 /
	DATA    TODEG   / 57.2957 79513 08232 08767 98155 D0 /
	DATA    TORAD   /  0.0174 53292 51994 32957 69237 D0 /
	DATA    TOCM    /  1.239 852    D-4 /
	DATA    TOANGS  /  1.239 852    D+4 /
        END

